/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.model;

import java.util.Properties;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.AbstractDataSource;
import oracle.spatial.edit.model.JDBCDataAccessObject;

public class JDBCDataSource
extends AbstractDataSource {
    public JDBCDataSource(String name) {
        this.name = name;
    }

    @Override
    public boolean init(Properties props) {
        if (this.name == null) {
            System.out.println("Object name has not been defined.");
            return false;
        }
        if (props == null) {
            System.out.println("JDBC connection properties must be defined:\nusername, password, host, port, sid");
            return false;
        }
        String user = props.getProperty("username");
        if (user == null) {
            System.out.println("Property [username] must be defined.");
            return false;
        }
        String password = props.getProperty("password");
        if (password == null) {
            System.out.println("Property [password] must be defined.");
            return false;
        }
        String host = props.getProperty("host");
        if (host == null) {
            System.out.println("Property [host] must be defined.");
            return false;
        }
        String port = props.getProperty("port");
        if (port == null) {
            System.out.println("Property [port] must be defined.");
            return false;
        }
        String sid = props.getProperty("sid");
        if (sid == null) {
            System.out.println("Property [sid] must be defined.");
            return false;
        }
        this.connProperties = props;
        return true;
    }

    @Override
    public AbstractDataAccessObject getDataAccessObject() {
        if (this.connProperties == null) {
            return null;
        }
        JDBCDataAccessObject dataAccess = new JDBCDataAccessObject(this);
        return dataAccess;
    }
}

