/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.index.geometry;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.maps.core.GeoObject;
import oracle.maps.geoobject.AbstractFeature;
import oracle.maps.geoobject.GeometryFeature;
import oracle.mapviewer.share.Field;
import oracle.sdovis.edit.util.GeometryUtil;
import oracle.sdovis.edit.util.JGeometrySegment;
import oracle.sdovis.edit.util.JGeometrySegmentPoint;
import oracle.sdovis.edit.util.JGeometryUtil;
import oracle.sdovis.edit.util.RubberPoint;
import oracle.spatial.edit.index.AbstractIndexedDataSet;
import oracle.spatial.edit.index.AbstractSpatialIndex;
import oracle.spatial.edit.index.RTreeIndex;
import oracle.spatial.edit.model.EditChangeEvent;
import oracle.spatial.edit.model.geometry.GeometrySet;
import oracle.spatial.geometry.JGeometry;

public class IndexedGeometrySet
extends AbstractIndexedDataSet {
    Hashtable<String, AbstractSpatialIndex> geomFeatureTree = new Hashtable();

    public IndexedGeometrySet(GeometrySet gset) {
        this.dataSet = gset;
        this.dataSet.setIndexedSet(this);
        RTreeIndex rtree = new RTreeIndex();
        rtree.create(null);
        this.sptIndex = rtree;
    }

    public GeometrySet getGeometrySet() {
        return (GeometrySet)this.dataSet;
    }

    public boolean addPoint(String featKey, JGeometry pointGeom) throws Exception {
        GeometryFeature gf = this.getFeature(featKey);
        JGeometry geom = gf.getSpatialAttribute();
        if (geom == null) {
            return false;
        }
        JGeometry change = JGeometryUtil.addPoint((JGeometry)geom, (JGeometry)pointGeom);
        if (change == null) {
            return false;
        }
        return this.updateSpatialAttribute(featKey, change);
    }

    public boolean addLine(String featKey, JGeometry lineGeom) throws Exception {
        GeometryFeature gf = this.getFeature(featKey);
        JGeometry geom = gf.getSpatialAttribute();
        if (geom == null) {
            return false;
        }
        JGeometry change = JGeometryUtil.addLine((JGeometry)geom, (JGeometry)lineGeom);
        if (change == null) {
            return false;
        }
        return this.updateSpatialAttribute(featKey, change);
    }

    public boolean addPolygon(String featKey, JGeometry polygonGeom) throws Exception {
        GeometryFeature gf = this.getFeature(featKey);
        JGeometry geom = gf.getSpatialAttribute();
        if (geom == null) {
            return false;
        }
        JGeometry change = JGeometryUtil.addPolygon((JGeometry)geom, (JGeometry)polygonGeom);
        if (change == null) {
            return false;
        }
        return this.updateSpatialAttribute(featKey, change);
    }

    public boolean addVoidPolygon(String featKey, int polyElemIndex, JGeometry voidPolygon) throws Exception {
        GeometryFeature gf = this.getFeature(featKey);
        JGeometry geom = gf.getSpatialAttribute();
        if (geom == null) {
            return false;
        }
        JGeometry change = JGeometryUtil.addVoidPolygon((JGeometry)geom, (int)polyElemIndex, (JGeometry)voidPolygon);
        if (change == null) {
            return false;
        }
        return this.updateSpatialAttribute(featKey, change);
    }

    public boolean removePoint(String featKey, int pointElemIndex) throws Exception {
        GeometryFeature gf = this.getFeature(featKey);
        JGeometry geom = gf.getSpatialAttribute();
        if (geom == null) {
            return false;
        }
        JGeometry change = JGeometryUtil.removePoint((JGeometry)geom, (int)pointElemIndex);
        if (change == null) {
            return false;
        }
        return this.updateSpatialAttribute(featKey, change);
    }

    public boolean removeLine(String featKey, int lineElemIndex) throws Exception {
        GeometryFeature gf = this.getFeature(featKey);
        JGeometry geom = gf.getSpatialAttribute();
        if (geom == null) {
            return false;
        }
        JGeometry change = JGeometryUtil.removeLine((JGeometry)geom, (int)lineElemIndex);
        if (change == null) {
            return false;
        }
        return this.updateSpatialAttribute(featKey, change);
    }

    public boolean removePolygon(String featKey, int polyElemIndex) throws Exception {
        GeometryFeature gf = this.getFeature(featKey);
        JGeometry geom = gf.getSpatialAttribute();
        if (geom == null) {
            return false;
        }
        JGeometry change = JGeometryUtil.removePolygon((JGeometry)geom, (int)polyElemIndex);
        if (change == null) {
            return false;
        }
        return this.updateSpatialAttribute(featKey, change);
    }

    public boolean removeVoidPolygon(String featKey, int polyElemIndex, int voidElemIndex) throws Exception {
        GeometryFeature gf = this.getFeature(featKey);
        JGeometry geom = gf.getSpatialAttribute();
        if (geom == null) {
            return false;
        }
        JGeometry change = JGeometryUtil.removeVoidPolygon((JGeometry)geom, (int)polyElemIndex, (int)voidElemIndex);
        if (change == null) {
            return false;
        }
        return this.updateSpatialAttribute(featKey, change);
    }

    public boolean addVertex(String featKey, JGeometrySegmentPoint newVertex) throws Exception {
        GeometryFeature gf = this.getFeature(featKey);
        JGeometry geom = gf.getSpatialAttribute();
        if (geom == null) {
            return false;
        }
        JGeometry change = JGeometryUtil.addVertex((JGeometry)geom, (JGeometrySegmentPoint)newVertex);
        if (change == null) {
            return false;
        }
        return this.updateSpatialAttribute(featKey, change);
    }

    public boolean removeVertex(String featKey, JGeometrySegmentPoint remVertex) throws Exception {
        GeometryFeature gf = this.getFeature(featKey);
        JGeometry geom = gf.getSpatialAttribute();
        if (geom == null) {
            return false;
        }
        JGeometry change = JGeometryUtil.removeVertex((JGeometry)geom, (JGeometrySegmentPoint)remVertex);
        if (change == null) {
            return false;
        }
        return this.updateSpatialAttribute(featKey, change);
    }

    public boolean removeVertexes(String featKey, JGeometrySegmentPoint[] remVertex) throws Exception {
        GeometryFeature gf = this.getFeature(featKey);
        JGeometry geom = gf.getSpatialAttribute();
        if (geom == null) {
            return false;
        }
        JGeometry change = JGeometryUtil.removeVertexes((JGeometry)geom, (JGeometrySegmentPoint[])remVertex);
        if (change == null) {
            return false;
        }
        return this.updateSpatialAttribute(featKey, change);
    }

    public boolean moveVertex(String featKey, JGeometrySegmentPoint segPoint, Point2D newVertex) throws Exception {
        GeometryFeature gf = this.getFeature(featKey);
        JGeometry geom = gf.getSpatialAttribute();
        if (geom == null) {
            return false;
        }
        JGeometry change = JGeometryUtil.moveVertex((JGeometry)geom, (JGeometrySegmentPoint)segPoint, (Point2D)newVertex);
        if (change == null) {
            return false;
        }
        return this.updateSpatialAttribute(featKey, change);
    }

    public boolean movePoint(String featKey, JGeometrySegmentPoint segPoint, Point2D newPoint) throws Exception {
        GeometryFeature gf = this.getFeature(featKey);
        JGeometry geom = gf.getSpatialAttribute();
        if (geom == null) {
            return false;
        }
        JGeometry change = JGeometryUtil.movePoint((JGeometry)geom, (JGeometrySegmentPoint)segPoint, (Point2D)newPoint);
        if (change == null) {
            return false;
        }
        return this.updateSpatialAttribute(featKey, change);
    }

    public GeometryFeature getFeature(String featKey) {
        return (GeometryFeature)this.getAbstractFeature(featKey);
    }

    @Override
    public boolean updateSpatialAttribute(Object featKey, Object change) throws Exception {
        super.updateSpatialAttribute(featKey, change);
        this.clearSegmentTree(featKey.toString());
        return true;
    }

    @Override
    public AbstractFeature identify(Point2D point, double tolerance, int granularity) {
        int gtype;
        int k;
        JGeometry[] geoms;
        GeometryFeature pf;
        int i;
        GeometryFeature sf = null;
        List<GeoObject> feats = this.getFeatures(point, tolerance);
        if (feats == null || feats.size() == 0) {
            return null;
        }
        double minDist = Double.MAX_VALUE;
        block0: for (i = 0; i < feats.size(); ++i) {
            pf = (GeometryFeature)feats.get(i);
            if (pf == null || pf.getSpatialAttribute() == null || (geoms = JGeometryUtil.getElements((JGeometry)pf.getSpatialAttribute())) == null) continue;
            for (k = 0; k < geoms.length; ++k) {
                double dy;
                Point2D pt;
                double dx;
                double distance;
                gtype = geoms[k].getType();
                if (gtype != 1 && gtype != 5 || !((distance = Math.sqrt((dx = (pt = geoms[k].getJavaPoint()).getX() - point.getX()) * dx + (dy = pt.getY() - point.getY()) * dy)) <= tolerance) || !(distance < minDist)) continue;
                minDist = distance;
                sf = pf;
                continue block0;
            }
        }
        if (sf != null) {
            return sf;
        }
        minDist = Double.MAX_VALUE;
        block2: for (i = 0; i < feats.size(); ++i) {
            pf = (GeometryFeature)feats.get(i);
            if (pf == null || pf.getSpatialAttribute() == null || (geoms = JGeometryUtil.getElements((JGeometry)pf.getSpatialAttribute())) == null) continue;
            for (k = 0; k < geoms.length; ++k) {
                Point2D[][] boundary;
                gtype = geoms[k].getType();
                if (gtype != 2 && gtype != 6 || (boundary = JGeometryUtil.getBoundaryOfElement((JGeometry)pf.getSpatialAttribute(), (int)k)) == null) continue;
                Point2D[] bounds = boundary[0];
                for (int m = 0; m < bounds.length - 1; ++m) {
                    Point2D p1 = bounds[m];
                    Point2D p2 = bounds[m + 1];
                    double[] dist = GeometryUtil.distToLine((Point2D)point, (Point2D)p1, (Point2D)p2);
                    if (!(dist[0] <= tolerance) || !(dist[0] < minDist)) continue;
                    minDist = dist[0];
                    sf = pf;
                    break;
                }
                if (sf != null) continue block2;
            }
        }
        if (sf != null) {
            return sf;
        }
        ArrayList<GeometryFeature> candidates = new ArrayList<GeometryFeature>();
        block5: for (int i2 = 0; i2 < feats.size(); ++i2) {
            JGeometry[] geoms2;
            GeometryFeature pf2 = (GeometryFeature)feats.get(i2);
            if (pf2 == null || pf2.getSpatialAttribute() == null || (geoms2 = JGeometryUtil.getElements((JGeometry)pf2.getSpatialAttribute())) == null) continue;
            for (int k2 = 0; k2 < geoms2.length; ++k2) {
                Point2D[][] boundary;
                int gtype2 = geoms2[k2].getType();
                if (gtype2 != 3 && gtype2 != 7 || (boundary = JGeometryUtil.getBoundaryOfElement((JGeometry)pf2.getSpatialAttribute(), (int)k2)) == null) continue;
                int extbounds = 0;
                if (geoms2[k2].getElemInfo()[1] == 2003) {
                    extbounds = boundary.length - 1;
                }
                if (!GeometryUtil.pointInPolygon((Point2D)point, (Point2D[])boundary[extbounds])) continue;
                if (boundary.length == 1) {
                    sf = pf2;
                    candidates.add(pf2);
                    continue block5;
                }
                boolean insideVoid = false;
                int startVoids = 1;
                int endVoids = boundary.length - 1;
                if (geoms2[k2].getElemInfo()[1] == 2003) {
                    startVoids = 0;
                    endVoids = boundary.length - 2;
                }
                for (int l = startVoids; l <= endVoids; ++l) {
                    if (!GeometryUtil.pointInPolygon((Point2D)point, (Point2D[])boundary[l])) continue;
                    insideVoid = true;
                    break;
                }
                if (insideVoid) continue;
                sf = pf2;
                candidates.add(pf2);
                continue block5;
            }
        }
        if (candidates.size() == 1) {
            return (GeometryFeature)candidates.get(0);
        }
        return this.polygonHitDetection(candidates, point);
    }

    GeometryFeature polygonHitDetection(List candidates, Point2D point) {
        int index = -1;
        double minDist = Double.POSITIVE_INFINITY;
        double px = point.getX();
        double py = point.getY();
        for (int i = 0; i < candidates.size(); ++i) {
            JGeometry[] geoms;
            GeometryFeature feature = (GeometryFeature)candidates.get(i);
            if (feature == null || (geoms = JGeometryUtil.getElements((JGeometry)feature.getSpatialAttribute())) == null) continue;
            double geomSegMinDist = Double.POSITIVE_INFINITY;
            for (int j = 0; j < geoms.length; ++j) {
                JGeometry g = geoms[j];
                double[] coords = g.getOrdinatesArray();
                int dim = g.getDimensions();
                double sx = coords[0];
                double sy = coords[1];
                double ex = 0.0;
                double ey = 0.0;
                for (int k = 1; k < coords.length / dim; ++k) {
                    ex = coords[k * dim];
                    ey = coords[k * dim + 1];
                    double dist = GeometryUtil.distToLine((double)px, (double)py, (double)sx, (double)sy, (double)ex, (double)ey)[0];
                    if (dist < geomSegMinDist) {
                        geomSegMinDist = dist;
                    }
                    sx = ex;
                    sy = ey;
                }
            }
            if (!(geomSegMinDist < minDist)) continue;
            minDist = geomSegMinDist;
            index = i;
        }
        return index >= 0 ? (GeometryFeature)candidates.get(index) : null;
    }

    public JGeometrySegmentPoint getSegmentPoint(Point2D point, double tolerance, boolean checkIsolatedPoints, boolean checkArcs, boolean checkCircles, boolean checkRectangles) {
        if (this.dataSet == null) {
            return null;
        }
        Point2D intersectPoint = null;
        List<GeoObject> feats = this.getFeatures(point, tolerance);
        if (feats == null || feats.size() == 0) {
            return null;
        }
        double minDist = Double.MAX_VALUE;
        String keyColumn = ((GeometrySet)this.dataSet).getKeyColumn();
        JGeometrySegmentPoint out = null;
        for (int i = 0; i < feats.size(); ++i) {
            double dy;
            double dx;
            double dist;
            Point2D inter;
            JGeometrySegmentPoint finter;
            GeometryFeature sf = (GeometryFeature)feats.get(i);
            Field key = sf.getAttribute(keyColumn);
            if (key == null || key.getValue() == null || (finter = this.getSegmentPoint(key.getValue().toString(), point, tolerance, checkIsolatedPoints, checkArcs, checkCircles, checkRectangles)) == null || (inter = finter.getPoint()) == null || !((dist = Math.sqrt((dx = point.getX() - inter.getX()) * dx + (dy = point.getY() - inter.getY()) * dy)) < minDist)) continue;
            minDist = dist;
            intersectPoint = inter;
            out = finter;
        }
        return out;
    }

    public JGeometrySegmentPoint[] getSegmentPointOfFeatures(Point2D point, double tolerance, boolean checkIsolatedPoints, boolean checkArcs, boolean checkCircles, boolean checkRectangles) {
        if (this.dataSet == null) {
            return null;
        }
        List<GeoObject> feats = this.getFeatures(point, tolerance);
        if (feats == null || feats.size() == 0) {
            return null;
        }
        double minDist = Double.MAX_VALUE;
        String keyColumn = ((GeometrySet)this.dataSet).getKeyColumn();
        Object out = null;
        ArrayList<JGeometrySegmentPoint> result = new ArrayList<JGeometrySegmentPoint>();
        for (int i = 0; i < feats.size(); ++i) {
            JGeometrySegmentPoint finter;
            GeometryFeature sf = (GeometryFeature)feats.get(i);
            Field key = sf.getAttribute(keyColumn);
            if (key == null || key.getValue() == null || (finter = this.getSegmentPoint(key.getValue().toString(), point, tolerance, checkIsolatedPoints, checkArcs, checkCircles, checkRectangles)) == null) continue;
            result.add(finter);
        }
        if (result.size() == 0) {
            return null;
        }
        return result.toArray(new JGeometrySegmentPoint[result.size()]);
    }

    public JGeometrySegmentPoint getSegmentPoint(String key, Point2D point, double tolerance, boolean checkIsolatedPoints, boolean checkArcs, boolean checkCircles, boolean checkRectangles) {
        int fsegloc;
        JGeometrySegment fseg;
        Point2D intersectPoint;
        block24: {
            if (key == null) {
                return null;
            }
            intersectPoint = null;
            fseg = null;
            fsegloc = -1;
            GeometryFeature gf = (GeometryFeature)this.dataSet.getFeature(key);
            if (gf == null) {
                return null;
            }
            JGeometry geo = gf.getSpatialAttribute();
            if (geo == null) {
                return null;
            }
            AbstractSpatialIndex index = this.geomFeatureTree.get(key);
            if (index == null) {
                index = this.buildSegmentTree(key);
            }
            if (index == null) {
                return null;
            }
            if (!(index instanceof RTreeIndex)) {
                return null;
            }
            int dim = 2;
            double[] oords = null;
            int offset = 0;
            double distance = 0.0;
            double dx = 0.0;
            double dy = 0.0;
            Point2D pt = null;
            int[] elemInfo = null;
            int coordsStart = 0;
            try {
                boolean gotSome = false;
                double[][] searchMBR = new double[][]{new double[2], new double[2]};
                searchMBR[0][0] = point.getX() - tolerance;
                searchMBR[0][1] = point.getX() + tolerance;
                searchMBR[1][0] = point.getY() - tolerance;
                searchMBR[1][1] = point.getY() + tolerance;
                double minDist = Double.MAX_VALUE;
                ArrayList a = new ArrayList(500);
                a.clear();
                gotSome = ((RTreeIndex)index).getTree().search((double[][])searchMBR, a);
                if (!gotSome) break block24;
                JGeometry[] geos = JGeometryUtil.getElements((JGeometry)geo);
                for (int i = 0; i < a.size(); ++i) {
                    JGeometrySegment o = (JGeometrySegment)a.get(i);
                    int seg = o.getSegmentIndex();
                    int elemindex = o.getElementIndex();
                    int subelemindex = o.getSubElementIndex();
                    if (o.getSegmentType() == JGeometrySegment.POINT_TYPE) {
                        if (!checkIsolatedPoints || !((distance = Math.sqrt((dx = (pt = geos[elemindex].getJavaPoint()).getX() - point.getX()) * dx + (dy = pt.getY() - point.getY()) * dy)) <= tolerance) || !(distance < minDist)) continue;
                        minDist = distance;
                        intersectPoint = pt;
                        fseg = o;
                        fsegloc = 0;
                        continue;
                    }
                    if (o.getSegmentType() == JGeometrySegment.LINE_TYPE) {
                        Point2D.Double p2;
                        Point2D.Double p1;
                        double[] dist;
                        dim = geos[elemindex].getDimensions();
                        oords = geos[elemindex].getOrdinatesArray();
                        offset = 0;
                        if (subelemindex > 0) {
                            elemInfo = geos[elemindex].getElemInfo();
                            offset = elemInfo[3 * subelemindex] - 1;
                        }
                        if ((dist = GeometryUtil.distToLine((Point2D)point, (Point2D)(p1 = new Point2D.Double(oords[dim * seg + offset], oords[dim * seg + 1 + offset])), (Point2D)(p2 = new Point2D.Double(oords[dim * (seg + 1) + offset], oords[dim * (seg + 1) + 1 + offset])))) == null || !(dist[0] <= tolerance) || !(dist[0] < minDist)) continue;
                        minDist = dist[0];
                        fseg = o;
                        fsegloc = (int)dist[1];
                        if ((int)dist[1] == 0) {
                            intersectPoint = p1;
                            continue;
                        }
                        if ((int)dist[1] == 1) {
                            intersectPoint = p2;
                            continue;
                        }
                        intersectPoint = GeometryUtil.getIntersectionPoint((Point2D)point, (Point2D)p1, (Point2D)p2);
                        fsegloc = 2;
                        if (intersectPoint == null) continue;
                        dx = intersectPoint.getX() - ((Point2D)p1).getX();
                        if (Math.sqrt(dx * dx + (dy = intersectPoint.getY() - ((Point2D)p1).getY()) * dy) <= tolerance) {
                            intersectPoint = p1;
                            fsegloc = 0;
                            continue;
                        }
                        dx = intersectPoint.getX() - ((Point2D)p2).getX();
                        if (!(Math.sqrt(dx * dx + (dy = intersectPoint.getY() - ((Point2D)p2).getY()) * dy) <= tolerance)) continue;
                        intersectPoint = p2;
                        fsegloc = 1;
                        continue;
                    }
                    if (o.getSegmentType() == JGeometrySegment.ARC_TYPE && checkArcs || o.getSegmentType() == JGeometrySegment.CIRCLE_TYPE && checkCircles) {
                        elemInfo = geos[elemindex].getElemInfo();
                        dim = geos[elemindex].getDimensions();
                        oords = geos[elemindex].getOrdinatesArray();
                        offset = 0;
                        int etype = elemInfo[1];
                        if (o.getSegmentType() == JGeometrySegment.ARC_TYPE && etype == 4 || o.getSegmentType() == JGeometrySegment.CIRCLE_TYPE && (etype == 1005 || etype == 2005)) {
                            offset = 3;
                        }
                        coordsStart = elemInfo[3 * subelemindex + offset] + seg * 2 * dim;
                        for (int arcPt = 0; arcPt < 3; ++arcPt) {
                            int pos = coordsStart - 1 + arcPt * dim;
                            pt = new Point2D.Double(oords[pos], oords[pos + 1]);
                            dx = pt.getX() - point.getX();
                            distance = Math.sqrt(dx * dx + (dy = pt.getY() - point.getY()) * dy);
                            if (!(distance <= tolerance) || !(distance < minDist)) continue;
                            minDist = distance;
                            intersectPoint = pt;
                            fseg = o;
                            fsegloc = arcPt == 0 ? 0 : (arcPt == 1 ? 2 : 1);
                        }
                        continue;
                    }
                    if (o.getSegmentType() != JGeometrySegment.RECTANGLE_TYPE || !checkRectangles) continue;
                    elemInfo = geos[elemindex].getElemInfo();
                    dim = geos[elemindex].getDimensions();
                    oords = geos[elemindex].getOrdinatesArray();
                    coordsStart = elemInfo[3 * subelemindex];
                    double x1 = 0.0;
                    double x2 = 0.0;
                    double y1 = 0.0;
                    double y2 = 0.0;
                    for (int recPt = 0; recPt < 4; ++recPt) {
                        if (recPt < 2) {
                            int pos = coordsStart - 1 + recPt * dim;
                            pt = new Point2D.Double(oords[pos], oords[pos + 1]);
                            if (recPt == 0) {
                                x1 = pt.getX();
                                y1 = pt.getY();
                            } else {
                                x2 = pt.getX();
                                y2 = pt.getY();
                            }
                        } else {
                            pt = recPt == 2 ? new Point2D.Double(x1, y2) : new Point2D.Double(x2, y1);
                        }
                        dx = pt.getX() - point.getX();
                        dy = pt.getY() - point.getY();
                        distance = Math.sqrt(dx * dx + dy * dy);
                        if (!(distance <= tolerance) || !(distance < minDist)) continue;
                        minDist = distance;
                        intersectPoint = pt;
                        fseg = o;
                        fsegloc = recPt == 0 ? 0 : (recPt == 1 ? 1 : 2);
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Exception in getIntersectionPoint: " + e.getMessage());
                intersectPoint = null;
            }
        }
        if (intersectPoint == null) {
            return null;
        }
        return new JGeometrySegmentPoint(intersectPoint, fseg, fsegloc, key);
    }

    public Hashtable<String, JGeometrySegmentPoint[]> getSegmentPointsOfFeaturesWithinBox(Rectangle2D box) {
        if (this.dataSet == null || box == null) {
            return null;
        }
        List<GeoObject> feats = this.getFeatures(box);
        if (feats == null || feats.size() == 0) {
            return null;
        }
        String keyColumn = ((GeometrySet)this.dataSet).getKeyColumn();
        Hashtable<String, JGeometrySegmentPoint[]> result = new Hashtable<String, JGeometrySegmentPoint[]>();
        for (int i = 0; i < feats.size(); ++i) {
            JGeometrySegmentPoint[] finter;
            GeometryFeature sf = (GeometryFeature)feats.get(i);
            Field key = sf.getAttribute(keyColumn);
            if (key == null || key.getValue() == null || (finter = this.getSegmentPointsWithinBox(key.getValue().toString(), box)) == null) continue;
            result.put(key.getValue().toString(), finter);
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    public JGeometrySegmentPoint[] getSegmentPointsWithinBox(String key, Rectangle2D box) {
        if (key == null || box == null) {
            return null;
        }
        GeometryFeature gf = (GeometryFeature)this.dataSet.getFeature(key);
        if (gf == null) {
            return null;
        }
        JGeometry geo = gf.getSpatialAttribute();
        if (geo == null) {
            return null;
        }
        AbstractSpatialIndex index = this.geomFeatureTree.get(key);
        if (index == null) {
            index = this.buildSegmentTree(key);
        }
        if (index == null) {
            return null;
        }
        if (!(index instanceof RTreeIndex)) {
            return null;
        }
        int dim = 2;
        double[] oords = null;
        int offset = 0;
        int[] elemInfo = null;
        ArrayList<JGeometrySegmentPoint> featSegments = new ArrayList<JGeometrySegmentPoint>();
        try {
            boolean gotSome = false;
            double[][] searchMBR = new double[][]{new double[2], new double[2]};
            searchMBR[0][0] = box.getMinX();
            searchMBR[0][1] = box.getMaxX();
            searchMBR[1][0] = box.getMinY();
            searchMBR[1][1] = box.getMaxY();
            ArrayList a = new ArrayList(500);
            a.clear();
            gotSome = ((RTreeIndex)index).getTree().search((double[][])searchMBR, a);
            if (gotSome) {
                JGeometry[] geos = JGeometryUtil.getElements((JGeometry)geo);
                Hashtable<String, String> segs = new Hashtable<String, String>();
                String search = null;
                for (int i = 0; i < a.size(); ++i) {
                    JGeometrySegment o = (JGeometrySegment)a.get(i);
                    int seg = o.getSegmentIndex();
                    int elemindex = o.getElementIndex();
                    int subelemindex = o.getSubElementIndex();
                    if (o.getSegmentType() != JGeometrySegment.LINE_TYPE) continue;
                    dim = geos[elemindex].getDimensions();
                    oords = geos[elemindex].getOrdinatesArray();
                    offset = 0;
                    if (subelemindex > 0) {
                        elemInfo = geos[elemindex].getElemInfo();
                        offset = elemInfo[3 * subelemindex] - 1;
                    }
                    Point2D.Double p1 = new Point2D.Double(oords[dim * seg + offset], oords[dim * seg + 1 + offset]);
                    search = "" + elemindex + ":" + (seg - 1) + ":" + subelemindex + ":" + 1;
                    if (box.contains(p1) && segs.get(search) == null) {
                        featSegments.add(new JGeometrySegmentPoint((Point2D)p1, o, 0, key));
                        segs.put("" + elemindex + ":" + seg + ":" + subelemindex + ":" + 0, "*");
                    }
                    Point2D.Double p2 = new Point2D.Double(oords[dim * (seg + 1) + offset], oords[dim * (seg + 1) + 1 + offset]);
                    search = "" + elemindex + ":" + (seg + 1) + ":" + subelemindex + ":" + 0;
                    if (!box.contains(p2) || segs.get(search) != null) continue;
                    featSegments.add(new JGeometrySegmentPoint((Point2D)p2, o, 1, key));
                    segs.put("" + elemindex + ":" + seg + ":" + subelemindex + ":" + 1, "*");
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception in getSegmentPointsWithinBox: " + e.getMessage());
            featSegments.clear();
        }
        if (featSegments.size() == 0) {
            return null;
        }
        return featSegments.toArray(new JGeometrySegmentPoint[featSegments.size()]);
    }

    public void clearSegmentTree(String key) {
        if (key == null) {
            return;
        }
        this.geomFeatureTree.remove(key);
    }

    public AbstractSpatialIndex buildSegmentTree(String key) {
        if (key == null || this.dataSet == null || this.sptIndex == null) {
            return null;
        }
        this.geomFeatureTree.remove(key);
        GeometryFeature gf = (GeometryFeature)this.dataSet.getFeature(key);
        if (gf == null) {
            return null;
        }
        JGeometry geo = gf.getSpatialAttribute();
        if (geo == null) {
            return null;
        }
        JGeometry[] geos = JGeometryUtil.getElements((JGeometry)geo);
        if (geos == null || geos.length == 0) {
            return null;
        }
        RTreeIndex index = null;
        if (!(this.sptIndex instanceof RTreeIndex)) {
            return null;
        }
        index = new RTreeIndex();
        ((AbstractSpatialIndex)index).create(this.sptIndex.getProperties());
        if (index == null) {
            return null;
        }
        Vector<double[]> mbrs = new Vector<double[]>();
        Vector<JGeometrySegment> segments = new Vector<JGeometrySegment>();
        for (int k = 0; k < geos.length; ++k) {
            int i;
            int segpos;
            int coordsEnd;
            int coordsStart;
            int l;
            int etype;
            int offset;
            double[] oords;
            int dim;
            int nelems;
            int[] elemInfo;
            double[] mbr = geos[k].getMBR();
            JGeometrySegment fseg = null;
            if (geos[k].isPoint() || geos[k].isRectangle() || geos[k].isCircle()) {
                fseg = new JGeometrySegment();
                fseg.setElementIndex(k);
                fseg.setSegmentIndex(0);
                fseg.setSubElementIndex(0);
                if (geos[k].isPoint()) {
                    fseg.setSegmentType(JGeometrySegment.POINT_TYPE);
                } else if (geos[k].isRectangle()) {
                    fseg.setSegmentType(JGeometrySegment.RECTANGLE_TYPE);
                } else if (geos[k].isCircle()) {
                    fseg.setSegmentType(JGeometrySegment.CIRCLE_TYPE);
                }
                mbrs.add(mbr);
                segments.add(fseg);
                continue;
            }
            if (geos[k].getType() == 3) {
                elemInfo = geos[k].getElemInfo();
                nelems = elemInfo.length / 3;
                dim = geos[k].getDimensions();
                oords = geos[k].getOrdinatesArray();
                offset = 0;
                etype = elemInfo[1];
                if (etype == 1005 || etype == 2005) {
                    offset = 3;
                    --nelems;
                }
                for (l = 0; l < nelems; ++l) {
                    coordsStart = elemInfo[3 * l + offset];
                    coordsEnd = -1;
                    coordsEnd = l < nelems - 1 ? elemInfo[3 * (l + 1) + offset] : oords.length;
                    if (elemInfo[3 * l + 2 + offset] == 2) {
                        segpos = 0;
                        for (i = coordsStart - 1; i < coordsEnd - dim; i += dim * 2) {
                            fseg = new JGeometrySegment();
                            fseg.setElementIndex(k);
                            fseg.setSegmentIndex(segpos++);
                            fseg.setSubElementIndex(l);
                            fseg.setSegmentType(JGeometrySegment.ARC_TYPE);
                            mbr = GeometryUtil.getArcMBR((double)oords[i], (double)oords[i + 1], (double)oords[i + dim], (double)oords[i + dim + 1], (double)oords[i + 2 * dim], (double)oords[i + 2 * dim + 1]);
                            if (mbr == null) continue;
                            mbrs.add(mbr);
                            segments.add(fseg);
                        }
                        continue;
                    }
                    if (elemInfo[3 * l + 2 + offset] == 3) {
                        fseg = new JGeometrySegment();
                        fseg.setElementIndex(k);
                        fseg.setSegmentIndex(0);
                        fseg.setSubElementIndex(l);
                        fseg.setSegmentType(JGeometrySegment.RECTANGLE_TYPE);
                        double xmin = Math.min(oords[coordsStart - 1], oords[coordsStart - 1 + dim]);
                        double xmax = Math.max(oords[coordsStart - 1], oords[coordsStart - 1 + dim]);
                        double ymin = Math.min(oords[coordsStart], oords[coordsStart + dim]);
                        double ymax = Math.max(oords[coordsStart], oords[coordsStart + dim]);
                        mbr = new double[]{xmin, ymin, xmax, ymax};
                        mbrs.add(mbr);
                        segments.add(fseg);
                        continue;
                    }
                    if (elemInfo[3 * l + 2 + offset] == 4) {
                        fseg = new JGeometrySegment();
                        fseg.setElementIndex(k);
                        fseg.setSegmentIndex(0);
                        fseg.setSubElementIndex(l);
                        fseg.setSegmentType(JGeometrySegment.CIRCLE_TYPE);
                        mbr = GeometryUtil.getArcMBR((double)oords[coordsStart - 1], (double)oords[coordsStart], (double)oords[coordsStart - 1 + dim], (double)oords[coordsStart + dim], (double)oords[coordsStart - 1 + 2 * dim], (double)oords[coordsStart + 2 * dim]);
                        if (mbr == null) continue;
                        mbrs.add(mbr);
                        segments.add(fseg);
                        continue;
                    }
                    segpos = 0;
                    for (i = coordsStart - 1; i < coordsEnd - dim; i += dim) {
                        mbr = new double[4];
                        fseg = new JGeometrySegment();
                        fseg.setElementIndex(k);
                        fseg.setSegmentIndex(segpos++);
                        fseg.setSubElementIndex(l);
                        fseg.setSegmentType(JGeometrySegment.LINE_TYPE);
                        mbr[0] = Math.min(oords[i], oords[i + dim]);
                        mbr[2] = Math.max(oords[i], oords[i + dim]);
                        mbr[1] = Math.min(oords[i + 1], oords[i + dim + 1]);
                        mbr[3] = Math.max(oords[i + 1], oords[i + dim + 1]);
                        mbrs.add(mbr);
                        segments.add(fseg);
                    }
                }
                continue;
            }
            if (geos[k].getType() != 2) continue;
            elemInfo = geos[k].getElemInfo();
            nelems = elemInfo.length / 3;
            dim = geos[k].getDimensions();
            oords = geos[k].getOrdinatesArray();
            offset = 0;
            etype = elemInfo[1];
            if (etype == 4) {
                offset = 3;
                --nelems;
            }
            for (l = 0; l < nelems; ++l) {
                coordsStart = elemInfo[3 * l + offset];
                coordsEnd = -1;
                coordsEnd = l < nelems - 1 ? elemInfo[3 * (l + 1) + offset] : oords.length;
                if (elemInfo[3 * l + 2 + offset] == 2) {
                    segpos = 0;
                    for (i = coordsStart - 1; i < coordsEnd - dim; i += dim * 2) {
                        fseg = new JGeometrySegment();
                        fseg.setElementIndex(k);
                        fseg.setSegmentIndex(segpos++);
                        fseg.setSubElementIndex(l);
                        fseg.setSegmentType(JGeometrySegment.ARC_TYPE);
                        mbr = GeometryUtil.getArcMBR((double)oords[i], (double)oords[i + 1], (double)oords[i + dim], (double)oords[i + dim + 1], (double)oords[i + 2 * dim], (double)oords[i + 2 * dim + 1]);
                        if (mbr == null) continue;
                        mbrs.add(mbr);
                        segments.add(fseg);
                    }
                    continue;
                }
                segpos = 0;
                for (i = coordsStart - 1; i < coordsEnd - dim; i += dim) {
                    mbr = new double[4];
                    mbr[0] = Math.min(oords[i], oords[i + dim]);
                    mbr[2] = Math.max(oords[i], oords[i + dim]);
                    mbr[1] = Math.min(oords[i + 1], oords[i + dim + 1]);
                    mbr[3] = Math.max(oords[i + 1], oords[i + dim + 1]);
                    fseg = new JGeometrySegment();
                    fseg.setElementIndex(k);
                    fseg.setSegmentIndex(segpos++);
                    fseg.setSubElementIndex(l);
                    fseg.setSegmentType(JGeometrySegment.LINE_TYPE);
                    mbrs.add(mbr);
                    segments.add(fseg);
                }
            }
        }
        double[][][] mbhs = new double[mbrs.size()][2][2];
        Object[] o = new Object[mbrs.size()];
        for (int i = 0; i < mbrs.size(); ++i) {
            double[] mbr = (double[])mbrs.get(i);
            JGeometrySegment fseg = (JGeometrySegment)segments.get(i);
            mbhs[i][0][0] = mbr[0];
            mbhs[i][0][1] = mbr[2];
            mbhs[i][1][0] = mbr[1];
            mbhs[i][1][1] = mbr[3];
            o[i] = fseg;
        }
        try {
            index.getTree().packTree(mbhs, o);
            this.geomFeatureTree.put(key, index);
        }
        catch (Exception e) {
            index = null;
            System.out.println("Exception in buildSegmentTree: " + e.getMessage());
            return null;
        }
        return index;
    }

    public RubberPoint getRubberPoint(String key, Point2D point, double tolerance) {
        GeometryFeature gf = (GeometryFeature)this.dataSet.getFeature(key);
        if (gf == null) {
            return null;
        }
        JGeometry geom = gf.getSpatialAttribute();
        if (geom == null) {
            return null;
        }
        RubberPoint rbpoint = null;
        ArrayList<Point2D.Double> rbpoints = new ArrayList<Point2D.Double>();
        JGeometrySegmentPoint finter = this.getSegmentPoint(key, point, tolerance, false, false, false, true);
        if (finter == null || finter.getPoint() == null || finter.getPointLocation() == 2) {
            return null;
        }
        JGeometrySegment fseg = finter.getSegment();
        if (fseg == null) {
            return null;
        }
        if (geom.isRectangle()) {
            if (fseg.getSegmentType() == JGeometrySegment.RECTANGLE_TYPE) {
                rbpoint = new RubberPoint();
                rbpoint.setId(key);
                rbpoint.setDragPoint(finter);
                double[] oords = geom.getOrdinatesArray();
                int dim = geom.getDimensions();
                Point2D pt = finter.getPoint();
                if (pt.getX() == oords[0] && pt.getY() == oords[1]) {
                    rbpoints.add(new Point2D.Double(oords[dim], oords[dim + 1]));
                } else {
                    rbpoints.add(new Point2D.Double(oords[0], oords[1]));
                }
                rbpoint.setFixedPoints(rbpoints.toArray(new Point2D[rbpoints.size()]));
                rbpoint.appliesToRectangle(true);
                return rbpoint;
            }
            return null;
        }
        JGeometry[] geoms = JGeometryUtil.getElements((JGeometry)geom);
        int elemSel = fseg.getElementIndex();
        int segSel = fseg.getSegmentIndex();
        int subelem = fseg.getSubElementIndex();
        int segPos = finter.getPointLocation();
        double[] oords = geoms[elemSel].getOrdinatesArray();
        int[] elemInfo = geoms[elemSel].getElemInfo();
        int nelems = elemInfo.length / 3;
        int dim = geoms[elemSel].getDimensions();
        int nvertexes = oords.length / dim;
        int offset = elemInfo[3 * subelem] - 1;
        if (nelems > 1) {
            nvertexes = subelem == nelems - 1 ? (oords.length - offset) / dim : (elemInfo[3 * (subelem + 1)] - offset) / dim;
        }
        if (segPos == 0) {
            if (segSel == 0) {
                rbpoints.add(new Point2D.Double(oords[dim * (segSel + 1) + offset], oords[dim * (segSel + 1) + 1 + offset]));
                if (geoms[elemSel].getType() == 3) {
                    rbpoints.add(new Point2D.Double(oords[dim * (nvertexes - 2) + offset], oords[dim * (nvertexes - 2) + 1 + offset]));
                }
            } else {
                rbpoints.add(new Point2D.Double(oords[dim * (segSel + 1) + offset], oords[dim * (segSel + 1) + 1 + offset]));
                rbpoints.add(new Point2D.Double(oords[dim * (segSel - 1) + offset], oords[dim * (segSel - 1) + 1 + offset]));
            }
        } else if (segSel == nvertexes - 2) {
            rbpoints.add(new Point2D.Double(oords[dim * segSel + offset], oords[dim * segSel + 1 + offset]));
            if (geoms[elemSel].getType() == 3) {
                rbpoints.add(new Point2D.Double(oords[dim + offset], oords[dim + 1 + offset]));
            }
        } else {
            rbpoints.add(new Point2D.Double(oords[dim * segSel + offset], oords[dim * segSel + 1 + offset]));
            rbpoints.add(new Point2D.Double(oords[dim * (segSel + 2) + offset], oords[dim * (segSel + 2) + 1 + offset]));
        }
        if (finter != null) {
            rbpoint = new RubberPoint();
            rbpoint.setDragPoint(finter);
        }
        if (finter != null && rbpoints.size() > 0) {
            rbpoint.setFixedPoints(rbpoints.toArray(new Point2D[rbpoints.size()]));
        }
        rbpoint.setId(key);
        return rbpoint;
    }

    public RubberPoint[] getRubberPoints(Point2D point, double tolerance) {
        if (point == null) {
            return null;
        }
        List<GeoObject> features = this.getFeatures(point, tolerance);
        if (features == null || features.size() == 0) {
            return null;
        }
        Vector<RubberPoint> rbpoints = new Vector<RubberPoint>();
        for (int i = 0; i < features.size(); ++i) {
            String keyColumn = this.getGeometrySet().getKeyColumn();
            String key = ((GeometryFeature)features.get(i)).getAttribute(keyColumn).getValue().toString();
            RubberPoint rb = this.getRubberPoint(key, point, tolerance);
            if (rb == null) continue;
            rbpoints.add(rb);
        }
        if (rbpoints.size() == 0) {
            return null;
        }
        return rbpoints.toArray(new RubberPoint[rbpoints.size()]);
    }

    @Override
    public void undo(EditChangeEvent change) throws Exception {
        super.undo(change);
        String id = change.getKey();
        if (id == null) {
            return;
        }
        this.clearSegmentTree(id);
    }
}

