/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.wfs.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import oracle.bali.ewt.border.TitledPane;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class WFSConnectionPanel
extends JPanel {
    private JLabel serverLabel = new JLabel();
    private JTextField serverField = new JTextField();
    private JLabel versionLabel = new JLabel();
    private JComboBox versionCombo = new JComboBox();
    private JCheckBox secCheckBox = new JCheckBox();
    private TitledPane secTitledPane = new TitledPane();
    private JPanel secPanel = new JPanel();
    private JTextField userTxt = new JTextField();
    private JPasswordField pwdTxt = new JPasswordField();
    private String serverURL = null;

    public WFSConnectionPanel(String serverURL) {
        this.serverURL = serverURL;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(530, 210));
        this.setPreferredSize(new Dimension(530, 210));
        this.serverLabel = new JLabel(MessagesBundle.getMessage("Label_wfs_get_capabilities_url"));
        if (this.serverURL == null) {
            this.serverField.setText("http://localhost:7001/SpatialWS-SpatialWS-context-root/xmlwfsservlet");
        } else {
            this.serverField.setText(this.serverURL);
        }
        this.versionLabel.setText(MessagesBundle.getMessage("Label_version"));
        this.versionCombo.addItem("1.0.0");
        this.secPanel.setLayout(new GridBagLayout());
        this.secPanel.setSize(new Dimension(240, 100));
        this.secPanel.setPreferredSize(new Dimension(240, 10));
        this.secPanel.add((Component)new JLabel(MessagesBundle.getMessage("Label_user")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 55, 0, 0), 0, 0));
        this.secPanel.add((Component)this.userTxt, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.secPanel.add((Component)new JLabel(MessagesBundle.getMessage("Label_password")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 30, 0, 0), 0, 0));
        this.secPanel.add((Component)this.pwdTxt, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.secPanel.add((Component)new JLabel(), new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.secCheckBox.setText(MessagesBundle.getMessage("Checkbox_basic_authentication"));
        this.secTitledPane.setTitle((Component)this.secCheckBox);
        this.secTitledPane.setContent((Component)this.secPanel);
        this.secCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WFSConnectionPanel.this.secCheckBox_actionPerformed(e);
            }
        });
        this.add((Component)this.serverLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.serverField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 10), 0, 0));
        this.add((Component)this.versionLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.versionCombo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
        this.add((Component)this.secTitledPane, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.secCheckBox_actionPerformed(null);
    }

    public String getServer() {
        return this.serverField.getText();
    }

    private void secCheckBox_actionPerformed(ActionEvent e) {
        if (this.secCheckBox.isSelected()) {
            this.userTxt.setEnabled(true);
            this.pwdTxt.setEnabled(true);
        } else {
            this.userTxt.setEnabled(false);
            this.pwdTxt.setEnabled(false);
        }
    }

    public boolean isAuthenticationEnabled() {
        return this.secCheckBox.isSelected();
    }

    public String getUser() {
        if (!this.isAuthenticationEnabled()) {
            return null;
        }
        if (this.userTxt.getText().trim().length() == 0) {
            return null;
        }
        return this.userTxt.getText().trim();
    }

    public String getPassword() {
        if (!this.isAuthenticationEnabled()) {
            return null;
        }
        String pwd = String.valueOf(this.pwdTxt.getPassword());
        if (pwd == null || pwd.trim().length() == 0) {
            return null;
        }
        return pwd.trim();
    }

    public String getVersion() {
        return this.versionCombo.getSelectedItem().toString();
    }
}

