/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.maps.core.Layer;
import oracle.maps.core.LayerManager;
import oracle.maps.core.LayerManagerEvent;
import oracle.maps.core.SelectionEvent;
import oracle.maps.core.SelectionListener;

public class StatusBarPanel
extends JPanel
implements ChangeListener,
SelectionListener {
    protected JProgressBar bar = null;
    protected LayerManager lm = null;
    protected JLabel toolLabel = new JLabel("Tool: none");
    protected JLabel numSelLabel = new JLabel("Selected: 0");

    public StatusBarPanel(JProgressBar bar) {
        this.setBorder(BorderFactory.createEtchedBorder(1));
        this.setLayout(new GridBagLayout());
        this.setProgressBar(bar);
        this.add((Component)this.toolLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.numSelLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
    }

    public void setProgressBar(JProgressBar bar) {
        if (this.bar != null) {
            this.remove(this.bar);
        }
        this.bar = bar;
        if (bar != null) {
            bar.setPreferredSize(new Dimension(300, 20));
            this.add((Component)bar, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        if (evt instanceof LayerManagerEvent) {
            this.update();
        }
    }

    @Override
    public void selectionChanged(SelectionEvent evt) {
        this.update();
    }

    private void update() {
        if (this.lm != null) {
            String toolName = "none";
            Layer tool = this.lm.getLayerByTag("toolLayer");
            if (tool != null) {
                toolName = tool.getName();
            }
            this.toolLabel.setText("Tool: " + toolName);
            int selected = this.lm.getAllSelections().size();
            this.numSelLabel.setText("Selected: " + selected);
        }
    }

    public synchronized void setLayerManager(LayerManager lm) {
        this.lm = lm;
    }
}

