/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.XFViewPort;
import oracle.sdovis.style.StyleColor;
import oracle.spatial.geometry.JGeometry;

public class NewGeomSelectPanel
extends JPanel {
    int lastSelected = -1;

    public NewGeomSelectPanel(JGeometry part1, JGeometry part2) {
        JLabel selfeatLabel = new JLabel(MessagesBundle.getMessage("Part_tobe_new_feature"));
        Image icon1 = this.generateGeometryIcon(new StyleColor(Color.RED, Color.RED), part1);
        JLabel jPanel1 = new JLabel(new ImageIcon(icon1));
        Image icon2 = this.generateGeometryIcon(new StyleColor(Color.RED, Color.RED), part2);
        JLabel jPanel2 = new JLabel(new ImageIcon(icon2));
        JRadioButton firstRButton = new JRadioButton();
        firstRButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewGeomSelectPanel.this.lastSelected = 1;
            }
        });
        JRadioButton secondRButton = new JRadioButton();
        secondRButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewGeomSelectPanel.this.lastSelected = 2;
            }
        });
        ButtonGroup bg = new ButtonGroup();
        bg.add(firstRButton);
        bg.add(secondRButton);
        firstRButton.setSelected(true);
        this.setLayout(new GridBagLayout());
        this.add((Component)selfeatLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)jPanel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)firstRButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 10, 0), 0, 0));
        this.add((Component)secondRButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 10, 0), 0, 0));
    }

    public int getLastSelected() {
        return this.lastSelected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image generateGeometryIcon(StyleColor sty, JGeometry geom) {
        if (sty == null || geom == null) {
            return null;
        }
        int width = 64;
        int height = 64;
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics2D g2 = (Graphics2D)((Image)img).getGraphics();
        g2.setColor(Color.white);
        g2.fillRect(0, 0, width, height);
        XFViewPort mXFViewPort = new XFViewPort();
        mXFViewPort.setDeviceView((Rectangle2D)new Rectangle2D.Double(2.0, 2.0, (double)width - 4.0, (double)height - 4.0));
        double[] mbr = geom.getMBR();
        double dx = mbr[2] - mbr[0];
        double dy = mbr[3] - mbr[1];
        mXFViewPort.setStrict(true);
        mXFViewPort.setDataView((Rectangle2D)new Rectangle2D.Double(mbr[0], mbr[1], dx, dy));
        AffineTransform mAT = mXFViewPort.getAffineTransform();
        Shape shp = geom.createShape(mAT, true);
        try {
            sty.apply(null, g2, shp, geom.getType(), null);
        }
        catch (Exception ex) {
            img.flush();
            img = null;
        }
        finally {
            g2.dispose();
        }
        return img;
    }
}

