/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.plaf.basic.BasicSliderUI;
import oracle.maps.core.MapCanvas;
import oracle.mdeditor.resources.icons.Icons;

public class MapNavigationPanel
extends JPanel {
    public static String BUTTON_LEFT = "left";
    public static String BUTTON_RIGHT = "right";
    public static String BUTTON_UP = "up";
    public static String BUTTON_DOWN = "down";
    public static String BUTTON_UPLEFT = "upleft";
    public static String BUTTON_UPRIGHT = "upright";
    public static String BUTTON_DOWNLEFT = "downleft";
    public static String BUTTON_DOWNRIGHT = "downright";
    public static String BUTTON_ZOOMIN = "zoomin";
    public static String BUTTON_ZOOMOUT = "zoomout";
    protected Hashtable<String, AbstractButton> mapButtons = new Hashtable();
    private MapCanvas drawPanel = null;
    private GridBagLayout layout = new GridBagLayout();
    private JButton left = new JButton(Icons.getIcon("pan_west.gif"));
    private JButton right = new JButton(Icons.getIcon("pan_east.gif"));
    private JButton up = new JButton(Icons.getIcon("pan_north.gif"));
    private JButton down = new JButton(Icons.getIcon("pan_south.gif"));
    private JButton upleft = new JButton(Icons.getIcon("pan_nw.gif"));
    private JButton upright = new JButton(Icons.getIcon("pan_ne.gif"));
    private JButton downleft = new JButton(Icons.getIcon("pan_sw.gif"));
    private JButton downright = new JButton(Icons.getIcon("pan_se.gif"));
    private JButton zoomin = new JButton(Icons.getIcon("nav_zoomin.gif"));
    private JButton zoomout = new JButton(Icons.getIcon("nav_zoomout.gif"));
    private JButton[] buttons = new JButton[]{this.left, this.right, this.up, this.down, this.upleft, this.upright, this.downleft, this.downright, this.zoomin, this.zoomout};
    private boolean slideBarEnabled = false;
    private int panDelta = 100;
    private int sliderValue = 50;
    private int tickSpacing = 5;
    private JSlider slideBar = new JSlider(1, 0, 100, this.sliderValue);

    public MapNavigationPanel() {
        this.setLayout(this.layout);
        this.mapButtons.put(BUTTON_LEFT, this.left);
        this.mapButtons.put(BUTTON_RIGHT, this.right);
        this.mapButtons.put(BUTTON_UP, this.up);
        this.mapButtons.put(BUTTON_DOWN, this.down);
        this.mapButtons.put(BUTTON_UPLEFT, this.upleft);
        this.mapButtons.put(BUTTON_UPRIGHT, this.upright);
        this.mapButtons.put(BUTTON_DOWNLEFT, this.downleft);
        this.mapButtons.put(BUTTON_DOWNRIGHT, this.downright);
        this.mapButtons.put(BUTTON_ZOOMIN, this.zoomin);
        this.mapButtons.put(BUTTON_ZOOMOUT, this.zoomout);
        for (int i = 0; i < this.buttons.length; ++i) {
            JButton cB = this.buttons[i];
            cB.setBorderPainted(false);
            cB.setOpaque(false);
            cB.setName("MapNavPanelButton");
        }
        this.slideBar.setOpaque(false);
        this.slideBar.setUI(new OMSliderUI(this.slideBar));
        this.slideBar.setMajorTickSpacing(this.tickSpacing);
        this.slideBar.setPaintTicks(true);
        this.slideBar.setSnapToTicks(true);
        int adjustXPadding = 0;
        int adjustYPadding = -7;
        this.add((Component)this.upleft, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), adjustXPadding, adjustYPadding));
        this.add((Component)this.up, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), adjustXPadding, adjustYPadding));
        this.add((Component)this.upright, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), adjustXPadding, adjustYPadding));
        this.add((Component)this.left, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), adjustXPadding, adjustYPadding));
        this.add((Component)this.right, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), adjustXPadding, adjustYPadding));
        this.add((Component)this.downleft, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), adjustXPadding, adjustYPadding));
        this.add((Component)this.down, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), adjustXPadding, adjustYPadding));
        this.add((Component)this.downright, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), adjustXPadding, adjustYPadding));
        this.add((Component)this.zoomin, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), adjustXPadding, adjustYPadding));
        if (this.slideBarEnabled) {
            this.add((Component)this.slideBar, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.add((Component)this.zoomout, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), adjustXPadding, adjustYPadding));
    }

    public void setDrawPanel(MapCanvas drawPanel) {
        this.drawPanel = drawPanel;
    }

    public void addActionListener4Button(String button, ActionListener al) {
        AbstractButton ab = this.mapButtons.get(button);
        if (ab == null) {
            return;
        }
        ab.addActionListener(al);
    }

    public int getPanShift() {
        return this.panDelta;
    }

    private class OMSliderUI
    extends BasicSliderUI {
        private Image im;

        public OMSliderUI(JSlider slider) {
            super(slider);
        }

        @Override
        public void paintThumb(Graphics g) {
            try {
                URL url = new URL(Icons.class.getResource("nav_zoomslider.gif"), "nav_zoomslider.gif");
                this.im = ImageIO.read(url);
                g.drawImage(this.im, this.thumbRect.x + 7, this.thumbRect.y, null);
            }
            catch (Exception e) {
                super.paintThumb(g);
            }
        }

        @Override
        public void paintFocus(Graphics g) {
        }

        @Override
        public void paintTicks(Graphics g) {
            g.translate(-10, 0);
            super.paintTicks(g);
            g.translate(10, 0);
        }

        @Override
        public void paintTrack(Graphics g) {
            g.translate(4, 0);
            Rectangle trackBounds = this.trackRect;
            if (this.slider.getOrientation() == 0) {
                super.paintTrack(g);
            } else {
                int cx = trackBounds.width / 2 - 2;
                int ch = trackBounds.height;
                g.translate(trackBounds.x + cx, trackBounds.y);
                g.setColor(Color.black);
                g.drawLine(1, 1, 1, ch - 2);
                g.translate(-(trackBounds.x + cx), -trackBounds.y);
            }
            g.translate(-4, 0);
        }
    }
}

