/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class GeometryMetadataTableModel
extends AbstractTableModel {
    Vector attrRecords = new Vector();
    protected static int NUM_COLUMNS = 4;
    protected static int START_NUM_ROWS = 0;
    protected int numRows = 0;
    static final String nameValue = MessagesBundle.getMessage("Name");
    static final String minValue = MessagesBundle.getMessage("Minimum_value");
    static final String maxValue = MessagesBundle.getMessage("Maximum_value");
    static final String tolValue = MessagesBundle.getMessage("Tolerance");

    public GeometryMetadataTableModel() {
        for (int i = 0; i < START_NUM_ROWS; ++i) {
            this.attrRecords.addElement(new ParamAttrRecord());
        }
        this.numRows = START_NUM_ROWS;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return nameValue;
            }
            case 1: {
                return minValue;
            }
            case 2: {
                return maxValue;
            }
            case 3: {
                return tolValue;
            }
        }
        return "";
    }

    @Override
    public int getColumnCount() {
        return NUM_COLUMNS;
    }

    public Class getColumnClass(int col) {
        if (col == 0) {
            return String.class;
        }
        if (col == 1) {
            return Double.class;
        }
        if (col == 2) {
            return Double.class;
        }
        if (col == 3) {
            return Double.class;
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public int getRowCount() {
        if (this.numRows < START_NUM_ROWS) {
            return START_NUM_ROWS;
        }
        return this.numRows;
    }

    @Override
    public Object getValueAt(int row, int col) {
        try {
            ParamAttrRecord t = (ParamAttrRecord)this.attrRecords.elementAt(row);
            switch (col) {
                case 0: {
                    return t.name;
                }
                case 1: {
                    return t.min;
                }
                case 2: {
                    return t.max;
                }
                case 3: {
                    return t.tol;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Object sc = null;
        ParamAttrRecord tr = (ParamAttrRecord)this.attrRecords.elementAt(row);
        if (value == null || value.toString().trim().length() == 0) {
            if (col == 0) {
                tr.name = null;
            } else if (col == 1) {
                tr.min = null;
            } else if (col == 2) {
                tr.max = null;
            } else if (col == 3) {
                tr.tol = null;
            }
        } else if (col == 0) {
            tr.name = value.toString();
        } else if (col == 1) {
            tr.min = Double.valueOf(value.toString());
        } else if (col == 2) {
            tr.max = Double.valueOf(value.toString());
        } else if (col == 3) {
            tr.tol = Double.valueOf(value.toString());
        }
        this.fireTableCellUpdated(row, col);
    }

    public void clearRows() {
        this.attrRecords.removeAllElements();
        if (this.numRows > START_NUM_ROWS) {
            this.fireTableRowsDeleted(START_NUM_ROWS, this.numRows - 1);
        }
        for (int i = 0; i < START_NUM_ROWS; ++i) {
            this.attrRecords.addElement(new ParamAttrRecord());
        }
        this.fireTableRowsUpdated(0, START_NUM_ROWS - 1);
        this.numRows = START_NUM_ROWS;
    }

    public String[] getDimNameValues() {
        if (this.numRows < 1) {
            return null;
        }
        String[] attrs = new String[this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            ParamAttrRecord tr = (ParamAttrRecord)this.attrRecords.elementAt(i);
            attrs[i] = tr.name;
        }
        return attrs;
    }

    public double[] getMinValues() {
        if (this.numRows < 1) {
            return null;
        }
        double[] attrs = new double[this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            ParamAttrRecord tr = (ParamAttrRecord)this.attrRecords.elementAt(i);
            attrs[i] = tr.min;
        }
        return attrs;
    }

    public double[] getMaxValues() {
        if (this.numRows < 1) {
            return null;
        }
        double[] attrs = new double[this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            ParamAttrRecord tr = (ParamAttrRecord)this.attrRecords.elementAt(i);
            attrs[i] = tr.max;
        }
        return attrs;
    }

    public double[] getToleranceValues() {
        if (this.numRows < 1) {
            return null;
        }
        double[] attrs = new double[this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            ParamAttrRecord tr = (ParamAttrRecord)this.attrRecords.elementAt(i);
            attrs[i] = tr.tol;
        }
        return attrs;
    }

    public void addRow(int idx, String name, double min, double max, double tol) {
        ParamAttrRecord trec = new ParamAttrRecord();
        trec.name = name;
        trec.min = new Double(min);
        trec.max = new Double(max);
        trec.tol = new Double(tol);
        if (idx == -1) {
            this.attrRecords.add(trec);
            this.fireTableRowsInserted(this.numRows, this.numRows);
        } else {
            this.attrRecords.insertElementAt(trec, idx + 1);
            this.fireTableRowsInserted(idx + 1, idx + 1);
        }
        ++this.numRows;
    }

    public void deleteRow(int idx) {
        if (idx < 0 || idx >= this.numRows) {
            return;
        }
        this.attrRecords.remove(idx);
        this.fireTableRowsDeleted(idx, idx);
        --this.numRows;
    }

    class ParamAttrRecord {
        String name = null;
        Double min = null;
        Double max = null;
        Double tol = null;

        ParamAttrRecord() {
        }
    }
}

