/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.mdeditor.ui.ColorIcon;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class CanvasPreferencesPanel
extends JPanel {
    private JLabel bgcolorLabel = new JLabel(MessagesBundle.getMessage("Label_background_color"));
    private ColorIcon bgcolorIcon = null;
    private JButton bgcolorButton = new JButton();
    private JCheckBox antialiasCBox = new JCheckBox(MessagesBundle.getMessage("Antialiasing"));
    private JCheckBox showscbarCBox = new JCheckBox(MessagesBundle.getMessage("Show_scale_bar"));

    public CanvasPreferencesPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(202, 94));
        this.bgcolorIcon = new ColorIcon(48, 16, new Color(255, 0, 0));
        this.bgcolorButton.setIcon(this.bgcolorIcon);
        this.bgcolorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CanvasPreferencesPanel.this.bgcolorButton_actionPerformed(e);
            }
        });
        this.add((Component)this.bgcolorLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.bgcolorButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.antialiasCBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.showscbarCBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
    }

    public boolean getAntialising() {
        return this.antialiasCBox.isSelected();
    }

    public void setAntialiasing(boolean aa) {
        this.antialiasCBox.setSelected(aa);
    }

    public boolean getShowScaleBar() {
        return this.showscbarCBox.isSelected();
    }

    public void setShowScaleBar(boolean sc) {
        this.showscbarCBox.setSelected(sc);
    }

    public Color getBackgroundColor() {
        return this.bgcolorIcon.getColor();
    }

    public void setBackgroundColor(Color c) {
        if (c == null) {
            return;
        }
        this.bgcolorIcon.setColor(c);
    }

    private void bgcolorButton_actionPerformed(ActionEvent e) {
        Color c = this.selectColor(this.bgcolorIcon.getColor());
        if (c != null) {
            this.bgcolorIcon.setColor(c);
        }
    }

    private Color selectColor(Color input) {
        if (input == null) {
            return null;
        }
        Color c = JColorChooser.showDialog(this, MessagesBundle.getMessage("Choose_color"), input);
        return c;
    }
}

