/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.tools;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.EventObject;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.maps.core.GeoObject;
import oracle.maps.core.MapCanvas;
import oracle.maps.geoobject.GeometryFeature;
import oracle.maps.layer.ActiveFeaturesLayer;
import oracle.maps.tools.BasicTool;
import oracle.maps.util.TransformUtils;
import oracle.mapviewer.share.Field;
import oracle.mdeditor.ui.ErrorDialog;
import oracle.mdeditor.ui.MainAppPanel;
import oracle.mdeditor.ui.NewGeomSelectPanel;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.edit.util.JGeometrySegmentPoint;
import oracle.sdovis.edit.util.JGeometryUtil;
import oracle.spatial.edit.index.geometry.IndexedGeometrySet;
import oracle.spatial.edit.layer.GeometrySetLayer;
import oracle.spatial.geometry.JGeometry;

public class BreakLineTool
extends BasicTool {
    GeometrySetLayer targetLayer = null;
    ActiveFeaturesLayer featureLayer = null;
    GeoObject activeFeature = null;
    JGeometrySegmentPoint snapInterPoint = null;
    MainAppPanel mainApp = null;

    public BreakLineTool(MapCanvas canvas) {
        super(canvas);
        this.properties.setDefaultProperty("oracle.maps.core.Layer.name", "Break line");
    }

    @Override
    public void handleTheEvent(EventObject evt) {
        this.targetLayer = (GeometrySetLayer)this.canvas.getLayerManager().getLayerByTag("targetLayer");
        this.activeFeature = this.featureLayer.getActiveFeature();
        if (evt instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)evt;
            int id = me.getID();
            switch (id) {
                case 500: {
                    this.mouseClicked(me);
                    this.finish();
                    break;
                }
                case 503: {
                    this.mouseMoved(me);
                    break;
                }
            }
        }
    }

    @Override
    public void clear() {
        this.snapInterPoint = null;
    }

    protected void mouseClicked(MouseEvent evt) {
        if (this.targetLayer == null || this.activeFeature == null || this.snapInterPoint == null) {
            return;
        }
    }

    protected void mouseMoved(MouseEvent evt) {
        this.snapInterPoint = null;
        if (this.targetLayer == null || this.activeFeature == null) {
            return;
        }
        try {
            Point2D.Double center = new Point2D.Double();
            this.canvas.getViewportTransform().inverseTransform(new Point2D.Double(evt.getX(), evt.getY()), center);
            double wcTolerance = TransformUtils.getWCTolerance(center, 3, this.canvas.getViewportTransform());
            GeometryFeature selectedFeature = (GeometryFeature)this.activeFeature;
            GeometrySetLayer gl = this.targetLayer;
            String keyColumn = gl.getIndexedDataSet().getDataSet().getKeyColumn();
            String key = selectedFeature.getAttribute(keyColumn).getValue().toString();
            this.snapInterPoint = ((IndexedGeometrySet)gl.getIndexedDataSet()).getSegmentPoint(key, new Point2D.Double(((Point2D)center).getX(), ((Point2D)center).getY()), wcTolerance, false, false, false, false);
            if (this.snapInterPoint == null || this.snapInterPoint.getSegment().getSegmentIndex() == 0 && this.snapInterPoint.getPointLocation() == 0) {
                this.snapInterPoint = null;
                this.featureLayer.setSnapPoint(null);
                return;
            }
            this.featureLayer.setSnapPoint(this.snapInterPoint.getPoint());
        }
        catch (Exception ex) {
            this.snapInterPoint = null;
            this.featureLayer.setSnapPoint(null);
        }
    }

    public JGeometrySegmentPoint getBreakPoint() {
        return this.snapInterPoint;
    }

    public void setFeatureLayer(ActiveFeaturesLayer featureLayer) {
        this.featureLayer = featureLayer;
    }

    public void setMainApp(MainAppPanel mainApp) {
        this.mainApp = mainApp;
    }

    private void finish() {
        JGeometrySegmentPoint segPoint = this.getBreakPoint();
        if (segPoint == null) {
            return;
        }
        GeometrySetLayer gl = (GeometrySetLayer)this.getCanvas().getLayerManager().getLayerByTag("targetLayer");
        List<GeoObject> selected = gl.getSelection();
        if (selected == null || selected.size() == 0) {
            return;
        }
        GeometryFeature feature = (GeometryFeature)selected.get(0);
        if (feature == null) {
            return;
        }
        JGeometry geom = feature.getSpatialAttribute();
        if (geom == null || geom.getType() != 2 && geom.getType() != 6) {
            return;
        }
        JGeometry breakline = JGeometryUtil.breakLine((JGeometry)geom, (JGeometrySegmentPoint)segPoint);
        if (breakline == null) {
            JOptionPane.showMessageDialog(this.canvas.getFrameForDialog(), MessagesBundle.getMessage("Unable_tobreak_line_geometry"), MessagesBundle.getMessage("Error"), 0);
            this.featureLayer.setSnapPoint(null);
            return;
        }
        JGeometry[] geomelems = breakline.getElements();
        if (geomelems == null || geomelems.length != 2) {
            JOptionPane.showMessageDialog(this.canvas.getFrameForDialog(), MessagesBundle.getMessage("Invalid_break_line_result"), MessagesBundle.getMessage("Error"), 0);
            this.featureLayer.setSnapPoint(null);
            return;
        }
        NewGeomSelectPanel slctPnl = new NewGeomSelectPanel(geomelems[0], geomelems[1]);
        Field[] fields = gl.getFieldsForFeature(null, false, slctPnl);
        if (fields == null || fields.length == 0) {
            this.featureLayer.setSnapPoint(null);
            return;
        }
        String keyColumn = gl.getIndexedDataSet().getDataSet().getKeyColumn();
        String key = feature.getAttribute(keyColumn).getValue().toString();
        try {
            if (slctPnl.getLastSelected() == 2) {
                gl.breakLine(key, geomelems[0], geomelems[1], fields);
            } else {
                gl.breakLine(key, geomelems[1], geomelems[0], fields);
            }
        }
        catch (Exception ex) {
            ErrorDialog.showErrorDialog(ex, this.canvas.getFrameForDialog(), MessagesBundle.getMessage("Unable_tobreak_line_geometry"), MessagesBundle.getMessage("Error"), 0);
        }
        this.featureLayer.setSnapPoint(null);
    }
}

