/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.layer;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.EventObject;
import java.util.List;
import java.util.Properties;
import javax.swing.Icon;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.MapRegionEvent;
import oracle.maps.util.PropertySupportObject;
import oracle.mdeditor.session.EditSession;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BasicLayer
implements Layer {
    protected MapCanvas canvas = null;
    protected EditSession editSession = null;
    protected PropertySupportObject properties = new PropertySupportObject(this);

    public BasicLayer(MapCanvas canvas) {
        this.properties.setDefaultProperty("oracle.maps.core.Layer.name", "Basic Layer");
        this.properties.setDefaultProperty("oracle.maps.core.Layer.visible", Boolean.toString(true));
        this.properties.setDefaultProperty("oracle.maps.core.Layer.srid", Integer.toString(0));
        this.setCanvas(canvas);
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public Element toXMLElement() {
        XMLDocument doc = new XMLDocument();
        doc.setXmlVersion("1.0");
        Element root = doc.createElement("layer");
        root.setAttribute("class", this.getClass().getCanonicalName());
        if (this.properties.size() > 0) {
            try {
                Element propsElem = this.properties.toXMLElement();
                if (propsElem != null) {
                    root.appendChild(doc.adoptNode((Node)propsElem));
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (SAXException ex) {
                ex.printStackTrace();
            }
        }
        return root;
    }

    @Override
    public void fromXMLElement(Element element) {
        NodeList propNodeList = element.getElementsByTagName("properties");
        if (propNodeList != null && propNodeList.getLength() > 0) {
            try {
                this.properties.fromXMLElement((XMLElement)propNodeList.item(0));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public String getName() {
        return this.getProperty("oracle.maps.core.Layer.name");
    }

    @Override
    public void setName(String name) {
        this.setProperty("oracle.maps.core.Layer.name", name);
    }

    @Override
    public boolean isVisible() {
        return Boolean.parseBoolean(this.getProperty("oracle.maps.core.Layer.visible"));
    }

    @Override
    public void setVisible(boolean v) {
        this.setProperty("oracle.maps.core.Layer.visible", Boolean.toString(v));
    }

    @Override
    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    @Override
    public String setProperty(String key, String value) {
        return this.properties.setProperty(key, value);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.properties.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.properties.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.properties.getPropertyChangeListeners();
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.properties.getPropertyChangeListeners(propertyName);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.properties.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.properties.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public void clear() {
    }

    @Override
    public MapCanvas getCanvas() {
        return this.canvas;
    }

    @Override
    public void setCanvas(MapCanvas canvas) {
        this.canvas = canvas;
    }

    @Override
    public boolean handleEvent(EventObject evt) {
        if (this.isVisible() && this.isMyEvent(evt)) {
            int x = -999;
            int y = -999;
            if (evt instanceof MouseEvent) {
                x = ((MouseEvent)evt).getX();
                y = ((MouseEvent)evt).getY();
            }
            this.setMyCursor(x, y);
            this.handleTheEvent(evt);
            return this.propagateEvent(evt);
        }
        return true;
    }

    public void handleTheEvent(EventObject evt) {
    }

    public void setMyCursor(int x, int y) {
    }

    public boolean isMyEvent(EventObject evt) {
        return false;
    }

    public boolean propagateEvent(EventObject evt) {
        return false;
    }

    @Override
    public List<GeoObject> hitTest(int x, int y, int granularity) {
        return null;
    }

    @Override
    public List<GeoObject> hitTest(Rectangle2D box, int granularity) {
        return null;
    }

    @Override
    public long render(Graphics2D g) {
        return 0L;
    }

    @Override
    public void mapRegionChanged(MapRegionEvent e) {
    }

    @Override
    public void update(long elapsedTime) {
    }

    @Override
    public void repaint() {
    }

    @Override
    public int getSRID() {
        return Integer.parseInt(this.getProperty("oracle.maps.core.Layer.srid"));
    }

    @Override
    public void setSRID(int srid) {
        this.setProperty("oracle.maps.core.Layer.srid", Integer.toString(srid));
    }

    @Override
    public Rectangle2D getDataMBR() {
        return null;
    }

    @Override
    public Rectangle2D getFullExtent() {
        return null;
    }

    @Override
    public void added(Object source) {
        if (source instanceof EditSession) {
            this.editSession = (EditSession)source;
        } else if (source instanceof MapCanvas) {
            this.setCanvas((MapCanvas)source);
        }
    }

    @Override
    public void removed(Object source) {
        if (source instanceof EditSession) {
            this.editSession = null;
        } else if (source instanceof MapCanvas) {
            this.canvas = null;
        }
    }

    @Override
    public String getProviderID() {
        return this.getProperty("oracle.maps.core.Layer.providerid");
    }

    @Override
    public void setProviderID(String providerID) {
        this.setProperty("oracle.maps.core.Layer.providerid", providerID);
    }
}

