/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;

public class SpinningClock {
    private int clockWidth = 32;
    private int clockHeight = 32;
    private Point2D topLeftCorner;
    private double hourHandSpeed = 4.0;
    private double minuteHandSpeed = 0.8;
    private double hourAngle = 0.0;
    private double minuteAngle = 0.0;
    private Stroke hourStroke = new BasicStroke(2.0f);
    private Stroke minuteStroke = new BasicStroke(1.0f);

    public void update(long elapsedTime) {
        double hourIncrement = 360.0 / (this.hourHandSpeed * 1000.0);
        double minuteIncrement = 360.0 / (this.minuteHandSpeed * 1000.0);
        this.hourAngle += hourIncrement * (double)elapsedTime;
        if (this.hourAngle >= 360.0) {
            this.hourAngle -= 360.0;
        }
        this.minuteAngle += minuteIncrement * (double)elapsedTime;
        if (this.minuteAngle >= 360.0) {
            this.minuteAngle -= 360.0;
        }
    }

    public long render(Graphics2D g) {
        this.paintClockFace(g);
        this.paintClockHands(g);
        return 0L;
    }

    protected void paintClockFace(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Paint oldPaint = g2.getPaint();
        int sx = (int)this.topLeftCorner.getX();
        int sy = (int)this.topLeftCorner.getY();
        g2.setColor(new Color(7575240));
        g2.fillOval(sx, sy, this.clockWidth, this.clockHeight);
        GradientPaint p = new GradientPaint(sx, sy, new Color(0.0f, 0.0f, 0.0f, 0.4f), sx, sy + this.clockHeight, new Color(0.0f, 0.0f, 0.0f, 0.0f));
        g2.setPaint(p);
        g2.fillOval(sx, sy, this.clockWidth, this.clockHeight);
        p = new GradientPaint(sx, sy, new Color(1.0f, 1.0f, 1.0f, 0.0f), sx, sy + this.clockHeight, new Color(1.0f, 1.0f, 1.0f, 1.0f));
        g2.setPaint(p);
        g2.fillOval(sx, sy, this.clockWidth, this.clockHeight);
        g2.setPaint(oldPaint);
    }

    protected void paintClockHands(Graphics2D g2) {
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(this.hourStroke);
        g2.setColor(new Color(68, 36, 153));
        Point2D[] pts = this.computeHandSegment(this.hourAngle);
        g2.drawLine((int)pts[0].getX(), (int)pts[0].getY(), (int)pts[1].getX(), (int)pts[1].getY());
        g2.setStroke(this.minuteStroke);
        pts = this.computeHandSegment(this.minuteAngle);
        g2.drawLine((int)pts[0].getX(), (int)pts[0].getY(), (int)pts[1].getX(), (int)pts[1].getY());
        g2.setStroke(oldStroke);
    }

    protected Point2D[] computeHandSegment(double angle) {
        double cx = this.topLeftCorner.getX() + (double)this.clockWidth / 2.0;
        double cy = this.topLeftCorner.getY() + (double)this.clockHeight / 2.0;
        double radian = Math.toRadians(angle);
        double len = (double)this.clockWidth / 2.0 * 0.4;
        double sx = cx + len * Math.cos(radian);
        double sy = cy + len * Math.sin(radian);
        len = (double)this.clockWidth / 2.0 - 1.5;
        double ex = cx + len * Math.cos(radian);
        double ey = cy + len * Math.sin(radian);
        return new Point2D[]{new Point2D.Double(sx, sy), new Point2D.Double(ex, ey)};
    }

    public void setClockSize(int width, int height) {
        this.clockWidth = width;
        this.clockHeight = height;
    }

    public void setMinuteHandSpeed(double seconds) {
        this.minuteHandSpeed = seconds;
    }

    public double getMinuteHandSpeed() {
        return this.minuteHandSpeed;
    }

    public void setHourHandSpeed(double seconds) {
        this.hourHandSpeed = seconds;
    }

    public double getHourHandSpeed() {
        return this.hourHandSpeed;
    }

    public Point2D getTopLeftCorner() {
        return this.topLeftCorner;
    }

    public void setTopLeftCorner(Point2D topLeftCorner) {
        this.topLeftCorner = topLeftCorner;
    }

    public int getClockHeight() {
        return this.clockHeight;
    }

    public int getClockWidth() {
        return this.clockWidth;
    }
}

