/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.core;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import oracle.maps.config.DefaultConfig;
import oracle.maps.core.MapCanvas;

public class CoreLoop
implements ActionListener {
    MapCanvas view = null;
    private Timer timer = new Timer(1000 / DefaultConfig.getRefreshRate(), this);
    long currentTime;

    public CoreLoop(MapCanvas view) {
        this.view = view;
        this.currentTime = System.currentTimeMillis();
    }

    public void start() {
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    public void stop() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    public void toggle() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        } else {
            this.timer.start();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        long t = System.currentTimeMillis();
        long elapsedTime = t - this.currentTime;
        this.currentTime = t;
        Object source = e.getSource();
        String cmd = e.getActionCommand();
        if (source == this.timer && cmd == null) {
            this.view.update(elapsedTime);
            this.view.repaint();
        }
    }
}

