/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import oracle.javatools.mt.annotation.CodeSharingSafe;

public class TranslationControl
extends ResourceBundle.Control {
    private final Set<String> m_translations;
    private final List<Locale> m_locales;
    private final List<String> m_formats;
    @CodeSharingSafe(value="StaticField")
    private static final TranslationControl CLASS_ONLY_CONTROL = new TranslationControl(Locale.getDefault(), ResourceBundle.Control.FORMAT_CLASS, System.getProperty("oracle.translated.locales"));
    @CodeSharingSafe(value="StaticField")
    private static final TranslationControl PROPERTIES_ONLY_CONTROL = new TranslationControl(Locale.getDefault(), ResourceBundle.Control.FORMAT_PROPERTIES, System.getProperty("oracle.translated.locales"));
    @CodeSharingSafe(value="StaticField")
    private static final TranslationControl DEFAULT_CONTROL = new TranslationControl(Locale.getDefault(), ResourceBundle.Control.FORMAT_DEFAULT, System.getProperty("oracle.translated.locales"));

    protected TranslationControl(Locale targetLocale, List<String> formats, String translations) {
        if (formats == null) {
            throw new IllegalArgumentException("formats is null");
        }
        this.m_formats = Collections.unmodifiableList(new ArrayList<String>(formats));
        HashSet<String> translationsSet = null;
        if (translations != null) {
            String[] inclusions;
            translationsSet = new HashSet<String>();
            for (String inclusion : inclusions = translations.split(",")) {
                translationsSet.add(inclusion.trim());
            }
        }
        this.m_translations = translationsSet;
        if (targetLocale == null) {
            targetLocale = Locale.getDefault();
        }
        List<Locale> locales = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_DEFAULT).getCandidateLocales("", this.findLocale(targetLocale));
        this.m_locales = Collections.unmodifiableList(new ArrayList<Locale>(locales));
    }

    private Locale findLocale(Locale locale) {
        if (this.m_translations == null) {
            return locale;
        }
        if (this.m_translations.contains(locale.toString())) {
            return locale;
        }
        if (this.m_translations.contains((locale = new Locale(locale.getLanguage(), locale.getCountry())).toString())) {
            return locale;
        }
        if (this.m_translations.contains((locale = new Locale(locale.getLanguage())).toString())) {
            return locale;
        }
        return new Locale("");
    }

    @Override
    public List<Locale> getCandidateLocales(String baseName, Locale locale) {
        if (baseName == null) {
            throw new NullPointerException();
        }
        return this.m_locales;
    }

    @Override
    public Locale getFallbackLocale(String baseName, Locale locale) {
        if (baseName == null || locale == null) {
            throw new NullPointerException();
        }
        if (this.m_translations != null) {
            return null;
        }
        return super.getFallbackLocale(baseName, locale);
    }

    @Override
    public List<String> getFormats(String baseName) {
        if (baseName == null) {
            throw new NullPointerException();
        }
        return this.m_formats;
    }

    public static TranslationControl getClassFormatTranslationControl() {
        return CLASS_ONLY_CONTROL;
    }

    public static TranslationControl getPropertiesFormatTranslationControl() {
        return PROPERTIES_ONLY_CONTROL;
    }

    public static TranslationControl getDefaultFormatTranslationControl() {
        return DEFAULT_CONTROL;
    }
}

