/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Supplier;
import oracle.javatools.annotations.Concealed;
import oracle.javatools.util.UnexpectedExceptionError;

@Concealed(value="Use {@link java.util.Map<K,java.util.Collection<V>>} instead.")
public class MultiMap<K, V>
implements Map<K, Collection<V>> {
    private final Map<K, Collection<V>> delegate;
    private final Class<? extends Collection> collectionClass;
    private final Supplier<? extends Collection> collectionFactory;
    private int valuesSize;
    public static final MultiMap EMPTY_MAP = new MultiMap(Collections.emptyMap(), null);

    public MultiMap() {
        this(LinkedHashMap.class, ArrayList.class);
    }

    public MultiMap(Class<? extends Collection> collectionClass) {
        this(LinkedHashMap.class, collectionClass);
    }

    public MultiMap(Class<? extends Map> mapClass, Class<? extends Collection> collectionClass) {
        try {
            this.delegate = mapClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new UnexpectedExceptionError(e);
        }
        catch (IllegalAccessException e) {
            throw new UnexpectedExceptionError(e);
        }
        this.collectionClass = collectionClass;
        this.collectionFactory = () -> {
            try {
                return (Collection)collectionClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new UnexpectedExceptionError(e);
            }
        };
    }

    public MultiMap(Class<? extends Map> mapClass, Class<? extends Collection> collectionClass, Supplier<? extends Collection> collectionFactory) {
        try {
            this.delegate = mapClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new UnexpectedExceptionError(e);
        }
        catch (IllegalAccessException e) {
            throw new UnexpectedExceptionError(e);
        }
        this.collectionClass = collectionClass;
        this.collectionFactory = collectionFactory;
    }

    protected MultiMap(Map<K, Collection<V>> delegate, Class<? extends Collection> collectionClass) {
        this.delegate = delegate;
        this.collectionClass = collectionClass;
        this.collectionFactory = () -> {
            try {
                return (Collection)collectionClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new UnexpectedExceptionError(e);
            }
        };
    }

    public MultiMap(MultiMap<K, V> map) {
        this(map.delegate.getClass(), map.collectionClass);
        this.putAll(map);
    }

    public static <K, V> MultiMap<K, V> getMultiMap() {
        return new MultiMap<K, V>();
    }

    public static <K, V> MultiMap<K, V> getMultiMap(Class<? extends Collection> collectionClass) {
        return new MultiMap<K, V>(collectionClass);
    }

    public static <K, V> MultiMap<K, V> getMultiMap(Class<? extends Map> mapClass, Class<? extends Collection> collectionClass) {
        return new MultiMap<K, V>(mapClass, collectionClass);
    }

    public static final <K, V> MultiMap<K, V> emptyMap() {
        return EMPTY_MAP;
    }

    public int keysSize() {
        return this.delegate.size();
    }

    public int valuesSize() {
        return this.valuesSize;
    }

    public int valuesSize(K key) {
        Collection<V> values = this.delegate.get(key);
        return values == null ? 0 : values.size();
    }

    public boolean contains(K key, V value) {
        Collection<V> values = this.delegate.get(key);
        return values != null && values.contains(value);
    }

    public boolean add(K key, V value) {
        Collection<V> collection = this.getOrCreateCollection(key);
        boolean added = collection.add(value);
        if (added) {
            ++this.valuesSize;
        } else if (collection.isEmpty()) {
            this.delegate.remove(key);
        }
        return added;
    }

    public boolean addAll(K key, Collection<V> values) {
        Collection<V> collection = this.getOrCreateCollection(key);
        int added = 0;
        for (V value : values) {
            if (!collection.add(value)) continue;
            ++added;
        }
        if (added > 0) {
            this.valuesSize += added;
            return true;
        }
        if (collection.isEmpty()) {
            this.delegate.remove(key);
            return false;
        }
        return false;
    }

    public boolean addAll(K key, V ... values) {
        return this.addAll(key, values, 0, values.length);
    }

    public boolean addAll(K key, V[] values, int from, int to) {
        Collection<V> collection = this.getOrCreateCollection(key);
        int added = 0;
        for (int i = from; i < to; ++i) {
            V value = values[i];
            if (!collection.add(value)) continue;
            ++added;
        }
        if (added > 0) {
            this.valuesSize += added;
            return true;
        }
        if (collection.isEmpty()) {
            this.delegate.remove(key);
            return false;
        }
        return false;
    }

    public boolean addAll(Map<? extends K, V> map) {
        Set<Map.Entry<K, V>> entries = map.entrySet();
        boolean added = false;
        for (Map.Entry<K, V> entry : entries) {
            added |= this.add(entry.getKey(), entry.getValue());
        }
        return added;
    }

    public V removeValue(K key, V value) {
        Collection<V> values = this.delegate.get(key);
        if (values != null && values.remove(value)) {
            --this.valuesSize;
            if (values.isEmpty()) {
                this.delegate.remove(key);
            }
            return value;
        }
        return null;
    }

    private Collection<V> getOrCreateCollection(K key) {
        Collection values = this.delegate.get(key);
        if (values == null) {
            values = this.collectionFactory.get();
            this.delegate.put(key, values);
        }
        return values;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Collection<V> values : this.delegate.values()) {
            if (!values.equals(value) && !values.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<V> get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public Collection<V> put(K key, Collection<V> values) {
        if (!this.collectionClass.isAssignableFrom(values.getClass())) {
            throw new IllegalArgumentException("class " + values.getClass() + " not assignable from collection class " + this.collectionClass);
        }
        Collection<V> oldValues = this.delegate.put(key, values);
        if (oldValues != null) {
            this.valuesSize -= oldValues.size();
        }
        this.valuesSize += values.size();
        return oldValues;
    }

    @Override
    public Collection<V> remove(Object key) {
        Collection<V> oldValues = this.delegate.remove(key);
        if (oldValues != null) {
            this.valuesSize -= oldValues.size();
        }
        return oldValues;
    }

    @Override
    public void putAll(Map<? extends K, ? extends Collection<V>> map) {
        Set<Map.Entry<K, Collection<V>>> entries = map.entrySet();
        for (Map.Entry<K, Collection<V>> entry : entries) {
            this.getOrCreateCollection(entry.getKey()).addAll(entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<Collection<V>> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        int keyCount = 0;
        StringBuilder buffer = new StringBuilder("{");
        for (Map.Entry<K, Collection<V>> e : this.entrySet()) {
            K key;
            if (keyCount++ > 0) {
                buffer.append(",");
            }
            if ((key = e.getKey()) == this) {
                buffer.append("(this Map)");
            } else {
                buffer.append(key);
            }
            int valueCount = 0;
            buffer.append("={");
            for (V value : e.getValue()) {
                if (valueCount++ > 0) {
                    buffer.append(",");
                }
                if (value == this) {
                    buffer.append("(this Map)");
                    continue;
                }
                buffer.append(value);
            }
            buffer.append("}");
        }
        buffer.append("}");
        return buffer.toString();
    }

    public Iterator<Map.Entry<K, V>> keyValueIterator() {
        return new KeyValueIterator();
    }

    public Iterator<V> valuesIterator() {
        return new ValuesIterator();
    }

    private class KeyValueIterator
    implements Iterator<Map.Entry<K, V>>,
    Map.Entry<K, V> {
        private final Iterator<Map.Entry<K, Collection<V>>> outer;
        private Iterator<V> inner;
        private K key;
        private V value;

        private KeyValueIterator() {
            this.outer = MultiMap.this.delegate.entrySet().iterator();
            this.inner = Collections.emptyIterator();
        }

        @Override
        public boolean hasNext() {
            if (this.inner.hasNext()) {
                return true;
            }
            if (this.outer.hasNext()) {
                Map.Entry entry = this.outer.next();
                this.key = entry.getKey();
                this.inner = entry.getValue().iterator();
                assert (this.inner.hasNext());
                return true;
            }
            return false;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.value = this.inner.next();
            return this;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }

    private class ValuesIterator
    implements Iterator<V> {
        private final Iterator<Map.Entry<K, Collection<V>>> outer;
        private Iterator<V> inner;

        private ValuesIterator() {
            this.outer = MultiMap.this.delegate.entrySet().iterator();
            this.inner = Collections.emptyIterator();
        }

        @Override
        public boolean hasNext() {
            if (this.inner.hasNext()) {
                return true;
            }
            if (this.outer.hasNext()) {
                this.inner = this.outer.next().getValue().iterator();
                assert (this.inner.hasNext());
                return true;
            }
            return false;
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.inner.next();
        }
    }
}

