/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import oracle.javatools.annotations.Concealed;
import oracle.javatools.util.ArrayIterator;

@Concealed(value="Use {@link java.util.Arrays#asList} or {@link java.util.Collections#UnmodifiableList} instead.")
public class ImmutableList<E>
extends AbstractList<E> {
    private E[] elements;

    public ImmutableList(E element) {
        this.elements = new Object[]{element};
    }

    public ImmutableList(E ... elements) {
        this.elements = elements;
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public boolean isEmpty() {
        return this.elements.length == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            for (E e : this.elements) {
                if (e != null) continue;
                return true;
            }
        } else {
            for (E e : this.elements) {
                if (!o.equals(e)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object element : collection) {
            if (this.contains(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public E get(int index) {
        return this.elements[index];
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayIterator<E>(this.elements);
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.elements.length];
        System.arraycopy(this.elements, 0, array, 0, this.elements.length);
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        if (array.length < this.elements.length) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.elements.length);
        } else if (array.length > this.elements.length) {
            array[this.elements.length] = null;
        }
        System.arraycopy(this.elements, 0, array, 0, this.elements.length);
        return array;
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException("immutable list");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("immutable list");
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException("immutable list");
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException("immutable list");
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException("immutable list");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("immutable list");
    }

    @Override
    public void sort(Comparator<? super E> c) {
        throw new UnsupportedOperationException("immutable list");
    }
}

