/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class Graph<T>
extends AbstractCollection<T> {
    protected Map<T, Vertex<T>> _vertices = new LinkedHashMap<T, Vertex<T>>();
    private final String INDENT = "  ";
    private final String ARROW = " -> ";

    public Graph(Graph<T> original) {
        this._vertices.putAll(original._vertices);
    }

    public Graph() {
    }

    public void dfs(T start, boolean direction, Visitor visitor) {
        LinkedHashSet visiting = new LinkedHashSet();
        HashSet visited = new HashSet();
        AtomicBoolean done = new AtomicBoolean();
        this.dfsImpl(visiting, visited, start, direction, visitor, done);
    }

    private void dfsImpl(Collection<T> visiting, Collection<T> visited, T start, boolean direction, Visitor visitor, AtomicBoolean done) {
        if (done.get()) {
            return;
        }
        if (visiting.contains(start)) {
            return;
        }
        if (visited.contains(start)) {
            return;
        }
        visiting.add(start);
        Vertex<T> startVertex = this._vertices.get(start);
        for (Vertex vertex : direction ? startVertex._toEdges : startVertex._fromEdges) {
            if (done.get()) {
                return;
            }
            if (!visitor.visit(Collections.unmodifiableCollection(visiting), vertex.getData())) {
                done.set(true);
                return;
            }
            this.dfsImpl(visiting, visited, vertex.getData(), direction, visitor, done);
        }
        visiting.remove(start);
        visited.add(start);
    }

    public Comparator<T> createComparator() throws CycleException {
        final List<T> sorted = this.getSortedVertices();
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return sorted.indexOf(o1) - sorted.indexOf(o2);
            }
        };
    }

    public Graph(Collection<T> vertices) {
        this.addAll(vertices);
    }

    @Override
    public boolean contains(Object vertex) {
        return this._vertices.containsKey(vertex);
    }

    @Override
    public boolean add(T vertex) {
        if (this._vertices.containsKey(vertex)) {
            throw new IllegalArgumentException("Already in graph: " + vertex);
        }
        this._vertices.put(vertex, new Vertex<T>(vertex));
        return true;
    }

    public void connect(T from, T to) {
        try {
            Vertex<T> fromVertex = this._vertices.get(from);
            if (fromVertex == null) {
                throw new IllegalArgumentException("from vertex is not in graph: " + from);
            }
            Vertex<T> toVertex = this._vertices.get(to);
            if (toVertex == null) {
                throw new IllegalArgumentException("to vertex is not in graph: " + to);
            }
            this.connectVertices(fromVertex, toVertex);
        }
        catch (CycleException ce) {
            throw new IllegalArgumentException(ce);
        }
    }

    public List<T> getOutwardEdges(T from) {
        Vertex<T> v = this._vertices.get(from);
        if (v == null) {
            throw new IllegalArgumentException("Not in graph: " + from);
        }
        return this.verticesToData(v._toEdges);
    }

    public List<T> getInwardEdges(T to) {
        Vertex<T> v = this._vertices.get(to);
        if (v == null) {
            throw new IllegalArgumentException("Not in graph: " + to);
        }
        return this.verticesToData(v._fromEdges);
    }

    private List<T> verticesToData(List<Vertex> l) {
        ArrayList connections = new ArrayList(l.size());
        for (Vertex vertex : l) {
            connections.add(vertex.getData());
        }
        return Collections.unmodifiableList(connections);
    }

    private void connectVertices(Vertex<T> from, Vertex<T> to) throws CycleException {
        if (from == to) {
            throw new CycleException(this);
        }
        to._fromEdges.add(from);
        from._toEdges.add(to);
    }

    public Graph<T> subgraph(Collection<T> vertices) {
        Graph<T> newGraph = new Graph<T>(this);
        newGraph.retainAll(vertices);
        return newGraph;
    }

    public List<Cycle> findCycles() {
        CycleFinder finder = new CycleFinder();
        return finder.getCycles();
    }

    public List<T> findElementaryCycle(Cycle cycle) {
        CycleFinder finder = new CycleFinder();
        return finder.getElementaryCycle(cycle);
    }

    public String getCycleMessage(List<Cycle> cycles) {
        if (cycles.size() == 0) {
            return "\nNo cycles in graph\n";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        int num = cycles.size();
        sb.append(num);
        if (num == 1) {
            sb.append(" dependency cycle detected\n");
        } else {
            sb.append(" dependency cycles detected\n");
        }
        int n = 0;
        for (Cycle cycle : cycles) {
            Object first;
            Set members = cycle.getMembers();
            sb.append("Cycle ");
            sb.append(++n);
            sb.append(": (");
            sb.append(members.size());
            sb.append(" modules)");
            sb.append('\n');
            Object[] memberObjects = members.toArray();
            Arrays.sort(memberObjects, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return String.valueOf(o1).compareTo(String.valueOf(o2));
                }
            });
            Object[] objectArray = memberObjects;
            int n2 = objectArray.length;
            for (int i = 0; i < n2; ++i) {
                Object o;
                Object member = o = objectArray[i];
                Vertex<T> v = this._vertices.get(member);
                for (Vertex ref : v._fromEdges) {
                    if (!cycle.isMember(ref.getData())) continue;
                    sb.append("  ");
                    sb.append(String.valueOf(member));
                    sb.append(" -> ");
                    sb.append(String.valueOf(ref.getData()));
                    sb.append('\n');
                }
            }
            CycleFinder finder = new CycleFinder();
            ArrayList smallCycle = finder.getElementaryCycle(cycle);
            if (smallCycle == null || smallCycle.size() <= 0) continue;
            sb.append("Elementary sub-cycle:\n");
            Object last = first = smallCycle.get(0);
            for (int i = 1; i < smallCycle.size(); ++i) {
                Object t = smallCycle.get(i);
                sb.append("  ");
                sb.append(last);
                sb.append(" -> ");
                sb.append(t);
                sb.append('\n');
                last = t;
            }
            sb.append("  ");
            sb.append(last);
            sb.append(" -> ");
            sb.append(first);
            sb.append('\n');
        }
        sb.append("[a -> b means a directly depends on b]\n");
        return sb.toString();
    }

    public String getElementaryCycleMessage(List<Cycle> cycles) {
        if (cycles.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int n = 0;
        Iterator<Cycle> iterator = cycles.iterator();
        while (iterator.hasNext()) {
            CycleFinder finder = new CycleFinder();
            Cycle cycle = iterator.next();
            ArrayList smallCycle = finder.getElementaryCycle(cycle);
            if (smallCycle == null || smallCycle.size() <= 0) continue;
            sb.append(++n);
            sb.append(". ");
            Object first = smallCycle.get(0);
            for (int i = 0; i < smallCycle.size(); ++i) {
                Object t = smallCycle.get(i);
                sb.append(t);
                sb.append(" -> ");
            }
            sb.append(first);
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<T> delegate = this._vertices.keySet().iterator();
        return new Iterator<T>(){
            private T current = null;

            @Override
            public boolean hasNext() {
                return delegate.hasNext();
            }

            @Override
            public T next() {
                this.current = delegate.next();
                return this.current;
            }

            @Override
            public void remove() {
                if (this.current == null) {
                    throw new IllegalStateException("You must use next() before remove()");
                }
                Graph.this.removeAllReferencesTo(this.current);
                delegate.remove();
            }
        };
    }

    @Override
    public boolean remove(Object vertex) {
        this.removeAllReferencesTo(vertex);
        return this._vertices.remove(vertex) != null;
    }

    private void removeAllReferencesTo(T vertex) {
        for (Vertex<T> v : this._vertices.values()) {
            v._fromEdges.remove(this._vertices.get(vertex));
            v._toEdges.remove(this._vertices.get(vertex));
        }
    }

    @Override
    public int size() {
        return this._vertices.size();
    }

    public List<T> getSortedVertices() throws CycleException {
        return this.getSortedVertices(null);
    }

    public List<T> getSortedVertices(T startVertex) throws CycleException {
        HashMap colors = new HashMap(this._vertices.size());
        LinkedList sortedList = new LinkedList();
        if (startVertex != null) {
            Color c = (Color)((Object)colors.get(startVertex));
            if (c == null) {
                this.visit(new ArrayList(), colors, startVertex, sortedList);
            }
        } else {
            for (T t : this) {
                Color c = (Color)((Object)colors.get(t));
                if (c != null) continue;
                this.visit(new ArrayList(), colors, t, sortedList);
            }
        }
        return Collections.unmodifiableList(sortedList);
    }

    private void visit(List<T> visiting, Map<T, Color> colors, T vertex, List<T> sortedList) throws CycleException {
        colors.put(vertex, Color.VISITING);
        visiting.add(vertex);
        for (Vertex to : this._vertices.get(vertex)) {
            Color color = colors.get(to.getData());
            if (color == Color.VISITING) {
                throw new CycleException(this);
            }
            if (color == Color.VISITED) continue;
            this.visit(visiting, colors, to.getData(), sortedList);
        }
        sortedList.add(0, vertex);
        visiting.remove(vertex);
        colors.put(vertex, Color.VISITED);
    }

    public List<T> getVerticesConnectedTo(T vertex) throws CycleException {
        if (vertex == null) {
            throw new NullPointerException("vertex is null");
        }
        ArrayList vertices = new ArrayList();
        HashMap colors = new HashMap();
        this.visitInReverse(colors, vertex, vertices);
        vertices.remove(vertex);
        return Collections.unmodifiableList(vertices);
    }

    private void visitInReverse(Map<T, Color> colors, T startVertex, List<T> vertices) throws CycleException {
        colors.put(startVertex, Color.VISITING);
        Vertex<T> v = this._vertices.get(startVertex);
        List<Vertex> from = v._fromEdges;
        for (Vertex fromVertex : from) {
            Color color = colors.get(fromVertex.getData());
            if (color == Color.VISITING) {
                throw new CycleException(this);
            }
            if (color == Color.VISITED) continue;
            this.visitInReverse(colors, fromVertex.getData(), vertices);
        }
        vertices.add(startVertex);
        colors.put(startVertex, Color.VISITED);
    }

    public static <Z> Graph<Z> unmodifiableGraph(Graph<? extends Z> graph) {
        return new UnmodifiableGraph<Z>(graph);
    }

    public abstract class Visitor {
        public abstract boolean visit(Collection<T> var1, T var2);
    }

    private final class Vertex<T>
    implements Iterable<Vertex> {
        private final T _data;
        private final List<Vertex> _toEdges = new ArrayList<Vertex>();
        private final List<Vertex> _fromEdges = new ArrayList<Vertex>();

        Vertex(T data) {
            this._data = data;
        }

        public T getData() {
            return this._data;
        }

        @Override
        public Iterator<Vertex> iterator() {
            return this._toEdges.iterator();
        }
    }

    public static class CycleException
    extends Exception {
        private final Graph graph;

        CycleException(Graph graph) {
            this.graph = graph;
        }

        @Override
        public String getMessage() {
            List<Cycle> cycles = this.graph.findCycles();
            return this.graph.getCycleMessage(cycles);
        }
    }

    private class CycleFinder {
        int nodeNumber;
        LinkedList<Vertex<T>> stack;
        ArrayList<Cycle> cycles;
        HashMap<Vertex<T>, VertexAux> auxmap;
        ArrayList<T> smallCycle;
        int smallCycleSize;
        ArrayList<Vertex<T>> path;

        private CycleFinder() {
        }

        public ArrayList<T> getElementaryCycle(Cycle scc) {
            Iterator it = scc.members.iterator();
            Object start = it.next();
            Vertex vstart = Graph.this._vertices.get(start);
            this.smallCycleSize = Integer.MAX_VALUE;
            this.smallCycle = null;
            this.path = new ArrayList();
            this.auxmap = new HashMap();
            this.findSmallCycles(vstart, scc);
            this.path = null;
            this.auxmap = null;
            return this.smallCycle;
        }

        private void findSmallCycles(Vertex<T> v, Cycle scc) {
            VertexAux vaux = this.getAux(v);
            vaux.visited = true;
            this.path.add(v);
            for (Vertex w : v._fromEdges) {
                int cycleSize;
                int i;
                if (!scc.members.contains(w._data)) continue;
                VertexAux waux = this.getAux(w);
                if (!waux.visited) {
                    this.findSmallCycles(w, scc);
                    continue;
                }
                for (i = this.path.size() - 1; i >= 0 && this.path.get(i) != w; --i) {
                }
                if (i < 0 || this.smallCycleSize <= (cycleSize = this.path.size() - i)) continue;
                this.smallCycleSize = cycleSize;
                this.smallCycle = new ArrayList();
                for (int j = i; j < this.path.size(); ++j) {
                    this.smallCycle.add(this.path.get((int)j)._data);
                }
            }
            this.path.remove(this.path.size() - 1);
        }

        private VertexAux getAux(Vertex<T> v) {
            VertexAux aux = this.auxmap.get(v);
            if (aux == null) {
                aux = new VertexAux();
                this.auxmap.put(v, aux);
            }
            return aux;
        }

        private void findCycles() {
            this.nodeNumber = 0;
            this.stack = new LinkedList();
            this.cycles = new ArrayList();
            this.auxmap = new HashMap();
            for (Vertex v : Graph.this._vertices.values()) {
                this.visit(v);
            }
        }

        public List<Cycle> getCycles() {
            this.findCycles();
            return this.cycles;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void visit(Vertex<T> v) {
            VertexAux vaux = this.getAux(v);
            if (vaux.visited) {
                return;
            }
            vaux.visited = true;
            vaux.number = ++this.nodeNumber;
            vaux.root = v;
            vaux.inComponent = false;
            for (Vertex w : v._toEdges) {
                this.visit(w);
                VertexAux waux = this.getAux(w);
                VertexAux wraux = this.getAux(waux.root);
                if (wraux.inComponent) continue;
                VertexAux vraux = this.getAux(vaux.root);
                if (wraux.number >= vraux.number) continue;
                vaux.root = waux.root;
            }
            if (vaux.root == v) {
                vaux.inComponent = true;
                if (this.stack.isEmpty()) return;
                Vertex top = this.stack.getLast();
                VertexAux topaux = this.getAux(top);
                if (topaux.number <= vaux.number) return;
                Cycle cycle = new Cycle();
                cycle.addMember(v.getData());
                this.cycles.add(cycle);
                do {
                    this.stack.removeLast();
                    topaux.inComponent = true;
                    cycle.addMember(top.getData());
                    if (this.stack.isEmpty()) return;
                    top = this.stack.getLast();
                    topaux = this.getAux(top);
                } while (topaux.number > vaux.number);
                return;
            } else {
                this.stack.addLast(v);
            }
        }
    }

    public static class Cycle {
        HashSet members = new HashSet();

        private Cycle() {
        }

        private void addMember(Object member) {
            this.members.add(member);
        }

        public Set getMembers() {
            return new HashSet(this.members);
        }

        public boolean isMember(Object t) {
            return this.members.contains(t);
        }
    }

    private static enum Color {
        VISITING,
        VISITED;

    }

    private static class UnmodifiableGraph<E>
    extends Graph<E> {
        private Graph<E> _graph;

        UnmodifiableGraph(Graph<E> g) {
            this._graph = g;
        }

        @Override
        public boolean equals(Object o) {
            return this._graph.equals(o);
        }

        @Override
        public int hashCode() {
            return this._graph.hashCode();
        }

        @Override
        public int size() {
            return this._graph.size();
        }

        @Override
        public boolean isEmpty() {
            return this._graph.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this._graph.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this._graph.toArray();
        }

        @Override
        public <E> E[] toArray(E[] a) {
            return this._graph.toArray(a);
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void connect(E e, E e2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<E> iterator() {
            final Iterator<E> i = this._graph.iterator();
            return new Iterator<E>(){

                @Override
                public boolean hasNext() {
                    return i.hasNext();
                }

                @Override
                public E next() {
                    return i.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private class VertexAux {
        Vertex<T> root;
        int number;
        boolean visited;
        boolean inComponent;
        boolean onStack;

        private VertexAux() {
        }
    }
}

