/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.plsql.old;

import oracle.javatools.mt.annotation.CodeSharingSafe;
import oracle.javatools.parser.AbstractSyntaxRecognizer;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.plsql.old.ExpressionRecognizer;
import oracle.javatools.parser.plsql.old.PlsqlLexer;
import oracle.javatools.parser.plsql.old.PlsqlSyntaxCodes;
import oracle.javatools.parser.plsql.old.PlsqlTokens;
import oracle.javatools.parser.plsql.old.RootRecognizer;

public abstract class PlsqlSyntaxRecognizer
extends AbstractSyntaxRecognizer
implements PlsqlSyntaxCodes,
PlsqlTokens {
    public static final int LEVEL_ROOT = 1;
    public static final int LEVEL_EXPRESSION = 2;
    public static final int INPUT_ROOT = 1;
    public static final int INPUT_EXPRESSION = 2;
    protected int startLevel;
    @CodeSharingSafe(value="StaticField")
    static final String SYNTAXERR_NOT_A_DATA_TYPE = resources.getString("PPARSER_ERROR_NOT_A_DATA_TYPE");

    public static PlsqlSyntaxRecognizer newRecognizer() {
        return PlsqlSyntaxRecognizer.newRecognizer(1, 2);
    }

    public static PlsqlSyntaxRecognizer newRecognizer(int startLevel, int depthLevel) {
        RootRecognizer r = switch (depthLevel) {
            default -> new RootRecognizer();
            case 2 -> new ExpressionRecognizer();
        };
        r.startLevel = startLevel;
        return r;
    }

    public static final boolean isKeywordToken(int token) {
        return 1000 <= token || token == 55;
    }

    public static final boolean isLiteralToken(int token) {
        return 51 <= token && token <= 55;
    }

    public static final boolean isPrefixOperator(int token) {
        switch (token) {
            case 100: 
            case 111: 
            case 1096: {
                return true;
            }
        }
        return false;
    }

    public static final boolean isSuffixOperator(int token) {
        return token == 125;
    }

    public static final boolean isInfixOperator(int token) {
        switch (token) {
            case 100: 
            case 103: 
            case 108: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 1002: 
            case 1108: {
                return true;
            }
        }
        return false;
    }

    public static final boolean isSpecialOperator(int token) {
        switch (token) {
            case 1011: 
            case 1065: 
            case 1074: 
            case 1078: {
                return true;
            }
        }
        return false;
    }

    public static final boolean isExpressionStatementPrefix(int token) {
        switch (token) {
            case 55: 
            case 1020: 
            case 1058: 
            case 1124: 
            case 1131: 
            case 1138: {
                return true;
            }
        }
        return false;
    }

    public static final boolean isSqlStatementPrefix(int token) {
        switch (token) {
            case 1024: 
            case 1028: 
            case 1037: 
            case 1052: 
            case 1068: 
            case 1080: 
            case 1105: 
            case 1133: 
            case 1140: 
            case 1167: {
                return true;
            }
        }
        return false;
    }

    protected final void nextTokenIdentifier(String id, String id2) {
        if (this.curToken == 11) {
            String curString = this.curTokenToString();
            if (this.curTokenToString().equalsIgnoreCase(id) || this.curTokenToString().equalsIgnoreCase(id2)) {
                this.skipToken();
                return;
            }
        }
        this.nextToken(11);
    }

    protected final void nextTokenIdentifier(String id) {
        if (this.curToken == 11) {
            String curString = this.curTokenToString();
            if (this.curTokenToString().equalsIgnoreCase(id)) {
                this.skipToken();
                return;
            }
        }
        this.nextToken(11);
    }

    protected final boolean optionalTokenIdentifier(String id) {
        if (this.curToken == 11) {
            String curString = this.curTokenToString();
            if (this.curTokenToString().equalsIgnoreCase(id)) {
                this.skipToken();
                return true;
            }
        }
        return false;
    }

    protected final void handleName() {
        if (PlsqlSyntaxRecognizer.isKeywordToken(this.curToken)) {
            this.skipToken();
        } else {
            this.nextToken(11);
        }
    }

    protected final boolean optionalName() {
        if (PlsqlSyntaxRecognizer.isKeywordToken(this.curToken)) {
            this.skipToken();
            return true;
        }
        return this.optionalToken(11);
    }

    protected final void finishName() {
        if (PlsqlSyntaxRecognizer.isKeywordToken(this.curToken)) {
            this.finishToken();
        } else {
            this.finishToken(11);
        }
    }

    protected final void parseSchemaName() {
        if (this.curToken == 11 || PlsqlSyntaxRecognizer.isKeywordToken(this.curToken)) {
            this.startQuiet(1003);
            while (this.peekToken() == 102) {
                this.handleName();
                this.nextToken(102);
            }
            this.finishName();
        } else {
            this.nextToken(11);
        }
    }

    protected final void parseSimpleName() {
        if (this.curToken == 11 || PlsqlSyntaxRecognizer.isKeywordToken(this.curToken)) {
            this.startQuiet(1002);
            this.finishToken();
        } else {
            this.nextToken(11);
        }
    }

    protected abstract void parseSqlExpression();

    protected abstract void parseExpression();

    protected abstract void parseRoot();

    @Override
    public void parse() {
        this.startQuiet(10);
        this.setContextString("PL/SQL");
        switch (this.startLevel) {
            default: {
                this.parseRoot();
                break;
            }
            case 2: {
                if (PlsqlSyntaxRecognizer.isSqlStatementPrefix(this.curToken)) {
                    this.start(600);
                    this.parseSqlExpression();
                    this.finishInherit();
                    break;
                }
                this.parseExpression();
            }
        }
        this.finishInherit();
    }

    @Override
    public Lexer instantiatePreferredLexer() {
        PlsqlLexer l = new PlsqlLexer();
        l.setSkipComments(true);
        return l;
    }

    @Override
    protected void errorExpecting(int token) {
        String suffix = null;
        switch (token) {
            case 107: {
                suffix = "COMMA";
                break;
            }
            case 11: {
                suffix = "IDENTIFIER";
                break;
            }
            case 51: {
                suffix = "INT_LITERAL";
                break;
            }
            case 104: {
                suffix = "LPAREN";
                break;
            }
            case 118: {
                suffix = "RANGE";
                break;
            }
            case 117: {
                suffix = "RLABEL";
                break;
            }
            case 105: {
                suffix = "RPAREN";
                break;
            }
            case 110: {
                suffix = "SEMI";
                break;
            }
            case 1002: {
                suffix = "KW_AND";
                break;
            }
            case 1016: {
                suffix = "KW_BY";
                break;
            }
            case 1022: {
                suffix = "KW_COLLECT";
                break;
            }
            case 1031: {
                suffix = "KW_CURSOR";
                break;
            }
            case 1044: {
                suffix = "KW_END";
                break;
            }
            case 1056: {
                suffix = "KW_FROM";
                break;
            }
            case 1068: {
                suffix = "KW_INSERT";
                break;
            }
            case 1065: {
                suffix = "KW_IN";
                break;
            }
            case 1074: {
                suffix = "KW_IS";
                break;
            }
            case 1073: {
                suffix = "KW_INTO";
                break;
            }
            case 1082: {
                suffix = "KW_LOOP";
                break;
            }
            case 55: {
                suffix = "KW_NULL";
                break;
            }
            case 1140: {
                suffix = "KW_SELECT";
                break;
            }
            case 1157: {
                suffix = "KW_THEN";
                break;
            }
            case 1163: {
                suffix = "KW_TYPE";
                break;
            }
            case 1171: {
                suffix = "KW_VALUES";
                break;
            }
            case 1176: {
                suffix = "KW_WHEN";
                break;
            }
            case 1180: {
                suffix = "KW_WITH";
                break;
            }
            default: {
                this.reportSyntaxError("Missing parser resource: expecting-" + token);
                return;
            }
        }
        String expecting = resources.getString("PPARSER_ERROR_EXPECTING_" + suffix);
        this.reportSyntaxError(expecting);
    }

    @Override
    public String _codeToString(int code) {
        return PlsqlSyntaxRecognizer.codeToString(code);
    }

    public static String codeToString(int code) {
        switch (code) {
            case 10: {
                return "SYNTAX_ROOT";
            }
            case 25: {
                return "SYNTAX_PLSQL_ROOT";
            }
            case 110: {
                return "SYNTAX_PACKAGE";
            }
            case 140: {
                return "SYNTAX_PROCEDURE";
            }
            case 150: {
                return "SYNTAX_FUNCTION";
            }
            case 155: {
                return "SYNTAX_PARAMETER_LIST";
            }
            case 156: {
                return "SYNTAX_PARAMETER";
            }
            case 200: {
                return "SYNTAX_BLOCK";
            }
            case 250: {
                return "SYNTAX_EXCEPTION_HANDLER";
            }
            case 300: {
                return "SYNTAX_STATEMENT";
            }
            case 312: {
                return "SYNTAX_LOOP_STATEMENT";
            }
            case 311: {
                return "SYNTAX_BLOCK_STATEMENT";
            }
            case 313: {
                return "SYNTAX_EXP_STATEMENT";
            }
            case 330: {
                return "SYNTAX_IF_STATEMENT";
            }
            case 331: {
                return "SYNTAX_ELSIF_CLAUSE";
            }
            case 332: {
                return "SYNTAX_ELSE_CLAUSE";
            }
            case 301: {
                return "SYNTAX_UNPARSED_STMT";
            }
            case 302: {
                return "SYNTAX_UNPARSED_LOOP";
            }
            case 350: {
                return "SYNTAX_LOOP";
            }
            case 351: {
                return "SYNTAX_WHILE_LOOP";
            }
            case 352: {
                return "SYNTAX_FOR_LOOP";
            }
            case 510: {
                return "SYNTAX_TYPE_DECL  ";
            }
            case 511: {
                return "SYNTAX_TYPE_TABLE_DECL";
            }
            case 514: {
                return "SYNTAX_TYPE_VARRAY_DECL";
            }
            case 550: {
                return "SYNTAX_ITEM_DECL  ";
            }
            case 551: {
                return "SYNTAX_CURSOR_DECL";
            }
            case 600: {
                return "SYNTAX_EXPRESSION";
            }
            case 601: {
                return "SYNTAX_UNPARSED_EXPRESSION";
            }
            case 610: {
                return "SYNTAX_PAREN_EXPRESSION";
            }
            case 630: {
                return "SYNTAX_SQL_EXPRESSION";
            }
            case 631: {
                return "SYNTAX_SELECT_EXPRESSION";
            }
            case 632: {
                return "SYNTAX_INSERT_EXPRESSION";
            }
            case 720: {
                return "SYNTAX_EXP_OUTER";
            }
            case 730: {
                return "SYNTAX_EXP_MIDDLE";
            }
            case 740: {
                return "SYNTAX_EXP_INNER";
            }
            case 711: {
                return "SYNTAX_PREFIX_OPERATOR";
            }
            case 714: {
                return "SYNTAX_POSTFIX_OPERATOR";
            }
            case 712: {
                return "SYNTAX_INFIX_OPERATOR";
            }
            case 713: {
                return "SYNTAX_SPECIAL_OPERATOR";
            }
            case 750: {
                return "SYNTAX_PRIMARY";
            }
            case 752: {
                return "SYNTAX_PRIMARY_NAME";
            }
            case 753: {
                return "SYNTAX_LITERAL";
            }
            case 760: {
                return "SYNTAX_ARGUMENTS";
            }
            case 1001: {
                return "SYNTAX_LABEL";
            }
            case 1002: {
                return "SYNTAX_SIMPLE_NAME";
            }
            case 1003: {
                return "SYNTAX_SCHEMA_NAME";
            }
            case 1010: {
                return "SYNTAX_DATATYPE";
            }
        }
        return "unknown " + code;
    }
}

