/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.scanner;

import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.SourceLiteral;
import oracle.javatools.parser.java.v2.scanner.FastLexer;

public class LexerLiteral
implements SourceLiteral,
JavaConstants {
    private final short token;
    private int startOffset = -1;
    private int endOffset = -1;
    private Object value;
    private boolean flag_dw = false;
    private short error = 0;
    private static final boolean[] isHexDigit = LexerLiteral.initHexDigit();
    private static final boolean[] isOctDigit = LexerLiteral.initOctDigit();
    private static final boolean[] isDecDigit = LexerLiteral.initDecDigit();
    private static final byte[] hexValue = LexerLiteral.initHexValue();

    public static LexerLiteral scanConstant(FastLexer lexer) {
        int token = lexer.getToken();
        if (8 > token || token >= 16) {
            return null;
        }
        ReadTextBuffer textBuffer = lexer.getTextBuffer();
        return new LexerLiteral(textBuffer, token, lexer.getStartOffset(), lexer.getEndOffset());
    }

    public static LexerLiteral scanConstant(LexerToken lexerToken, ReadTextBuffer textBuffer) {
        boolean literal;
        int token = lexerToken.getToken();
        boolean bl = literal = 8 <= token && token < 16;
        if (!literal) {
            return null;
        }
        return new LexerLiteral(textBuffer, token, lexerToken.getStartOffset(), lexerToken.getEndOffset());
    }

    public static LexerLiteral copyConstant(LexerLiteral source) {
        return new LexerLiteral(source);
    }

    public static LexerLiteral createConstant(Object object) {
        if (object == null) {
            return new LexerLiteral(15);
        }
        if (object instanceof Boolean) {
            LexerLiteral literal = new LexerLiteral(12);
            literal.setBoolean((Boolean)object);
            return literal;
        }
        if (object instanceof Character) {
            LexerLiteral literal = new LexerLiteral(13);
            literal.setChar(((Character)object).charValue());
            return literal;
        }
        if (object instanceof Integer) {
            LexerLiteral literal = new LexerLiteral(8);
            literal.setInteger(((Integer)object).intValue());
            return literal;
        }
        if (object instanceof Long) {
            LexerLiteral literal = new LexerLiteral(9);
            literal.setInteger((Long)object);
            return literal;
        }
        if (object instanceof Float) {
            LexerLiteral literal = new LexerLiteral(10);
            literal.setFloat(((Float)object).floatValue());
            return literal;
        }
        if (object instanceof Double) {
            LexerLiteral literal = new LexerLiteral(11);
            literal.setFloat((Double)object);
            return literal;
        }
        if (object instanceof String) {
            LexerLiteral literal = new LexerLiteral(14);
            literal.setString((String)object);
            return literal;
        }
        return null;
    }

    public static LexerLiteral createTextBlockConstant(String text) {
        LexerLiteral literal = new LexerLiteral(14);
        literal.flag_dw = true;
        literal.setString(text);
        return literal;
    }

    private LexerLiteral(short token) {
        this.token = token;
    }

    private LexerLiteral(LexerLiteral that) {
        this.token = that.getTokenValue();
        this.startOffset = that.startOffset;
        this.endOffset = that.endOffset;
        this.value = that.value;
        this.flag_dw = that.flag_dw;
        this.error = that.error;
    }

    private LexerLiteral(ReadTextBuffer textBuffer, int token, int start, int end) {
        this.token = (short)token;
        this.startOffset = start;
        this.endOffset = end;
        switch (token) {
            case 12: {
                this.scanBooleanLiteral(textBuffer, start);
                break;
            }
            case 13: {
                this.scanCharLiteral(textBuffer, start, end);
                break;
            }
            case 9: {
                this.flag_dw = true;
                this.scanIntegerLiteral(textBuffer, start, end);
                break;
            }
            case 8: {
                this.scanIntegerLiteral(textBuffer, start, end);
                break;
            }
            case 11: {
                this.flag_dw = true;
            }
            case 10: {
                this.scanFloatLiteral(textBuffer, start, end);
                break;
            }
            case 14: {
                this.scanStringLiteral(textBuffer, start, end);
                break;
            }
        }
    }

    @Override
    public Object getConstantValue() {
        String o = switch (this.getTokenValue()) {
            case 12 -> this.getBoolean();
            case 13 -> Character.valueOf(this.getChar());
            case 9 -> this.getInteger();
            case 8 -> (int)this.getInteger();
            case 11 -> this.getFloat();
            case 10 -> Float.valueOf((float)this.getFloat());
            case 14 -> this.getString();
            default -> null;
        };
        return o;
    }

    @Override
    public boolean isTextBlock() {
        return this.token == 14 && this.flag_dw;
    }

    @Override
    public boolean isValid() {
        return this.error == 0;
    }

    private void scanBooleanLiteral(ReadTextBuffer buffer, int start) {
        this.setBoolean(buffer.getChar(start) == 't');
    }

    private void scanStringLiteral(ReadTextBuffer buffer, int start, int end) {
        if (buffer.getChar(start) != '\"' || buffer.getChar(end - 1) != '\"') {
            this.error = (short)8;
            this.startOffset = start;
            this.endOffset = end;
        }
        if (end <= start + 2) {
            this.setString("");
        } else if (buffer.getChar(start + 1) == '\"' && start + 3 <= end && buffer.getChar(start + 2) == '\"') {
            this.scanTextBlockLiteral(buffer, start, end);
        } else {
            char[] chars = buffer.getChars(start + 1, end - start - 2);
            this.setString(this.source2string(chars, 0, chars.length, start + 1));
        }
    }

    private void scanTextBlockLiteral(ReadTextBuffer buffer, int start, int end) {
        if (end - start >= 7 && buffer.getChar(end - 1) == '\"' && buffer.getChar(end - 2) == '\"' && buffer.getChar(end - 3) == '\"' && (buffer.getChar(end - 4) != '\\' || buffer.getChar(end - 5) == '\\')) {
            int begin = start + 3;
            block5: while (begin < end) {
                switch (buffer.getChar(begin++)) {
                    case '\t': 
                    case '\f': 
                    case ' ': {
                        continue block5;
                    }
                    case '\r': {
                        if (begin >= end || buffer.getChar(begin) != '\n') break block5;
                        ++begin;
                        break block5;
                    }
                    case '\n': {
                        break block5;
                    }
                    default: {
                        CommonUtilities.panic("invalid characters after text block opening delimiter not detected");
                        break block5;
                    }
                }
            }
            this.flag_dw = true;
            this.setString(this.translateEscapes(buffer.getString(begin, end - begin - 3).stripIndent()));
        } else {
            this.error = (short)128;
            this.startOffset = start;
            this.endOffset = end;
        }
    }

    private void scanCharLiteral(ReadTextBuffer buffer, int start, int end) {
        if (end == start + 2) {
            this.error = (short)9;
            this.startOffset = start;
            this.endOffset = end;
        } else if (end > start + 2) {
            if (buffer.getChar(start) != '\'' || buffer.getChar(end - 1) != '\'') {
                this.error = (short)10;
                this.startOffset = start;
                this.endOffset = end;
            }
            char[] chars = buffer.getChars(start + 1, end - start - 2);
            String string = this.source2string(chars, 0, chars.length, start + 1);
            this.setChar(string.charAt(0));
            if (string.length() > 1) {
                this.error = (short)10;
                this.startOffset = start;
                this.endOffset = end;
            }
        }
    }

    private void scanIntegerLiteral(ReadTextBuffer buffer, int start, int end) {
        long value = 0L;
        try {
            boolean gotValue = false;
            int pos = start;
            char ch = buffer.getChar(pos++);
            if (ch == '0') {
                if (end == pos) {
                    return;
                }
                if ((ch = buffer.getChar(pos++)) == 'x' || ch == 'X') {
                    while (pos < end) {
                        if ((ch = buffer.getChar(pos++)) == '_') {
                            if (!this.checkUnderscore(buffer, start, end, pos - 1, true)) continue;
                            break;
                        }
                        if (ch >= '\u0100' || !isHexDigit[ch]) break;
                        if ((value & 0xF000000000000000L) != 0L) {
                            this.error = (short)5;
                            this.startOffset = start;
                            this.endOffset = end;
                            break;
                        }
                        value *= 16L;
                        value += (long)hexValue[ch];
                        gotValue = true;
                    }
                } else if (ch == 'b' || ch == 'B') {
                    while (pos < end) {
                        if ((ch = buffer.getChar(pos++)) == '_') {
                            if (!this.checkUnderscore(buffer, start, end, pos - 1, true)) continue;
                            break;
                        }
                        if (ch != '0' && ch != '1') break;
                        if ((value & Long.MIN_VALUE) != 0L) {
                            this.error = (short)5;
                            this.startOffset = start;
                            this.endOffset = end;
                            break;
                        }
                        value *= 2L;
                        value += (long)hexValue[ch];
                        gotValue = true;
                    }
                } else if (ch == 'l' || ch == 'L') {
                    gotValue = true;
                } else {
                    --pos;
                    while (pos < end) {
                        if ((ch = buffer.getChar(pos++)) == '_') {
                            if (!this.checkUnderscore(buffer, start, end, pos - 1, false)) continue;
                            break;
                        }
                        if (ch < '\u0100' && isOctDigit[ch]) {
                            if ((value & 0xE000000000000000L) != 0L) {
                                this.error = (short)5;
                                this.startOffset = start;
                                this.endOffset = end;
                                break;
                            }
                            value *= 8L;
                            value += (long)hexValue[ch];
                            gotValue = true;
                            continue;
                        }
                        if (!isDecDigit[ch]) break;
                        this.error = (short)4;
                        this.startOffset = start;
                        this.endOffset = end;
                        break;
                    }
                }
                if (!this.flag_dw && value > 0xFFFFFFFFL) {
                    this.error = (short)5;
                    this.startOffset = start;
                    this.endOffset = end;
                }
            } else {
                value = hexValue[ch];
                gotValue = true;
                if (value != 0L) {
                    while (pos < end) {
                        if ((ch = buffer.getChar(pos++)) == '_') {
                            if (!this.checkUnderscore(buffer, start, end, pos - 1, false)) continue;
                            break;
                        }
                        if (ch >= '\u0100' || !isDecDigit[ch]) break;
                        long ov = value;
                        value *= 10L;
                        if ((value += (long)hexValue[ch]) >= ov || value == Long.MIN_VALUE) continue;
                        this.error = (short)5;
                        this.startOffset = start;
                        this.endOffset = end;
                        break;
                    }
                    if (!this.flag_dw && value > 0x80000000L) {
                        this.error = (short)5;
                        this.startOffset = start;
                        this.endOffset = end;
                    }
                }
            }
            if (!gotValue) {
                this.error = (short)4;
                this.startOffset = start;
                this.endOffset = end;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.setInteger(value);
    }

    private boolean isZeroFloating(ReadTextBuffer buffer, int start, int end) {
        boolean afterExponent = false;
        block5: for (int i = start; i < end; ++i) {
            char ch = buffer.getChar(i);
            switch (ch) {
                case '.': 
                case '0': 
                case 'D': 
                case 'F': 
                case 'X': 
                case '_': 
                case 'd': 
                case 'f': 
                case 'x': {
                    continue block5;
                }
                case 'E': 
                case 'P': 
                case 'e': 
                case 'p': {
                    afterExponent = true;
                    continue block5;
                }
                case '+': 
                case '-': 
                case '1': {
                    if (afterExponent) continue block5;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private void scanFloatLiteral(ReadTextBuffer buffer, int start, int end) {
        this.flag_dw = true;
        char ch = buffer.getChar(end - 1);
        boolean includeLast = true;
        if (ch == 'f' || ch == 'F') {
            this.flag_dw = false;
            includeLast = false;
        } else if (ch == 'd' || ch == 'D') {
            includeLast = false;
        }
        int effectiveLength = end - start;
        if (!includeLast) {
            --effectiveLength;
        }
        StringBuilder buf = new StringBuilder();
        boolean hexadecimal = false;
        for (int i = start; i < start + effectiveLength; ++i) {
            ch = buffer.getChar(i);
            if (ch == '_') {
                if (!this.checkUnderscore(buffer, start, end, i, hexadecimal)) continue;
                this.setFloat(0.0);
                return;
            }
            if (ch == 'x' || ch == 'X') {
                hexadecimal = true;
            } else if (ch == 'p' || ch == 'P') {
                hexadecimal = false;
            }
            buf.append(ch);
        }
        String text = buf.toString();
        try {
            double value = this.flag_dw ? Double.parseDouble(text) : (double)Float.parseFloat(text);
            if (value == 0.0 && !this.isZeroFloating(buffer, start, end)) {
                this.error = (short)6;
                this.startOffset = start;
                this.endOffset = end;
            } else if (value == Double.POSITIVE_INFINITY) {
                this.error = (short)5;
                this.startOffset = start;
                this.endOffset = end;
            }
            this.setFloat(value);
        }
        catch (NumberFormatException e) {
            this.error = (short)4;
            this.startOffset = start;
            this.endOffset = end;
        }
    }

    private String source2string(char[] source, int offset, int length, int errorDelta) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        block12: while (i < length) {
            if (source[offset + i] == '\\') {
                int start = offset + i;
                if (i + 1 < length) {
                    switch (source[offset + ++i]) {
                        case 'n': {
                            buffer.append('\n');
                            ++i;
                            continue block12;
                        }
                        case 't': {
                            buffer.append('\t');
                            ++i;
                            continue block12;
                        }
                        case 'b': {
                            buffer.append('\b');
                            ++i;
                            continue block12;
                        }
                        case 'r': {
                            buffer.append('\r');
                            ++i;
                            continue block12;
                        }
                        case 'f': {
                            buffer.append('\f');
                            ++i;
                            continue block12;
                        }
                        case '\'': {
                            buffer.append('\'');
                            ++i;
                            continue block12;
                        }
                        case '\"': {
                            buffer.append('\"');
                            ++i;
                            continue block12;
                        }
                        case '\\': {
                            buffer.append('\\');
                            ++i;
                            continue block12;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': {
                            StringBuilder octalValue = new StringBuilder();
                            octalValue.append(source[offset + i]);
                            ++i;
                            for (int count = 1; count < (octalValue.charAt(0) < '4' ? 3 : 2) && i < length && LexerLiteral.isOctalDigit(source[offset + i]); ++count, ++i) {
                                octalValue.append(source[offset + i]);
                            }
                            buffer.append((char)Integer.valueOf(octalValue.toString(), 8).intValue());
                            continue block12;
                        }
                        case 'u': {
                            int l;
                            for (l = i + 1; l < length && source[offset + l] == 'u'; ++l) {
                            }
                            if (l + 4 > length) break;
                            char code = '\u0000';
                            int d = 0;
                            for (int k = 0; k < 4; ++k) {
                                d = LexerLiteral.digit2int(source[offset + l + k], 16);
                                if (d < 0) {
                                    this.error = (short)11;
                                    this.startOffset = start + errorDelta;
                                    this.endOffset = offset + l + k + 1 + errorDelta;
                                    break;
                                }
                                code = (char)(code << 4);
                                code = (char)(code + (char)d);
                            }
                            if (d < 0) break;
                            buffer.append(code);
                            i = l + 4;
                            continue block12;
                        }
                    }
                    this.error = (short)11;
                    this.startOffset = start + errorDelta;
                    this.endOffset = offset + i + 1 + errorDelta;
                } else {
                    this.error = (short)11;
                    this.startOffset = start + errorDelta;
                    this.endOffset = start + 1 + errorDelta;
                }
            }
            char b = source[offset + i++];
            buffer.append(b);
        }
        return buffer.toString();
    }

    private static boolean isOctalDigit(char ch) {
        int intValue = LexerLiteral.digit2int(ch, 10);
        return intValue >= 0 && intValue < 8;
    }

    static int digit2int(char ch, int base) {
        if ('0' <= ch && ch <= '9' && ch < 48 + base) {
            return ch - 48;
        }
        if ('A' <= ch && ch < 65 + base - 10) {
            return ch - 65 + 10;
        }
        if ('a' <= ch && ch < 97 + base - 10) {
            return ch - 97 + 10;
        }
        return -1;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public short getTokenValue() {
        return this.token;
    }

    public boolean getBoolean() {
        boolean bl;
        Object object = this.value;
        if (object instanceof Boolean) {
            Boolean b = (Boolean)object;
            bl = b;
        } else {
            bl = false;
        }
        return bl;
    }

    private void setBoolean(boolean b) {
        this.value = b;
    }

    public char getChar() {
        char c;
        Object object = this.value;
        if (object instanceof Character) {
            Character c2 = (Character)object;
            c = c2.charValue();
        } else {
            c = '\u0000';
        }
        return c;
    }

    private void setChar(char c) {
        this.value = Character.valueOf(c);
    }

    public String getString() {
        String s;
        Object object = this.value;
        return object instanceof String ? (s = (String)object) : null;
    }

    private void setString(String s) {
        this.value = s;
    }

    public long getInteger() {
        long l;
        Object object = this.value;
        if (object instanceof Long) {
            Long l2 = (Long)object;
            l = l2;
        } else {
            l = 0L;
        }
        return l;
    }

    private void setInteger(long i) {
        this.value = i;
    }

    public double getFloat() {
        double d;
        Object object = this.value;
        if (object instanceof Double) {
            Double d2 = (Double)object;
            d = d2;
        } else {
            d = 0.0;
        }
        return d;
    }

    private void setFloat(double f) {
        this.value = f;
    }

    public short getError() {
        return this.error;
    }

    private static boolean[] initHexDigit() {
        int i;
        boolean[] isHexDigit = new boolean[256];
        for (i = 48; i <= 57; i = (int)((byte)(i + 1))) {
            isHexDigit[i] = true;
        }
        for (i = 97; i <= 102; i = (int)((byte)(i + 1))) {
            isHexDigit[i] = true;
        }
        for (i = 65; i <= 70; i = (int)((byte)(i + 1))) {
            isHexDigit[i] = true;
        }
        return isHexDigit;
    }

    private static boolean[] initOctDigit() {
        boolean[] isOctDigit = new boolean[256];
        for (int i = 48; i <= 55; i = (int)((byte)(i + 1))) {
            isOctDigit[i] = true;
        }
        return isOctDigit;
    }

    private static boolean[] initDecDigit() {
        boolean[] isDecDigit = new boolean[256];
        for (int i = 48; i <= 57; i = (int)((byte)(i + 1))) {
            isDecDigit[i] = true;
        }
        return isDecDigit;
    }

    private static byte[] initHexValue() {
        int i;
        byte[] hexValue = new byte[256];
        for (i = 48; i <= 57; i = (int)((byte)(i + 1))) {
            hexValue[i] = (byte)(i - 48);
        }
        for (i = 97; i <= 102; i = (int)((byte)(i + 1))) {
            hexValue[i] = (byte)(i - 97 + 10);
        }
        for (i = 65; i <= 70; i = (int)((byte)(i + 1))) {
            hexValue[i] = (byte)(i - 65 + 10);
        }
        return hexValue;
    }

    private boolean checkUnderscore(ReadTextBuffer buffer, int start, int end, int underscore, boolean hexadecimal) {
        char postCh;
        char prevCh;
        boolean isError;
        boolean bl = isError = underscore == start || underscore == end;
        if (!isError && (prevCh = buffer.getChar(underscore - 1)) != '_') {
            if (hexadecimal) {
                isError = prevCh >= '\u0100' || !isHexDigit[prevCh];
            } else {
                boolean bl2 = isError = prevCh >= '\u0100' || !isDecDigit[prevCh];
            }
        }
        if (!isError && (postCh = buffer.getChar(underscore + 1)) != '_') {
            if (hexadecimal) {
                isError = postCh >= '\u0100' || !isHexDigit[postCh];
            } else {
                boolean bl3 = isError = postCh >= '\u0100' || !isDecDigit[postCh];
            }
        }
        if (isError) {
            this.error = (short)4;
            this.startOffset = start;
            this.endOffset = end;
            return true;
        }
        return false;
    }

    public String translateEscapes(String string) {
        if (string.isEmpty()) {
            return "";
        }
        char[] chars = string.toCharArray();
        int length = chars.length;
        int from = 0;
        int to = 0;
        block12: while (from < length) {
            char ch;
            if ((ch = chars[from++]) == '\\') {
                ch = from < length ? chars[from++] : (char)'\u0000';
                switch (ch) {
                    case 'b': {
                        ch = '\b';
                        break;
                    }
                    case 'f': {
                        ch = '\f';
                        break;
                    }
                    case 'n': {
                        ch = '\n';
                        break;
                    }
                    case 'r': {
                        ch = '\r';
                        break;
                    }
                    case 's': {
                        ch = ' ';
                        break;
                    }
                    case 't': {
                        ch = '\t';
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        int limit = Integer.min(from + (ch <= '3' ? 2 : 1), length);
                        int code = ch - 48;
                        while (from < limit && (ch = chars[from]) >= '0' && '7' >= ch) {
                            ++from;
                            code = code << 3 | ch - 48;
                        }
                        ch = (char)code;
                        break;
                    }
                    case '\n': {
                        continue block12;
                    }
                    case '\r': {
                        if (from >= length || chars[from] != '\n') continue block12;
                        ++from;
                        continue block12;
                    }
                    default: {
                        this.error = (short)11;
                        this.startOffset = from;
                        this.endOffset = from + 1;
                        String msg = String.format("Invalid escape sequence: \\%c \\\\u%04X", Character.valueOf(ch), (int)ch);
                        throw new IllegalArgumentException(msg);
                    }
                }
            }
            chars[to++] = ch;
        }
        return new String(chars, 0, to);
    }
}

