/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol.stmt;

import java.util.List;
import oracle.javatools.parser.java.v2.JavaTokens;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.LabelSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.IfStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.TryStmt;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceToken;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceIfStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceStatementLabel;
import oracle.javatools.parser.java.v2.model.statement.SourceTryStatement;

public abstract class Stmt
extends TreeSym
implements SourceStatement {
    @Override
    public String getStatementKeyword() {
        return JavaTokens.toString(this.getStatementToken());
    }

    @Override
    @Deprecated(since="14")
    public abstract short getStatementToken();

    @Override
    public List<SourceStatementLabel> getStatementLabels() {
        return this.getChildrenList(16);
    }

    public final SourceIfStatement getOwningIf() {
        return this.getOwningIfSym();
    }

    public final SourceTryStatement getOwningTry() {
        return this.getOwningTrySym();
    }

    public final IfStmt getOwningIfSym() {
        Sym sym = this.symParent;
        while (sym != null) {
            if (sym.symKind == 58) {
                return (IfStmt)sym;
            }
            sym = sym.symParent;
        }
        return null;
    }

    public final TryStmt getOwningTrySym() {
        Sym sym = this.symParent;
        while (sym != null) {
            if (sym.symKind == 63) {
                return (TryStmt)sym;
            }
            sym = sym.symParent;
        }
        return null;
    }

    public SourceName getExpressionName() {
        return (SourceName)((Object)this.getChild((byte)20));
    }

    public SourceExpression getOutputExpression() {
        return null;
    }

    public SourceExpression getControlExpression() {
        return this.getExpressionSym();
    }

    public int getControlSectionStart() {
        short stmtToken = this.getStatementToken();
        List<SourceToken> tokens = this.getTokens();
        block3: for (SourceToken token : tokens) {
            short value = token.getTokenValue();
            switch (value) {
                case 5: 
                case 6: 
                case 24: 
                case 25: 
                case 26: {
                    continue block3;
                }
            }
            if (value == stmtToken) continue;
            return token.getTokenStart();
        }
        return -1;
    }

    public int getControlSectionEnd() {
        short stmtToken = this.getStatementToken();
        Stmt clauseSym = this.getPrimaryClauseSym();
        int stop = clauseSym != null ? clauseSym.getStartOffset() : this.getEndOffset();
        List<SourceToken> tokens = this.getTokens();
        int end = -1;
        block3: for (SourceToken token : tokens) {
            if (token.getTokenStart() >= stop) break;
            short value = token.getTokenValue();
            switch (value) {
                case 5: 
                case 6: 
                case 24: 
                case 25: 
                case 26: {
                    continue block3;
                }
            }
            if (value == stmtToken) continue;
            end = token.getTokenEnd();
        }
        return end;
    }

    public final SourceStatement getPrimaryClause() {
        return this.getPrimaryClauseSym();
    }

    public final Stmt getPrimaryClauseSym() {
        return (Stmt)this.getChild((byte)107);
    }

    public SourceStatement getEndClause() {
        return null;
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 16: {
                return true;
            }
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    public boolean checkSafeToInsert() {
        return this.getParentSym().symKind == 2;
    }

    @Override
    public boolean checkSafeToDelete(TreeSym parent) {
        return parent.symKind == 2;
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        return (Stmt)super.cloneSelf(targetFile);
    }

    @Override
    protected void verboseSelf(StringBuilder buffer) {
        buffer.append(" stmt \"");
        buffer.append(this.getStatementKeyword());
        buffer.append('\"');
    }

    public static Sym getTargetLabel(Sym breakOrContinueSym) {
        Sym target;
        if ((breakOrContinueSym.symKind == 49 || breakOrContinueSym.symKind == 51) && (target = ((TreeSym)breakOrContinueSym).getChild((byte)20)) != null) {
            String targetName = ((NameSym)target).getName();
            for (Sym parent = breakOrContinueSym.getParentSym(); parent != null && parent.symKind != 19 && parent.symKind != 6; parent = parent.getParentSym()) {
                List<SourceElement> labels = parent.getChildren(16);
                for (int i = 0; i < labels.size(); ++i) {
                    LabelSym label = (LabelSym)labels.get(i);
                    if (!targetName.equals(label.getName())) continue;
                    return label;
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void compileBreakContinueContext(CompilerDriver compiler, Sym targetSym, boolean checkBreak) {
        block5: for (SourceElement parent = targetSym.getParent(); parent != null; parent = parent.getParent()) {
            int kind = parent.getSymbolKind();
            switch (kind) {
                case 3: 
                case 6: 
                case 11: 
                case 19: {
                    break block5;
                }
                case 23: 
                case 60: {
                    if (!checkBreak) break;
                    return;
                }
                case 52: 
                case 57: 
                case 64: {
                    return;
                }
            }
        }
        compiler.error(targetSym, checkBreak ? (short)82 : 83);
    }

    @Override
    protected JavaElement compileImpl(CompilerDriver compiler) {
        if (compiler.skipCompilations()) {
            super.compileImpl(compiler);
            return this;
        }
        compiler.startStatementFlowAnalysis(this);
        try {
            JavaElement javaElement = this.compileImplImpl(compiler);
            return javaElement;
        }
        finally {
            compiler.endStatementFlowAnalysis(this);
        }
    }

    protected JavaElement compileImplImpl(CompilerDriver compiler) {
        return super.compileImpl(compiler);
    }
}

