/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol.expr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.BlockSym;
import oracle.javatools.parser.java.v2.internal.symbol.SwitchLabelSym;
import oracle.javatools.parser.java.v2.internal.symbol.SwitchRuleSym;
import oracle.javatools.parser.java.v2.internal.symbol.SwitchStatementGroupSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.Stmt;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceSwitchElement;
import oracle.javatools.parser.java.v2.model.SourceSwitchRule;
import oracle.javatools.parser.java.v2.model.SourceSwitchStatementGroup;
import oracle.javatools.parser.java.v2.model.SourceToken;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSwitchExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchLabel;

public final class SwitchExpr
extends Expr
implements SourceSwitchExpression,
SourceSwitchElement,
SourceExpression {
    @Override
    public boolean isExpression() {
        return true;
    }

    @Override
    public boolean isStatement() {
        return false;
    }

    @Override
    public SourceExpression getSelectorExpression() {
        return this.getExpressionSym();
    }

    @Override
    public SourceBlock getSwitchBlock() {
        return this.getBlockSym();
    }

    @Override
    public boolean hasRules() {
        SwitchLabelSym label = (SwitchLabelSym)this.getSym((byte)2, 23);
        return label.hasRule();
    }

    @Override
    public List<SourceSwitchRule> getRules() {
        if (this.hasStatementGroups()) {
            return null;
        }
        ArrayList<SourceSwitchRule> rules = new ArrayList<SourceSwitchRule>();
        for (SwitchLabelSym label : this.getBlockSym().getSyms((byte)23)) {
            rules.add(new SwitchRuleSym(this.getBlockSym(), label, label.getSiblingAfter()));
        }
        return rules;
    }

    @Override
    public boolean hasStatementGroups() {
        SwitchLabelSym label = (SwitchLabelSym)this.getSym((byte)2, 23);
        return label.hasStatementGroup();
    }

    @Override
    public List<SourceSwitchStatementGroup> getStatementGroups() {
        if (this.hasRules()) {
            return null;
        }
        ArrayList<SourceSwitchStatementGroup> groups = new ArrayList<SourceSwitchStatementGroup>();
        ArrayList<SourceSwitchLabel> labels = null;
        List<SourceElement> elements = null;
        boolean wasLabel = false;
        boolean wasOther = false;
        for (SourceElement element : this.getSwitchBlock().getCodeElements()) {
            if (element instanceof SwitchLabelSym) {
                SwitchLabelSym label = (SwitchLabelSym)element;
                if (wasOther) {
                    groups.add(new SwitchStatementGroupSym(this, this.getBlockSym(), labels, elements));
                    labels = new ArrayList<SwitchLabelSym>(Collections.singletonList(label));
                    elements = new ArrayList<SourceElement>();
                } else if (wasLabel) {
                    labels.add(label);
                } else {
                    labels = new ArrayList<SourceSwitchLabel>(Collections.singletonList(label));
                }
                wasLabel = true;
                wasOther = false;
                continue;
            }
            if (wasOther) {
                elements.add(element);
            } else if (wasLabel) {
                elements = new ArrayList<SourceElement>(Collections.singletonList(element));
            }
            wasOther = true;
            wasLabel = false;
            assert (element != null) : "elements null after wasOther == true";
        }
        if (labels != null && !labels.isEmpty()) {
            if (elements == null) {
                elements = Collections.emptyList();
            }
            groups.add(new SwitchStatementGroupSym(this, this.getBlockSym(), (List<SourceSwitchLabel>)labels, elements));
        }
        return groups;
    }

    @Override
    public SourceExpression getControlExpression() {
        return this.getExpressionSym();
    }

    @Override
    public List<SourceSwitchLabel> getSwitchLabels() {
        BlockSym block = this.getBlockSym();
        return block != null ? block.getChildrenList(23) : Collections.emptyList();
    }

    public int getControlSectionStart() {
        List<SourceToken> tokens = this.getTokens();
        block3: for (SourceToken token : tokens) {
            short value = token.getTokenValue();
            switch (value) {
                case 5: 
                case 6: 
                case 24: 
                case 25: 
                case 26: {
                    continue block3;
                }
            }
            if (value == 134) continue;
            return token.getTokenStart();
        }
        return -1;
    }

    public int getControlSectionEnd() {
        Stmt clauseSym = (Stmt)this.getChild((byte)107);
        int stop = clauseSym != null ? clauseSym.getStartOffset() : this.getEndOffset();
        List<SourceToken> tokens = this.getTokens();
        int end = -1;
        block3: for (SourceToken token : tokens) {
            if (token.getTokenStart() >= stop) break;
            short value = token.getTokenValue();
            switch (value) {
                case 5: 
                case 6: 
                case 24: 
                case 25: 
                case 26: {
                    continue block3;
                }
            }
            if (value == 134) continue;
            end = token.getTokenEnd();
        }
        return end;
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        return switch (symKind) {
            case 48, 81 -> true;
            default -> super.isValidChildSymKind(symKind);
        };
    }

    @Override
    protected JavaElement resolveImplImpl(CompilerDriver compiler) {
        return compiler.resolve(this);
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }
}

