/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol.expr;

import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.expression.SourceLiteralExpression;
import oracle.javatools.parser.java.v2.scanner.LexerLiteral;

public final class LiteralExpr
extends Expr
implements SourceLiteralExpression {
    private LexerLiteral literal;
    private String text;

    public void setLiteral(LexerLiteral literal, String text) {
        this.literal = literal;
        this.text = text;
    }

    @Override
    public int getTokenValue() {
        if (this.literal != null) {
            return this.literal.getTokenValue();
        }
        return 8;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public boolean isValid() {
        return this.literal.isValid();
    }

    @Override
    public boolean isTextBlock() {
        return this.literal != null ? this.literal.isTextBlock() : false;
    }

    @Override
    public LexerLiteral getLiteral() {
        return this.literal;
    }

    @Override
    public Object getConstantValue() {
        return this.literal != null ? this.literal.getConstantValue() : null;
    }

    @Override
    protected JavaElement resolveImplImpl(CompilerDriver compiler) {
        return compiler.resolve(this);
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        LiteralExpr sym = (LiteralExpr)super.cloneSelf(targetFile);
        if (this.literal != null) {
            sym.literal = LexerLiteral.copyConstant(this.literal);
        }
        sym.text = this.text;
        return sym;
    }

    @Override
    protected void verboseSelf(StringBuilder buffer) {
        Object constantValue = this.getConstantValue();
        if (constantValue != null) {
            buffer.append(' ').append(constantValue);
        }
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }
}

