/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol.expr;

import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.SimpleNameExpr;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;

public final class DotExpr
extends Expr
implements SourceDotExpression {
    @Override
    public Expr getLhsOperandSym() {
        return this.getNthOperandSym(0);
    }

    @Override
    public void setLhsOperandSym(Expr e) {
        this.setSym((byte)108, e);
    }

    public boolean isQualifiedName() {
        Expr lhsSym = this.getLhsOperandSym();
        return lhsSym != null && lhsSym.flag_maybePackage();
    }

    public String getQualifiedName() {
        if (!this.isQualifiedName()) {
            throw new UnsupportedOperationException("Not a qualified name");
        }
        String name = this.getName();
        Expr lhs = this.getLhsOperandSym();
        try {
            if (lhs.symKind == 77) {
                SimpleNameExpr e = (SimpleNameExpr)lhs;
                return e.getName() + "." + name;
            }
            DotExpr e = (DotExpr)lhs;
            return e.getQualifiedName() + "." + name;
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("Not a qualified name");
        }
    }

    @Override
    protected JavaElement resolveImplImpl(CompilerDriver compiler) {
        return compiler.resolve(this);
    }

    @Override
    protected JavaElement compileImpl(CompilerDriver compiler) {
        SourceElement sourceElement;
        Expr lhs;
        JavaElement result = super.compileImpl(compiler);
        if (!compiler.skipCompilations() && result != null && (lhs = this.getLhsOperandSym()) != null && "this".equals(lhs.getName()) && (sourceElement = result.getSourceElement()) != null && sourceElement.getSymbolKind() == 10) {
            compiler.fieldUsedFlowAnalysis((SourceFieldVariable)sourceElement, this);
        }
        return result;
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 20: {
                return true;
            }
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    protected void linkChildTrigger(Sym child, byte filter) {
        super.linkChildTrigger(child, filter);
        boolean addMaybePackage = false;
        switch (child.symKind) {
            case 77: {
                addMaybePackage = true;
                break;
            }
            case 69: {
                DotExpr dotExpr = (DotExpr)child;
                addMaybePackage = dotExpr.isQualifiedName();
            }
        }
        if (!addMaybePackage) {
            return;
        }
        Expr childExpr = (Expr)child;
        if (!childExpr.flag_maybePackage()) {
            childExpr.symFlags = (byte)(childExpr.symFlags | 0x40);
            Sym sym = this;
            Sym parentSym = sym.getParentSym();
            while (parentSym != null && parentSym.symKind == 69) {
                sym.symFlags = (byte)(sym.symFlags | 0x40);
                sym = parentSym;
                parentSym = sym.getParentSym();
            }
        }
    }

    @Override
    protected void unlinkChildTrigger(Sym child, byte filter) {
        super.unlinkChildTrigger(child, filter);
        switch (child.symKind) {
            case 69: 
            case 77: {
                break;
            }
            default: {
                return;
            }
        }
        Expr childExpr = (Expr)child;
        if (childExpr.flag_maybePackage()) {
            childExpr.symFlags = (byte)(childExpr.symFlags & 0xFFFFFFBF);
            Sym sym = this;
            Sym parentSym = sym.getParentSym();
            while (parentSym != null && parentSym.symKind == 69) {
                sym.symFlags = (byte)(sym.symFlags & 0xFFFFFFBF);
                sym = parentSym;
                parentSym = sym.getParentSym();
            }
        }
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }
}

