/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.List;
import java.util.function.Function;
import javax.swing.undo.UndoableEdit;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.GuardedTextBuffer;
import oracle.javatools.buffer.OffsetRegion;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.parser.java.v2.internal.parser.SyntaxData;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.SymOperation;
import oracle.javatools.parser.java.v2.internal.symbol.SymSavepoint;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.write.SourceSavepoint;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.javatools.parser.java.v2.write.SourceTransactionListener;

final class SymTransaction
extends TreeSym
implements SourceTransaction,
TextBufferListener {
    protected TextBuffer realTextBuffer;
    protected TextBuffer copyTextBuffer;
    protected TextBuffer transTextBuffer;
    private SyntaxData transData;
    private TextEdit transEditFront;
    private TextEdit transEditBack;
    private SourceTransactionListener[] listeners;
    Sym symBeingFormatted;
    int[] regionBeingFormatted;
    private Thread transactionThread;
    private boolean hasGuardedTextBuffer;
    private boolean abortedDuringExceptionHandling;
    private boolean runningInAutoTransaction;

    SymTransaction(FileSym fileSym, TextBuffer textBuffer) {
        this.transEditBack = this.transEditFront = new TextEdit(0, 0);
        this.listeners = SourceTransactionListener.EMPTY_ARRAY;
        this.symKind = (byte)103;
        if (fileSym == null) {
            throw new IllegalArgumentException();
        }
        this.symParent = fileSym;
        this.symFile = fileSym;
        this.transData = new SyntaxData();
        if (textBuffer == null) {
            throw new IllegalArgumentException("File has no text buffer");
        }
        this.realTextBuffer = textBuffer;
        this.transactionThread = Thread.currentThread();
        this.hasGuardedTextBuffer = textBuffer instanceof GuardedTextBuffer && ((GuardedTextBuffer)textBuffer).isGuardActive() && !((GuardedTextBuffer)textBuffer).getRegions().isEmpty();
    }

    public synchronized boolean hasOutstandingChanges() {
        return this.transData.kidCount > 0;
    }

    protected synchronized void checkSavepoint() {
        if (this.transactionThread == null) {
            return;
        }
        this.savepoint();
    }

    @Override
    public synchronized SourceSavepoint savepoint() {
        if (this.transactionThread == null) {
            throw new IllegalStateException("Transaction has been closed");
        }
        this.symFile.symFlags = (byte)(this.symFile.symFlags | 0xFFFFFF80);
        try {
            if (this.transData.kidCount == 0) {
                SymSavepoint symSavepoint = (SymSavepoint)this.getLastChild((byte)102);
                return symSavepoint;
            }
            int lastSavepoint = this.lastIndexOf((byte)102);
            SymSavepoint savepoint = new SymSavepoint(this);
            this.symFile.clearCompiledInfo();
            savepoint.preprocessSelf();
            int childCount = this.treeChildren.length;
            for (int i = lastSavepoint + 1; i < childCount; ++i) {
                this.transData.addKid(this.treeChildren[i]);
            }
            savepoint.symData = this.transData;
            savepoint.buildSelf();
            savepoint.processSelf();
            savepoint.lastIncludedEdit = this.transEditBack;
            savepoint.symData = this.transData;
            savepoint.buildSelf();
            if (this.transData.kidCount > 0) {
                SymTransaction.panic();
            }
            this.transData.addKid(savepoint);
            this.buildSelf();
            this.symFile.clearCompiledInfo();
            SymSavepoint symSavepoint = savepoint;
            return symSavepoint;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.symFile.symFlags = (byte)(this.symFile.symFlags & 0x7F);
        }
    }

    @Override
    public synchronized void rollback(SourceSavepoint target) {
        if (this.abortedDuringExceptionHandling) {
            return;
        }
        if (this.transactionThread == null) {
            throw new IllegalStateException("Transaction has been closed");
        }
        SymSavepoint savepointSym = (SymSavepoint)target;
        int savepointIndex = this.indexOf(savepointSym);
        if (savepointIndex == -1) {
            throw new IllegalArgumentException();
        }
        int count = this.transData.kidCount;
        Sym[] kids = this.transData.kids;
        this.transData = new SyntaxData();
        for (int i = count - 1; i >= 0; --i) {
            SymOperation op = (SymOperation)kids[i];
            op.undoSelf();
        }
        count = this.treeChildren.length;
        for (int i = count - 1; i > savepointIndex; --i) {
            SymSavepoint savepoint = (SymSavepoint)this.treeChildren[i];
            savepoint.undoSelf();
        }
        this.transData.kidCount = 0;
        savepointSym.lastIncludedEdit.next = null;
        this.transEditBack = savepointSym.lastIncludedEdit;
        this.symFile.clearFormatInfo();
        this.symFile.adjustOffsets();
        Sym[] newArray = new Sym[savepointIndex + 1];
        System.arraycopy(this.treeChildren, 0, newArray, 0, savepointIndex + 1);
        this.treeChildren = newArray;
        this.symFile.buildSelf();
        this.symFile.clearCompiledInfo();
    }

    @Override
    public synchronized void rollback() {
        this.rollback((SymSavepoint)this.treeChildren[0]);
    }

    @Override
    public synchronized UndoableEdit commit() {
        return this.commit(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized UndoableEdit commit(boolean runningInAutoTransaction) {
        if (runningInAutoTransaction != this.runningInAutoTransaction) {
            throw new IllegalStateException("Transaction is managed, cannot call commit");
        }
        if (this.transactionThread == null) {
            throw new IllegalStateException("Transaction has been closed");
        }
        this.realTextBuffer.beginEdit();
        UndoableEdit edit = null;
        boolean completed = false;
        try {
            this.savepoint();
            SymTransaction.performTextEdits(this.realTextBuffer, this.transEditFront);
            completed = true;
        }
        catch (Exception ex) {
            Assert.printStackTrace(ex);
            throw new RuntimeException(ex);
        }
        finally {
            edit = this.realTextBuffer.endEdit();
            if (!completed) {
                try {
                    if (edit != null) {
                        edit.undo();
                    }
                }
                catch (Exception ex) {
                    Assert.printStackTrace(ex);
                }
                try {
                    this.abort(runningInAutoTransaction);
                }
                finally {
                    this.abortedDuringExceptionHandling = true;
                }
            }
        }
        this.close(true);
        this.symFile.notify(this);
        return edit;
    }

    @Override
    public synchronized void abort() {
        this.abort(false);
    }

    private synchronized void abort(boolean runningInAutoTransaction) {
        if (runningInAutoTransaction != this.runningInAutoTransaction) {
            throw new IllegalStateException("Transaction is managed, cannot call abort");
        }
        if (this.abortedDuringExceptionHandling || this.transactionThread == null) {
            return;
        }
        try {
            this.rollback();
        }
        catch (Exception ex) {
            Assert.printStackTrace(ex);
            throw new RuntimeException(ex);
        }
        finally {
            this.close(false);
        }
    }

    protected TextBuffer getTextBuffer() {
        return this.transTextBuffer;
    }

    Thread getTransactionThread() {
        return this.transactionThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void begin() {
        boolean acquiredWriteLock = false;
        try {
            this.realTextBuffer.writeLock();
            acquiredWriteLock = true;
        }
        finally {
            if (!acquiredWriteLock) {
                this.closeTransaction();
            }
        }
        boolean transactionBegan = false;
        try {
            this.copyTextBuffer = TextBufferFactory.createGapTextBuffer();
            if (this.hasGuardedTextBuffer) {
                this.copyTextBuffer = new GuardedTextBuffer(this.copyTextBuffer, true);
            }
            char[] chars = this.realTextBuffer.getChars(0, this.realTextBuffer.getLength());
            this.copyTextBuffer.insert(0, chars);
            this.copyTextBuffer.addTextBufferListener(this);
            if (this.hasGuardedTextBuffer) {
                GuardedTextBuffer guardedCopy = (GuardedTextBuffer)this.copyTextBuffer;
                List<OffsetRegion> guardedRegions = ((GuardedTextBuffer)this.realTextBuffer).getRegions();
                for (OffsetRegion region : guardedRegions) {
                    guardedCopy.guard(region.getStartOffset(), region.getEndOffset() - region.getStartOffset() + 1);
                }
                guardedCopy.setGuardActive(true);
            }
            this.transTextBuffer = this.copyTextBuffer;
            SymSavepoint savepoint = new SymSavepoint(this);
            savepoint.lastIncludedEdit = this.transEditBack;
            this.treeChildren = new Sym[]{savepoint};
            transactionBegan = true;
        }
        finally {
            if (!transactionBegan) {
                this.close(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void close(boolean commit) {
        try {
            try {
                this.transactionThread = null;
                this.symFile.releaseTransaction();
            }
            finally {
                this.realTextBuffer.writeUnlock();
            }
            if (this.copyTextBuffer != null) {
                this.copyTextBuffer.removeTextBufferListener(this);
                this.copyTextBuffer = null;
            }
            this.transTextBuffer = null;
            int count = this.listeners.length;
            for (int i = count - 1; i >= 0; --i) {
                this.listeners[i].closeUpdate(this, commit);
            }
            this.listeners = SourceTransactionListener.EMPTY_ARRAY;
        }
        finally {
            this.closeTransaction();
            this.notifyAll();
        }
    }

    private void closeTransaction() {
        this.symFile.closeTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UndoableEdit editInAutoTransaction(FileSym file, Function<SourceTransaction, Boolean> editingCode) {
        UndoableEdit result = null;
        SymTransaction txn = (SymTransaction)file.beginTransaction();
        txn.runningInAutoTransaction = true;
        try {
            Boolean success = editingCode.apply(txn);
            if (success.booleanValue()) {
                result = txn.commit(true);
                txn = null;
            }
        }
        finally {
            if (txn != null) {
                txn.abort(true);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Exception> UndoableEdit editInAutoTransactionEx(FileSym file, SourceFile.FunctionEx<SourceTransaction, Boolean, E> editingCode) throws E {
        UndoableEdit result = null;
        SymTransaction txn = (SymTransaction)file.beginTransaction();
        txn.runningInAutoTransaction = true;
        try {
            Boolean success = editingCode.apply(txn);
            if (success.booleanValue()) {
                result = txn.commit(true);
                txn = null;
            }
        }
        finally {
            if (txn != null) {
                txn.abort(true);
            }
        }
        return result;
    }

    protected synchronized SymOperation newOperation(byte op) {
        SymOperation operation = new SymOperation(this, op);
        this.transData.addKid(operation);
        return operation;
    }

    protected synchronized void notifyOperation(SymOperation op) {
        int count = this.listeners.length;
        for (int i = count - 1; i >= 0; --i) {
            this.listeners[i].changeUpdate(this, null);
        }
    }

    @Override
    public void buildSelf() {
        this.symData = this.transData;
        super.buildSelf();
        this.transData.kidCount = 0;
    }

    private int findListener(SourceTransactionListener listener) {
        int count = this.listeners.length;
        for (int i = 0; i < count; ++i) {
            if (this.listeners[i] != listener) continue;
            return i;
        }
        return -1;
    }

    @Override
    public synchronized void addListener(SourceTransactionListener listener) {
        if (this.transactionThread == null) {
            throw new IllegalStateException("Transaction has been closed");
        }
        int index = this.findListener(listener);
        if (index != -1) {
            return;
        }
        int count = this.listeners.length;
        SourceTransactionListener[] newArray = new SourceTransactionListener[count + 1];
        if (count > 0) {
            System.arraycopy(this.listeners, 0, newArray, 0, count);
        }
        newArray[count] = listener;
        this.listeners = newArray;
    }

    @Override
    public synchronized void removeListener(SourceTransactionListener listener) {
        int index = this.findListener(listener);
        if (index == -1) {
            return;
        }
        int count = this.listeners.length;
        if (count == 1) {
            this.listeners = SourceTransactionListener.EMPTY_ARRAY;
        } else {
            SourceTransactionListener[] newArray = new SourceTransactionListener[count - 1];
            if (index != 0) {
                System.arraycopy(this.listeners, 0, newArray, 0, index);
            }
            if (index != count - 1) {
                System.arraycopy(this.listeners, index + 1, newArray, index, count - 1 - index);
            }
            this.listeners = newArray;
        }
    }

    @Override
    public void insertUpdate(TextBuffer buffer, int offset, int count, char[] data) {
        TextEdit edit;
        this.transEditBack.next = edit = new TextEdit(offset, data);
        this.transEditBack = edit;
    }

    @Override
    public void removeUpdate(TextBuffer buffer, int offset, int count, char[] data) {
        TextEdit edit;
        this.transEditBack.next = edit = new TextEdit(offset, count);
        this.transEditBack = edit;
    }

    @Override
    public void attributeUpdate(TextBuffer buffer, int attribute) {
    }

    private static void performTextEdits(TextBuffer textBuffer, TextEdit front) {
        TextEdit te = front;
        while (te != null) {
            if (te.insertedData != null) {
                textBuffer.insert(te.offset, te.insertedData);
            } else if (te.count > 0) {
                textBuffer.remove(te.offset, te.count);
            }
            te = te.next;
        }
    }

    protected static class TextEdit {
        private final int offset;
        private final int count;
        private final char[] insertedData;
        private TextEdit next = null;

        private TextEdit(int offset, char[] insertedData) {
            this.offset = offset;
            this.count = 0;
            this.insertedData = insertedData;
        }

        private TextEdit(int offset, int count) {
            this.offset = offset;
            this.count = count;
            this.insertedData = null;
        }
    }
}

