/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.mt.annotation.CodeSharingSafe;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.parser.java.v2.internal.compiler.CallerContextCookie;
import oracle.javatools.parser.java.v2.internal.compiler.CallerContextImpl;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.Emitter;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.parser.SyntaxData;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.MemberSym;
import oracle.javatools.parser.java.v2.internal.symbol.ObjectSym;
import oracle.javatools.parser.java.v2.internal.symbol.SymBinding;
import oracle.javatools.parser.java.v2.internal.symbol.SymFactory;
import oracle.javatools.parser.java.v2.internal.symbol.SymOperation;
import oracle.javatools.parser.java.v2.internal.symbol.SymText;
import oracle.javatools.parser.java.v2.internal.symbol.SymTransaction;
import oracle.javatools.parser.java.v2.internal.symbol.SymUtilities;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.NodeBinding;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceError;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceLexicalComment;
import oracle.javatools.parser.java.v2.model.SourceToken;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.javatools.parser.java.v2.scanner.TokenArray;
import oracle.javatools.parser.java.v2.util.SimplifyTypeHelper;
import oracle.javatools.parser.java.v2.util.SourceVisitor;
import oracle.javatools.parser.java.v2.write.SourceSavepoint;
import oracle.javatools.parser.util.ArrayListHeap;
import oracle.javatools.util.Tuple;

public abstract class Sym
extends SymUtilities
implements SourceElement,
JavaElement,
Comparable<Sym> {
    @CodeSharingSafe(value="StaticField")
    public static final Sym[] EMPTY_ARRAY = new Sym[0];
    public FileSym symFile;
    public Sym symParent;
    public int symSiblingIndex = -1;
    public char symAccess = '\u0000';
    public byte symKind = 0;
    public byte symFlags;
    public int symStart = -1;
    public int symEnd = -1;
    public transient SyntaxData symData;
    int bindingIdentifier;
    private static Object symBindingLock = new Object();
    private NodeBinding[] symBindings = NodeBinding.EMPTY_ARRAY;
    public transient char symFormat;

    @Override
    public int getStartOffset() {
        int startIndex = this.getStartIndex();
        if (startIndex == -1) {
            return -1;
        }
        Callable<Integer> callable = () -> {
            int startIndex1 = this.getStartIndex();
            if (startIndex1 == -1) {
                return -1;
            }
            TokenArray tokenArray = this.symFile.getTokenArray();
            this.checkIndex(startIndex1, tokenArray);
            return tokenArray.tokenStarts[startIndex1];
        };
        try {
            return this.checkTransactionAndCall(callable);
        }
        catch (Exception ex) {
            Assert.printStackTrace(ex);
            return -1;
        }
    }

    @Override
    public int getEndOffset() {
        int endIndex = this.getEndIndex();
        if (endIndex == -1) {
            return this.getStartIndex() != -1 ? this.getStartOffset() : -1;
        }
        Callable<Integer> callable = () -> {
            int endIndex1 = this.getEndIndex();
            if (endIndex1 == -1) {
                return this.getStartIndex() != -1 ? this.getStartOffset() : -1;
            }
            TokenArray tokenArray = this.symFile.getTokenArray();
            this.checkIndex(endIndex1, tokenArray);
            return tokenArray.tokenEnds[endIndex1];
        };
        try {
            return this.checkTransactionAndCall(callable);
        }
        catch (Exception ex) {
            Assert.printStackTrace(ex);
            return -1;
        }
    }

    protected void checkIndex(int index, TokenArray tokenArray) {
        int tokenCount = tokenArray.tokenCount;
        if (tokenCount <= index) {
            StringBuilder builder = new StringBuilder();
            builder.append("bad token index ");
            builder.append(SymFactory.describe(this.symKind));
            builder.append(" (");
            builder.append(this.symKind);
            builder.append(") [");
            builder.append(this.symStart);
            builder.append('-');
            builder.append(this.symEnd);
            builder.append(']');
            builder.append(", last token ");
            builder.append(tokenCount - 1);
            builder.append(" [");
            builder.append(tokenArray.tokenStarts[tokenCount - 1]);
            builder.append('-');
            builder.append(tokenArray.tokenEnds[tokenCount - 1]);
            builder.append(')');
            for (Sym parent = this.getParentSym(); parent != null; parent = parent.getParentSym()) {
                if (parent.getStartIndex() >= tokenCount || parent.getEndIndex() >= tokenCount) continue;
                builder.append("; sane parent ");
                builder.append(parent.toString());
                break;
            }
            Assert.printStackTrace(builder.toString());
        }
    }

    public final int getStartIndex() {
        return this.symStart;
    }

    public final int getEndIndex() {
        return this.symEnd;
    }

    @Override
    public String getText() {
        Object binding = this.getInternalBinding(1);
        if (binding != null) {
            return binding.toString();
        }
        TextBuffer textBuffer = this.symFile.getTextBuffer();
        if (textBuffer == null) {
            return "";
        }
        Callable<String> callable = () -> this.getText(textBuffer);
        try {
            return this.checkTransactionAndCall(callable);
        }
        catch (Exception ex) {
            Assert.printStackTrace(ex);
            return "";
        }
    }

    private String getText(TextBuffer textBuffer) {
        int endOffset;
        int startOffset = this.getStartOffset();
        if (startOffset >= 0 && (endOffset = this.getEndOffset()) > startOffset) {
            return textBuffer.getString(startOffset, endOffset - startOffset);
        }
        return "";
    }

    protected void setText(String text) {
        Sym.unsupported("Base Sym implementation may not set text");
    }

    protected final void setTextImpl(String text) {
        SymTransaction transaction = this.verifyTransaction();
        SymOperation op = transaction.newOperation((byte)5);
        op.opTarget = this;
        op.opText = text;
        op.buildSelf();
    }

    @Override
    public final int getSymbolKind() {
        return this.symKind;
    }

    @Override
    public int getElementKind() {
        return 0;
    }

    public void simplifyType() {
        SimplifyTypeHelper.simplifyType(this);
    }

    @Override
    public final void addSelf(SourceElement parent) {
        Sym sym = (Sym)parent;
        sym.add(this);
    }

    @Override
    public final void replaceSelf(SourceElement newElement) {
        Sym newSym = (Sym)newElement;
        if (this.symParent == null) {
            Sym.errorNoParent();
        }
        this.symParent.replace(this, newSym);
    }

    @Override
    public final void addSelf(SourceElement siblingElement, boolean before) {
        ListIterator<SourceElement> siblings = siblingElement.getSiblings(458752);
        if (!before) {
            siblings.next();
        }
        siblings.add(this);
    }

    @Override
    public final void addSelfBefore(SourceElement sibling) {
        this.addSelf(sibling, true);
    }

    @Override
    public final void addSelfAfter(SourceElement sibling) {
        this.addSelf(sibling, false);
    }

    @Override
    public void removeSelf() {
        if (this.symParent != null) {
            this.symParent.remove(this);
        }
    }

    protected void add(Sym child) {
        Sym.unsupported("Sym may not be parent");
    }

    protected void replace(Sym oldSym, Sym newSym) {
        Sym.unsupported("Sym may not be parent");
    }

    protected void remove(Sym child) {
        Sym.unsupported("Sym may not be parent");
    }

    protected void remove(Sym child, byte filter) {
        Sym.unsupported("Sym may not be parent");
    }

    protected int indexOf(Sym sym) {
        return -1;
    }

    protected int lastIndexOf(Sym sym) {
        return -1;
    }

    public final boolean hasBinding(int bindingType) {
        return this.getInternalBinding(bindingType) != null;
    }

    @Override
    public final NodeBinding getBinding(int bindingType) {
        if (bindingType < 26) {
            throw new IllegalArgumentException("Invalid NodeBinding type");
        }
        return this.getInternalBinding(bindingType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <T extends NodeBinding> T getInternalBinding(int bindingType) {
        if (bindingType >= 4 && bindingType < 21) {
            return (T)this.symFile.getCompilerBinding(this, bindingType);
        }
        if (bindingType >= 21 && bindingType < 25) {
            return (T)this.symFile.getCacheBinding(this, bindingType);
        }
        Object object = symBindingLock;
        synchronized (object) {
            for (NodeBinding data : this.symBindings) {
                if (data.getBindingType() != bindingType) continue;
                return (T)data;
            }
        }
        return null;
    }

    @Override
    public final void setBinding(NodeBinding data) {
        if (data == null || data.getBindingType() < 26) {
            throw new IllegalArgumentException("Invalid NodeBinding type");
        }
        this.setInternalBinding(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInternalBinding(NodeBinding data) {
        int target = data.getBindingType();
        if (target >= 4 && target < 21) {
            this.symFile.setCompilerBinding(this, data);
        } else if (target >= 21 && target < 25) {
            this.symFile.setCacheBinding(this, data);
        } else {
            Object object = symBindingLock;
            synchronized (object) {
                int bindingCount = this.symBindings.length;
                for (int i = 0; i < bindingCount; ++i) {
                    if (this.symBindings[i].getBindingType() != target) continue;
                    this.symBindings[i] = data;
                    return;
                }
                NodeBinding[] newArray = new NodeBinding[bindingCount + 1];
                if (bindingCount > 0) {
                    System.arraycopy(this.symBindings, 0, newArray, 0, bindingCount);
                }
                newArray[bindingCount] = data;
                this.symBindings = newArray;
            }
        }
    }

    @Override
    public final void clearBinding(int bindingType) {
        if (bindingType < 26) {
            throw new IllegalArgumentException("Invalid NodeBinding type");
        }
        this.clearInternalBinding(bindingType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void clearInternalBinding(int bindingType) {
        if (bindingType >= 4 && bindingType < 21) {
            this.symFile.clearCompilerBinding(this, bindingType);
        } else if (bindingType >= 21 && bindingType < 25) {
            this.symFile.clearCacheBinding(this, bindingType);
        } else {
            Object object = symBindingLock;
            synchronized (object) {
                int bindingCount = this.symBindings.length;
                for (int i = 0; i < bindingCount; ++i) {
                    if (this.symBindings[i].getBindingType() != bindingType) continue;
                    if (bindingCount == 1) {
                        this.symBindings = NodeBinding.EMPTY_ARRAY;
                        break;
                    }
                    NodeBinding[] newArray = new NodeBinding[bindingCount - 1];
                    if (i != 0) {
                        System.arraycopy(this.symBindings, 0, newArray, 0, i);
                    }
                    if (i != bindingCount - 1) {
                        System.arraycopy(this.symBindings, i + 1, newArray, i, bindingCount - 1 - i);
                    }
                    this.symBindings = newArray;
                    break;
                }
            }
        }
    }

    @Override
    public CallerContext getContext() {
        return this.getContextImpl();
    }

    @Override
    public void setContext(CallerContext context) {
        this.setContextImpl((CallerContextImpl)context);
    }

    @Override
    public CallerContext createContext(boolean forgiving) {
        SourceFile file = this.getOwningSourceFile();
        JavaProvider provider = file.getProvider();
        if (provider == null) {
            throw new IllegalStateException("No provider");
        }
        return new CallerContextImpl(provider, this, forgiving, this.getJdkVersion());
    }

    public CallerContextImpl getContextImpl() {
        CallerContextCookie binding = (CallerContextCookie)this.getInternalBinding(4);
        if (binding != null) {
            return binding.context;
        }
        return null;
    }

    public void setContextImpl(CallerContextImpl context) {
        CallerContextImpl found = this.getContextImpl();
        if (found == null && this.symParent != null) {
            Sym.panic("Cannot have both parent and context");
        }
        if (context == null) {
            this.clearInternalBinding(4);
            this.symParent = null;
        } else {
            CallerContextCookie cookie = new CallerContextCookie(context);
            this.setInternalBinding(cookie);
            this.symParent = context.scopeCookie;
        }
    }

    private final void setMapping(Sym other) {
        SymBinding binding = new SymBinding(other);
        this.setInternalBinding(binding);
    }

    public final Sym getMapping() {
        SymBinding binding = (SymBinding)this.getInternalBinding(2);
        if (binding != null) {
            return binding.getSym();
        }
        return null;
    }

    @Override
    public int getModifiers() {
        return this.symAccess;
    }

    public final void addModifiers(int modifiers) {
        int targetAccess = this.symAccess | modifiers;
        int publicProtectedPrivate = 7;
        int accessModifiers = modifiers & 7;
        if (accessModifiers != 0) {
            switch (accessModifiers) {
                case 1: 
                case 2: 
                case 4: {
                    int exclusive = 7 & ~accessModifiers;
                    targetAccess &= ~exclusive;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        this.setModifiers(targetAccess);
    }

    public final void removeModifiers(int modifiers) {
        this.setModifiers(this.symAccess & ~modifiers);
    }

    public final void setModifiers(int modifiers) {
        this.setModifiersImpl((char)modifiers);
    }

    protected void setModifiersImpl(char access) {
        this.setAccess(access);
    }

    public List<SourceAnnotation> getSourceAnnotations() {
        return Collections.emptyList();
    }

    public final boolean isPublic() {
        return (this.getModifiers() & 1) != 0;
    }

    public final boolean isProtected() {
        return (this.getModifiers() & 4) != 0;
    }

    public final boolean isPrivate() {
        return (this.getModifiers() & 2) != 0;
    }

    public final boolean isPackagePrivate() {
        return (this.getModifiers() & 7) == 0;
    }

    public final boolean isStatic() {
        return (this.getModifiers() & 8) != 0;
    }

    @Override
    public final boolean isFinal() {
        return (this.getModifiers() & 0x10) != 0;
    }

    public final boolean isAbstract() {
        return (this.getModifiers() & 0x400) != 0;
    }

    @Override
    public final boolean isMandated() {
        return (this.getModifiers() & 0x8000) != 0;
    }

    @Override
    public final boolean isSynthetic() {
        return (this.symAccess & 0x1000) != 0;
    }

    public final boolean isVarargs() {
        return (this.symAccess & 0x80) != 0;
    }

    public final boolean isTransient() {
        return (this.symAccess & 0x80) != 0;
    }

    public boolean isNative() {
        return (this.symAccess & 0x100) != 0;
    }

    @Override
    public final JavaFile getFile() {
        return this.getOwningSourceFile();
    }

    @Override
    @Deprecated
    public final SourceFile getOwningFile() {
        return this.getOwningSourceFile();
    }

    @Override
    public final SourceFile getOwningSourceFile() {
        if (this.symFile.isLightSourceFile) {
            SourceClass sourceClass;
            JavaProvider provider = this.symFile.getProvider();
            if (provider == null) {
                return null;
            }
            JavaClass primaryClass = this.symFile.getPrimaryClass();
            if (primaryClass != null && (sourceClass = provider.getSourceClass(primaryClass.getRawName())) != null) {
                return sourceClass.getOwningSourceFile();
            }
            return null;
        }
        return this.symFile;
    }

    @Override
    public final SourceElement getParent() {
        return this.getParentSym();
    }

    public final Sym getParentSym() {
        Sym parent = this.symParent;
        while (parent != null) {
            if ((parent.symFlags & 2) == 0) {
                return parent;
            }
            parent = parent.symParent;
        }
        return null;
    }

    public int getChildCount(int mask) {
        return 0;
    }

    @Override
    public List<SourceElement> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public List<SourceElement> getChildren(int mask) {
        return Collections.emptyList();
    }

    public <T extends SourceElement> Collection<T> getSyms(byte filter) {
        return Collections.emptyList();
    }

    public final <T extends SourceElement> Collection<T> getChildrenRecursive(byte filter) {
        ArrayList list = new ArrayList();
        this.getChildrenRecursive(filter, list);
        return list;
    }

    protected <T extends SourceElement> void getChildrenRecursive(byte filter, ArrayList<T> list) {
    }

    @Override
    public ListIterator<SourceElement> getSiblings() {
        Sym parent = this.getParentSym();
        if (parent == null) {
            return Collections.emptyListIterator();
        }
        if (parent == this.symFile) {
            parent = this.symFile.getRoot();
        }
        TreeSym treeSym = (TreeSym)parent;
        return treeSym.getSiblingsFor(this);
    }

    @Override
    public ListIterator<SourceElement> getSiblings(int mask) {
        Sym parent = this.getParentSym();
        if (parent == null) {
            return Collections.emptyListIterator();
        }
        TreeSym treeSym = (TreeSym)parent;
        return treeSym.getSiblingsFor(this, mask);
    }

    @Override
    public final SourceElement getSiblingBefore() {
        return this.getSiblingSymBefore(65536);
    }

    @Override
    public final SourceElement getSiblingBefore(int mask) {
        return this.getSiblingSymBefore(mask);
    }

    @Override
    public final SourceElement getSiblingAfter() {
        return this.getSiblingSymAfter(65536);
    }

    @Override
    public final SourceElement getSiblingAfter(int mask) {
        return this.getSiblingSymAfter(mask);
    }

    public final Sym getSiblingSymBefore(int mask) {
        if (this.symSiblingIndex <= 0) {
            return null;
        }
        Sym parent = this.getParentSym();
        if (parent == null) {
            return null;
        }
        if (parent == this.symFile) {
            parent = this.symFile.getRoot();
        }
        TreeSym treeSym = (TreeSym)parent;
        return treeSym.getSiblingBeforeFor(this, mask);
    }

    public final Sym getSiblingSymAfter(int mask) {
        if (this.symSiblingIndex < 0) {
            return null;
        }
        Sym parent = this.getParentSym();
        if (parent == null) {
            return null;
        }
        if (parent == this.symFile) {
            parent = this.symFile.getRoot();
        }
        TreeSym treeSym = (TreeSym)parent;
        return treeSym.getSiblingAfterFor(this, mask);
    }

    @Override
    public final boolean isSourceElement() {
        return !this.symFile.isLightSourceFile;
    }

    @Override
    public SourceElement getSourceElement() {
        if (this.symFile.isLightSourceFile) {
            return null;
        }
        return this;
    }

    @Override
    public JavaElement getOwner() {
        Sym sym = this.symParent;
        while (sym != null) {
            if (sym instanceof ObjectSym) {
                return sym;
            }
            sym = sym.symParent;
        }
        return null;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    public boolean hasDeprecatedTag() {
        return false;
    }

    public boolean hasHiddenTag() {
        return false;
    }

    @Override
    public JavaElement getCompiledObject() {
        return null;
    }

    public boolean isProcessed() {
        return false;
    }

    @Override
    public final JavaElement resolve() {
        if (this.isProcessed()) {
            return null;
        }
        CallerContextImpl callerContext = this.getContextImpl();
        CompilerDriver compiler = callerContext != null ? callerContext.compiler : this.symFile.getCompiler();
        if (compiler == null) {
            return null;
        }
        try {
            if (this.symFile.hasBeenCanceled(compiler)) {
                throw new CancellationException();
            }
            return this.resolve(compiler);
        }
        catch (CancellationException ce) {
            Thread.interrupted();
            if (this.symFile.inCompilation()) {
                compiler.error(null, (short)42);
                Throwable initCause = compiler.getCancelTrace();
                if (initCause != null) {
                    if (ce.getCause() == null) {
                        ce.initCause(initCause);
                    } else {
                        ce = (CancellationException)new CancellationException(ce.getMessage()).initCause(initCause);
                    }
                }
                throw ce;
            }
            return null;
        }
    }

    @Override
    public final void compile() {
        CompilerDriver compiler = this.symKind == 11 ? this.symFile.createCompiler() : this.symFile.getCompiler();
        if (compiler == null) {
            return;
        }
        this.compile(compiler);
    }

    public void clearOffsets() {
        this.symStart = -1;
        this.symEnd = -1;
    }

    protected void clearFormatInfo() {
        this.symFormat = '\u0000';
        this.clearInternalBinding(2);
        this.clearInternalBinding(1);
    }

    @Override
    public String printCompiledInfo() {
        return "";
    }

    @Override
    public JdkVersion getJdkVersion() {
        if (this.symFile != null) {
            return this.symFile.getJdkVersion();
        }
        return JavaParser.getJdkVersion();
    }

    @Override
    public final List<SourceToken> getTokens() {
        return this.getTokensImpl(null);
    }

    @Override
    public final List<SourceToken> getTokens(short desiredTokenValue) {
        return this.getTokensImpl(desiredTokenValue);
    }

    private final List<SourceToken> getTokensImpl(final Short desiredTokenValue) {
        if (this.symFile != null) {
            Callable<List<SourceToken>> callable = new Callable<List<SourceToken>>(){

                @Override
                public List<SourceToken> call() {
                    return Sym.this.getTokensImplImpl(desiredTokenValue);
                }
            };
            try {
                return this.checkTransactionAndCall(callable);
            }
            catch (Exception ex) {
                Assert.printStackTrace(ex);
            }
        }
        return Collections.emptyList();
    }

    private List<SourceToken> getTokensImplImpl(Short desiredTokenValue) {
        int startIndex = this.getStartIndex();
        int endIndex = this.getEndIndex();
        if (startIndex >= 0 && endIndex >= startIndex) {
            return this.symFile.getTokens(startIndex, endIndex, desiredTokenValue);
        }
        return Collections.emptyList();
    }

    @Override
    public final SourceToken getFirstToken(final short desiredTokenValue) {
        if (this.symFile != null) {
            Callable<SourceToken> callable = new Callable<SourceToken>(){

                @Override
                public SourceToken call() {
                    return Sym.this.getFirstTokenImpl(desiredTokenValue);
                }
            };
            try {
                return this.checkTransactionAndCall(callable);
            }
            catch (Exception ex) {
                Assert.printStackTrace(ex);
            }
        }
        return null;
    }

    private SourceToken getFirstTokenImpl(short desiredTokenValue) {
        int startIndex = this.getStartIndex();
        int endIndex = this.getEndIndex();
        if (startIndex >= 0 && endIndex >= startIndex) {
            return this.symFile.getFirstToken(startIndex, endIndex, desiredTokenValue);
        }
        return null;
    }

    @Override
    public final SourceToken getLastToken(final short desiredTokenValue) {
        if (this.symFile != null) {
            Callable<SourceToken> callable = new Callable<SourceToken>(){

                @Override
                public SourceToken call() {
                    return Sym.this.getLastTokenImpl(desiredTokenValue);
                }
            };
            try {
                return this.checkTransactionAndCall(callable);
            }
            catch (Exception ex) {
                Assert.printStackTrace(ex);
            }
        }
        return null;
    }

    private SourceToken getLastTokenImpl(short desiredTokenValue) {
        int startIndex = this.getStartIndex();
        int endIndex = this.getEndIndex();
        if (startIndex >= 0 && endIndex >= startIndex) {
            return this.symFile.getLastToken(startIndex, endIndex, desiredTokenValue);
        }
        return null;
    }

    public final String toString() {
        return this.verbose();
    }

    @Override
    public int compareTo(Sym other) {
        if (this == other) {
            return 0;
        }
        int start1 = this.symStart;
        int start2 = other.symStart;
        if (start1 != start2) {
            return start1 - start2;
        }
        int end1 = this.symEnd;
        int end2 = other.symEnd;
        if (end1 != end2) {
            return end2 - end1;
        }
        int depth1 = this.getDepth();
        int depth2 = other.getDepth();
        return depth1 - depth2;
    }

    public void buildSelf() {
        this.symData = null;
    }

    public void sortSelf() {
    }

    public void addToSubtree(Sym sym) {
    }

    protected void distributeChildren(Sym[] kids, int start, int end) {
    }

    protected int indexSelf(Sym[] index, int pos, TokenArray tokenArray) {
        if (!this.isSynthetic() && (this.symFlags & 2) == 0) {
            while (pos <= this.symEnd) {
                index[pos++] = this;
            }
        }
        return pos;
    }

    protected void removeSelf(TextBuffer textBuffer) {
        int startOffset = this.getStartOffset();
        int endOffset = this.getEndOffset();
        textBuffer.remove(startOffset, endOffset - startOffset);
    }

    @Override
    public final void visitSelf(SourceVisitor visitor) {
        visitor.visit(this);
    }

    protected final void adjustSelf(Sym other) {
        this.mapSelf(other);
        this.traverseSelf(SymAdjustTraversal.singleton);
    }

    protected void adjustSelfImpl(Sym other) {
        this.symStart = other.symStart;
        this.symEnd = other.symEnd;
    }

    protected final void mapSelf(Sym other) {
        this.traverseDual(other, SymMappingDualTraversal.singleton);
    }

    protected final void mapSelfImpl(Sym other) {
        this.setMapping(other);
        other.setMapping(this);
    }

    public boolean traverseSelf(SymTraversal traverse) {
        try {
            traverse.enter(this);
            return traverse.leave(this);
        }
        catch (TraversalCancelledException e) {
            return false;
        }
    }

    protected boolean traverseDual(Sym other, SymDualTraversal traverse) {
        try {
            traverse.enter(this, other);
            return traverse.leave(this, other);
        }
        catch (TraversalCancelledException e) {
            return false;
        }
    }

    public final boolean testSymFlag(byte mask) {
        return (this.symFlags & mask) != 0;
    }

    public final boolean isScope() {
        return this.testSymFlag((byte)1);
    }

    public final boolean isInvisible() {
        return this.testSymFlag((byte)2);
    }

    public final boolean isSkeleton() {
        return this.testSymFlag((byte)4);
    }

    public final boolean is(byte filter) {
        if (1 <= filter && filter < 104) {
            return this.symKind == filter;
        }
        return this.isFilter(filter);
    }

    public final boolean isFilter(byte filter) {
        switch (filter) {
            case 104: {
                return Sym.symKindIsMemberDeclaration(this.symKind);
            }
            case 105: {
                return Sym.symKindIsMemberDeclaration(this.symKind) && this.symKind != 5;
            }
            case 106: {
                return Sym.symKindIsBlockElement(this.symKind);
            }
            case 107: {
                return Sym.symKindIsStatement(this.symKind);
            }
            case 108: {
                return Sym.symKindIsExpression(this.symKind);
            }
            case 109: {
                return this.isScope();
            }
            case 110: {
                return this.isSkeleton();
            }
            case 111: {
                return this.symKind == 88 || this.symKind == 91;
            }
            case 112: {
                return 88 <= this.symKind && this.symKind < 95;
            }
            case 113: {
                return 95 <= this.symKind && this.symKind < 98;
            }
            case 114: {
                return this.symKind == 77 && this.isSkeleton();
            }
            case 115: {
                return this.symKind == 13 || this.symKind == 28 || this.symKind == 31;
            }
            case 117: {
                return this.symKind == 10 || this.symKind == 7;
            }
            case 118: {
                return this.symKind == 10;
            }
            case 119: {
                return this.symKind == 17;
            }
            case 120: {
                return this.symKind == 87;
            }
            case 116: {
                return this.symKind == 18 || this.symKind == 77;
            }
            case 0: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasErrors() {
        return this.hasErrors(this.symFile.getParseErrors()) || this.hasErrors(this.symFile.getCompileErrors());
    }

    private boolean hasErrors(List errors) {
        for (SourceError error : errors) {
            if (error.getErrorSeverity() < 4 || error.getStartOffset() < this.getStartOffset() || error.getEndOffset() > this.getEndOffset()) continue;
            return true;
        }
        return false;
    }

    protected final String verbose() {
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append(SymFactory.describe(this.symKind));
        stringBuffer.append(" (");
        stringBuffer.append(this.symKind);
        stringBuffer.append(") [");
        stringBuffer.append(this.getStartOffset());
        stringBuffer.append('-');
        stringBuffer.append(this.getEndOffset() - 1);
        stringBuffer.append(']');
        stringBuffer.append(" [");
        stringBuffer.append(this.symStart);
        stringBuffer.append('-');
        stringBuffer.append(this.symEnd);
        stringBuffer.append(']');
        this.verboseSelf(stringBuffer);
        return stringBuffer.toString();
    }

    protected void verboseSelf(StringBuilder stringBuffer) {
    }

    public void describeSelf(int depth) {
        for (int i = 0; i < depth; ++i) {
            System.err.print("..");
        }
        System.err.print("+-");
        System.err.println(this.verbose());
    }

    public final int getDepth() {
        int count = 0;
        Sym sym = this.symParent;
        while (sym != null) {
            ++count;
            sym = sym.symParent;
        }
        return count;
    }

    public Sym getScope() {
        Sym sym = this.symParent;
        if (sym == null) {
            return null;
        }
        if (sym.isFilter((byte)109)) {
            return sym;
        }
        return sym.getScope();
    }

    public final ClassSym getOwningClassSym() {
        Sym sym = this.symParent;
        while (sym != null) {
            if (sym.symKind == 3) {
                return (ClassSym)sym;
            }
            sym = sym.symParent;
        }
        return null;
    }

    public final MemberSym getOwningMemberSym() {
        Sym sym = this.symParent;
        while (sym != null) {
            if (sym.isFilter((byte)104)) {
                return (MemberSym)sym;
            }
            sym = sym.symParent;
        }
        return null;
    }

    protected final boolean isAttached() {
        Sym sym = this;
        while (sym.symParent != null) {
            sym = sym.symParent;
        }
        return sym == this.symFile;
    }

    public Sym getChildAt(int offset) {
        return null;
    }

    protected final boolean hasSyntaxData() {
        return this.symData != null;
    }

    public final JavaElement resolve(CompilerDriver compiler) {
        return this.resolveImpl(compiler);
    }

    public final JavaElement compile(CompilerDriver compiler) {
        return this.compileImpl(compiler);
    }

    protected JavaElement resolveImpl(CompilerDriver compiler) {
        return this.getCompiledObject();
    }

    protected JavaElement compileImpl(CompilerDriver compiler) {
        return this.resolveImpl(compiler);
    }

    protected void checkAccessModifiers(CompilerDriver compiler) {
        int modifiers = this.getModifiers();
        char[] modifiersToCheck = new char[]{'\u0001', '\u0002', '\u0004', '\b', '\u0010', ' ', '@', '@', '\u0080', '\u0080', '\u0100', '\u0400', '\u0800', '\u1000', '\u0200'};
        int mutuallyExclusiveModifierCount = 0;
        for (int i = 0; i < modifiersToCheck.length; ++i) {
            boolean error;
            if ((modifiers & modifiersToCheck[i]) == 0) continue;
            boolean bl = error = i < 3 && mutuallyExclusiveModifierCount++ > 0;
            if (!error) {
                boolean bl2 = error = !this.isValidAccess(modifiersToCheck[i]);
            }
            if (!error) continue;
            compiler.error(this, (short)93, Character.valueOf(modifiersToCheck[i]));
        }
    }

    protected final void checkAnnotations(CompilerDriver compiler) {
        List<SourceAnnotation> annotations = this.getSourceAnnotations();
        if (!annotations.isEmpty()) {
            HashMap<String, SourceAnnotation> names = new HashMap<String, SourceAnnotation>();
            for (SourceAnnotation annotation : annotations) {
                String qualifiedName;
                SourceAnnotation alreadyDefined;
                SourceAnnotation sourceAnnotation = annotation;
                JavaType annotationType = sourceAnnotation.getResolvedType();
                if (annotationType == null || (alreadyDefined = names.put(qualifiedName = annotationType.getQualifiedName(), sourceAnnotation)) == null || this.isValidRepeatableAnnotation(annotationType)) continue;
                compiler.error((Sym)((Object)annotation), (short)52, qualifiedName, alreadyDefined);
            }
        }
    }

    private boolean isValidRepeatableAnnotation(JavaType annotationType) {
        if (this.getJdkVersion().isGreaterThanOrEqualTo8()) {
            Collection<JavaAnnotation> metaAnnotations = annotationType.getAnnotations();
            for (JavaAnnotation metaAnnotation : metaAnnotations) {
                JavaType metaType = metaAnnotation.getResolvedType();
                if (metaType == null || !"java.lang.annotation.Repeatable".equals(metaType.getQualifiedName())) continue;
                return true;
            }
        }
        return false;
    }

    protected void setAccess(char access) {
        char oldAccess = this.symAccess;
        if (access == oldAccess) {
            return;
        }
        this.setAccessImpl(access);
    }

    protected final void setAccessImpl(char access) {
        if (!this.isValidAccess(access)) {
            Sym.unsupported("Illegal modifiers 0X" + Integer.toHexString(access) + " after change, current modifiers 0X" + Integer.toHexString(this.getModifiers()));
        }
        SymTransaction transaction = this.verifyTransaction();
        SymOperation op = transaction.newOperation((byte)4);
        op.opTarget = this;
        op.symAccess = this.symAccess;
        this.symAccess = access;
        this.symFormat = (char)(this.symFormat | 8);
        op.buildSelf();
    }

    protected void linkSelfTrigger(TreeSym parent, byte filter) {
        Sym sym = parent;
        while (sym != null) {
            if (sym == this) {
                Sym.errorCycle(this);
            }
            sym = sym.symParent;
        }
    }

    protected void unlinkSelfTrigger(TreeSym parent, byte filter) {
        this.saveText(parent);
        this.symSiblingIndex = -1;
    }

    public final void saveText() {
        this.saveText((TreeSym)null);
    }

    private void saveText(final TreeSym parent) {
        if (this.isSynthetic() || this.symStart < 0) {
            return;
        }
        SourceVisitor visitor = new SourceVisitor(){

            @Override
            public void whenEnterDocComment(SourceDocComment sourceDocComment) {
                this.saveText((Sym)((Object)sourceDocComment));
            }

            @Override
            public void whenEnterLexicalComment(SourceLexicalComment sourceLexicalComment) {
                this.saveText((Sym)((Object)sourceLexicalComment));
            }

            private void saveText(Sym sym) {
                String text;
                if (sym.getInternalBinding(1) == null && !(text = sym.getText()).isEmpty()) {
                    TreeSym symParent = sym == Sym.this ? parent : (TreeSym)sym.getParentSym();
                    sym.saveText(text, symParent);
                }
            }
        };
        visitor.visit(this);
    }

    public final void saveText(ReadTextBuffer textBuffer) {
        int startOffset = this.getStartOffset();
        int endOffset = this.getEndOffset();
        if (startOffset >= 0 && startOffset <= endOffset) {
            String text = textBuffer.getString(startOffset, endOffset - startOffset);
            this.saveText(text, null);
            return;
        }
        Assert.printStackTrace("Invalid offsets");
    }

    public final SymText unsaveText() {
        this.symFormat = (char)(this.symFormat & 0xFFFFFFFB);
        SymText binding = (SymText)this.getInternalBinding(1);
        if (binding != null) {
            this.clearInternalBinding(1);
        }
        return binding;
    }

    private final void saveText(String s, TreeSym parent) {
        Sym parentSym;
        if (this.symKind == 95 && s.indexOf(10) < 0 && s.indexOf(13) < 0) {
            return;
        }
        if (parent == null && (parentSym = this.getParentSym()) instanceof TreeSym) {
            parent = (TreeSym)parentSym;
        }
        SymText symText = new SymText(s, parent);
        this.setInternalBinding(symText);
        this.symFormat = (char)(this.symFormat | 4);
    }

    private SymText getSavedText() {
        if ((this.symFormat & 4) != 0) {
            return (SymText)this.getInternalBinding(1);
        }
        return null;
    }

    protected boolean isValidChild(Sym target, byte filter) {
        return this.isValidChildSymKind(target.symKind);
    }

    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 97: {
                return true;
            }
            case 95: 
            case 96: {
                return true;
            }
        }
        return false;
    }

    protected boolean isValidAccess(char access) {
        return access == '\u0000' || access == '\u1000';
    }

    public boolean checkSourceSanity() {
        return true;
    }

    public final SymTransaction verifyTransaction() {
        SymTransaction transaction = this.symFile.getTransactionSym();
        if (transaction == null) {
            Sym.unsupported("Must be in a transaction");
        }
        return transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected final <T> T checkTransactionAndCall(Callable<T> callable) throws Exception {
        SymTransaction transaction = null;
        TreeSym treeSym = this.symFile;
        // MONITORENTER : treeSym
        if (!this.symFile.flag_noAutoSavepoint() && this.isAttached()) {
            transaction = this.symFile.getTransactionSym();
        }
        if (transaction == null) {
            // MONITOREXIT : treeSym
            return callable.call();
        }
        // MONITOREXIT : treeSym
        if (transaction.getTransactionThread() == Thread.currentThread()) {
            treeSym = transaction;
            // MONITORENTER : treeSym
            transaction.checkSavepoint();
            // MONITOREXIT : treeSym
            return callable.call();
        }
        while (true) {
            treeSym = transaction;
            // MONITORENTER : treeSym
            if (this.symFile.getTransactionSym() == transaction) {
                transaction.wait();
            }
            // MONITOREXIT : treeSym
            treeSym = this.symFile;
            // MONITORENTER : treeSym
            transaction = this.symFile.getTransactionSym();
            if (transaction == null) {
                // MONITOREXIT : treeSym
                return callable.call();
            }
            // MONITOREXIT : treeSym
        }
    }

    protected void checkCloneable() {
    }

    @Override
    public final SourceElement cloneSelf(SourceFile targetFile) {
        this.checkCloneable();
        FileSym fileSym = (FileSym)targetFile;
        Sym sym = this.cloneSelf(fileSym);
        this.clearFormatInfo();
        sym.symFile = this.symFile;
        sym.symStart = this.symStart;
        sym.symEnd = this.symEnd;
        sym.saveText();
        sym.symFile = fileSym;
        sym.symStart = -1;
        sym.symEnd = -1;
        return sym;
    }

    protected Sym cloneSelfImpl(FileSym targetFile) {
        return SymFactory.createNode(targetFile, this.symKind);
    }

    public Sym cloneSelf(FileSym targetFile) {
        Sym sym = this.cloneSelfImpl(targetFile);
        sym.symStart = -1;
        sym.symEnd = -1;
        sym.symFlags = this.symFlags;
        sym.symAccess = this.symAccess;
        sym.symFormat = (char)(sym.symFormat | 2);
        sym.setMapping(this);
        return sym;
    }

    public void qualifySelf() {
    }

    @Override
    public final boolean reformatSelf(int formatMask) {
        return this.reformatSelfComparable(formatMask) == null;
    }

    public Tuple<String, String> reformatSelfComparable(int formatMask) {
        for (SourceError error : this.symFile.getParseErrors()) {
            if (error.getErrorSeverity() < 4) continue;
            return null;
        }
        TextBuffer buffer = this.symFile.getTextBuffer();
        if (buffer == null) {
            return null;
        }
        SymTransaction transaction = this.verifyTransaction();
        SourceSavepoint savepoint = transaction.savepoint();
        String copy = buffer.getString(0, buffer.getLength());
        this.symFile.reformatSubtree(this == this.symFile ? this.symFile.getRoot() : this, formatMask);
        TextBuffer textBuffer = this.symFile.getTextBuffer();
        if (Sym.equalIgnoreWhiteSpace(copy, (ReadTextBuffer)textBuffer)) {
            return null;
        }
        Tuple<String, String> tuple = new Tuple<String, String>(copy, textBuffer.getString(0, textBuffer.getLength()));
        transaction.rollback(savepoint);
        return tuple;
    }

    private static boolean equalIgnoreWhiteSpace(String one, String two) {
        if (one == null || two == null) {
            return false;
        }
        return Sym.equalIgnoreWhiteSpace(TextBufferFactory.createReadTextBuffer(one), TextBufferFactory.createReadTextBuffer(two));
    }

    private static boolean equalIgnoreWhiteSpace(String one, ReadTextBuffer two) {
        if (one == null || two == null) {
            return false;
        }
        return Sym.equalIgnoreWhiteSpace(TextBufferFactory.createReadTextBuffer(one), two);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean equalIgnoreWhiteSpace(ReadTextBuffer one, ReadTextBuffer two) {
        if (one == null || two == null) {
            return false;
        }
        JavaLexer lexerOne = new JavaLexer(JavaParser.getJdkVersion());
        lexerOne.setSkipComments(false);
        lexerOne.setTextBuffer(one);
        JavaLexer lexerTwo = new JavaLexer(JavaParser.getJdkVersion());
        lexerTwo.setSkipComments(false);
        lexerTwo.setTextBuffer(two);
        LexerToken oneLexerToken = lexerOne.createLexerToken();
        LexerToken twoLexerToken = lexerTwo.createLexerToken();
        int oneToken = lexerOne.lex(oneLexerToken);
        int twoToken = lexerTwo.lex(twoLexerToken);
        while (true) {
            block26: {
                boolean dotDoc;
                block25: {
                    if (oneToken != twoToken) break block25;
                    if (oneToken == 0) break;
                    String oneText = one.getString(oneLexerToken.getStartOffset(), oneLexerToken.getEndOffset() - oneLexerToken.getStartOffset());
                    int twoLength = twoLexerToken.getEndOffset() - twoLexerToken.getStartOffset();
                    String twoText = two.getString(twoLexerToken.getStartOffset(), twoLength);
                    switch (oneToken) {
                        case 24: 
                        case 25: 
                        case 26: {
                            if (!Sym.commentsEqual(oneText, twoText)) {
                                return false;
                            }
                            break block26;
                        }
                        default: {
                            if (!oneText.equals(twoText)) {
                                return false;
                            }
                            break block26;
                        }
                    }
                }
                boolean oneTokenIsDoc = Sym.isCommentToken(oneToken);
                boolean twoTokenIsDoc = Sym.isCommentToken(twoToken);
                boolean docDot = oneTokenIsDoc && twoToken == 43;
                boolean bl = dotDoc = oneToken == 43 && twoTokenIsDoc;
                if (!docDot && !dotDoc) {
                    return false;
                }
                ArrayList oneList = ArrayListHeap.allocArrayList();
                ArrayList twoList = ArrayListHeap.allocArrayList();
                try {
                    boolean twoIsComment;
                    boolean oneIsComment;
                    if (docDot) {
                        twoToken = lexerTwo.lex(twoLexerToken);
                    } else {
                        oneToken = lexerOne.lex(oneLexerToken);
                    }
                    oneList.add(one.getString(oneLexerToken.getStartOffset(), oneLexerToken.getEndOffset() - oneLexerToken.getStartOffset()));
                    int twoLength = twoLexerToken.getEndOffset() - twoLexerToken.getStartOffset();
                    twoList.add(two.getString(twoLexerToken.getStartOffset(), twoLength));
                    do {
                        oneToken = lexerOne.lex(oneLexerToken);
                        twoToken = lexerTwo.lex(twoLexerToken);
                        oneIsComment = Sym.isCommentToken(oneToken);
                        if (oneIsComment) {
                            oneList.add(one.getString(oneLexerToken.getStartOffset(), oneLexerToken.getEndOffset() - oneLexerToken.getStartOffset()));
                        }
                        if (!(twoIsComment = Sym.isCommentToken(twoToken))) continue;
                        twoLength = twoLexerToken.getEndOffset() - twoLexerToken.getStartOffset();
                        twoList.add(two.getString(twoLexerToken.getStartOffset(), twoLength));
                    } while (oneIsComment && twoIsComment);
                    if (docDot && oneToken != 43) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    if (dotDoc && twoToken != 43) {
                        boolean bl3 = false;
                        return bl3;
                    }
                    if (oneList.size() != twoList.size()) {
                        oneIsComment = false;
                        return oneIsComment;
                    }
                    for (int x = 0; x < oneList.size(); ++x) {
                        if (Sym.commentsEqual(oneList.get(x).toString(), twoList.get(x).toString())) continue;
                        boolean bl4 = false;
                        return bl4;
                    }
                }
                finally {
                    ArrayListHeap.freeArrayList(oneList);
                    ArrayListHeap.freeArrayList(twoList);
                }
                if (docDot) {
                    oneToken = lexerOne.lex(oneLexerToken);
                    continue;
                }
                twoToken = lexerTwo.lex(twoLexerToken);
                continue;
            }
            oneToken = lexerOne.lex(oneLexerToken);
            twoToken = lexerTwo.lex(twoLexerToken);
        }
        return true;
    }

    private static boolean commentsEqual(String one, String two) {
        int onePtr = 0;
        int twoPtr = 0;
        int oneLength = one.length();
        int twoLength = two.length();
        while (onePtr < oneLength) {
            char c_one;
            if (Character.isWhitespace(c_one = one.charAt(onePtr++))) continue;
            boolean checked_chars = false;
            while (twoPtr < twoLength) {
                char c_two;
                if (Character.isWhitespace(c_two = two.charAt(twoPtr++))) continue;
                if (c_two != c_one) {
                    return false;
                }
                checked_chars = true;
                break;
            }
            if (checked_chars) continue;
            return false;
        }
        while (twoPtr < twoLength) {
            char c_two;
            if (Character.isWhitespace(c_two = two.charAt(twoPtr++))) continue;
            return false;
        }
        return true;
    }

    public boolean checkSafeToInsert() {
        return false;
    }

    public boolean checkSafeToDelete(TreeSym parent) {
        return false;
    }

    @Override
    public boolean adjustTextIndentation(final int delta, final int tabSize, final boolean useTabs) {
        final boolean[] result = new boolean[]{false};
        SourceVisitor visitor = new SourceVisitor(){

            @Override
            public void whenEnterDocComment(SourceDocComment sourceDocComment) {
                this.adjustText((Sym)((Object)sourceDocComment));
            }

            @Override
            public void whenEnterLexicalComment(SourceLexicalComment sourceLexicalComment) {
                this.adjustText((Sym)((Object)sourceLexicalComment));
            }

            private void adjustText(Sym sym) {
                String text;
                SymText symText = sym.getSavedText();
                if (symText != null && (text = symText.getText()) != null) {
                    int index = 0;
                    int len = text.length();
                    StringBuilder buf = new StringBuilder();
                    int state = 0;
                    int whitespace = 0;
                    while (index < len) {
                        char c;
                        boolean isEol = (c = text.charAt(index++)) == '\n' || c == '\r';
                        switch (state) {
                            case 0: {
                                if (isEol) {
                                    state = 1;
                                }
                                buf.append(c);
                                break;
                            }
                            case 1: {
                                if (isEol) {
                                    buf.append(c);
                                    whitespace = 0;
                                    break;
                                }
                                if (Character.isWhitespace(c)) {
                                    if (c == '\t') {
                                        whitespace += tabSize;
                                        break;
                                    }
                                    ++whitespace;
                                    break;
                                }
                                whitespace += delta;
                                while (whitespace > 0) {
                                    if (useTabs && whitespace >= tabSize) {
                                        buf.append('\t');
                                        whitespace -= tabSize;
                                        continue;
                                    }
                                    buf.append(' ');
                                    --whitespace;
                                }
                                buf.append(c);
                                whitespace = 0;
                                state = 0;
                            }
                        }
                    }
                    symText.setText(buf.toString());
                    result[0] = result[0] | true;
                }
            }
        };
        visitor.visit(this);
        return result[0];
    }

    public int getFormatInsertOffset() {
        TreeSym parent = (TreeSym)this.symParent;
        List<Sym> treeChildren = parent.getTreeChildren(null);
        int count = treeChildren.size();
        if (count < 2) {
            return -1;
        }
        int index = parent.indexOf(this);
        if (index == -1) {
            Sym.errorInvalidParent();
        }
        if (parent.symKind == 98) {
            int prev;
            int next;
            for (next = index + 1; next < count; ++next) {
                Sym nextChild = treeChildren.get(next);
                if (nextChild.symKind != this.symKind) break;
                if (nextChild.symStart == -1) continue;
                return nextChild.getFormatStartOffsetImpl();
            }
            for (prev = index - 1; 0 <= prev; --prev) {
                Sym prevChild = treeChildren.get(prev);
                if (prevChild.symKind != this.symKind) break;
                if (prevChild.symStart == -1) continue;
                return prevChild.getFormatEndOffsetImpl();
            }
            if (next < count) {
                return treeChildren.get(next).getFormatStartOffsetImpl();
            }
            if (0 <= prev) {
                return treeChildren.get(prev).getFormatEndOffsetImpl();
            }
            if (index == count - 1) {
                return parent.getEndOffset();
            }
            return parent.getStartOffset();
        }
        if (index + 1 == count) {
            return treeChildren.get(index - 1).getFormatEndOffsetImpl();
        }
        return treeChildren.get(index + 1).getFormatStartOffsetImpl();
    }

    public final int getFormatStartOffset() {
        boolean endsOnLineByItself;
        boolean bl = endsOnLineByItself = this.getEndOffset() != this.getFormatEndOffsetImpl();
        if (endsOnLineByItself) {
            return this.getFormatStartOffsetImpl();
        }
        return this.getStartOffset();
    }

    public final int getFormatEndOffset() {
        return this.getFormatEndOffsetImpl();
    }

    protected final int getFormatStartOffsetImpl() {
        SymText binding;
        int startOffset = this.getStartOffset();
        if (startOffset == -1) {
            return -1;
        }
        Sym parent = this.symParent;
        if (this.symParent == null && (binding = (SymText)this.getInternalBinding(1)) != null) {
            parent = binding.parent;
        }
        if (parent != null && this.getStartIndex() == parent.getStartIndex()) {
            return startOffset;
        }
        TextBuffer textBuffer = this.symFile.getTextBuffer();
        if (textBuffer == null) {
            return startOffset;
        }
        for (int pos = startOffset; pos > 0; --pos) {
            char ch = textBuffer.getChar(pos - 1);
            switch (ch) {
                case '\n': {
                    return pos;
                }
            }
            if (Character.isWhitespace(ch)) continue;
            return startOffset;
        }
        return 0;
    }

    protected final int getFormatEndOffsetImpl() {
        SymText binding;
        int endIndex = this.getEndIndex();
        if (endIndex == -1) {
            return this.getEndOffset();
        }
        Sym parent = this.symParent;
        if (this.symParent == null && (binding = (SymText)this.getInternalBinding(1)) != null) {
            parent = binding.parent;
        }
        if (parent != null && this.getEndIndex() == parent.getEndIndex()) {
            return this.getEndOffset();
        }
        TokenArray tokenArray = this.symFile.getTokenArray();
        if (tokenArray.tokenCount <= endIndex + 1) {
            return tokenArray.tokenEnds[tokenArray.tokenCount - 1];
        }
        int endOffset = this.getEndOffset();
        TextBuffer textBuffer = this.symFile.getTextBuffer();
        if (textBuffer == null) {
            return endOffset;
        }
        int nextStart = tokenArray.tokenStarts[endIndex + 1];
        int startOffset = this.getStartOffset();
        boolean onLineByItself = startOffset == 0 || startOffset != this.getFormatStartOffsetImpl() || textBuffer.getChar(startOffset - 1) == '\n';
        for (int pos = endOffset; pos < nextStart; ++pos) {
            char ch = textBuffer.getChar(pos);
            switch (ch) {
                case '\n': {
                    if (onLineByItself) {
                        return pos + 1;
                    }
                    return pos;
                }
            }
        }
        return nextStart;
    }

    public boolean isBeingFormatted() {
        SymTransaction txn = this.symFile.getTransactionSym();
        if (txn != null) {
            Sym formatSym = txn.symBeingFormatted;
            if (formatSym != null) {
                Sym sym = this;
                while (sym != null) {
                    if (sym == formatSym) {
                        return true;
                    }
                    sym = sym.symParent;
                }
                return false;
            }
            int[] formatOffsets = txn.regionBeingFormatted;
            if (formatOffsets != null && formatOffsets.length == 2) {
                return this.getStartOffset() >= formatOffsets[0] && this.getEndOffset() <= formatOffsets[1];
            }
        }
        return false;
    }

    protected static void print(Sym sym, PrintWriter out, int argument) {
        if (sym == null) {
            return;
        }
        sym.print(out, argument);
    }

    protected static void print(Sym sym, PrintWriter out) {
        if (sym == null) {
            return;
        }
        sym.print(out);
    }

    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    public final void print(FormatDriver out) {
        out.enter(this);
        try {
            this.printSelf(out);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            out.leave(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(PrintWriter out) {
        Emitter emitter = Emitter.createRegularEmitter();
        FormatDriver formatter = new FormatDriver(this.symFile, emitter);
        formatter.init(this);
        try {
            this.print(formatter);
        }
        finally {
            formatter.fini(this);
        }
        out.print(emitter);
    }

    @Override
    public void print(PrintWriter out, int argument) {
        this.print(out);
    }

    @Override
    public final String print(int printFlag) {
        return this.print((Integer)printFlag);
    }

    @Override
    public final String print() {
        return this.print((Integer)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String print(Integer printFlag) {
        try (PrintWriter writer = null;){
            StringWriter stringWriter = new StringWriter();
            writer = new PrintWriter(stringWriter);
            if (printFlag == null) {
                this.print(writer);
            } else {
                this.print(writer, printFlag);
            }
            String string = stringWriter.toString();
            return string;
        }
    }

    protected final void printModifiers(PrintWriter out) {
        if ((this.symAccess & '\u0001') != 0) {
            out.print(Sym.keywordToText((short)128) + " ");
        }
        if ((this.symAccess & 4) != 0) {
            out.print(Sym.keywordToText((short)127) + " ");
        }
        if ((this.symAccess & 2) != 0) {
            out.print(Sym.keywordToText((short)126) + " ");
        }
        if (!(this.symKind == 3 && ((SourceClass)((Object)this)).isInterface() || (this.symAccess & 0x400) == 0)) {
            out.print(Sym.keywordToText((short)96) + " ");
        }
        if (this.symKind == 19 && (this.symAccess & 0x200) != 0) {
            out.print(Sym.keywordToText((short)106));
        }
        if ((this.symAccess & 8) != 0) {
            out.print(Sym.keywordToText((short)131) + " ");
        }
        if ((this.symAccess & 0x10) != 0) {
            out.print(Sym.keywordToText((short)111) + " ");
        }
        if (this.symKind != 3 && (this.symAccess & 0x20) != 0) {
            out.print(Sym.keywordToText((short)135) + " ");
        }
        if (this.symKind == 9 || this.symKind == 10) {
            if ((this.symAccess & 0x80) != 0) {
                out.print(Sym.keywordToText((short)139) + " ");
            }
            if ((this.symAccess & 0x40) != 0) {
                out.print(Sym.keywordToText((short)142) + " ");
            }
        }
        if ((this.symAccess & 0x100) != 0) {
            out.print(Sym.keywordToText((short)123) + " ");
        }
        if ((this.symAccess & 0x800) != 0) {
            out.print(Sym.keywordToText((short)132) + " ");
        }
    }

    @Override
    public SourceElement[] getContainedElements() {
        List<SourceElement> children = this.getChildren();
        int count = children.size();
        return children.toArray(new SourceElement[count]);
    }

    private static class SymAdjustTraversal
    extends SymTraversal {
        @CodeSharingSafe(value="StaticField")
        protected static final SymAdjustTraversal singleton = new SymAdjustTraversal();

        private SymAdjustTraversal() {
        }

        @Override
        protected boolean leave(Sym sym) {
            Sym other = sym.getMapping();
            if (other != null) {
                sym.adjustSelfImpl(other);
            }
            return true;
        }
    }

    public static abstract class SymTraversal
    extends SymUtilities {
        protected boolean enter(Sym sym) {
            return true;
        }

        protected boolean leave(Sym sym) {
            return true;
        }
    }

    private static class SymMappingDualTraversal
    extends SymDualTraversal {
        @CodeSharingSafe(value="StaticField")
        protected static final SymMappingDualTraversal singleton = new SymMappingDualTraversal();

        private SymMappingDualTraversal() {
        }

        @Override
        protected boolean enter(Sym sym, Sym other) {
            sym.mapSelfImpl(other);
            return true;
        }
    }

    public static abstract class SymDualTraversal
    extends SymUtilities {
        protected boolean enter(Sym sym, Sym other) {
            return true;
        }

        protected boolean leave(Sym sym, Sym other) {
            return true;
        }
    }

    public static class TraversalCancelledException
    extends RuntimeException {
    }
}

