/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.symbol.AnnotateSym;
import oracle.javatools.parser.java.v2.internal.symbol.FieldSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.LocalVariableSym;
import oracle.javatools.parser.java.v2.internal.symbol.ObjectSymFlags;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.VardeclSym;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasAnnotations;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;

public abstract class ObjectSym
extends TreeSym {
    public char objectXaccess;
    public char objectImplicit;

    public char getObjectFlags() {
        ObjectSymFlags binding = (ObjectSymFlags)this.getInternalBinding(11);
        if (binding != null) {
            return binding.getFlags();
        }
        return '\u0000';
    }

    public void setObjectFlags(char objectFlags) {
        ObjectSymFlags binding = (ObjectSymFlags)this.getInternalBinding(11);
        if (binding == null) {
            binding = new ObjectSymFlags();
            this.setInternalBinding(binding);
        }
        binding.setFlags(objectFlags);
    }

    public JavaType getResolvedType() {
        TypeSym typeSym = this.getTypeSym();
        if (typeSym == null) {
            return null;
        }
        JavaType returnType = typeSym.getResolvedType();
        if (returnType == null) {
            return null;
        }
        return returnType;
    }

    public JavaType guessResolvedType() {
        return this.getResolvedType();
    }

    @Override
    public JavaElement getCompiledObject() {
        return this;
    }

    @Override
    public int getModifiers() {
        return this.symAccess | this.objectImplicit;
    }

    public boolean isValidModifiers(int modifiers) {
        return this.isValidAccess((char)modifiers);
    }

    public Collection<JavaAnnotation> getDeclaredAnnotations() {
        return new ArrayList<JavaAnnotation>(this.getSourceAnnotations());
    }

    public Collection<JavaAnnotation> getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    public final JavaAnnotation getDeclaredAnnotation(JavaType annotationType) {
        return CommonUtilities.getDeclaredAnnotation((JavaHasAnnotations)((Object)this), annotationType);
    }

    public JavaAnnotation getAnnotation(JavaType annotationType) {
        return this.getDeclaredAnnotation(annotationType);
    }

    @Override
    public boolean isDeprecated() {
        return (this.objectXaccess & '\u0001') != 0;
    }

    @Override
    public final boolean isHidden() {
        return (this.objectXaccess & 0x2000) != 0;
    }

    @Override
    public final boolean isProcessed() {
        return (this.getObjectFlags() & '\u0001') != 0;
    }

    public final void setProcessed() {
        char flags = this.getObjectFlags();
        flags = (char)(flags | '\u0001');
        this.setObjectFlags(flags);
    }

    @Override
    public Sym cloneSelf(FileSym targetFile) {
        ObjectSym sym = (ObjectSym)super.cloneSelf(targetFile);
        sym.objectXaccess = this.objectXaccess;
        sym.objectImplicit = this.objectImplicit;
        return sym;
    }

    @Override
    protected void adjustSelfImpl(Sym other) {
        super.adjustSelfImpl(other);
        if (other instanceof ObjectSym) {
            ObjectSym otherSym = (ObjectSym)other;
            this.objectImplicit = otherSym.objectImplicit;
        }
    }

    @Override
    public List<SourceAnnotation> getSourceAnnotations() {
        if (this.symKind == 10) {
            return ((FieldSym)this).getOwningDeclarationSym().getSourceAnnotations();
        }
        List<SourceAnnotation> annotations = super.getSourceAnnotations();
        if (this.getJdkVersion().isGreaterThanOrEqualTo8() && (this.symKind == 9 || this.symKind == 19 || this.symKind == 13)) {
            ArrayList<SourceAnnotation> excludedAnnotations = new ArrayList<SourceAnnotation>(this.getDeclaredTypeAnnotations(true));
            return new SourceAnnotationList<SourceAnnotation>(annotations, excludedAnnotations);
        }
        return annotations;
    }

    public List<SourceAnnotation> getDeclaredTypeAnnotations(boolean strict) {
        if (this.symKind == 10) {
            VardeclSym declaration = ((FieldSym)this).getOwningDeclarationSym();
            if (declaration != null) {
                return declaration.getDeclaredTypeAnnotations(strict);
            }
        } else if (this.symKind == 17) {
            VardeclSym declaration = ((LocalVariableSym)this).getOwningDeclarationSym();
            if (declaration != null) {
                return declaration.getDeclaredTypeAnnotations(strict);
            }
        } else if ((this.symKind == 9 || this.symKind == 19 || this.symKind == 13 || this.symKind == 18) && this.getJdkVersion().isGreaterThanOrEqualTo8()) {
            ArrayList<SourceAnnotation> typeAnnotations = new ArrayList<SourceAnnotation>();
            List<SourceAnnotation> sourceAnnotations = super.getSourceAnnotations();
            for (SourceAnnotation sourceAnnotation : sourceAnnotations) {
                AnnotateSym annotateSym = (AnnotateSym)sourceAnnotation;
                if (!annotateSym.testSymFlag((byte)-128) || annotateSym.dimensionIndex != 0 || annotateSym.testSymFlag((byte)64) || !CommonUtilities.isTypeUseAnnotation(sourceAnnotation, strict)) continue;
                typeAnnotations.add(sourceAnnotation);
            }
            ArrayList<SourceAnnotation> nonTypeAnnotations = new ArrayList<SourceAnnotation>(sourceAnnotations);
            nonTypeAnnotations.removeAll(typeAnnotations);
            return new SourceAnnotationList<SourceAnnotation>(sourceAnnotations, nonTypeAnnotations);
        }
        return new ArrayList<SourceAnnotation>();
    }

    private class SourceAnnotationList<SourceAnnotation>
    extends AbstractList<SourceAnnotation> {
        final List<SourceAnnotation> allAnnotations;
        final List<? extends JavaAnnotation> excludeList;

        SourceAnnotationList(List<SourceAnnotation> allAnnotations, List<? extends JavaAnnotation> excludeList) {
            this.allAnnotations = allAnnotations;
            this.excludeList = excludeList;
        }

        @Override
        public int size() {
            return this.allAnnotations.size() - this.excludeList.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public boolean contains(Object o) {
            for (SourceAnnotation sourceAnnotation : this.allAnnotations) {
                if (this.excludeList.contains(sourceAnnotation) || o != sourceAnnotation) continue;
                return true;
            }
            return false;
        }

        @Override
        public Iterator<SourceAnnotation> iterator() {
            return new Iterator<SourceAnnotation>(){
                int index = 0;
                SourceAnnotation lastNextAnnotation = null;

                @Override
                public boolean hasNext() {
                    for (int nextIndex = this.index; nextIndex < SourceAnnotationList.this.allAnnotations.size(); ++nextIndex) {
                        if (SourceAnnotationList.this.excludeList.contains(SourceAnnotationList.this.allAnnotations.get(nextIndex))) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public SourceAnnotation next() {
                    while (this.index < SourceAnnotationList.this.allAnnotations.size()) {
                        Object annotation;
                        if (SourceAnnotationList.this.excludeList.contains(annotation = SourceAnnotationList.this.allAnnotations.get(this.index++))) continue;
                        this.lastNextAnnotation = annotation;
                        return annotation;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    if (this.lastNextAnnotation != null) {
                        SourceAnnotationList.this.allAnnotations.remove(this.lastNextAnnotation);
                        this.lastNextAnnotation = null;
                        --this.index;
                    } else {
                        throw new IllegalStateException();
                    }
                }
            };
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[this.size()]);
        }

        @Override
        public <T> T[] toArray(T[] array) {
            int arrayIndex = 0;
            for (int x = 0; x < this.allAnnotations.size(); ++x) {
                SourceAnnotation annotation = this.allAnnotations.get(x);
                if (this.excludeList.contains(annotation)) continue;
                array[arrayIndex++] = annotation;
            }
            return array;
        }

        @Override
        public boolean add(SourceAnnotation e) {
            this.add(this.allAnnotations.size(), e);
            return true;
        }

        @Override
        public void add(int index, SourceAnnotation element) {
            if (index == this.allAnnotations.size()) {
                this.allAnnotations.add(element);
                return;
            }
            int addIndex = 0;
            for (int x = 0; x < this.allAnnotations.size(); ++x) {
                if (this.excludeList.contains(this.allAnnotations.get(x))) continue;
                if (addIndex == index) {
                    this.allAnnotations.add(x, element);
                    return;
                }
                ++addIndex;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean remove(Object o) {
            for (int x = 0; x < this.allAnnotations.size(); ++x) {
                SourceAnnotation annotation = this.allAnnotations.get(x);
                if (this.excludeList.contains(annotation) || o != annotation) continue;
                this.allAnnotations.remove(x);
                return true;
            }
            return false;
        }

        @Override
        public SourceAnnotation remove(int index) {
            int removeIndex = 0;
            for (int x = 0; x < this.allAnnotations.size(); ++x) {
                if (this.excludeList.contains(this.allAnnotations.get(x))) continue;
                if (removeIndex == index) {
                    return this.allAnnotations.remove(x);
                }
                ++removeIndex;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public boolean containsAll(Collection c) {
            for (Object o : c) {
                if (this.excludeList.contains(o)) {
                    return false;
                }
                if (this.allAnnotations.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends SourceAnnotation> c) {
            Iterator<SourceAnnotation> iter = c.iterator();
            while (iter.hasNext()) {
                this.add(iter.next());
            }
            return c.size() > 0;
        }

        @Override
        public boolean addAll(int index, Collection<? extends SourceAnnotation> c) {
            Iterator<SourceAnnotation> iterator = c.iterator();
            while (iterator.hasNext()) {
                this.add(index++, iterator.next());
            }
            return c.size() > 0;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean result = false;
            Iterator<?> iterator = c.iterator();
            while (iterator.hasNext()) {
                result |= this.remove(iterator.next());
            }
            return result;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            boolean result = false;
            for (int x = this.allAnnotations.size() - 1; x >= 0; --x) {
                SourceAnnotation annotation = this.allAnnotations.get(x);
                if (this.excludeList.contains(annotation) || c.contains(annotation)) continue;
                result |= this.allAnnotations.remove(x) != null;
            }
            return result;
        }

        @Override
        public void clear() {
            this.allAnnotations.retainAll(this.excludeList);
        }

        @Override
        public SourceAnnotation get(int index) {
            int getIndex = 0;
            for (int x = 0; x < this.allAnnotations.size(); ++x) {
                SourceAnnotation annotation = this.allAnnotations.get(x);
                if (this.excludeList.contains(annotation)) continue;
                if (getIndex == index) {
                    return annotation;
                }
                ++getIndex;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public SourceAnnotation set(int index, SourceAnnotation element) {
            int setIndex = 0;
            for (int x = 0; x < this.allAnnotations.size(); ++x) {
                SourceAnnotation annotation = this.allAnnotations.get(x);
                if (this.excludeList.contains(annotation)) continue;
                if (setIndex == index) {
                    this.allAnnotations.set(x, element);
                    return annotation;
                }
                ++setIndex;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int indexOf(Object o) {
            int index = 0;
            for (int x = 0; x < this.allAnnotations.size(); ++x) {
                SourceAnnotation annotation = this.allAnnotations.get(x);
                if (this.excludeList.contains(annotation)) continue;
                if (annotation == o) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            int index = this.size() - 1;
            for (int x = this.allAnnotations.size() - 1; x >= 0; --x) {
                SourceAnnotation annotation = this.allAnnotations.get(x);
                if (this.excludeList.contains(annotation)) continue;
                if (annotation == o) {
                    return index;
                }
                --index;
            }
            return -1;
        }

        @Override
        public ListIterator<SourceAnnotation> listIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<SourceAnnotation> listIterator(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SourceAnnotation> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }
    }
}

