/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.ModifierSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.model.JavaModule;
import oracle.javatools.parser.java.v2.model.JavaModuleExports;
import oracle.javatools.parser.java.v2.model.JavaModuleOpens;
import oracle.javatools.parser.java.v2.model.JavaModuleProvides;
import oracle.javatools.parser.java.v2.model.JavaModuleRequires;
import oracle.javatools.parser.java.v2.model.JavaModuleUses;
import oracle.javatools.parser.java.v2.model.SourceModifier;
import oracle.javatools.parser.java.v2.model.SourceModule;
import oracle.javatools.parser.java.v2.model.SourceModuleBody;
import oracle.javatools.parser.java.v2.model.SourceModuleExports;
import oracle.javatools.parser.java.v2.model.SourceModuleOpens;
import oracle.javatools.parser.java.v2.model.SourceModuleProvides;
import oracle.javatools.parser.java.v2.model.SourceModuleRequires;
import oracle.javatools.parser.java.v2.model.SourceModuleUses;

public class ModuleSym
extends TreeSym
implements SourceModule {
    @Override
    public int getElementKind() {
        return 13;
    }

    @Override
    public boolean isOpen() {
        return (this.getModifiers() & 0x20) != 0;
    }

    @Override
    public void setOpen(boolean isOpen) {
        int modifiers = this.getModifiers();
        if (isOpen) {
            modifiers |= 0x20;
            this.addModifier(' ');
        } else {
            modifiers &= 0xFFFFFFDF;
            this.removeModifier(' ');
        }
        this.setModifiers(modifiers);
    }

    private void addModifier(char access) {
        SourceFactory factory = this.getOwningSourceFile().getFactory();
        SourceModifier modifier = factory.createModifier(access);
        modifier.addSelf(this);
    }

    private void removeModifier(char access) {
        List modifiers = this.getChildrenList(43);
        Iterator iter = modifiers.iterator();
        while (iter.hasNext()) {
            SourceModifier modifier = (SourceModifier)iter.next();
            if (modifier.getModifier() != access) continue;
            iter.remove();
            break;
        }
    }

    @Override
    protected boolean isValidAccess(char access) {
        int allowed = 32800;
        return super.isValidAccess((char)(access & 0xFFFF7FDF));
    }

    @Override
    protected void linkChildTrigger(Sym added, byte filter) {
        super.linkChildTrigger(added, filter);
        switch (added.symKind) {
            case 43: {
                this.setModifiers(this.getModifiers() | ((ModifierSym)added).getModifier());
            }
        }
    }

    @Override
    protected void unlinkChildTrigger(Sym removed, byte filter) {
        super.unlinkChildTrigger(removed, filter);
        switch (removed.symKind) {
            case 43: {
                int modifiers = this.getModifiers();
                this.setModifiers(modifiers &= ~((ModifierSym)removed).getModifier());
                break;
            }
        }
    }

    @Override
    public SourceModuleBody getSourceModuleBody() {
        return (SourceModuleBody)((Object)this.getChildOrCreateSkeleton((byte)33));
    }

    @Override
    public List<SourceModuleRequires> getSourceModuleRequires() {
        return this.getSourceModuleBody().getSourceModuleRequires();
    }

    @Override
    public List<SourceModuleExports> getSourceModuleExports() {
        return this.getSourceModuleBody().getSourceModuleExports();
    }

    @Override
    public List<SourceModuleOpens> getSourceModuleOpens() {
        return this.getSourceModuleBody().getSourceModuleOpens();
    }

    @Override
    public List<SourceModuleUses> getSourceModuleUses() {
        return this.getSourceModuleBody().getSourceModuleUses();
    }

    @Override
    public List<SourceModuleProvides> getSourceModuleProvides() {
        return this.getSourceModuleBody().getSourceModuleProvides();
    }

    @Override
    public Collection<JavaModuleRequires> getRequires() {
        if (this.getChild((byte)33) != null) {
            List<SourceModuleRequires> requires = this.getSourceModuleRequires();
            ArrayList<JavaModuleRequires> javaRequires = new ArrayList<JavaModuleRequires>(requires.size());
            for (SourceModuleRequires require : requires) {
                javaRequires.add(require);
            }
            return javaRequires;
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<JavaModuleExports> getExports() {
        if (this.getChild((byte)33) != null) {
            List<SourceModuleExports> exports = this.getSourceModuleExports();
            ArrayList<JavaModuleExports> javaExports = new ArrayList<JavaModuleExports>(exports.size());
            for (SourceModuleExports export : exports) {
                javaExports.add(export);
            }
            return javaExports;
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<JavaModuleOpens> getOpens() {
        if (this.getChild((byte)33) != null) {
            List<SourceModuleOpens> opens = this.getSourceModuleOpens();
            ArrayList<JavaModuleOpens> javaOpens = new ArrayList<JavaModuleOpens>(opens.size());
            for (SourceModuleOpens open : opens) {
                javaOpens.add(open);
            }
            return javaOpens;
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<JavaModuleUses> getUses() {
        if (this.getChild((byte)33) != null) {
            List<SourceModuleUses> uses = this.getSourceModuleUses();
            ArrayList<JavaModuleUses> javaUses = new ArrayList<JavaModuleUses>(uses.size());
            for (SourceModuleUses use : uses) {
                javaUses.add(use);
            }
            return javaUses;
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<JavaModuleProvides> getProvides() {
        if (this.getChild((byte)33) != null) {
            List<SourceModuleProvides> provides = this.getSourceModuleProvides();
            ArrayList<JavaModuleProvides> javaProvides = new ArrayList<JavaModuleProvides>(provides.size());
            for (SourceModuleProvides provide : provides) {
                javaProvides.add(provide);
            }
            return javaProvides;
        }
        return Collections.emptyList();
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 20: 
            case 33: 
            case 42: 
            case 43: {
                return true;
            }
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    protected int getTargetIndex(Sym sym, byte filter) {
        switch (sym.symKind) {
            case 20: {
                return 0;
            }
            case 33: {
                return this.getChild((byte)20) != null ? 1 : 0;
            }
        }
        return super.getTargetIndex(sym, filter);
    }

    static boolean isValidServiceInterfaceName(String name) {
        if (name != null) {
            String[] pieces;
            for (String piece : pieces = name.split("/")) {
                if (CommonUtilities.isValidIdentifier(piece)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    @Override
    public void clearCompiledInfo() {
    }

    @Override
    public URL getURL() {
        return this.symFile.getURL();
    }

    @Override
    public JavaProvider getProvider() {
        return this.symFile.getProvider();
    }

    public boolean equals(Object o) {
        if (o instanceof ModuleSym) {
            ModuleSym other = (ModuleSym)o;
            if (!this.getName().equals(other.getName())) {
                return false;
            }
            List<SourceModuleExports> otherExports = other.getSourceModuleExports();
            List<SourceModuleExports> exports = this.getSourceModuleExports();
            if (otherExports.size() != exports.size()) {
                return false;
            }
            for (SourceModuleExports export : exports) {
                if (otherExports.contains(export)) continue;
                return false;
            }
            List<SourceModuleProvides> otherProvides = other.getSourceModuleProvides();
            List<SourceModuleProvides> provides = this.getSourceModuleProvides();
            if (provides.size() != otherProvides.size()) {
                return false;
            }
            for (SourceModuleProvides provide : provides) {
                if (otherProvides.contains(provide)) continue;
                return false;
            }
            List<SourceModuleRequires> otherRequires = other.getSourceModuleRequires();
            List<SourceModuleRequires> requires = this.getSourceModuleRequires();
            for (SourceModuleRequires require : requires) {
                if (otherRequires.contains(require)) continue;
                return false;
            }
            List<SourceModuleUses> otherUses = other.getSourceModuleUses();
            List<SourceModuleUses> uses = this.getSourceModuleUses();
            for (SourceModuleUses use : uses) {
                if (otherUses.contains(use)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        for (SourceModuleExports export : this.getSourceModuleExports()) {
            hashCode = 31 * hashCode + export.hashCode();
        }
        for (SourceModuleProvides provides : this.getSourceModuleProvides()) {
            hashCode = 31 * hashCode + provides.hashCode();
        }
        for (SourceModuleRequires requires : this.getSourceModuleRequires()) {
            hashCode = 31 * hashCode + requires.hashCode();
        }
        for (SourceModuleUses uses : this.getSourceModuleUses()) {
            hashCode = 31 * hashCode + uses.hashCode();
        }
        return hashCode;
    }

    @Override
    public JavaModule getCompiledObject() {
        return this;
    }

    @Override
    public SourceModule getSourceElement() {
        return this;
    }
}

