/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.ObjectSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocCommentSym;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.SourceTypeParameter;

public abstract class MemberSym
extends ObjectSym {
    public MemberSym() {
        this.symFlags = (byte)(this.symFlags | 1);
    }

    public final JavaClass getOwningClass() {
        return this.getOwningClassSym();
    }

    public final List<SourceTypeParameter> getSourceTypeParameters() {
        return this.getChildrenList(26);
    }

    public final boolean hasTypeParameters() {
        return this.getChild((byte)26) != null;
    }

    public final Collection<JavaTypeVariable> getTypeParameters() {
        return this.getObjects((byte)26);
    }

    public final boolean hasActualTypeArguments() {
        return false;
    }

    public final Collection<JavaType> getActualTypeArguments() {
        return Collections.emptyList();
    }

    @Override
    protected void linkChild(int index, Sym child, byte filter) {
        if (child.symKind == 1) {
            int targetIndex = this.getTargetIndex(child, filter);
            if (index > targetIndex) {
                index = targetIndex;
            } else if (index <= this.indexOf((byte)89)) {
                index = this.indexOf((byte)89) + 1;
            }
        }
        super.linkChild(index, child, filter);
    }

    @Override
    protected void unlinkChild(int index, byte filter) {
        Sym firstChild = this.getNthChild(0);
        Sym removeChild = this.getNthChild(filter, index);
        super.unlinkChild(index, filter);
        Sym newFirstChild = this.getNthChild(0);
        if (firstChild != null && firstChild != newFirstChild && newFirstChild != null && MemberSym.symKindIsLexical(newFirstChild.symKind) && removeChild != null && (removeChild.symKind == 89 || removeChild.symKind == 1)) {
            this.remove(newFirstChild);
            newFirstChild.addSelfBefore(this);
        }
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 1: 
            case 89: {
                return true;
            }
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    protected int getTargetIndex(Sym sym, byte filter) {
        switch (sym.symKind) {
            case 89: {
                return 0;
            }
            case 1: {
                int i = this.lastAnnotationIndex();
                if (i >= 0) {
                    return i + 1;
                }
                if (this.indexOf((byte)89) != -1) {
                    return 1;
                }
                return 0;
            }
            case 27: {
                int lastAnnotation = this.lastAnnotationIndex();
                if (lastAnnotation != -1) {
                    return lastAnnotation + 1;
                }
                return this.indexOf((byte)89) != -1 ? 1 : 0;
            }
        }
        return super.getTargetIndex(sym, filter);
    }

    private int lastAnnotationIndex() {
        List<Sym> children = this.getTreeChildren(null);
        for (int i = children.size() - 1; i >= 0; --i) {
            if (children.get((int)i).symKind != 1) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean checkSafeToInsert() {
        return true;
    }

    @Override
    public boolean checkSafeToDelete(TreeSym parent) {
        return true;
    }

    @Override
    public void buildSelf() {
        super.buildSelf();
        Sym parentSym = this.getParentSym();
        if (parentSym != null && parentSym.symKind == 4) {
            for (ClassSym owningClass = this.getOwningClassSym(); owningClass != null; owningClass = owningClass.getOwningClassSym()) {
                this.objectXaccess = (char)(this.objectXaccess | owningClass.objectXaccess & 0x2001);
            }
        }
    }

    @Override
    public String printCompiledInfo() {
        Object out = "";
        if (this.isDeprecated()) {
            out = (String)out + "@deprecated ";
        }
        if (this.isHidden()) {
            out = (String)out + "@hidden ";
        }
        return out;
    }

    public final void print_javadoc(PrintWriter out) {
        DocCommentSym javadoc = this.getJavadocSym();
        if (javadoc == null) {
            return;
        }
        MemberSym.print(javadoc, out);
        out.println();
    }

    public final void print_ty_parameters(PrintWriter out, int argument) {
        List<SourceTypeParameter> parameters = this.getSourceTypeParameters();
        if (parameters.isEmpty()) {
            return;
        }
        out.print('<');
        int comma = 0;
        for (SourceTypeParameter parameter : parameters) {
            if (comma++ == 1) {
                out.print(", ");
            }
            MemberSym.print((Sym)((Object)parameter), out, argument);
        }
        out.print('>');
    }

    public final void print_ty_parameters(PrintWriter out) {
        this.print_ty_parameters(out, 0);
    }
}

