/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.BindingPatternSym;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.LocalVariableSym;
import oracle.javatools.parser.java.v2.internal.symbol.ObjectBinding;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.pattern.SourceBindingPattern;
import oracle.javatools.parser.java.v2.util.SourceVisitor;

public class BlockSym
extends TreeSym
implements SourceBlock {
    public BlockSym() {
        this.symFlags = (byte)(this.symFlags | 1);
    }

    @Override
    public List<SourceElement> getCodeElements() {
        return this.getChildren(106);
    }

    @Override
    public List<SourceClass> getLocalClasses() {
        return this.getChildrenList(3);
    }

    public List<ClassSym> getLocalClasses(String name) {
        if (this.testSymFlag((byte)64)) {
            return Collections.emptyList();
        }
        ObjectBinding localsBinding = (ObjectBinding)this.getInternalBinding(23);
        if (localsBinding != null) {
            List<ClassSym> localClasses = (List<ClassSym>)((Map)localsBinding.getObject()).get(name);
            return localClasses != null ? localClasses : Collections.emptyList();
        }
        List<SourceElement> localClasses = this.getChildren(3);
        if (localClasses.isEmpty()) {
            this.symFlags = (byte)(this.symFlags | 0x40);
            return Collections.emptyList();
        }
        LinkedHashMap<String, List> localClassesByName = new LinkedHashMap<String, List>(localClasses.size());
        for (SourceElement element : localClasses) {
            ClassSym localClass = (ClassSym)element;
            String localName = localClass.getName();
            List localList = localClassesByName.computeIfAbsent(localName, k -> new ArrayList());
            localList.add(localClass);
        }
        this.setInternalBinding(new ObjectBinding(23, localClassesByName));
        List<ClassSym> matches = (List<ClassSym>)localClassesByName.get(name);
        return matches != null ? matches : Collections.emptyList();
    }

    @Override
    public List<SourceLocalVariableDeclaration> getLocalVariableDeclarations() {
        if (this.testSymFlag((byte)-128)) {
            return Collections.emptyList();
        }
        return this.getChildrenList(18);
    }

    @Override
    public Collection<SourceLocalVariable> getLocalVariables() {
        if (this.testSymFlag((byte)-128)) {
            return Collections.emptyList();
        }
        final ArrayList<SourceLocalVariable> variables = new ArrayList<SourceLocalVariable>();
        this.visitSelf(new SourceVisitor<SourceBlock>(){

            @Override
            public void whenEnterLocalVariable(SourceLocalVariable variable) {
                variables.add(variable);
            }

            @Override
            public void whenEnterBindingPattern(SourceBindingPattern pattern) {
                variables.add(pattern);
            }

            @Override
            public void whenEnterBlock(SourceBlock statement) {
                if (BlockSym.this != statement) {
                    this.cancelSubtree();
                }
            }
        });
        if (variables.isEmpty()) {
            this.symFlags = (byte)(this.symFlags | 0xFFFFFF80);
            return Collections.emptyList();
        }
        return variables;
    }

    public List<LocalVariableSym> getLocalVariables(String name) {
        if (this.testSymFlag((byte)-128)) {
            return Collections.emptyList();
        }
        ObjectBinding variablesBinding = (ObjectBinding)this.getInternalBinding(22);
        if (variablesBinding != null) {
            List<LocalVariableSym> variables = (List<LocalVariableSym>)((Map)variablesBinding.getObject()).get(name);
            return variables != null ? variables : Collections.emptyList();
        }
        final LinkedHashMap variables = new LinkedHashMap();
        this.visitSelf(new SourceVisitor<SourceBlock>(){

            @Override
            public void whenEnterLocalVariable(SourceLocalVariable variable) {
                List list = variables.computeIfAbsent(variable.getName(), k -> new ArrayList());
                list.add((LocalVariableSym)variable);
            }

            @Override
            public void whenEnterBindingPattern(SourceBindingPattern pattern) {
                List list = variables.computeIfAbsent(pattern.getName(), k -> new ArrayList());
                list.add((BindingPatternSym)pattern);
            }

            @Override
            public void whenEnterBlock(SourceBlock statement) {
                if (BlockSym.this != statement) {
                    this.cancelSubtree();
                }
            }
        });
        if (variables.isEmpty()) {
            this.symFlags = (byte)(this.symFlags | 0xFFFFFF80);
            return Collections.emptyList();
        }
        this.setInternalBinding(new ObjectBinding(22, variables));
        List<LocalVariableSym> matches = (List<LocalVariableSym>)variables.get(name);
        return matches != null ? matches : Collections.emptyList();
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        switch (symKind) {
            case 3: 
            case 18: {
                return true;
            }
            case 23: {
                Sym grandpa;
                Sym parent = this.getParentSym();
                if (parent == null) {
                    return true;
                }
                if (parent.symKind != 48 || (grandpa = parent.getParentSym()) != null && grandpa.symKind != 60) break;
                return true;
            }
        }
        if (BlockSym.symKindIsStatement(symKind)) {
            return true;
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    protected void linkChildTrigger(Sym added, byte filter) {
        super.linkChildTrigger(added, filter);
        switch (added.symKind) {
            case 3: {
                this.clearClassCache();
                break;
            }
            case 18: 
            case 87: {
                this.clearLocalsCache();
            }
        }
    }

    @Override
    protected void unlinkChildTrigger(Sym removed, byte filter) {
        super.unlinkChildTrigger(removed, filter);
        switch (removed.symKind) {
            case 3: {
                this.clearClassCache();
                break;
            }
            case 18: 
            case 87: {
                this.clearLocalsCache();
            }
        }
    }

    private void clearClassCache() {
        this.symFlags = (byte)(this.symFlags & 0xFFFFFFBF);
        this.clearInternalBinding(23);
    }

    void clearLocalsCache() {
        this.symFlags = (byte)(this.symFlags & 0x7F);
        this.clearInternalBinding(22);
    }

    @Override
    protected JavaElement compileImpl(CompilerDriver compiler) {
        if (compiler.skipCompilations()) {
            return super.compileImpl(compiler);
        }
        compiler.startBlockFlowAnalysis(this);
        try {
            super.compileImpl(compiler);
            JavaElement javaElement = compiler.compile(this);
            return javaElement;
        }
        finally {
            compiler.endBlockFlowAnalysis(this);
        }
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }
}

