/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.model;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.ClassHierarchy;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.QuickUnresolvedType;
import oracle.javatools.parser.java.v2.common.Value;
import oracle.javatools.parser.java.v2.internal.model.AnnotatedJavaType;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaRecordComponent;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.UnresolvedType;
import oracle.javatools.parser.java.v2.model.expression.CompiledTmpVariable;
import oracle.javatools.parser.java.v2.util.Conversions;

public class WrappedJavaType
implements JavaType,
AnnotatedJavaType {
    protected JavaType wrappedType;
    private List<JavaAnnotation> typeAnnotations;
    private WeakReference<ClassHierarchy> hierarchyRef;

    public WrappedJavaType(JavaType typeToWrap) {
        if (typeToWrap == null) {
            throw new IllegalArgumentException("Type to wrap cannot be null");
        }
        this.wrappedType = typeToWrap;
    }

    public WrappedJavaType(JavaType typeToWrap, List<JavaAnnotation> typeAnnotations) {
        if (typeToWrap == null) {
            throw new IllegalArgumentException("Type to wrap cannot be null");
        }
        this.wrappedType = typeToWrap;
        this.typeAnnotations = typeAnnotations;
    }

    public boolean equals(Object that) {
        if (that instanceof JavaType) {
            JavaType type = (JavaType)that;
            return CommonUtilities.equals(this, type);
        }
        return false;
    }

    public int hashCode() {
        return CommonUtilities.hashCode(this);
    }

    @Override
    @Deprecated
    public JavaClass getClosestClass() {
        return this.wrappedType.getTypeErasure();
    }

    @Override
    public JavaClass getTypeErasure() {
        return this.wrappedType.getTypeErasure();
    }

    @Override
    public CompiledTmpVariable getThisValue() {
        return Value.createValue(this);
    }

    @Override
    public boolean isPrimitive() {
        return this.wrappedType.isPrimitive();
    }

    @Override
    public boolean isArray() {
        return this.wrappedType.isArray();
    }

    @Override
    public JavaType getComponentType() {
        return this.wrappedType.getComponentType();
    }

    @Override
    public int getArrayDimensions() {
        return this.wrappedType.getArrayDimensions();
    }

    @Override
    public JavaType getBaseComponentType() {
        return this.wrappedType.getBaseComponentType();
    }

    @Override
    public boolean isInterface() {
        return this.wrappedType.isInterface();
    }

    @Override
    public boolean isEnum() {
        return this.wrappedType.isEnum();
    }

    @Override
    public boolean isRecord() {
        return this.wrappedType.isRecord();
    }

    @Override
    public boolean isAnnotation() {
        return this.wrappedType.isAnnotation();
    }

    @Override
    public boolean isExported() {
        return this.wrappedType.isExported();
    }

    @Override
    public boolean isMemberClass() {
        return this.wrappedType.isMemberClass();
    }

    @Override
    public boolean isAnonymousClass() {
        return this.wrappedType.isAnonymousClass();
    }

    @Override
    public boolean isLocalClass() {
        return this.wrappedType.isLocalClass();
    }

    @Override
    public String getName() {
        return this.wrappedType.getName();
    }

    @Override
    public String getUnqualifiedName() {
        return this.wrappedType.getUnqualifiedName();
    }

    @Override
    public String getQualifiedName() {
        return this.wrappedType.getQualifiedName();
    }

    @Override
    public String getRawName() {
        return this.wrappedType.getRawName();
    }

    @Override
    public String getVMName() {
        return this.wrappedType.getVMName();
    }

    @Override
    public String getDescriptor() {
        return this.wrappedType.getDescriptor();
    }

    @Override
    public String getTypeSignature() {
        return this.wrappedType.getTypeSignature();
    }

    @Override
    public String getSignature() {
        return this.wrappedType.getSignature();
    }

    @Override
    public String getUniqueIdentifier() {
        return this.wrappedType.getUniqueIdentifier();
    }

    @Override
    public JavaPackage getPackage() {
        return this.wrappedType.getPackage();
    }

    @Override
    public String getPackageName() {
        return this.wrappedType.getPackageName();
    }

    @Override
    public JavaType getSuperclass() {
        return this.wrappedType.getSuperclass();
    }

    @Override
    public UnresolvedType getUnresolvedSuperclass() {
        return this.wrappedType.getUnresolvedSuperclass();
    }

    @Override
    public Collection<JavaType> getInterfaces() {
        return this.wrappedType.getInterfaces();
    }

    @Override
    public Collection<JavaType> getPermittedSubclasses() {
        return this.wrappedType.getPermittedSubclasses();
    }

    @Override
    public Collection<UnresolvedType> getUnresolvedInterfaces() {
        return this.wrappedType.getUnresolvedInterfaces();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<JavaType> getHierarchy() {
        WrappedJavaType wrappedJavaType = this;
        synchronized (wrappedJavaType) {
            ClassHierarchy o;
            if (this.hierarchyRef != null && (o = (ClassHierarchy)this.hierarchyRef.get()) != null) {
                return o;
            }
            ClassHierarchy hierarchy = new ClassHierarchy(this);
            this.hierarchyRef = new WeakReference<ClassHierarchy>(hierarchy);
            return hierarchy;
        }
    }

    @Override
    public boolean isAssignableFrom(JavaType subject) {
        return Conversions.applyAssignmentConversion(subject, this, false, null);
    }

    @Override
    public boolean isSubtypeOf(JavaType supertype) {
        return Conversions.isSubtypeOf(this, supertype);
    }

    @Override
    public Collection<JavaField> getDeclaredFields() {
        return this.wrappedType.getDeclaredFields();
    }

    @Override
    public JavaField getDeclaredField(String name) {
        return CommonUtilities.getDeclaredField(this, name);
    }

    @Override
    public Collection<JavaRecordComponent> getDeclaredRecordComponents() {
        return this.wrappedType.getDeclaredRecordComponents();
    }

    @Override
    public JavaRecordComponent getDeclaredRecordComponent(String name) {
        return CommonUtilities.getDeclaredRecordComponent(this, name);
    }

    @Override
    public Collection<JavaMethod> getDeclaredConstructors() {
        return this.wrappedType.getDeclaredConstructors();
    }

    @Override
    public JavaMethod getDeclaredConstructor(JavaType[] parameters) {
        return CommonUtilities.getDeclaredConstructor(this, parameters);
    }

    @Override
    public Collection<JavaMethod> getDeclaredMethods() {
        return this.wrappedType.getDeclaredMethods();
    }

    @Override
    public Collection<JavaMethod> getDeclaredMethods(String name) {
        return CommonUtilities.getDeclaredMethods(this, name);
    }

    @Override
    public JavaMethod getDeclaredMethod(String name, JavaType[] parameters) {
        return CommonUtilities.getDeclaredMethod(this, name, parameters);
    }

    @Override
    public Collection<JavaClass> getDeclaredClasses() {
        return this.wrappedType.getDeclaredClasses();
    }

    @Override
    public JavaClass getDeclaredClass(String name) {
        return CommonUtilities.getDeclaredClass(this, name);
    }

    @Override
    public Collection<JavaClass> getDeclaredAnonymousClasses() {
        return this.wrappedType.getDeclaredAnonymousClasses();
    }

    @Override
    public Collection<JavaClass> getDeclaredLocalClasses() {
        return this.wrappedType.getDeclaredLocalClasses();
    }

    @Override
    public JavaMethod getClinitMethod() {
        return this.wrappedType.getClinitMethod();
    }

    @Override
    public Collection<JavaField> getFields() {
        return this.wrappedType.getFields();
    }

    @Override
    public JavaField getField(String name) {
        return CommonUtilities.getField(this, name);
    }

    @Override
    public Collection<JavaMethod> getMethods() {
        return this.wrappedType.getMethods();
    }

    @Override
    public Collection<JavaMethod> getMethods(String name) {
        return CommonUtilities.getMethods(this, name);
    }

    @Override
    public JavaMethod getMethod(String name, JavaType ... parameters) {
        return CommonUtilities.getMethod(this, name, parameters);
    }

    @Override
    public Collection<JavaClass> getClasses() {
        return this.wrappedType.getClasses();
    }

    @Override
    public JavaClass getClass(String name) {
        return CommonUtilities.getClass(this, name);
    }

    @Override
    public URL getURL() {
        return this.wrappedType.getURL();
    }

    @Override
    public JavaClass getOwningClass() {
        return this.wrappedType.getOwningClass();
    }

    @Override
    public boolean isPublic() {
        return this.wrappedType.isPublic();
    }

    @Override
    public boolean isProtected() {
        return this.wrappedType.isProtected();
    }

    @Override
    public boolean isPrivate() {
        return this.wrappedType.isPrivate();
    }

    @Override
    public boolean isStatic() {
        return this.wrappedType.isStatic();
    }

    @Override
    public boolean isAbstract() {
        return this.wrappedType.isAbstract();
    }

    @Override
    public boolean isPackagePrivate() {
        return this.wrappedType.isPackagePrivate();
    }

    @Override
    public boolean hasTypeParameters() {
        return this.wrappedType.hasTypeParameters();
    }

    @Override
    public Collection<JavaTypeVariable> getTypeParameters() {
        return this.wrappedType.getTypeParameters();
    }

    @Override
    public JavaTypeVariable getTypeParameter(String name) {
        return CommonUtilities.getTypeParameter(this, name);
    }

    @Override
    public boolean hasActualTypeArguments() {
        return this.wrappedType.hasActualTypeArguments();
    }

    @Override
    public Collection<JavaType> getActualTypeArguments() {
        return this.wrappedType.getActualTypeArguments();
    }

    @Override
    public boolean isErasedType() {
        return this.wrappedType.isErasedType();
    }

    @Override
    public int getElementKind() {
        return this.wrappedType.getElementKind();
    }

    @Override
    public JavaFile getFile() {
        return this.wrappedType.getFile();
    }

    @Override
    public JavaElement getOwner() {
        return this.wrappedType.getOwner();
    }

    @Override
    public boolean isSourceElement() {
        return false;
    }

    @Override
    public SourceElement getSourceElement() {
        return this.wrappedType.getSourceElement();
    }

    @Override
    public int getModifiers() {
        return this.wrappedType.getModifiers();
    }

    @Override
    public boolean isFinal() {
        return this.wrappedType.isFinal();
    }

    @Override
    public boolean isSynthetic() {
        return this.wrappedType.isSynthetic();
    }

    @Override
    public boolean isHidden() {
        return this.wrappedType.isHidden();
    }

    @Override
    public boolean isDeprecated() {
        return this.wrappedType.isDeprecated();
    }

    @Override
    public String printCompiledInfo() {
        return this.wrappedType.printCompiledInfo();
    }

    @Override
    public JavaType getResolvedType() {
        return this;
    }

    @Override
    public UnresolvedType getUnresolvedType() {
        return QuickUnresolvedType.createUnresolvedType(this);
    }

    @Override
    public Collection<JavaAnnotation> getDeclaredAnnotations() {
        return this.wrappedType.getDeclaredAnnotations();
    }

    @Override
    public Collection<JavaAnnotation> getAnnotations() {
        return this.wrappedType.getAnnotations();
    }

    @Override
    public JavaAnnotation getDeclaredAnnotation(JavaType annotationType) {
        return this.wrappedType.getDeclaredAnnotation(annotationType);
    }

    @Override
    public JavaAnnotation getAnnotation(JavaType annotationType) {
        return CommonUtilities.getAnnotation(this, annotationType);
    }

    @Override
    public Collection<JavaAnnotation> getTypeAnnotations() {
        if (this.typeAnnotations != null) {
            return this.typeAnnotations;
        }
        return this.wrappedType.getTypeAnnotations();
    }

    @Override
    public void setTypeAnnotations(List<JavaAnnotation> typeAnnotations) {
        this.typeAnnotations = typeAnnotations == null ? new ArrayList() : typeAnnotations;
    }

    @Override
    public JavaProvider getProvider() {
        return this.wrappedType.getProvider();
    }

    @Override
    public JavaType getQualifyingType() {
        return this.wrappedType.getQualifyingType();
    }

    @Override
    public void setQualifyingType(JavaType qualifyingType) {
        this.wrappedType.setQualifyingType(qualifyingType);
    }

    @Override
    public JavaType getNonParameterizedType() {
        return this.wrappedType.getNonParameterizedType();
    }
}

