/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.ContextImageB;
import oracle.javatools.parser.java.v2.internal.symbol.BindingPatternSym;
import oracle.javatools.parser.java.v2.internal.symbol.BlockSym;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.FormalParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.ImportSym;
import oracle.javatools.parser.java.v2.internal.symbol.LocalVariableSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.LambdaExpr;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.CatchStmt;
import oracle.javatools.parser.java.v2.internal.symbol.stmt.ForStmt;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceLambdaParameter;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.SourceTryResourcesElement;
import oracle.javatools.parser.java.v2.model.SourceTryResourcesList;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.pattern.SourceBindingPattern;
import oracle.javatools.parser.java.v2.model.statement.SourceTryStatement;

abstract class ContextImageC
extends ContextImageB {
    ContextImageC(CompilerDriver compiler, Sym cookie) {
        super(compiler, cookie);
    }

    protected final JavaType findType(Sym scope, String name) {
        if (scope == null) {
            return null;
        }
        if (name == null || name.length() == 0) {
            return null;
        }
        TreeSym treeSym = (TreeSym)scope;
        return this.lookupType(treeSym, name);
    }

    protected final JavaVariable findVariable(Sym scope, String name, boolean useStrict) {
        if (scope == null) {
            return null;
        }
        if (name == null || name.length() == 0) {
            return null;
        }
        TreeSym treeSym = (TreeSym)scope;
        return this.lookupVariable(treeSym, name, useStrict);
    }

    protected final JavaClass findMemberType(JavaType targetClass, String name) {
        if (targetClass == null) {
            return null;
        }
        if (name == null || name.length() == 0) {
            return null;
        }
        return this.lookupMemberType(targetClass, name);
    }

    protected final JavaVariable findMemberVariable(JavaType targetClass, String name) {
        if (targetClass == null) {
            return null;
        }
        if (name == null || name.length() == 0) {
            return null;
        }
        return this.lookupMemberVariable(targetClass, name);
    }

    protected final JavaVariable findImportedVariable(String name) {
        this.flag_instance = false;
        return this.lookupImportedVariable(name);
    }

    protected final JavaType findImportedType(String name) {
        this.flag_instance = false;
        return this.lookupImportedType(name);
    }

    protected final boolean findVisibleType(JavaType targetClass, String name) {
        if (targetClass == null) {
            return false;
        }
        JavaClass inner = targetClass.getDeclaredClass(name);
        if (inner != null && inner.isExported()) {
            return true;
        }
        for (JavaType type : targetClass.getHierarchy()) {
            inner = type.getDeclaredClass(name);
            if (inner == null || !inner.isExported()) continue;
            return this.processVisible(inner);
        }
        return false;
    }

    protected final boolean findVisibleVariable(JavaType targetClass, String name) {
        if (targetClass == null) {
            return false;
        }
        JavaField member = targetClass.getDeclaredField(name);
        if (member != null) {
            return true;
        }
        for (JavaType type : targetClass.getHierarchy()) {
            JavaField field = type.getDeclaredField(name);
            if (field == null || !this.processVisible(field)) continue;
            return true;
        }
        return false;
    }

    private JavaType lookupType(TreeSym scope, String name) {
        byte scopeType = scope.symKind;
        switch (scopeType) {
            case 3: 
            case 6: 
            case 19: {
                ClassSym classSym;
                Iterator<SourceElement> iterator = scope.getChildren(26).iterator();
                TypeParameterSym lastFound = null;
                while (iterator.hasNext()) {
                    TypeParameterSym parameterSym = (TypeParameterSym)iterator.next();
                    if (!name.equals(parameterSym.getName())) continue;
                    if (lastFound != null) {
                        this.error((short)41, name);
                    }
                    lastFound = parameterSym;
                }
                if (scopeType == 3 && name.equals((classSym = (ClassSym)scope).getName())) {
                    return classSym;
                }
                return lastFound;
            }
            case 2: {
                BlockSym blockSym = (BlockSym)scope;
                int start = this.symCookie.symStart;
                boolean inScope = false;
                ClassSym lastFound = null;
                List<ClassSym> localClasses = blockSym.getLocalClasses(name);
                for (ClassSym classSym : localClasses) {
                    if (lastFound != null && inScope) {
                        this.error((short)41, name);
                    }
                    inScope = start == -1 || start < classSym.symStart;
                    lastFound = classSym;
                }
                if (lastFound != null && start != -1 && start < lastFound.symStart) {
                    return null;
                }
                return lastFound;
            }
            case 98: {
                Iterator<SourceElement> iterator = scope.getChildren(3).iterator();
                ClassSym lastFound = null;
                while (iterator.hasNext()) {
                    ClassSym classSym = (ClassSym)iterator.next();
                    if (!name.equals(classSym.getName())) continue;
                    if (lastFound != null) {
                        this.error((short)41, name);
                    }
                    lastFound = classSym;
                }
                return lastFound;
            }
        }
        return null;
    }

    private JavaClass lookupMemberType(JavaType targetClass, String name) {
        HashSet<Object> processed = new HashSet<Object>();
        JavaClass result = (JavaClass)this.findRecursive(targetClass, name, processed, true);
        return result;
    }

    private boolean matchVariable(SourceVariable sym, String name, boolean useStrict) {
        if (sym == null || !name.equals(sym.getName())) {
            return false;
        }
        return this.matchVariable(sym, useStrict);
    }

    private boolean matchVariable(SourceVariable sym, boolean useStrict) {
        if (sym == null) {
            return false;
        }
        if (useStrict) {
            if (!this.allowAccess(sym)) {
                return false;
            }
            return this.compiler.flag_nonFinalLocalVars == null || this.compiler.flag_nonFinalLocalVars != false || sym.isFinal();
        }
        return true;
    }

    private JavaVariable lookupVariable(TreeSym scope, String name, boolean useStrict) {
        byte scopeType = scope.symKind;
        switch (scopeType) {
            case 6: 
            case 19: {
                MethodSym methodSym = (MethodSym)scope;
                for (SourceVariable sourceVariable : methodSym.getSourceParameters()) {
                    FormalParameterSym variableSym = (FormalParameterSym)sourceVariable;
                    if (!this.matchVariable(variableSym, name, useStrict)) continue;
                    return variableSym;
                }
                return null;
            }
            case 2: {
                SourceTryStatement tryStmt;
                Sym grandparent;
                Sym sym;
                int start = this.symCookie.symStart;
                if (start < 0) {
                    return null;
                }
                BlockSym blockSym = (BlockSym)scope;
                for (LocalVariableSym variableSym : blockSym.getLocalVariables(name)) {
                    Object object;
                    if (!this.matchVariable(variableSym, useStrict)) continue;
                    if (variableSym.symKind == 87) {
                        if (!((SourceBindingPattern)((Object)variableSym)).isVisible(start)) continue;
                        return variableSym;
                    }
                    Sym parent2 = variableSym.symParent;
                    if (parent2 != null && (object = parent2.symParent) instanceof ForStmt) {
                        ForStmt f = (ForStmt)object;
                        if (start <= parent2.symEnd || start > f.symEnd) continue;
                        return variableSym;
                    }
                    if (start < variableSym.symStart || start > blockSym.symEnd) continue;
                    return variableSym;
                }
                if (this.compiler.jdkVersion.isGreaterThanOrEqualTo7() && (sym = blockSym.getParentSym()) != null && (grandparent = sym.getParentSym()) != null && grandparent.symKind == 63 && (tryStmt = (SourceTryStatement)((Object)grandparent)).hasTryResourcesElements()) {
                    List<SourceTryResourcesElement> list = tryStmt.getTryResourcesElements();
                    for (SourceTryResourcesElement element : list) {
                        if (element.getSymbolKind() != 18) continue;
                        List<SourceVariable> sourceVariables = ((SourceLocalVariableDeclaration)element).getVariables();
                        for (SourceVariable sourceVariable : sourceVariables) {
                            if (!this.matchVariable(sourceVariable, name, useStrict)) continue;
                            return sourceVariable;
                        }
                    }
                }
                return null;
            }
            case 17: {
                LocalVariableSym variableSym = (LocalVariableSym)scope;
                if (this.matchVariable(variableSym, name, useStrict)) {
                    // empty if block
                }
                return null;
            }
            case 18: {
                Sym parent;
                if (this.compiler.jdkVersion.isGreaterThanOrEqualTo7() && (parent = scope.getParentSym()) != null && parent.symKind == 30) {
                    SourceTryResourcesList tryResources = (SourceTryResourcesList)((Object)parent);
                    List<SourceTryResourcesElement> list = tryResources.getTryResourcesElements();
                    for (SourceTryResourcesElement element : list) {
                        if (element == scope) break;
                        if (element.getSymbolKind() != 18) continue;
                        List<SourceVariable> sourceVariables = ((SourceLocalVariableDeclaration)element).getVariables();
                        for (SourceVariable sourceVariable : sourceVariables) {
                            if (!this.matchVariable(sourceVariable, name, useStrict)) continue;
                            return sourceVariable;
                        }
                    }
                }
                return null;
            }
            case 57: {
                ForStmt forStmt = (ForStmt)scope;
                for (LocalVariableSym localVariableSym : forStmt.getForVariables()) {
                    if (!this.matchVariable(localVariableSym, name, useStrict)) continue;
                    return localVariableSym;
                }
                return null;
            }
            case 50: {
                CatchStmt catchClause = (CatchStmt)scope;
                FormalParameterSym variableSym = (FormalParameterSym)catchClause.getCatchVariable();
                if (this.matchVariable(variableSym, name, useStrict)) {
                    return variableSym;
                }
                return null;
            }
            case 83: {
                LambdaExpr lambdaExpr = (LambdaExpr)scope;
                List<SourceLambdaParameter> formalParameters = lambdaExpr.getFormalParameters();
                for (SourceLambdaParameter parameter : formalParameters) {
                    if (!(parameter.isInferredFormalParameter() ? name.equals(parameter.getName()) : this.matchVariable(parameter, name, useStrict))) continue;
                    return parameter;
                }
                return null;
            }
            case 87: {
                BindingPatternSym variable = (BindingPatternSym)scope;
                return this.matchVariable(variable, name, useStrict) ? variable : null;
            }
        }
        return null;
    }

    private JavaVariable lookupMemberVariable(JavaType targetClass, String name) {
        HashSet<Object> processed = new HashSet<Object>();
        JavaVariable result = (JavaVariable)((Object)this.findRecursive(targetClass, name, processed, false));
        return result;
    }

    private JavaMember findRecursive(JavaType targetClass, String targetName, Set<Object> processed, boolean isType) {
        if (targetClass == null) {
            return null;
        }
        if (ContextImageC.classProcessed(processed, targetClass)) {
            return null;
        }
        JavaMember declared = this.findDeclared(targetClass, targetName, isType);
        if (declared != null) {
            return declared;
        }
        JavaMember alreadyFound = null;
        JavaType baseClass = targetClass.getSuperclass();
        if (baseClass != null) {
            alreadyFound = this.findRecursive(baseClass, targetName, processed, isType);
        }
        for (JavaType baseInterface : targetClass.getInterfaces()) {
            JavaMember found = this.findRecursive(baseInterface, targetName, processed, isType);
            if (found == null) continue;
            if (alreadyFound != null) {
                this.error((short)41);
            }
            alreadyFound = found;
        }
        return alreadyFound;
    }

    private JavaMember findDeclared(JavaType targetClass, String targetName, boolean isType) {
        if (isType) {
            JavaClass inner = targetClass.getDeclaredClass(targetName);
            if (inner != null && inner.isExported() && this.processVisible(inner)) {
                return inner;
            }
        } else {
            JavaField field = targetClass.getDeclaredField(targetName);
            if (field != null && this.processVisible(field)) {
                return field;
            }
        }
        return null;
    }

    private JavaVariable lookupImportedVariable(String name) {
        FileSym sourceFile = this.symCookie.symFile;
        if (sourceFile == null) {
            return null;
        }
        List<ImportSym> staticImportList = this.getValidStaticImports(sourceFile);
        if (staticImportList.size() == 0) {
            return null;
        }
        for (ImportSym importSym : staticImportList) {
            String importedName;
            if (!importSym.isNarrow()) continue;
            String fqname = importSym.getName();
            int lastDot = fqname.lastIndexOf(46);
            String string = importedName = lastDot == -1 ? fqname : fqname.substring(lastDot + 1);
            if (!importedName.equals(name)) continue;
            importSym.resolve();
            JavaClass qualifying = importSym.getQualifyingType();
            if (qualifying == null || !this.findVisibleVariable(qualifying, name)) continue;
            JavaVariable found = this.findMemberVariable(qualifying, name);
            if (found != null) {
                importSym.setUsed();
                ArrayList<JavaHasType> importList = importSym.getImportObj().importList;
                if (importList != null && !importList.contains(found)) {
                    importList.add(found);
                }
            }
            return found;
        }
        HashSet<String> importKeys = new HashSet<String>();
        for (ImportSym importSym : staticImportList) {
            String importName;
            if (importSym.isNarrow() || importKeys.contains(importName = importSym.getName())) continue;
            importKeys.add(importName);
            importSym.resolve();
            JavaClass qualifying = importSym.getQualifyingType();
            if (qualifying == null || !this.findVisibleVariable(qualifying, name)) continue;
            JavaVariable found = this.findMemberVariable(qualifying, name);
            if (found != null) {
                importSym.setUsed();
                ArrayList<JavaHasType> importList = importSym.getImportObj().importList;
                if (importList != null && !importList.contains(found)) {
                    importList.add(found);
                }
            }
            return found;
        }
        return null;
    }

    private JavaType lookupImportedType(String name) {
        FileSym sourceFile = this.symCookie.symFile;
        if (sourceFile == null) {
            return null;
        }
        List<ImportSym> staticImportList = this.getValidStaticImports(sourceFile);
        if (staticImportList.size() == 0) {
            return null;
        }
        for (ImportSym importSym : staticImportList) {
            String importedName;
            if (!importSym.isNarrow()) continue;
            String fqname = importSym.getName();
            int lastDot = fqname.lastIndexOf(46);
            String string = importedName = lastDot == -1 ? fqname : fqname.substring(lastDot + 1);
            if (!importedName.equals(name)) continue;
            importSym.resolve();
            JavaClass qualifying = importSym.getQualifyingType();
            if (qualifying == null || !this.findVisibleType(qualifying, name)) continue;
            JavaClass found = this.findMemberType(qualifying, name);
            if (found != null) {
                importSym.setUsed();
                ArrayList<JavaHasType> importList = importSym.getImportObj().importList;
                if (importList != null && !importList.contains(found)) {
                    importList.add(found);
                }
            }
            return found;
        }
        HashSet<String> importKeys = new HashSet<String>();
        for (ImportSym importSym : staticImportList) {
            String importName;
            if (importSym.isNarrow() || importKeys.contains(importName = importSym.getName())) continue;
            importKeys.add(importName);
            importSym.resolve();
            JavaClass qualifying = importSym.getQualifyingType();
            if (qualifying == null || !this.findVisibleType(qualifying, name)) continue;
            JavaClass found = this.findMemberType(qualifying, name);
            if (found != null) {
                importSym.setUsed();
                ArrayList<JavaHasType> importList = importSym.getImportObj().importList;
                if (importList != null && !importList.contains(found)) {
                    importList.add(found);
                }
            }
            return found;
        }
        return null;
    }
}

