/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.parser.java.v2.BindingRegistry;
import oracle.javatools.parser.java.v2.internal.symbol.expr.LiteralExpr;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.NodeBinding;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.scanner.LexerLiteral;

public class ConstantExpressionEvaluator {
    private static final int BINDING_CONSTANT = BindingRegistry.register("audit-constant-value");
    private static final int TYPE_BYTE = 1;
    private static final int TYPE_CHAR = 2;
    private static final int TYPE_SHORT = 3;
    private static final int TYPE_INT = 4;
    private static final int TYPE_LONG = 5;
    private static final int TYPE_FLOAT = 6;
    private static final int TYPE_DOUBLE = 7;
    private static final int TYPE_BOOLEAN = 8;
    private static final int TYPE_STRING = 9;
    private static final int TYPE_INVALID = 10;
    private static final Map TYPES = ConstantExpressionEvaluator.initTypes();
    private static final ConstantValue PENDING_VALUE = new ConstantValue(null);

    public static Object evaluate(SourceExpression expression) {
        Object value = ConstantExpressionEvaluator.evaluateCached(expression);
        if (value instanceof CharacterNumber) {
            value = Character.valueOf(((CharacterNumber)value).charValue());
        } else if (value != null && !TYPES.containsKey(value.getClass())) {
            value = null;
        }
        return value;
    }

    public static Object evaluate(JavaVariable variable) {
        if (!variable.isFinal()) {
            return null;
        }
        Object value = variable.getConstantValue();
        if (value instanceof CharacterNumber) {
            value = Character.valueOf(((CharacterNumber)value).charValue());
        } else if (value != null && !TYPES.containsKey(value.getClass())) {
            value = null;
        }
        Object casted = ConstantExpressionEvaluator.cast(value, variable.getResolvedType());
        return casted != null ? casted : value;
    }

    public static Object evaluateUnconstrained(SourceExpression expression) {
        Object object = ConstantExpressionEvaluator.evaluateCached(expression);
        if (object instanceof CharacterNumber) {
            object = Character.valueOf(((CharacterNumber)object).charValue());
        }
        return object;
    }

    public static Object evaluate(SourceExpression expression, JavaType castToType) {
        return ConstantExpressionEvaluator.cast(ConstantExpressionEvaluator.evaluate(expression), castToType);
    }

    public static Object cast(Object constantValue, JavaType toType) {
        int fromType = ConstantExpressionEvaluator.constantType(constantValue);
        switch (ConstantExpressionEvaluator.constantType(toType)) {
            case 8: {
                switch (fromType) {
                    case 8: {
                        return constantValue;
                    }
                }
                return null;
            }
            case 1: {
                switch (fromType) {
                    case 1: {
                        return constantValue;
                    }
                    case 2: {
                        return new CharacterNumber((Character)constantValue).byteValue();
                    }
                    case 3: {
                        return ((Number)constantValue).byteValue();
                    }
                    case 4: {
                        return ((Number)constantValue).byteValue();
                    }
                    case 5: {
                        return ((Number)constantValue).byteValue();
                    }
                    case 6: {
                        return ((Number)constantValue).byteValue();
                    }
                    case 7: {
                        return ((Number)constantValue).byteValue();
                    }
                }
                return null;
            }
            case 2: {
                switch (fromType) {
                    case 1: {
                        return Character.valueOf((char)((Number)constantValue).byteValue());
                    }
                    case 2: {
                        assert (!(constantValue instanceof CharacterNumber));
                        return constantValue;
                    }
                    case 3: {
                        return Character.valueOf((char)((Number)constantValue).shortValue());
                    }
                    case 4: {
                        return Character.valueOf((char)((Number)constantValue).intValue());
                    }
                    case 5: {
                        return Character.valueOf((char)((Number)constantValue).longValue());
                    }
                    case 6: {
                        return Character.valueOf((char)((Number)constantValue).floatValue());
                    }
                    case 7: {
                        return Character.valueOf((char)((Number)constantValue).doubleValue());
                    }
                }
                return null;
            }
            case 3: {
                switch (fromType) {
                    case 1: {
                        return ((Number)constantValue).shortValue();
                    }
                    case 2: {
                        return new CharacterNumber((Character)constantValue).shortValue();
                    }
                    case 3: {
                        return constantValue;
                    }
                    case 4: {
                        return ((Number)constantValue).shortValue();
                    }
                    case 5: {
                        return ((Number)constantValue).shortValue();
                    }
                    case 6: {
                        return ((Number)constantValue).shortValue();
                    }
                    case 7: {
                        return ((Number)constantValue).shortValue();
                    }
                }
                return null;
            }
            case 4: {
                switch (fromType) {
                    case 1: {
                        return ((Number)constantValue).intValue();
                    }
                    case 2: {
                        return new CharacterNumber((Character)constantValue).intValue();
                    }
                    case 3: {
                        return ((Number)constantValue).intValue();
                    }
                    case 4: {
                        return constantValue;
                    }
                    case 5: {
                        return ((Number)constantValue).intValue();
                    }
                    case 6: {
                        return ((Number)constantValue).intValue();
                    }
                    case 7: {
                        return ((Number)constantValue).intValue();
                    }
                }
                return null;
            }
            case 5: {
                switch (fromType) {
                    case 1: {
                        return ((Number)constantValue).longValue();
                    }
                    case 2: {
                        return new CharacterNumber((Character)constantValue).longValue();
                    }
                    case 3: {
                        return ((Number)constantValue).longValue();
                    }
                    case 4: {
                        return ((Number)constantValue).longValue();
                    }
                    case 5: {
                        return constantValue;
                    }
                    case 6: {
                        return ((Number)constantValue).longValue();
                    }
                    case 7: {
                        return ((Number)constantValue).longValue();
                    }
                }
                return null;
            }
            case 6: {
                switch (fromType) {
                    case 1: {
                        return Float.valueOf(((Number)constantValue).floatValue());
                    }
                    case 2: {
                        return Float.valueOf(new CharacterNumber((Character)constantValue).floatValue());
                    }
                    case 3: {
                        return Float.valueOf(((Number)constantValue).floatValue());
                    }
                    case 4: {
                        return Float.valueOf(((Number)constantValue).floatValue());
                    }
                    case 5: {
                        return Float.valueOf(((Number)constantValue).floatValue());
                    }
                    case 6: {
                        return constantValue;
                    }
                    case 7: {
                        return Float.valueOf(((Number)constantValue).floatValue());
                    }
                }
                return null;
            }
            case 7: {
                switch (fromType) {
                    case 1: {
                        return ((Number)constantValue).doubleValue();
                    }
                    case 2: {
                        return new CharacterNumber((Character)constantValue).doubleValue();
                    }
                    case 3: {
                        return ((Number)constantValue).doubleValue();
                    }
                    case 4: {
                        return ((Number)constantValue).doubleValue();
                    }
                    case 5: {
                        return ((Number)constantValue).doubleValue();
                    }
                    case 6: {
                        return ((Number)constantValue).doubleValue();
                    }
                    case 7: {
                        return constantValue;
                    }
                }
                return null;
            }
            case 9: {
                switch (fromType) {
                    case 9: {
                        return constantValue;
                    }
                }
                return null;
            }
        }
        return null;
    }

    private static Map initTypes() {
        HashMap<Object, Integer> types = new HashMap<Object, Integer>();
        types.put(Boolean.class, 8);
        types.put(Byte.class, 1);
        types.put(Character.class, 2);
        types.put(CharacterNumber.class, 2);
        types.put(Short.class, 3);
        types.put(Integer.class, 4);
        types.put(Long.class, 5);
        types.put(Float.class, 6);
        types.put(Double.class, 7);
        types.put(String.class, 9);
        types.put(Boolean.class.getName(), 8);
        types.put(Byte.class.getName(), 1);
        types.put(Character.class.getName(), 2);
        types.put(CharacterNumber.class.getName(), 2);
        types.put(Short.class.getName(), 3);
        types.put(Integer.class.getName(), 4);
        types.put(Long.class.getName(), 5);
        types.put(Float.class.getName(), 6);
        types.put(Double.class.getName(), 7);
        types.put(String.class.getName(), 9);
        return types;
    }

    private static int constantType(Object object) {
        if (object == null) {
            return 10;
        }
        return ConstantExpressionEvaluator.constantType(object.getClass());
    }

    private static int constantType(Class type) {
        Integer code = (Integer)TYPES.get(type);
        if (code == null) {
            return 10;
        }
        return code;
    }

    private static int constantType(JavaType type) {
        if (type == null) {
            return 10;
        }
        String name = type.getRawName();
        if (name == null) {
            return 10;
        }
        switch (name) {
            case "byte": 
            case "java.lang.Byte": {
                return 1;
            }
            case "short": 
            case "java.lang.Short": {
                return 3;
            }
            case "char": 
            case "java.lang.Character": {
                return 2;
            }
            case "int": 
            case "java.lang.Integer": {
                return 4;
            }
            case "long": 
            case "java.lang.Long": {
                return 5;
            }
            case "float": 
            case "java.lang.Float": {
                return 6;
            }
            case "double": 
            case "java.lang.Double": {
                return 7;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                return 8;
            }
            case "java.lang.String": {
                return 9;
            }
        }
        return 10;
    }

    private static int unaryPromotedType(int operandType) {
        int type = 4;
        if (operandType > type) {
            type = operandType;
        }
        return type;
    }

    private static int binaryPromotedType(int leftType, int rightType) {
        int type = 4;
        if (leftType > type) {
            type = leftType;
        }
        if (rightType > type) {
            type = rightType;
        }
        return type;
    }

    private static Object evaluateCached(SourceExpression expression) {
        if (expression == null) {
            return null;
        }
        NodeBinding binding = expression.getBinding(BINDING_CONSTANT);
        if (binding == PENDING_VALUE) {
            return null;
        }
        if (binding instanceof ConstantValue) {
            return ((ConstantValue)binding).getValue();
        }
        expression.setBinding(PENDING_VALUE);
        Object value = ConstantExpressionEvaluator.evaluateUncached(expression);
        expression.setBinding(new ConstantValue(value));
        return value;
    }

    private static Object evaluateUncached(SourceExpression expression) {
        if (expression == null) {
            return null;
        }
        switch (expression.getSymbolKind()) {
            case 72: {
                LexerLiteral literal = ((LiteralExpr)expression).getLiteral();
                if (literal == null) {
                    return null;
                }
                switch (literal.getTokenValue()) {
                    case 12: {
                        return literal.getBoolean() ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 13: {
                        return new CharacterNumber(literal.getChar());
                    }
                    case 9: {
                        return literal.getInteger();
                    }
                    case 8: {
                        return (int)literal.getInteger();
                    }
                    case 11: {
                        return literal.getFloat();
                    }
                    case 10: {
                        return Float.valueOf((float)literal.getFloat());
                    }
                    case 14: {
                        return literal.getString();
                    }
                }
                return null;
            }
            case 79: {
                Object value = ConstantExpressionEvaluator.evaluate(expression.getSecondOperand(), expression.getResolvedType());
                return value instanceof Character ? new CharacterNumber((Character)value) : value;
            }
            case 80: {
                Object operand = ConstantExpressionEvaluator.evaluateCached(expression.getFirstOperand());
                int type = ConstantExpressionEvaluator.unaryPromotedType(ConstantExpressionEvaluator.constantType(operand));
                switch (expression.getOperatorCode()) {
                    case 44: {
                        switch (type) {
                            case 4: {
                                return ((Number)operand).intValue();
                            }
                            case 5: {
                                return operand;
                            }
                            case 6: {
                                return operand;
                            }
                            case 7: {
                                return operand;
                            }
                        }
                        return null;
                    }
                    case 37: {
                        switch (type) {
                            case 4: {
                                return -((Number)operand).intValue();
                            }
                            case 5: {
                                return -((Number)operand).longValue();
                            }
                            case 6: {
                                return Float.valueOf(-((Number)operand).floatValue());
                            }
                            case 7: {
                                return -((Number)operand).doubleValue();
                            }
                        }
                        return null;
                    }
                    case 9: {
                        switch (type) {
                            case 4: {
                                return ~((Number)operand).intValue();
                            }
                            case 5: {
                                return ((Number)operand).longValue() ^ 0xFFFFFFFFFFFFFFFFL;
                            }
                        }
                        return null;
                    }
                    case 41: {
                        switch (type) {
                            case 8: {
                                return (Boolean)operand != false ? Boolean.FALSE : Boolean.TRUE;
                            }
                        }
                        return null;
                    }
                }
                return null;
            }
            case 70: {
                int operandCount = expression.getOperandCount();
                Object left = ConstantExpressionEvaluator.evaluateCached(expression.getFirstOperand());
                int leftType = ConstantExpressionEvaluator.constantType(left);
                for (int x = 1; x < operandCount; ++x) {
                    Object right = ConstantExpressionEvaluator.evaluateCached(expression.getOperandAt(x));
                    int rightType = ConstantExpressionEvaluator.constantType(right);
                    int promotedType = ConstantExpressionEvaluator.binaryPromotedType(leftType, rightType);
                    left = ConstantExpressionEvaluator.evaluateInfixExpression(expression.getOperatorCode(), leftType, rightType, promotedType, left, right);
                    leftType = ConstantExpressionEvaluator.constantType(left);
                }
                return left;
            }
            case 76: {
                int greaterType;
                Object greater;
                int lesserType;
                Object choice;
                Object condition = ConstantExpressionEvaluator.evaluateCached(expression.getFirstOperand());
                if (ConstantExpressionEvaluator.constantType(condition) != 8) {
                    return null;
                }
                Object left = ConstantExpressionEvaluator.evaluateCached(expression.getSecondOperand());
                int leftType = ConstantExpressionEvaluator.constantType(left);
                Object right = ConstantExpressionEvaluator.evaluateCached(expression.getThirdOperand());
                int rightType = ConstantExpressionEvaluator.constantType(right);
                Object object = choice = (Boolean)condition != false ? left : right;
                if (leftType == rightType) {
                    return choice;
                }
                if (leftType < rightType) {
                    lesserType = leftType;
                    greater = right;
                    greaterType = rightType;
                } else {
                    lesserType = rightType;
                    greater = left;
                    greaterType = leftType;
                }
                switch (greaterType) {
                    case 2: {
                        switch (lesserType) {
                            case 1: {
                                return ((Number)choice).intValue();
                            }
                        }
                        throw new InternalError();
                    }
                    case 3: {
                        switch (lesserType) {
                            case 1: {
                                return ((Number)choice).shortValue();
                            }
                            case 2: {
                                return ((Number)choice).intValue();
                            }
                        }
                        throw new InternalError();
                    }
                    case 4: {
                        int value = ((Number)greater).intValue();
                        switch (lesserType) {
                            case 1: {
                                if (value >= -128 && value <= 127) {
                                    return ((Number)choice).byteValue();
                                }
                                return ((Number)choice).intValue();
                            }
                            case 2: {
                                if (value >= 0 && value <= 65535) {
                                    return new CharacterNumber((char)((Number)choice).intValue());
                                }
                                return ((Number)choice).intValue();
                            }
                            case 3: {
                                if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
                                    return ((Number)choice).shortValue();
                                }
                                return ((Number)choice).intValue();
                            }
                        }
                        throw new InternalError();
                    }
                    case 5: {
                        return ((Number)choice).longValue();
                    }
                    case 6: {
                        return Float.valueOf(((Number)choice).floatValue());
                    }
                    case 7: {
                        return ((Number)choice).doubleValue();
                    }
                }
                return null;
            }
            case 81: {
                return ConstantExpressionEvaluator.evaluateCached(expression.getFirstOperand());
            }
            case 69: 
            case 77: {
                JavaHasType object = expression.getResolvedObject();
                if (!(object instanceof JavaVariable)) {
                    return null;
                }
                JavaVariable variable = (JavaVariable)object;
                if (!variable.isFinal()) {
                    return null;
                }
                Object value = variable.getConstantValue();
                if (value instanceof Character) {
                    value = new CharacterNumber((Character)value);
                }
                return value;
            }
        }
        return null;
    }

    private static Object evaluateInfixExpression(int operatorCode, int leftType, int rightType, int promotedType, Object left, Object right) {
        switch (operatorCode) {
            case 35: {
                switch (promotedType) {
                    case 4: {
                        return ((Number)left).intValue() * ((Number)right).intValue();
                    }
                    case 5: {
                        return ((Number)left).longValue() * ((Number)right).longValue();
                    }
                    case 6: {
                        return Float.valueOf(((Number)left).floatValue() * ((Number)right).floatValue());
                    }
                    case 7: {
                        return ((Number)left).doubleValue() * ((Number)right).doubleValue();
                    }
                }
                return null;
            }
            case 17: {
                switch (promotedType) {
                    case 4: {
                        int i = ((Number)right).intValue();
                        return i != 0 ? Integer.valueOf(((Number)left).intValue() / i) : null;
                    }
                    case 5: {
                        long l = ((Number)right).longValue();
                        return l != 0L ? Long.valueOf(((Number)left).longValue() / l) : null;
                    }
                    case 6: {
                        float leftFloatValue = ((Number)left).floatValue();
                        float rightFloatValue = ((Number)right).floatValue();
                        if (rightFloatValue == 0.0f) {
                            if (leftFloatValue > 0.0f) {
                                return Float.valueOf(Float.POSITIVE_INFINITY);
                            }
                            if (leftFloatValue < 0.0f) {
                                return Float.valueOf(Float.NEGATIVE_INFINITY);
                            }
                            return Float.valueOf(Float.NaN);
                        }
                        return Float.valueOf(leftFloatValue / rightFloatValue);
                    }
                    case 7: {
                        double leftDoubleValue = ((Number)left).doubleValue();
                        double rightDoubleValue = ((Number)right).doubleValue();
                        if (rightDoubleValue == 0.0) {
                            if (leftDoubleValue > 0.0) {
                                return Double.POSITIVE_INFINITY;
                            }
                            if (leftDoubleValue < 0.0) {
                                return Double.NEGATIVE_INFINITY;
                            }
                            return Double.NaN;
                        }
                        return leftDoubleValue / rightDoubleValue;
                    }
                }
                return null;
            }
            case 33: {
                switch (promotedType) {
                    case 4: {
                        int i = ((Number)right).intValue();
                        return i != 0 ? Integer.valueOf(((Number)left).intValue() % i) : null;
                    }
                    case 5: {
                        long l = ((Number)right).longValue();
                        return l != 0L ? Long.valueOf(((Number)left).longValue() % l) : null;
                    }
                    case 6: {
                        float f = ((Number)right).floatValue();
                        return f != 0.0f ? Float.valueOf(((Number)left).floatValue() % f) : null;
                    }
                    case 7: {
                        double d = ((Number)right).doubleValue();
                        return d != 0.0 ? Double.valueOf(((Number)left).doubleValue() % d) : null;
                    }
                }
                return null;
            }
            case 1: {
                switch (promotedType) {
                    case 4: {
                        return ((Number)left).intValue() + ((Number)right).intValue();
                    }
                    case 5: {
                        return ((Number)left).longValue() + ((Number)right).longValue();
                    }
                    case 6: {
                        return Float.valueOf(((Number)left).floatValue() + ((Number)right).floatValue());
                    }
                    case 7: {
                        return ((Number)left).doubleValue() + ((Number)right).doubleValue();
                    }
                    case 9: {
                        return (String.valueOf(left) + String.valueOf(right)).intern();
                    }
                }
                return null;
            }
            case 31: {
                switch (promotedType) {
                    case 4: {
                        return ((Number)left).intValue() - ((Number)right).intValue();
                    }
                    case 5: {
                        return ((Number)left).longValue() - ((Number)right).longValue();
                    }
                    case 6: {
                        return Float.valueOf(((Number)left).floatValue() - ((Number)right).floatValue());
                    }
                    case 7: {
                        return ((Number)left).doubleValue() - ((Number)right).doubleValue();
                    }
                }
                return null;
            }
            case 28: {
                switch (ConstantExpressionEvaluator.unaryPromotedType(leftType)) {
                    case 4: {
                        if (rightType <= 5) {
                            return ((Number)left).intValue() << ((Number)right).intValue();
                        }
                        return null;
                    }
                    case 5: {
                        if (rightType <= 5) {
                            return ((Number)left).longValue() << ((Number)right).intValue();
                        }
                        return null;
                    }
                }
                return null;
            }
            case 51: {
                switch (ConstantExpressionEvaluator.unaryPromotedType(leftType)) {
                    case 4: {
                        if (rightType <= 5) {
                            return ((Number)left).intValue() >> ((Number)right).intValue();
                        }
                        return null;
                    }
                    case 5: {
                        if (rightType <= 5) {
                            return ((Number)left).longValue() >> ((Number)right).intValue();
                        }
                        return null;
                    }
                }
                return null;
            }
            case 56: {
                switch (ConstantExpressionEvaluator.unaryPromotedType(leftType)) {
                    case 4: {
                        if (rightType <= 5) {
                            return ((Number)left).intValue() >>> ((Number)right).intValue();
                        }
                        return null;
                    }
                    case 5: {
                        if (rightType <= 5) {
                            return ((Number)left).longValue() >>> ((Number)right).intValue();
                        }
                        return null;
                    }
                }
                return null;
            }
            case 30: {
                switch (promotedType) {
                    case 4: {
                        return ((Number)left).intValue() < ((Number)right).intValue();
                    }
                    case 5: {
                        return ((Number)left).longValue() < ((Number)right).longValue();
                    }
                    case 6: {
                        return ((Number)left).floatValue() < ((Number)right).floatValue();
                    }
                    case 7: {
                        return ((Number)left).doubleValue() < ((Number)right).doubleValue();
                    }
                }
                return null;
            }
            case 25: {
                switch (promotedType) {
                    case 4: {
                        return ((Number)left).intValue() <= ((Number)right).intValue();
                    }
                    case 5: {
                        return ((Number)left).longValue() <= ((Number)right).longValue();
                    }
                    case 6: {
                        return ((Number)left).floatValue() <= ((Number)right).floatValue();
                    }
                    case 7: {
                        return ((Number)left).doubleValue() <= ((Number)right).doubleValue();
                    }
                }
                return null;
            }
            case 22: {
                switch (promotedType) {
                    case 4: {
                        return ((Number)left).intValue() > ((Number)right).intValue();
                    }
                    case 5: {
                        return ((Number)left).longValue() > ((Number)right).longValue();
                    }
                    case 6: {
                        return ((Number)left).floatValue() > ((Number)right).floatValue();
                    }
                    case 7: {
                        return ((Number)left).doubleValue() > ((Number)right).doubleValue();
                    }
                }
                return null;
            }
            case 21: {
                switch (promotedType) {
                    case 4: {
                        return ((Number)left).intValue() >= ((Number)right).intValue();
                    }
                    case 5: {
                        return ((Number)left).longValue() >= ((Number)right).longValue();
                    }
                    case 6: {
                        return ((Number)left).floatValue() >= ((Number)right).floatValue();
                    }
                    case 7: {
                        return ((Number)left).doubleValue() >= ((Number)right).doubleValue();
                    }
                }
                return null;
            }
            case 20: {
                switch (promotedType) {
                    case 4: {
                        return ((Number)left).intValue() == ((Number)right).intValue();
                    }
                    case 5: {
                        return ((Number)left).longValue() == ((Number)right).longValue();
                    }
                    case 6: {
                        return ((Number)left).floatValue() == ((Number)right).floatValue();
                    }
                    case 7: {
                        return ((Number)left).doubleValue() == ((Number)right).doubleValue();
                    }
                    case 8: {
                        return leftType == rightType ? Boolean.valueOf(left.equals(right)) : null;
                    }
                    case 9: {
                        return leftType == rightType ? Boolean.valueOf(left == right) : null;
                    }
                }
                return null;
            }
            case 42: {
                switch (promotedType) {
                    case 4: {
                        return ((Number)left).intValue() != ((Number)right).intValue();
                    }
                    case 5: {
                        return ((Number)left).longValue() != ((Number)right).longValue();
                    }
                    case 6: {
                        return ((Number)left).floatValue() != ((Number)right).floatValue();
                    }
                    case 7: {
                        return ((Number)left).doubleValue() != ((Number)right).doubleValue();
                    }
                    case 8: {
                        return leftType == rightType ? Boolean.valueOf(!left.equals(right)) : null;
                    }
                    case 9: {
                        return leftType == rightType ? Boolean.valueOf(left != right) : null;
                    }
                }
                return null;
            }
            case 7: {
                switch (promotedType) {
                    case 4: {
                        return ((Number)left).intValue() & ((Number)right).intValue();
                    }
                    case 5: {
                        return ((Number)left).longValue() & ((Number)right).longValue();
                    }
                    case 8: {
                        return leftType == rightType ? Boolean.valueOf((Boolean)left & (Boolean)right) : null;
                    }
                }
                return null;
            }
            case 12: {
                switch (promotedType) {
                    case 4: {
                        return ((Number)left).intValue() ^ ((Number)right).intValue();
                    }
                    case 5: {
                        return ((Number)left).longValue() ^ ((Number)right).longValue();
                    }
                    case 8: {
                        return leftType == rightType ? Boolean.valueOf((Boolean)left ^ (Boolean)right) : null;
                    }
                }
                return null;
            }
            case 10: {
                switch (promotedType) {
                    case 4: {
                        return ((Number)left).intValue() | ((Number)right).intValue();
                    }
                    case 5: {
                        return ((Number)left).longValue() | ((Number)right).longValue();
                    }
                    case 8: {
                        return leftType == rightType ? Boolean.valueOf((Boolean)left | (Boolean)right) : null;
                    }
                }
                return null;
            }
            case 3: {
                switch (leftType) {
                    case 8: {
                        return rightType == 8 ? Boolean.valueOf((Boolean)left != false && (Boolean)right != false) : null;
                    }
                }
                return null;
            }
            case 43: {
                switch (leftType) {
                    case 8: {
                        return rightType == 8 ? Boolean.valueOf((Boolean)left != false || (Boolean)right != false) : null;
                    }
                }
                return null;
            }
        }
        return null;
    }

    private static class CharacterNumber
    extends Number {
        private final char value;

        public CharacterNumber(char value) {
            this.value = value;
        }

        public CharacterNumber(Character value) {
            this.value = value.charValue();
        }

        public char charValue() {
            return this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public int intValue() {
            return this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ConstantValue
    implements NodeBinding {
        private Object value;

        public ConstantValue(Object value) {
            assert (!(value instanceof Character));
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public int getBindingType() {
            return BINDING_CONSTANT;
        }
    }
}

