/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.common.QuickMethod;
import oracle.javatools.parser.java.v2.internal.compiler.ClassObj;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerLayer5j;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerUtilities;
import oracle.javatools.parser.java.v2.internal.compiler.ImportObj;
import oracle.javatools.parser.java.v2.internal.compiler.TypeVariableObj;
import oracle.javatools.parser.java.v2.internal.symbol.ClassBodySym;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.EnumConstantSym;
import oracle.javatools.parser.java.v2.internal.symbol.FormalsSym;
import oracle.javatools.parser.java.v2.internal.symbol.ImportSym;
import oracle.javatools.parser.java.v2.internal.symbol.MethodSym;
import oracle.javatools.parser.java.v2.internal.symbol.NameSym;
import oracle.javatools.parser.java.v2.internal.symbol.RecordComponentSym;
import oracle.javatools.parser.java.v2.internal.symbol.RecordHeaderSym;
import oracle.javatools.parser.java.v2.internal.symbol.RootSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeParameterSym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ListExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.SwitchExpr;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassInitializer;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceEnumConstant;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSwitchExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchLabel;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceYieldStatement;
import oracle.javatools.parser.java.v2.util.Conversions;
import oracle.javatools.parser.java.v2.util.SourceVisitor;

abstract class CompilerLayer5
extends CompilerLayer5j {
    CompilerLayer5() {
    }

    public final void compile(RootSym rootSym) {
        HashSet<String> importNames = new HashSet<String>();
        importNames.add("java.lang.*");
        List<SourceImport> importSyms = rootSym.getSourceImports();
        HashMap<String, ImportSym> narrowNames = new HashMap<String, ImportSym>(importSyms.size());
        for (ImportSym importSym : importSyms) {
            String name = importSym.getName();
            if (importNames.contains(name)) {
                importSym.setInvalid();
            }
            importNames.add(name);
            if (!importSym.isNarrow()) continue;
            int lastDot = name.lastIndexOf(46);
            String lastname = name.substring(lastDot + 1);
            ImportSym foundImport = (ImportSym)narrowNames.get(lastname);
            if (foundImport != null) {
                if (!foundImport.isInvalid()) {
                    foundImport.setInvalid();
                    this.error(foundImport, (short)40, name);
                }
                importSym.setInvalid();
                this.error(importSym, (short)40, name);
            }
            narrowNames.put(lastname, foundImport);
        }
        for (ImportSym importSym : importSyms) {
            if (importSym.isInvalid()) continue;
            ImportObj importObj = importSym.getImportObj();
            if (importSym.isUsed()) {
                int size;
                if (importObj.importList == null) continue;
                if (importObj.importResults != null) {
                    CompilerLayer5.panic(importSym);
                }
                importObj.importResults = (size = importObj.importList.size()) == 0 ? JavaHasType.EMPTY_ARRAY : importObj.importList.toArray(new JavaHasType[size]);
                importObj.importList = null;
                continue;
            }
            this.error(importSym, (short)77);
        }
        this.processClassDuplicates(rootSym.getSourceClasses());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JavaElement resolve(ImportSym importSym) {
        ImportObj importObj = importSym.getImportObj();
        if (importObj.flag_resolved) {
            return importSym;
        }
        try {
            boolean errorFound;
            if (importSym.isInvalid()) {
                ImportSym importSym2 = importSym;
                return importSym2;
            }
            String name = importSym.getName();
            if (name.length() == 0) {
                ImportSym importSym3 = importSym;
                return importSym3;
            }
            if (importSym.isStatic()) {
                String qualifier;
                JavaClass qualifyingType;
                errorFound = true;
                int lastDot = name.lastIndexOf(46);
                if (lastDot != -1 && (qualifyingType = this.provider.getClass(qualifier = name.substring(0, lastDot))) != null) {
                    importObj.importQualifyingType = qualifyingType;
                    errorFound = false;
                }
            } else {
                errorFound = false;
                if (importSym.isNarrow()) {
                    JavaClass result = this.provider.getClass(name);
                    if (result != null) {
                        importObj.importResults = new JavaHasType[]{result};
                    } else {
                        errorFound = true;
                    }
                }
            }
            if (errorFound) {
                importSym.setInvalid();
                importObj.importResults = JavaHasType.EMPTY_ARRAY;
                this.error(importSym, (short)54, name);
            }
            if (!importSym.isInvalid() && importObj.importResults == null) {
                importObj.importList.clear();
            } else {
                importObj.importList = null;
            }
            ImportSym importSym4 = importSym;
            return importSym4;
        }
        finally {
            importObj.flag_resolved = true;
        }
    }

    public final JavaClass resolve(ClassSym classSym) {
        ClassObj classObj = classSym.getClassObj();
        if (classObj.flag_resolved) {
            return classSym;
        }
        JavaType superclass = null;
        TypeSym tySuper = classSym.superType;
        if (tySuper != null) {
            tySuper.resolve((CompilerDriver)this);
            JavaType resolved = tySuper.getResolvedType();
            if (resolved != null) {
                if (resolved.getElementKind() != 3) {
                    this.error(tySuper, (short)51);
                }
                if (!resolved.isInterface()) {
                    superclass = resolved;
                }
            }
        }
        if (superclass == null) {
            superclass = this.resolveSuperclass(classSym);
        }
        classObj.typeSuperclass = superclass;
        if (classSym.hasInterfaces()) {
            for (SourceTypeReference sourceTypeReference : classSym.getSourceInterfaces()) {
                TypeSym sym = (TypeSym)sourceTypeReference;
                sym.resolve((CompilerDriver)this);
            }
        }
        if (this.needsClinitMethod(classSym)) {
            classObj.classClinit = QuickMethod.createMethod(classSym, '\b', null, "<clinit>", null, null);
        }
        classObj.typeHierarchy = null;
        classObj.resolveSelfTypes((CompilerDriver)this);
        classObj.flag_resolved = true;
        return classSym;
    }

    private boolean checkClassCircularity(ClassSym originalClass, JavaType currentClass, Set<Object> processed) {
        if (CommonUtilities.classProcessed(processed, currentClass)) {
            if (CommonUtilities.equals(currentClass, originalClass)) {
                this.error(originalClass, (short)50);
                return true;
            }
            return false;
        }
        if (originalClass.isInterface()) {
            for (JavaType baseInterface : currentClass.getInterfaces()) {
                if (!this.checkClassCircularity(originalClass, baseInterface, processed)) continue;
                return true;
            }
        } else {
            JavaType baseClass = currentClass.getSuperclass();
            if (baseClass != null && this.checkClassCircularity(originalClass, baseClass, processed)) {
                return true;
            }
        }
        return false;
    }

    public final void compile(ClassSym classSym) {
        assert (!this.skipCompilations());
        this.checkClassCircularity(classSym, classSym, new HashSet<Object>());
    }

    public final JavaElement compile(ClassBodySym sym) {
        assert (!this.skipCompilations());
        this.processDuplicates(sym.getSourceFieldVariables());
        this.processMethodDuplicates(sym.getSourceMethods());
        this.processMethodDuplicates(sym.getSourceConstructors());
        this.processClassDuplicates(sym.getSourceClasses());
        return sym;
    }

    public final void compile(MethodSym sym) {
        JavaType paramType;
        SourceVariable firstParameter;
        List<SourceVariable> parameters;
        boolean canOmitBodies;
        assert (!this.skipCompilations());
        boolean bl = canOmitBodies = (sym.getModifiers() & 0x500) != 0;
        if (!canOmitBodies && sym.getBlock() == null) {
            Sym cookie = sym;
            NameSym nameSym = sym.getNameSym();
            if (nameSym != null) {
                cookie = nameSym;
            }
            this.error(cookie, (short)80);
        }
        JavaClass owningClass = sym.getOwningClass();
        if (sym.symKind == 19 && owningClass != null) {
            boolean hasOverriddenMethods = false;
            Collection<JavaMethod> superMethods = CommonUtilities.getMethods(owningClass, sym.getName());
            for (JavaMethod superMethod : superMethods) {
                if (superMethod == sym || owningClass == superMethod.getOwningClass() || !Conversions.hasSubsignatureOf(sym, superMethod)) continue;
                if (CommonUtilities.hasOverrideCompatibleVisibility(sym, superMethod)) {
                    if (!Conversions.isReturnTypeSubstitutable(sym, superMethod)) {
                        this.error(sym, (short)105, superMethod);
                        break;
                    }
                    if (CommonUtilities.methodThrowsMoreCheckedExceptions(sym, superMethod)) {
                        this.error(sym, (short)106, superMethod);
                        break;
                    }
                    hasOverriddenMethods = true;
                    continue;
                }
                if (!CompilerUtilities.methodHasWeakerAccess(sym, superMethod) || superMethod.isPackagePrivate() && sym.isPrivate()) continue;
                this.error(sym, (short)104, superMethod);
                break;
            }
            this.checkForIllegalOverride(sym, hasOverriddenMethods);
        } else if (sym.symKind == 6) {
            this.checkForIllegalOverride(sym, false);
        }
        JavaClass cls = sym.getOwningClass();
        if (cls != null && cls.isAnnotation()) {
            JavaType defaultValueType;
            Expr defaultValueSym;
            JavaType methodType = sym.getReturnType();
            if (!this.validAnnotationElementType(methodType)) {
                TypeSym errorSymbol = sym.getTypeSym();
                this.error(errorSymbol, (short)112, sym.getReturnType());
            }
            if ((defaultValueSym = sym.getDefaultValueSym()) != null && (defaultValueType = defaultValueSym.getResolvedType()) != null && methodType != null && !methodType.isAssignableFrom(defaultValueType)) {
                this.error(defaultValueSym, (short)43, defaultValueType, methodType);
            }
        } else if (cls != null && this.jdkVersion.isGreaterThanOrEqualTo8() && (parameters = sym.getSourceParameters()).size() > 0 && "this".equals((firstParameter = parameters.get(0)).getName()) && (paramType = firstParameter.getResolvedType()) != null && !paramType.equals(cls)) {
            this.error((Sym)((Object)firstParameter), (short)124);
        }
    }

    private boolean validAnnotationElementType(JavaType javaType) {
        if (javaType == null) {
            return true;
        }
        if (javaType.isArray()) {
            return this.validAnnotationElementType(javaType.getBaseComponentType());
        }
        if (javaType.isPrimitive() || javaType.isEnum() || javaType.isAnnotation()) {
            return true;
        }
        if ("java.lang.String".equals(javaType.getRawName())) {
            return true;
        }
        return "java.lang.Class".equals(javaType.getRawName());
    }

    public final JavaTypeVariable resolve(TypeParameterSym parameterSym) {
        TypeVariableObj typeObj = parameterSym.getTypeVariableObj();
        if (typeObj.flag_resolved) {
            return parameterSym;
        }
        this.resolveBounds(parameterSym);
        typeObj.typeHierarchy = null;
        parameterSym.setProcessed();
        typeObj.flag_resolved = true;
        return parameterSym;
    }

    public final JavaTypeVariable compile(TypeParameterSym parameterSym) {
        assert (!this.skipCompilations());
        TypeVariableObj typeObj = parameterSym.getTypeVariableObj();
        if (!typeObj.flag_resolved) {
            this.resolve(parameterSym);
        }
        if (typeObj.flag_compiled) {
            return parameterSym;
        }
        typeObj.flag_compiled = true;
        return parameterSym;
    }

    public final JavaElement compile(FormalsSym sym) {
        assert (!this.skipCompilations());
        if (sym.getChild((byte)13) != null) {
            this.processDuplicates(sym.getChildren(13));
        }
        return sym;
    }

    public final JavaMethod resolve(MethodSym sym) {
        if (sym.isProcessed()) {
            return sym;
        }
        sym.setProcessed();
        return sym;
    }

    private void checkForIllegalOverride(MethodSym sym, boolean hasOverriddenMethods) {
        List<SourceAnnotation> annotations = sym.getSourceAnnotations();
        for (SourceAnnotation annotation : annotations) {
            JavaType annotationType = annotation.getResolvedType();
            if (annotationType == null || !"java.lang.Override".equals(annotationType.getQualifiedName()) || hasOverriddenMethods || this.isObjectMethodOverrideInInterface(sym)) continue;
            this.error((Sym)((Object)annotation), (short)107);
            break;
        }
    }

    private boolean isObjectMethodOverrideInInterface(MethodSym sym) {
        JavaClass owner = sym.getOwningClass();
        if (owner != null && owner.isInterface() && !owner.isAnnotation() && owner.getInterfaces().isEmpty()) {
            JavaClass objectClazz = this.provider.getClassByVMName("java/lang/Object");
            String thisMethodName = sym.getName();
            if (objectClazz != null && thisMethodName != null) {
                Collection<JavaMethod> objectMethods = objectClazz.getDeclaredMethods();
                for (JavaMethod objectMethod : objectMethods) {
                    JavaType[] objectMethodParameterTypes;
                    if (objectMethod.isConstructor() || !objectMethod.isPublic() || !thisMethodName.equals(objectMethod.getName()) || !CommonUtilities.matchMethod(sym, objectMethodParameterTypes = objectMethod.getParameterTypes())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JavaMethod resolve(EnumConstantSym sym) {
        JavaMethod result;
        if (sym.isProcessed()) {
            return null;
        }
        Object[] argumentsAndTypes = this.getArgumentsAndTypes(sym);
        JavaHasType[] arguments = (JavaHasType[])argumentsAndTypes[0];
        JavaType[] argumentTypes = (JavaType[])argumentsAndTypes[1];
        CompilerContext savedContext = this.getCompilerContext();
        try {
            CompilerContext context = this.newContext(sym);
            this.setCompilerContext(context);
            result = context.findMethod(null, sym.getResolvedType(), "<init>", null, arguments, argumentTypes, null);
        }
        finally {
            this.setCompilerContext(savedContext);
        }
        sym.setProcessed();
        return result;
    }

    private Object[] getArgumentsAndTypes(EnumConstantSym sym) {
        JavaType[] argumentTypes;
        JavaHasType[] arguments;
        ListExpr argumentsSym = sym.getArgumentsSym();
        if (argumentsSym != null) {
            arguments = new JavaHasType[argumentsSym.getOperandCount()];
            argumentTypes = this.getArgumentTypes(argumentsSym, null);
            for (int i = 0; i < arguments.length; ++i) {
                arguments[i] = argumentsSym.getOperandAt(i);
            }
        } else {
            arguments = new JavaHasType[]{};
            argumentTypes = new JavaType[]{};
        }
        return new Object[]{arguments, argumentTypes};
    }

    public final void compile(RecordHeaderSym sym) {
        assert (!this.skipCompilations());
        HashSet<String> names = new HashSet<String>();
        for (RecordComponentSym component : sym.getComponents()) {
            String name;
            switch (name = component.getName()) {
                case "clone": 
                case "finalize": 
                case "getClass": 
                case "hashCode": 
                case "notify": 
                case "notifyAll": 
                case "toString": 
                case "wait": {
                    this.error(sym.getNameSym(), (short)137, name);
                }
            }
            if (names.add(name)) continue;
            this.error(component, (short)52, name);
        }
    }

    public final void compile(EnumConstantSym sym) {
        String name;
        assert (!this.skipCompilations());
        JavaMethod constructor = sym.getCompiledObject();
        if (constructor == null) {
            JavaElement owner;
            Object[] argumentsAndTypes = this.getArgumentsAndTypes(sym);
            String errorName = sym.getName();
            for (owner = sym.getOwner(); owner != null; owner = owner.getOwner()) {
                if (!(owner instanceof ClassSym)) continue;
                errorName = ((ClassSym)owner).getName();
                break;
            }
            this.error(sym, (short)60, errorName, argumentsAndTypes[1], owner != null ? owner : sym, null);
        }
        if ((name = sym.getName()) != null && name.length() > 0) {
            block1: for (Sym parentSym = sym.getParentSym(); parentSym != null; parentSym = parentSym.getParentSym()) {
                if (!(parentSym instanceof ClassBodySym)) continue;
                ClassBodySym classBodySym = (ClassBodySym)parentSym;
                List<SourceEnumConstant> enums = classBodySym.getSourceEnumConstants();
                for (EnumConstantSym enumConstantSym : enums) {
                    if (enumConstantSym == sym || !enumConstantSym.isProcessed() || !name.equals(enumConstantSym.getName())) continue;
                    this.error(sym, (short)52, name, enumConstantSym);
                    break block1;
                }
                break;
            }
        }
    }

    public JavaHasType resolve(SwitchExpr switchExpression) {
        JavaType targetType;
        this.compileSwitchElement(switchExpression);
        Collection<JavaType> targetTypes = CommonUtilities.getTargetType(switchExpression, null);
        JavaType javaType = targetType = targetTypes.isEmpty() ? null : targetTypes.iterator().next();
        if (targetType != null) {
            return targetType.getThisValue();
        }
        final ArrayList<JavaType> resultTypes = new ArrayList<JavaType>();
        final ArrayList<Object> constantValues = new ArrayList<Object>();
        for (SourceSwitchLabel label : switchExpression.getSwitchLabels()) {
            if (label.hasRule()) {
                SourceElement element = label.getRuleElement();
                if (element instanceof SourceExpression) {
                    SourceExpression expression = (SourceExpression)element;
                    this.collectTypes(expression, expression, targetType, resultTypes, constantValues);
                    continue;
                }
                if (!(element instanceof SourceBlock)) continue;
                SourceBlock block = (SourceBlock)element;
                block.visitSelf(new SourceVisitor<SourceBlock>(){

                    @Override
                    public void whenEnterYieldStatement(SourceYieldStatement statement) {
                        CompilerLayer5.this.collectTypes(statement, statement.getExpression(), targetType, resultTypes, constantValues);
                    }

                    @Override
                    public void whenEnterSwitchStatement(SourceSwitchStatement statement) {
                        this.cancelSubtree();
                    }

                    @Override
                    public void whenEnterSwitchExpression(SourceSwitchExpression expression) {
                        this.cancelSubtree();
                    }
                });
                continue;
            }
            List<SourceElement> elements = label.getStatementGroupElements();
            for (SourceElement element : elements) {
                element.visitSelf(new SourceVisitor<SourceElement>(){

                    @Override
                    public void whenEnterYieldStatement(SourceYieldStatement statement) {
                        CompilerLayer5.this.collectTypes(statement, statement.getExpression(), targetType, resultTypes, constantValues);
                    }

                    @Override
                    public void whenEnterSwitchStatement(SourceSwitchStatement statement) {
                        this.cancelSubtree();
                    }

                    @Override
                    public void whenEnterSwitchExpression(SourceSwitchExpression expression) {
                        this.cancelSubtree();
                    }
                });
            }
        }
        HashSet uniqueResultTypes = new HashSet(resultTypes);
        Set<JavaType> booleanTypes = this.booleanTypesSet();
        Set<JavaType> numericTypes = this.numericTypesSet();
        if (uniqueResultTypes.size() == 1) {
            return ((JavaType)resultTypes.iterator().next()).getThisValue();
        }
        if (resultTypes.equals(booleanTypes)) {
            return booleanTypes.iterator().next().getThisValue();
        }
        if (uniqueResultTypes.stream().allMatch(t -> numericTypes.contains(t))) {
            Integer i;
            int value;
            PrimitiveType resolvedType;
            if (uniqueResultTypes.size() == 1) {
                return ((JavaType)uniqueResultTypes.iterator().next()).getThisValue();
            }
            Set uniqueUnboxedTypes = uniqueResultTypes.stream().map(t -> PrimitiveType.applyUnboxingConversion(t).getName()).collect(Collectors.toSet());
            if (uniqueUnboxedTypes.contains("double")) {
                return PrimitiveType.lookupPrimitive("double").getThisValue();
            }
            if (uniqueUnboxedTypes.contains("float")) {
                return PrimitiveType.lookupPrimitive("float").getThisValue();
            }
            if (uniqueUnboxedTypes.contains("long")) {
                return PrimitiveType.lookupPrimitive("long").getThisValue();
            }
            PrimitiveType INT_TYPE = PrimitiveType.getPrimitiveType(4);
            PrimitiveType SHORT_TYPE = PrimitiveType.getPrimitiveType(3);
            PrimitiveType BYTE_TYPE = PrimitiveType.getPrimitiveType(1);
            PrimitiveType CHAR_TYPE = PrimitiveType.getPrimitiveType(2);
            HashSet<Object> uniqueConstantValues = new HashSet<Object>(constantValues);
            if (uniqueUnboxedTypes.contains("int") && uniqueConstantValues.contains(null)) {
                return INT_TYPE.getThisValue();
            }
            if (uniqueUnboxedTypes.contains("short") && !uniqueUnboxedTypes.contains("char")) {
                resolvedType = SHORT_TYPE;
                if (!uniqueUnboxedTypes.contains("int")) {
                    return resolvedType.getThisValue();
                }
                for (Object e : uniqueConstantValues) {
                    if (!(e instanceof Integer) || (value = (i = (Integer)e).intValue()) >= Short.MIN_VALUE && value <= Short.MAX_VALUE) continue;
                    resolvedType = null;
                }
                if (resolvedType != null) {
                    return resolvedType.getThisValue();
                }
            }
            if (uniqueUnboxedTypes.contains("byte") && !uniqueUnboxedTypes.contains("short") && !uniqueUnboxedTypes.contains("char")) {
                resolvedType = BYTE_TYPE;
                if (!uniqueUnboxedTypes.contains("int")) {
                    return resolvedType.getThisValue();
                }
                for (Object e : uniqueConstantValues) {
                    if (!(e instanceof Integer) || (value = (i = (Integer)e).intValue()) >= -128 && value <= 127) continue;
                    resolvedType = null;
                }
                if (resolvedType != null) {
                    return resolvedType.getThisValue();
                }
            }
            if (uniqueUnboxedTypes.contains("char") && !uniqueUnboxedTypes.contains("short") && !uniqueUnboxedTypes.contains("byte")) {
                resolvedType = CHAR_TYPE;
                if (!uniqueUnboxedTypes.contains("int")) {
                    return resolvedType.getThisValue();
                }
                for (Object e : uniqueConstantValues) {
                    if (!(e instanceof Integer) || (value = (i = (Integer)e).intValue()) >= 0 && value <= 65535) continue;
                    resolvedType = null;
                }
                if (resolvedType != null) {
                    return resolvedType.getThisValue();
                }
            }
            return INT_TYPE.getThisValue();
        }
        Set uniqueBoxedTypes = uniqueResultTypes.stream().map(t -> t.isPrimitive() ? Conversions.applyBoxingConversion(t, (JavaProvider)this.provider, this.jdkVersion) : t).collect(Collectors.toSet());
        Iterator iterator = uniqueBoxedTypes.iterator();
        if (uniqueBoxedTypes.size() == 1) {
            return ((JavaType)iterator.next()).getThisValue();
        }
        JavaType lub = (JavaType)iterator.next();
        while (iterator.hasNext()) {
            lub = CompilerUtilities.leastUpperBound(this.provider, lub, (JavaType)iterator.next());
        }
        while (iterator.hasNext()) {
        }
        return lub.getThisValue();
    }

    private Set<JavaType> numericTypesSet() {
        PrimitiveType BYTE = PrimitiveType.getPrimitiveType(1);
        PrimitiveType SHORT = PrimitiveType.getPrimitiveType(3);
        PrimitiveType CHAR = PrimitiveType.getPrimitiveType(2);
        PrimitiveType INT = PrimitiveType.getPrimitiveType(4);
        PrimitiveType LONG = PrimitiveType.getPrimitiveType(5);
        PrimitiveType FLOAT = PrimitiveType.getPrimitiveType(6);
        PrimitiveType DOUBLE = PrimitiveType.getPrimitiveType(7);
        HashSet<JavaType> numerics = new HashSet<JavaType>();
        numerics.add(BYTE);
        numerics.add(SHORT);
        numerics.add(CHAR);
        numerics.add(INT);
        numerics.add(LONG);
        numerics.add(FLOAT);
        numerics.add(DOUBLE);
        numerics.add(PrimitiveType.applyBoxingConversion(BYTE, this.provider, this.jdkVersion));
        numerics.add(PrimitiveType.applyBoxingConversion(SHORT, this.provider, this.jdkVersion));
        numerics.add(PrimitiveType.applyBoxingConversion(CHAR, this.provider, this.jdkVersion));
        numerics.add(PrimitiveType.applyBoxingConversion(INT, this.provider, this.jdkVersion));
        numerics.add(PrimitiveType.applyBoxingConversion(LONG, this.provider, this.jdkVersion));
        numerics.add(PrimitiveType.applyBoxingConversion(FLOAT, this.provider, this.jdkVersion));
        numerics.add(PrimitiveType.applyBoxingConversion(DOUBLE, this.provider, this.jdkVersion));
        return numerics;
    }

    private Set<JavaType> booleanTypesSet() {
        PrimitiveType BOOLEAN = PrimitiveType.getPrimitiveType(0);
        LinkedHashSet<JavaType> booleans = new LinkedHashSet<JavaType>();
        booleans.add(BOOLEAN);
        booleans.add(PrimitiveType.applyBoxingConversion(BOOLEAN, this.provider, this.jdkVersion));
        return booleans;
    }

    private void collectTypes(SourceElement element, SourceExpression expression, JavaType targetType, List<JavaType> resultTypes, List<Object> constantValues) {
        JavaType elementType = expression.getResolvedType();
        Object constantValue = expression.getConstantValue();
        if (targetType == null) {
            resultTypes.add(elementType);
            constantValues.add(constantValue);
        } else if (!Conversions.applyAssignmentConversion(elementType, expression, targetType, constantValue != null, this.provider, this.jdkVersion)) {
            this.error((Sym)element, (short)133, targetType, elementType);
        }
    }

    private JavaType resolveSuperclass(ClassSym classSym) {
        JavaType superclass = null;
        switch (classSym.getClassKind()) {
            case CLASS: {
                if (!"java.lang.Object".equals(classSym.getRawName())) break;
                return null;
            }
            case RECORD: {
                superclass = this.getSystemClass("java/lang/Record");
                break;
            }
            case ENUM: {
                JavaType[] bounds;
                JavaClass enumType = this.provider.getClassByVMName("java/lang/Enum");
                if (enumType == null || (superclass = CommonUtilities.createParameterizedType(this.provider, enumType, bounds = new JavaType[]{classSym})) != null) break;
                superclass = enumType;
                break;
            }
            case INTERFACE: {
                return null;
            }
            case ANNOTATION: {
                superclass = this.getSystemClass("java/lang/annotation/Annotation");
            }
        }
        if (superclass == null) {
            Sym parentSym;
            JavaType type;
            TypeSym typeSym = (TypeSym)classSym.getSourceSuperclass();
            if (typeSym != null && (type = (JavaType)typeSym.resolve((CompilerDriver)this)) != null) {
                return type;
            }
            if (classSym.isAnonymousClass() && (parentSym = classSym.getParentSym()) != null && parentSym.symKind == 7) {
                superclass = classSym.getOwningClassSym();
            }
            if (superclass == null) {
                superclass = this.getPreloadedClass((byte)4);
            }
        }
        return superclass;
    }

    private void resolveBounds(TypeParameterSym parameterSym) {
        TypeVariableObj obj = parameterSym.getTypeVariableObj();
        obj.typeSuperclass = null;
        obj.typeInterfaces = Collections.emptyList();
        boolean circularityError = false;
        if (CommonUtilities.hasBoundsCircularity(parameterSym)) {
            circularityError = true;
            this.error(parameterSym, (short)53);
        }
        TypeSym firstBound = parameterSym.getFirstBoundSym();
        if (!circularityError && firstBound != null) {
            List<SourceTypeReference> bounds = parameterSym.getSourceBounds();
            if (bounds.size() == 1) {
                JavaType type = firstBound.getResolvedType();
                if (type != null) {
                    if (!type.isInterface()) {
                        obj.typeSuperclass = type;
                    } else {
                        obj.typeInterfaces = Arrays.asList(type);
                    }
                }
            } else {
                JavaType firstType;
                ArrayList<JavaType> list = new ArrayList<JavaType>();
                list.addAll(parameterSym.getObjects((byte)27));
                if (!list.isEmpty() && !(firstType = (JavaType)list.get(0)).isInterface()) {
                    obj.typeSuperclass = firstType;
                    list.remove(0);
                }
                obj.typeInterfaces = list;
            }
        }
        if (obj.typeSuperclass == null) {
            obj.typeSuperclass = this.getPreloadedClass((byte)4);
        }
    }

    private boolean needsClinitMethod(ClassSym classSym) {
        if (!classSym.getSourceEnumConstants().isEmpty()) {
            return true;
        }
        for (SourceFieldVariable field : classSym.getSourceFieldVariables()) {
            if (!field.isStatic() || field.getInitializer() == null) continue;
            return true;
        }
        for (SourceClassInitializer initializer : classSym.getSourceInitializers()) {
            if (!initializer.isStatic()) continue;
            return true;
        }
        return false;
    }

    protected final void processClassDuplicates(Collection<SourceClass> classes) {
        if (this.skipCompilations()) {
            return;
        }
        HashMap<String, SourceClass> previousClasses = new HashMap<String, SourceClass>();
        for (SourceClass sourceClass : classes) {
            String name = sourceClass.getName();
            SourceClass previous = (SourceClass)previousClasses.get(name);
            if (previous != null) {
                this.error((Sym)((Object)sourceClass), (short)52, name, previous);
                continue;
            }
            previousClasses.put(name, sourceClass);
        }
    }
}

