/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.IntersectionType;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerLayer3b;
import oracle.javatools.parser.java.v2.internal.symbol.AnnotateSym;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.AnnotateExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ArrayAccessExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ArrayCreatorExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.AssignExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ClassCreatorExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.Expr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.InfixExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.IntersectionTypeExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ListExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.LiteralExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.QuestionExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.TypeExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.TypecastExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.UnaryExpr;
import oracle.javatools.parser.java.v2.internal.symbol.expr.WrapperExpr;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.expression.CompiledTmpVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLambdaExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceQuestionExpression;
import oracle.javatools.parser.java.v2.scanner.LexerLiteral;
import oracle.javatools.parser.java.v2.util.Conversions;

abstract class CompilerLayer3c
extends CompilerLayer3b {
    private static final byte PRIMOP_ADD = 0;
    private static final byte PRIMOP_ARITHMETIC = 1;
    private static final byte PRIMOP_BITWISE = 2;
    private static final byte PRIMOP_LOGICAL = 3;
    private static final byte BINOP_ASSIGNMENT = 0;
    private static final byte BINOP_COMPARISON = 1;
    private static final byte BINOP_EQUALITY = 2;
    private static final byte BINOP_SHIFT = 3;

    CompilerLayer3c() {
    }

    public final JavaHasType resolve(LiteralExpr e) {
        JavaClass type;
        LexerLiteral literal = e.getLiteral();
        if (literal == null) {
            return null;
        }
        switch (literal.getTokenValue()) {
            case 8: {
                type = PrimitiveType.PRIMITIVE_objects[4];
                break;
            }
            case 9: {
                type = PrimitiveType.PRIMITIVE_objects[5];
                break;
            }
            case 10: {
                type = PrimitiveType.PRIMITIVE_objects[6];
                break;
            }
            case 11: {
                type = PrimitiveType.PRIMITIVE_objects[7];
                break;
            }
            case 12: {
                type = PrimitiveType.PRIMITIVE_objects[0];
                break;
            }
            case 13: {
                type = PrimitiveType.PRIMITIVE_objects[2];
                break;
            }
            case 15: {
                type = PrimitiveType.PRIMITIVE_objects[8];
                break;
            }
            case 14: {
                type = this.getPreloadedClass((byte)6);
                break;
            }
            default: {
                CompilerLayer3c.panic(e);
                return null;
            }
        }
        return type != null ? type.getThisValue() : null;
    }

    public final JavaHasType resolve(AnnotateExpr e) {
        AnnotateSym annotateSym = e.getAnnotateSym();
        if (annotateSym == null) {
            return null;
        }
        return (JavaAnnotation)annotateSym.resolve((CompilerDriver)this);
    }

    public final JavaHasType resolve(TypeExpr e) {
        TypeSym typeSym = e.getTypeSym();
        if (typeSym == null) {
            return null;
        }
        return (JavaType)typeSym.resolve((CompilerDriver)this);
    }

    public final JavaHasType resolve(IntersectionTypeExpr e) {
        JavaType finalType = null;
        List<SourceExpression> typeCastExprs = e.getOperands();
        ArrayList<JavaType> typeCasts = new ArrayList<JavaType>(typeCastExprs.size());
        Iterator<SourceExpression> iter = typeCastExprs.iterator();
        while (iter.hasNext()) {
            JavaType typeCast = iter.next().getResolvedType();
            if (typeCast == null) continue;
            typeCasts.add(typeCast);
        }
        finalType = typeCasts.isEmpty() ? null : (typeCasts.size() == 1 ? (JavaType)typeCasts.get(0) : new IntersectionType(typeCasts, this.provider));
        return finalType;
    }

    public final JavaHasType resolve(WrapperExpr e) {
        return this.processNthOperand(e, 0);
    }

    public final JavaHasType resolve(ListExpr e) {
        if (e.exprOptcode != 5) {
            return null;
        }
        if (!this.skipCompilations()) {
            Sym grandParent;
            boolean hasError = false;
            Sym parentSym = e.getParentSym();
            if (parentSym != null && parentSym.symKind == 71 && (grandParent = parentSym.getParentSym()) != null && (grandParent.symKind == 73 || grandParent.symKind == 75)) {
                this.error(e, (short)119);
                hasError = true;
            }
            if (!hasError) {
                JavaType targetType = null;
                Collection<JavaType> targetTypes = CommonUtilities.getTargetType(e, null);
                if (targetTypes.size() > 0) {
                    targetType = targetTypes.iterator().next();
                }
                if (targetType != null) {
                    if (!targetType.isArray()) {
                        this.error(e, (short)116);
                    } else if ((targetType = targetType.getComponentType()) != null) {
                        for (Expr expr : e.getOperands()) {
                            boolean constantValue;
                            if (expr == null || expr.exprOptcode == 5) continue;
                            JavaType thisTargetType = this.checkForLambdaLhs(expr, targetType);
                            JavaType exprJavaType = expr.getResolvedType();
                            if (Conversions.applyAssignmentConversion(exprJavaType, thisTargetType, constantValue = expr.getConstantValue() != null, this.provider)) continue;
                            this.error(expr, (short)116);
                        }
                    }
                }
            }
        }
        int dimension = this.getDimension(e, 1);
        PrimitiveType nullType = PrimitiveType.PRIMITIVE_objects[8];
        return this.provider.getArrayType(nullType, dimension).getThisValue();
    }

    private int getDimension(SourceExpression expr, int dimension) {
        int innerDimension = 0;
        int operandCount = expr.getOperandCount();
        for (int x = 0; x < operandCount; ++x) {
            SourceExpression operand = expr.getOperandAt(x);
            if (operand == null || operand.getExpressionCode() != 5) continue;
            innerDimension = this.getDimension(operand, dimension);
        }
        return dimension + innerDimension;
    }

    public final JavaHasType resolve(QuestionExpr e) {
        return this.handleQuestion(e);
    }

    public final JavaHasType resolve(TypecastExpr e) {
        return this.handleTypecast(e);
    }

    public final JavaHasType resolve(ArrayAccessExpr e) {
        return this.handleArrayDereference(e);
    }

    public final JavaHasType resolve(ArrayCreatorExpr e) {
        int operandCount;
        TypeSym typeSym = e.getTypeSym();
        JavaType type = typeSym.getResolvedType();
        if (type == null) {
            return null;
        }
        Expr list = e.getNthOperandSym(0);
        if (list.getExpressionCode() == 26 && (operandCount = list.getOperandCount()) > 0) {
            type = CompilerLayer3c.createArrayType(this.provider, type, list.getOperandCount());
        }
        return type.getThisValue();
    }

    public final JavaHasType resolve(AssignExpr e) {
        return this.processInfix(e);
    }

    public final JavaHasType resolve(InfixExpr e) {
        return this.processInfix(e);
    }

    public final JavaHasType resolve(UnaryExpr e) {
        JavaType type;
        int op = e.getOperatorCode();
        switch (op) {
            case 37: 
            case 44: {
                type = this.handlePrimitiveOperator(e, (byte)1);
                break;
            }
            case 41: {
                type = this.handlePrimitiveOperator(e, (byte)3);
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                type = this.handlePrePostIncPrePostDec(e);
                break;
            }
            case 9: {
                type = this.handlePrimitiveOperator(e, (byte)2);
                break;
            }
            case 50: {
                return this.handleQualifiedThis(e);
            }
            case 49: {
                return this.handleQualifiedSuper(e);
            }
            case 14: {
                type = this.handleClassLiteral(e);
                break;
            }
            default: {
                CompilerLayer3c.panic(e);
                return null;
            }
        }
        if (type != null) {
            return type.getThisValue();
        }
        return null;
    }

    private JavaHasType processNthOperand(Expr e, int n) {
        int elementKind;
        JavaHasType finalHasType;
        Expr opnp = (Expr)e.getNthChild((byte)108, n);
        if (opnp == null) {
            return null;
        }
        JavaHasType javaHasType = this.processExpression(opnp);
        Expr finalOpnp = opnp;
        block4: while (finalOpnp != null) {
            switch (finalOpnp.symKind) {
                case 79: {
                    finalOpnp = (Expr)finalOpnp.getSecondOperand();
                    continue block4;
                }
                case 81: {
                    finalOpnp = (Expr)finalOpnp.getFirstOperand();
                    continue block4;
                }
            }
        }
        JavaHasType javaHasType2 = finalHasType = finalOpnp != null ? this.processExpression(finalOpnp) : null;
        if (!this.skipCompilations() && finalOpnp != null && finalOpnp.getOperatorCode() != 16 && finalHasType != null && opnp.flag_lvalue() && (elementKind = finalHasType.getElementKind()) != 5 && elementKind != 7 && elementKind != 4) {
            this.error(e, (short)114);
        }
        return javaHasType;
    }

    private JavaType processNthOperandType(Expr e, int n) {
        JavaHasType result = this.processNthOperand(e, n);
        return this.processHasType(result, false);
    }

    private JavaType processHasType(JavaHasType hasType, boolean resolveMethodTypeParams) {
        if (hasType != null) {
            JavaMethod method;
            if (resolveMethodTypeParams && hasType.getElementKind() == 8 && (method = (JavaMethod)hasType).hasTypeParameters() && !method.hasActualTypeArguments()) {
                Collection<JavaTypeVariable> typeParams = method.getTypeParameters();
                JavaType[] typeArgs = new JavaType[typeParams.size()];
                Iterator<JavaTypeVariable> typeParamIter = typeParams.iterator();
                int count = 0;
                while (typeParamIter.hasNext()) {
                    JavaType bound;
                    JavaTypeVariable typeParam = typeParamIter.next();
                    Collection<JavaType> bounds = typeParam.getBounds();
                    if (bounds.isEmpty()) {
                        bound = this.getPreloadedClass((byte)4).getResolvedType();
                    } else {
                        bound = bounds.iterator().next();
                        if (bound != null) {
                            bound = bound.getResolvedType();
                        }
                    }
                    if (bound == null) break;
                    typeArgs[count++] = bound;
                }
                if (count == typeParams.size()) {
                    hasType = CommonUtilities.createParameterizedMethod(this.provider, method, typeArgs);
                }
            }
            return hasType.getResolvedType();
        }
        return null;
    }

    public final JavaHasType processInfix(Expr e) {
        int op = e.getOperatorCode();
        switch (op) {
            case 6: {
                type = this.handleBinaryOperator(e, (byte)0);
                break;
            }
            case 1: 
            case 2: {
                type = this.handlePrimitiveOperator(e, (byte)0);
                break;
            }
            case 17: 
            case 18: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                type = this.handlePrimitiveOperator(e, (byte)1);
                break;
            }
            case 3: 
            case 43: {
                type = this.handlePrimitiveOperator(e, (byte)3);
                break;
            }
            case 20: 
            case 42: {
                type = this.handleBinaryOperator(e, (byte)2);
                break;
            }
            case 21: 
            case 22: 
            case 25: 
            case 30: {
                type = this.handleBinaryOperator(e, (byte)1);
                break;
            }
            case 23: {
                return this.handleInstanceof(e);
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                type = this.handlePrimitiveOperator(e, (byte)2);
                break;
            }
            case 28: 
            case 29: 
            case 51: 
            case 52: 
            case 56: 
            case 57: {
                type = this.handleBinaryOperator(e, (byte)3);
                break;
            }
            default: {
                CompilerLayer3c.panic(e);
                return null;
            }
        }
        JavaType type = switch (op) {
            case 2, 8, 11, 13, 18, 29, 32, 34, 36, 52, 57 -> {
                JavaType assignedToType = this.processNthOperandType(e, 0);
                if (assignedToType == null) yield assignedToType;
            }
        };
        if (type != null) {
            return type.getThisValue();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private JavaType handlePrimitiveOperator(Expr e, byte primop) {
        switch (primop) {
            case 3: {
                defaultReturn = PrimitiveType.PRIMITIVE_objects[0];
                if (!this.flag_forgiving) break;
                return defaultReturn;
            }
            default: {
                defaultReturn = PrimitiveType.PRIMITIVE_objects[4];
            }
        }
        if ((opnCount = e.getOperandCount()) == 0) {
            return defaultReturn;
        }
        attempt = this.processNthOperandType(e, 0);
        isString = false;
        lhsType = null;
        if (attempt != null && !CompilerLayer3c.isVoidType(attempt)) {
            switch (primop) {
                case 0: {
                    lhsType = attempt;
                    isString = "java.lang.String".equals(lhsType.getRawName());
                    break;
                }
                case 1: {
                    if (!CompilerLayer3c.isNumericType(attempt, this.jdkVersion)) break;
                    lhsType = attempt;
                    break;
                }
                case 2: {
                    if (!CompilerLayer3c.isIntegralOrBooleanType(attempt, this.jdkVersion)) break;
                    lhsType = attempt;
                    break;
                }
                case 3: {
                    if (!CompilerLayer3c.isBooleanType(attempt)) break;
                    lhsType = attempt;
                }
            }
            if (lhsType == null) {
                this.error(e.getNthOperandSym(0), (short)57, attempt);
            }
        }
        if (lhsType == null) {
            lhsType = defaultReturn;
        }
        if (opnCount == 1) {
            unary = CompilerLayer3c.applyUnaryPromotion(lhsType, this.jdkVersion);
            if (unary != null) {
                return unary;
            }
            this.error(e.getNthOperandSym(0), (short)57, lhsType);
            return null;
        }
        block15: for (opn = 1; opn < opnCount; ++opn) {
            rhsType = this.processNthOperandType(e, opn);
            if (rhsType == null) {
                rhsType = defaultReturn;
            } else if (CompilerLayer3c.isVoidType(rhsType)) {
                this.error(e.getNthOperandSym(opn), (short)57, rhsType);
                rhsType = defaultReturn;
            }
            switch (primop) {
                case 0: {
                    if (isString) continue block15;
                    if (rhsType != null && "java.lang.String".equals(rhsType.getRawName())) {
                        isString = true;
                        lhsType = rhsType;
                        continue block15;
                    }
                    if (opn == 1) {
                        attempt0 = lhsType;
                        lhsType = null;
                        if (CompilerLayer3c.isNumericType(attempt0, this.jdkVersion)) {
                            lhsType = attempt0;
                        }
                        if (lhsType == null) {
                            this.error(e.getNthOperandSym(0), (short)57, attempt0);
                            lhsType = defaultReturn;
                        }
                    }
                }
                case 1: {
                    newType = CompilerLayer3c.applyBinaryPromotion(lhsType, rhsType, this.jdkVersion);
                    if (newType != null) {
                        lhsType = newType;
                        continue block15;
                    }
                    ** GOTO lbl79
                }
                case 2: {
                    if (CompilerLayer3c.isIntegralOrBooleanType(attempt, this.jdkVersion) && (lhsType = CompilerLayer3c.applyBinaryPromotion(lhsType, rhsType, this.jdkVersion)) != null) continue block15;
                    lhsType = CompilerLayer3c.applyBinaryPromotion(lhsType, lhsType, this.jdkVersion);
                    ** GOTO lbl79
                }
                case 3: {
                    if (CompilerLayer3c.isBooleanType(rhsType)) continue block15;
                }
lbl79:
                // 4 sources

                default: {
                    this.error(e.getNthOperandSym(opn), (short)57, rhsType);
                }
            }
        }
        return lhsType;
    }

    private JavaType handleBinaryOperator(Expr e, byte binop) {
        PrimitiveType defaultReturn;
        switch (binop) {
            case 0: {
                defaultReturn = null;
                break;
            }
            case 1: 
            case 2: {
                defaultReturn = PrimitiveType.PRIMITIVE_objects[0];
                if (!this.flag_forgiving) break;
                return defaultReturn;
            }
            default: {
                defaultReturn = PrimitiveType.PRIMITIVE_objects[4];
            }
        }
        int opnCount = e.getOperandCount();
        if (opnCount == 0) {
            return defaultReturn;
        }
        JavaType lhsType = this.processHasType(this.processNthOperand(e, 0), binop == 2);
        if (opnCount == 1) {
            switch (binop) {
                case 0: {
                    return lhsType;
                }
                case 3: {
                    if (lhsType != null) {
                        lhsType = CompilerLayer3c.applyUnaryPromotion(lhsType, this.jdkVersion);
                        break;
                    }
                    lhsType = defaultReturn;
                    break;
                }
                default: {
                    return defaultReturn;
                }
            }
        }
        if (opnCount > 2) {
            // empty if block
        }
        JavaType rhsType = null;
        Expr opnp = (Expr)e.getNthChild((byte)108, 1);
        if (opnp != null) {
            lhsType = this.checkForLambdaLhs(opnp, lhsType);
            JavaHasType rhsHasType = this.processExpression(opnp);
            rhsType = this.processHasType(rhsHasType, binop == 2);
        }
        switch (binop) {
            case 0: {
                JavaType targetType;
                if (this.flag_forgiving || this.skipCompilations()) {
                    return lhsType;
                }
                JavaHasType lhsHasType = this.processNthOperand(e, 0);
                if (lhsHasType != null && lhsHasType instanceof JavaType) {
                    this.error(e.getNthOperandSym(0), (short)65, lhsHasType);
                }
                SourceExpression rhsExpr = e.getSecondOperand();
                JavaHasType rhsHasType = this.processNthOperand(e, 1);
                if (rhsExpr != null && rhsExpr.getSymbolKind() != 82 && rhsHasType != null && rhsHasType instanceof JavaType) {
                    this.error(e.getNthOperandSym(1), (short)74, rhsHasType);
                }
                if (CompilerLayer3c.applyAssignmentConversion(rhsType, rhsExpr, lhsType, false, this.provider, this.jdkVersion)) break;
                boolean constant = true;
                if (CompilerLayer3c.applyAssignmentConversion(rhsType, rhsExpr, lhsType, true, this.provider, this.jdkVersion) || lhsType.isArray() && CompilerLayer3c.isComponentAssignment(e) && CompilerLayer3c.applyAssignmentConversion(rhsType, rhsExpr, targetType = lhsType.getComponentType(), true, this.provider, this.jdkVersion) || this.allowDiamondSyntaxAssign(rhsExpr, rhsType, lhsType) || this.allowAssignAfterInferringWithTargetType(Conversions.ConversionType.ASSIGNMENT, rhsExpr, rhsType, lhsType)) break;
                this.error(e.getNthOperandSym(1), (short)43, rhsType, lhsType);
                break;
            }
            case 1: {
                PrimitiveType rhs;
                if (rhsType == null) {
                    return defaultReturn;
                }
                PrimitiveType lhs = PrimitiveType.applyUnboxingConversion(lhsType, this.jdkVersion);
                if (lhs == null || !lhs.isNumeric()) {
                    this.error(e.getNthOperandSym(0), (short)57, lhsType);
                }
                if ((rhs = PrimitiveType.applyUnboxingConversion(rhsType, this.jdkVersion)) == null || !rhs.isNumeric()) {
                    this.error(e.getNthOperandSym(0), (short)57, rhsType);
                }
                CompilerLayer3c.applyBinaryPromotion(lhs, rhs, this.jdkVersion);
                return defaultReturn;
            }
            case 2: {
                PrimitiveType unboxedType;
                if (lhsType == null || rhsType == null) {
                    return defaultReturn;
                }
                if (Conversions.applyCastingConversion(lhsType, rhsType, this.provider, this.jdkVersion) || Conversions.applyCastingConversion(rhsType, lhsType, this.provider, this.jdkVersion)) {
                    return defaultReturn;
                }
                if (!lhsType.isPrimitive() && (unboxedType = PrimitiveType.applyUnboxingConversion(lhsType, this.jdkVersion)) != null) {
                    lhsType = unboxedType;
                }
                if (!rhsType.isPrimitive() && (unboxedType = PrimitiveType.applyUnboxingConversion(rhsType, this.jdkVersion)) != null) {
                    rhsType = unboxedType;
                }
                if (!Conversions.applyCastingConversion(lhsType, rhsType, this.provider, this.jdkVersion) && !Conversions.applyCastingConversion(rhsType, lhsType, this.provider, this.jdkVersion) && CompilerLayer3c.applyBinaryPromotion(lhsType, rhsType, this.jdkVersion) == null && CompilerLayer3c.applyBinaryPromotion(rhsType, lhsType, this.jdkVersion) == null) {
                    this.error(e.getNthOperandSym(1), (short)57, rhsType);
                }
                return defaultReturn;
            }
            case 3: {
                JavaType promotedRhs;
                JavaType promotedLhs = CompilerLayer3c.applyUnaryPromotion(lhsType, this.jdkVersion);
                if (!CompilerLayer3c.isIntegralType(promotedLhs, this.jdkVersion)) {
                    this.error(e.getNthOperandSym(0), (short)57, lhsType);
                }
                if (!CompilerLayer3c.isIntegralType(promotedRhs = CompilerLayer3c.applyUnaryPromotion(rhsType, this.jdkVersion), this.jdkVersion)) {
                    this.error(e.getNthOperandSym(1), (short)57, rhsType);
                }
                lhsType = promotedLhs;
                break;
            }
            default: {
                CompilerLayer3c.panic(e);
                return null;
            }
        }
        return lhsType;
    }

    protected boolean allowAssignAfterInferringWithTargetType(Conversions.ConversionType conversionType, SourceExpression rhsExpr, JavaType rhsType, JavaType lhsType) {
        if (conversionType != Conversions.ConversionType.ASSIGNMENT || !this.jdkVersion.isGreaterThanOrEqualTo8()) {
            return false;
        }
        while (rhsExpr != null && rhsExpr.getSymbolKind() == 81) {
            rhsExpr = rhsExpr.getFirstOperand();
        }
        if (rhsExpr.getSymbolKind() == 76) {
            JavaType secondType;
            SourceQuestionExpression questionExpr = (SourceQuestionExpression)rhsExpr;
            SourceExpression firstExpr = questionExpr.getSecondOperand();
            SourceExpression secondExpr = questionExpr.getThirdOperand();
            JavaType firstType = this.inferWithTargetType(firstExpr, lhsType, firstExpr.getResolvedType());
            JavaType resultType = this.handleQuestion((Expr)rhsExpr, firstType, secondType = this.inferWithTargetType(secondExpr, lhsType, secondExpr.getResolvedType()));
            if (resultType != null) {
                return CompilerLayer3c.applyAssignmentConversion(resultType, rhsExpr, lhsType, rhsExpr.getConstantValue() != null, this.provider, this.jdkVersion);
            }
            return false;
        }
        rhsType = this.inferWithTargetType(rhsExpr, lhsType, rhsType);
        return CompilerLayer3c.applyAssignmentConversion(rhsType, rhsExpr, lhsType, rhsExpr.getConstantValue() != null, this.provider, this.jdkVersion);
    }

    private JavaType inferWithTargetType(SourceExpression rhsExpr, JavaType lhsType, JavaType rhsType) {
        while (rhsExpr != null && rhsExpr.getSymbolKind() == 81) {
            rhsExpr = rhsExpr.getFirstOperand();
        }
        if (rhsExpr.getSymbolKind() == 73) {
            CompilerContext context = this.getCompilerContext();
            return context.resolveMethodCallUsingTargetType((SourceMethodCallExpression)rhsExpr, lhsType, rhsType);
        }
        return rhsType;
    }

    protected boolean allowDiamondSyntaxAssign(SourceExpression rhsExpr, JavaType rhsType, JavaType lhsType) {
        if (rhsExpr != null && rhsExpr.getSymbolKind() == 75) {
            JavaType javaType;
            TypeSym sym = ((ClassCreatorExpr)rhsExpr).getTypeSym();
            JavaType javaType2 = javaType = sym != null ? sym.getResolvedType() : null;
            if (javaType != null && javaType.hasTypeParameters() && javaType.hasActualTypeArguments() && javaType.getActualTypeArguments().isEmpty() && CompilerLayer3c.applyAssignmentConversion(rhsType.getTypeErasure(), rhsExpr, lhsType.getTypeErasure(), false, this.provider, this.jdkVersion)) {
                return true;
            }
        }
        return false;
    }

    private JavaHasType handleArrayDereference(Expr e) {
        JavaType lhsType = this.processNthOperandType(e, 0);
        JavaType componentType = null;
        Expr list = e.getNthOperandSym(1);
        int count = list.getOperandCount();
        for (int i = 0; i < count; ++i) {
            if (lhsType == null) {
                return null;
            }
            componentType = lhsType.getComponentType();
            if (componentType == null) {
                return (JavaHasType)this.error(e.getNthOperandSym(0), (short)69, lhsType);
            }
            JavaType rhsType = this.processNthOperandType(list, i);
            if (rhsType == null || this.flag_forgiving) {
                return componentType.getThisValue();
            }
            if ((rhsType = CompilerLayer3c.applyUnaryPromotion(rhsType, this.jdkVersion)) != null && !CompilerLayer3c.isIntegralType(rhsType, this.jdkVersion)) {
                this.error(e.getNthOperandSym(1), (short)57, rhsType);
            }
            lhsType = componentType;
        }
        if (componentType == null) {
            return null;
        }
        return componentType.getThisValue();
    }

    private JavaType handleClassLiteral(UnaryExpr e) {
        JavaClass javaLangClass = this.getPreloadedClass((byte)0);
        if (javaLangClass == null) {
            return null;
        }
        if (!javaLangClass.hasTypeParameters()) {
            return javaLangClass;
        }
        JavaType lhsType = this.processNthOperandType(e, 0);
        if (lhsType != null) {
            try {
                JavaType classType;
                if (lhsType.hasActualTypeArguments()) {
                    this.error(e.getNthOperandSym(0), (short)94, lhsType);
                }
                if ((classType = lhsType.getTypeErasure()).isPrimitive() && this.jdkVersion.isGreaterThanOrEqualTo5()) {
                    classType = PrimitiveType.applyBoxingConversion((PrimitiveType)classType, this.provider, this.jdkVersion);
                }
                JavaType[] arguments = new JavaType[]{classType};
                return CompilerLayer3c.createParameterizedType(this.provider, javaLangClass, arguments);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return javaLangClass;
    }

    private JavaHasType handleInstanceof(Expr e) {
        JavaHasType lhsHasType;
        JavaType rhsType;
        PrimitiveType booleanType = PrimitiveType.PRIMITIVE_objects[0];
        CompiledTmpVariable booleanVar = booleanType.getThisValue();
        if (this.flag_forgiving || this.skipCompilations()) {
            return booleanVar;
        }
        JavaHasType rhsHasType = this.processNthOperand(e, 1);
        JavaType javaType = rhsType = rhsHasType != null ? this.processHasType(rhsHasType, false) : null;
        if (rhsHasType != null && rhsHasType.getElementKind() != 3 || rhsType != null && rhsType.isPrimitive()) {
            this.error(e.getNthOperandSym(1), (short)57, rhsHasType);
        }
        if ((lhsHasType = this.processNthOperand(e, 0)) != null) {
            if (lhsHasType.getElementKind() == 3) {
                this.error(e.getNthOperandSym(0), (short)57, lhsHasType);
            } else {
                JavaType lhsType = this.processHasType(lhsHasType, false);
                if (lhsType != null) {
                    if (lhsType.isPrimitive() && !"null".equals(lhsType.getQualifiedName())) {
                        this.error(e.getNthOperandSym(0), (short)57, lhsType);
                    } else if (rhsType != null && !Conversions.applyCastingConversion(lhsType, rhsType, this.provider, this.jdkVersion)) {
                        this.error(e.getNthOperandSym(0), (short)48, lhsType, rhsType);
                    }
                }
            }
        }
        return booleanVar;
    }

    private JavaType handlePrePostIncPrePostDec(Expr e) {
        PrimitiveType integerType = PrimitiveType.PRIMITIVE_objects[4];
        int opnCount = e.getOperandCount();
        if (opnCount == 0) {
            return integerType;
        }
        JavaType lhsType = this.processNthOperandType(e, 0);
        if (lhsType == null) {
            return integerType;
        }
        if (this.flag_forgiving || this.skipCompilations()) {
            return lhsType;
        }
        JavaType result = CompilerLayer3c.applyBinaryPromotion(lhsType, integerType, this.jdkVersion);
        if (result == null) {
            this.error(e.getNthOperandSym(0), (short)57, lhsType);
        }
        return lhsType;
    }

    private JavaHasType handleQualifiedThis(Expr e) {
        JavaType lhsType = this.processNthOperandType(e, 0);
        if (lhsType == null) {
            return null;
        }
        return this.processThisSuperQualifier(e, lhsType);
    }

    private JavaHasType processThisSuperQualifier(Expr e, JavaType lhsType) {
        ClassSym found = this.resolveEnclosingScope(e, lhsType);
        if (found != null) {
            return found.getThisVariable();
        }
        return null;
    }

    private JavaHasType handleQualifiedSuper(Expr e) {
        JavaType lhsType = this.processNthOperandType(e, 0);
        if (lhsType == null) {
            return null;
        }
        if (e.getJdkVersion().isGreaterThanOrEqualTo8() && lhsType.isInterface()) {
            return lhsType.getThisValue();
        }
        JavaHasType qualifier = this.processThisSuperQualifier(e, lhsType);
        JavaType qualifierType = this.processHasType(qualifier, false);
        if (qualifierType == null) {
            return null;
        }
        JavaType superType = qualifierType.getSuperclass();
        if (superType != null) {
            return superType.getThisValue();
        }
        return null;
    }

    private JavaHasType handleQuestion(Expr e) {
        JavaType firstType = this.processNthOperandType(e, 0);
        if (firstType != null && !CompilerLayer3c.isBooleanType(firstType)) {
            this.error(e.getNthOperandSym(0), (short)57, firstType);
        }
        JavaHasType lhs = this.processNthOperand(e, 1);
        JavaHasType rhs = this.processNthOperand(e, 2);
        if (lhs == null) {
            return rhs;
        }
        if (rhs == null) {
            return lhs;
        }
        JavaType lhsType = lhs.getResolvedType();
        if (lhsType == null) {
            return rhs;
        }
        JavaType rhsType = rhs.getResolvedType();
        if (rhsType == null) {
            return lhs;
        }
        JavaType resultType = this.handleQuestion(e, lhsType, rhsType);
        if (resultType == lhsType) {
            return lhs;
        }
        if (resultType == rhsType) {
            return rhs;
        }
        if (resultType == null) {
            this.error(e.getNthOperandSym(2), (short)43, rhsType, lhsType);
            return lhs;
        }
        return resultType.getThisValue();
    }

    private JavaHasType handleTypecast(TypecastExpr e) {
        JavaType newLhsType;
        JavaType lhsType = this.processNthOperandType(e, 0);
        if (lhsType == null) {
            JavaClass object = this.getPreloadedClass((byte)4);
            if (object != null) {
                return object.getThisValue();
            }
            return null;
        }
        if (this.flag_forgiving || this.skipCompilations()) {
            return lhsType.getThisValue();
        }
        JavaType rhsType = null;
        Expr rhsExpression = (Expr)e.getSecondOperand();
        if (rhsExpression != null) {
            JavaMethod rhsMethod;
            JavaClass owningClass;
            JavaHasType rhsHasType = this.processExpression(rhsExpression);
            if (rhsHasType instanceof JavaMethod && (owningClass = (rhsMethod = (JavaMethod)rhsHasType).getOwningClass()) != null && "java.lang.invoke.VarHandle".equals(owningClass.getRawName())) {
                return lhsType.getThisValue();
            }
            rhsType = this.processHasType(rhsHasType, false);
        }
        if (rhsType != null && !CompilerLayer3c.applyCastingConversion(rhsType, newLhsType = this.checkForLambdaLhs(rhsExpression, lhsType), this.provider, this.jdkVersion)) {
            this.error(e, (short)48, rhsType, lhsType);
        }
        return lhsType.getThisValue();
    }

    private JavaType handleQuestion(Expr expr, JavaType one, JavaType two) {
        if (one.equals(two)) {
            return one;
        }
        boolean oneIsPrimitive = one.isPrimitive();
        boolean twoIsPrimitive = two.isPrimitive();
        if (!oneIsPrimitive && !twoIsPrimitive) {
            PrimitiveType oneUnboxed = PrimitiveType.applyUnboxingConversion(one, this.jdkVersion);
            PrimitiveType twoUnboxed = PrimitiveType.applyUnboxingConversion(two, this.jdkVersion);
            if (oneUnboxed != null && oneUnboxed.isNumeric() && twoUnboxed != null && twoUnboxed.isNumeric()) {
                return this.handleQuestionImpl(expr, oneUnboxed, twoUnboxed);
            }
            return this.handleQuestionImpl(one, two);
        }
        if (oneIsPrimitive && twoIsPrimitive) {
            return this.handleQuestionImpl(expr, (PrimitiveType)one, (PrimitiveType)two);
        }
        if (oneIsPrimitive) {
            return this.handleQuestionImpl(expr, (PrimitiveType)one, two);
        }
        return this.handleQuestionImpl(expr, (PrimitiveType)two, one);
    }

    private JavaType handleQuestionImpl(JavaType one, JavaType two) {
        if (one.isSubtypeOf(two)) {
            return two;
        }
        if (two.isSubtypeOf(one)) {
            return one;
        }
        return !this.jdkVersion.isGreaterThanOrEqualTo5() ? null : CompilerLayer3c.leastUpperBound(this.provider, one, two);
    }

    private JavaType handleQuestionImpl(Expr expr, PrimitiveType one, JavaType two) {
        if ("null".equals(one.getQualifiedName())) {
            return two;
        }
        PrimitiveType twoUnboxed = PrimitiveType.applyUnboxingConversion(two, this.jdkVersion);
        if (twoUnboxed != null) {
            return this.handleQuestionImpl(expr, one, twoUnboxed);
        }
        JavaType oneBoxed = CompilerLayer3c.applyBoxingConversion((JavaType)one, (JavaProvider)this.provider, this.jdkVersion);
        if (oneBoxed != null) {
            return this.handleQuestionImpl(oneBoxed, two);
        }
        return null;
    }

    private JavaType handleQuestionImpl(Expr expr, PrimitiveType one, PrimitiveType two) {
        JavaType type;
        Expr left = (Expr)expr.getNthChild((byte)108, 1);
        Expr right = (Expr)expr.getNthChild((byte)108, 2);
        if (one.primCode == 4 && left.getConstantValue() != null ? (type = this.handleQuestionOneConstant(left, two)) != null : two.primCode == 4 && right.getConstantValue() != null && (type = this.handleQuestionOneConstant(right, one)) != null) {
            return type;
        }
        if (one.isSubtypeOf(two)) {
            return two;
        }
        if (two.isSubtypeOf(one)) {
            return one;
        }
        JavaType promoted = CompilerLayer3c.applyBinaryPromotion(one, two, this.jdkVersion);
        if (promoted != null) {
            return promoted;
        }
        if ("null".equals(one.getName())) {
            return CompilerLayer3c.applyBoxingConversion((JavaType)two, (JavaProvider)this.provider, this.jdkVersion);
        }
        if ("null".equals(two.getName())) {
            return CompilerLayer3c.applyBoxingConversion((JavaType)one, (JavaProvider)this.provider, this.jdkVersion);
        }
        return null;
    }

    private JavaType handleQuestionOneConstant(Expr one, PrimitiveType otherType) {
        Object value = one.getConstantValue();
        if (value instanceof Integer) {
            int intValue = (Integer)value;
            if (otherType.primCode == 1 && intValue >= -128 && intValue <= 127) {
                return otherType;
            }
            if (otherType.primCode == 2 && intValue >= 0 && intValue <= 65535) {
                return otherType;
            }
            if (otherType.primCode == 3 && intValue >= Short.MIN_VALUE && intValue <= Short.MAX_VALUE) {
                return otherType;
            }
        }
        return null;
    }

    protected JavaType checkForLambdaLhs(Expr rhsExpression, JavaType lhsType) {
        while (rhsExpression != null && rhsExpression.symKind == 81) {
            rhsExpression = (Expr)rhsExpression.getNthChild((byte)108, 0);
        }
        if (rhsExpression != null && rhsExpression.symKind == 83) {
            JavaMethod method;
            JavaType returnType = lhsType;
            SourceLambdaExpression lambda = (SourceLambdaExpression)((Object)rhsExpression);
            while ((method = CommonUtilities.getFunctionalInterfaceMethod(returnType)) != null) {
                returnType = method.getResolvedType();
                if (lambda.getBody().getSymbolKind() != 83) break;
                lambda = (SourceLambdaExpression)lambda.getBody();
            }
            return returnType;
        }
        return lhsType;
    }
}

