/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.JavaProvider2;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.parser.java.v2.internal.InternalUtilities;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerUtilities;
import oracle.javatools.parser.java.v2.internal.compiler.ObjConstants;
import oracle.javatools.parser.java.v2.internal.symbol.FileSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;

abstract class CompilerLayer1
extends CompilerUtilities
implements ObjConstants {
    protected static final byte ___code_conventions = 0;
    protected Thread thread = Thread.currentThread();
    protected JdkVersion jdkVersion = JavaParser.getJdkVersion();
    protected JavaProvider2 provider = null;
    protected JavaClass[] preloadedClasses = new JavaClass[15];
    protected volatile boolean cancel = false;
    private Throwable cancelTrace;
    protected boolean flag_forgiving = false;
    private boolean skipCompilations = true;
    protected Boolean flag_nonFinalLocalVars = null;
    protected CompilerContext compilerContext;
    private Map<Thread, CompilerContext> temporaryCompilerContexts = new HashMap<Thread, CompilerContext>();

    CompilerLayer1() {
    }

    public boolean skipCompilations() {
        return this.skipCompilations;
    }

    public void setSkipCompilations(boolean skipCompilations) {
        this.skipCompilations = skipCompilations;
    }

    public Thread getThread() {
        return this.thread;
    }

    public JavaElement resolve(Sym sym) {
        CompilerLayer1.panic(sym);
        return null;
    }

    protected void setProvider(JavaProvider provider) {
        this.provider = new JavaProvider2Proxy(provider);
    }

    public JavaProvider getProvider() {
        return this.provider;
    }

    protected synchronized CompilerContext getCompilerContext() {
        CompilerContext temporaryContext = this.temporaryCompilerContexts.get(Thread.currentThread());
        if (temporaryContext != null) {
            return temporaryContext;
        }
        return this.compilerContext;
    }

    protected synchronized void setCompilerContext(CompilerContext context) {
        if (context == null || context == this.compilerContext) {
            this.temporaryCompilerContexts.remove(Thread.currentThread());
        } else {
            this.temporaryCompilerContexts.put(Thread.currentThread(), context);
        }
    }

    final CompilerContext newContext(Sym cookie) {
        return new CompilerContext((CompilerDriver)this, cookie);
    }

    public boolean isJdkLoaded() {
        return this.getPreloadedClass((byte)4) != null;
    }

    public final boolean preloadClasses() {
        for (byte i = 0; i < 8; i = (byte)(i + 1)) {
            JavaClass loaded = this.getPreloadedClass(i);
            if (loaded != null) continue;
            return false;
        }
        return true;
    }

    protected final JavaClass getPreloadedClass(byte n) {
        if (this.preloadedClasses[n] == null) {
            this.preloadedClasses[n] = this.provider.getClassByVMName(CLASS_vmnames[n]);
        }
        if (this.preloadedClasses[n] != null) {
            return this.preloadedClasses[n];
        }
        if (n >= 8 && !this.jdkVersion.isGreaterThanOrEqualTo5()) {
            return null;
        }
        this.error(null, (short)75, CLASS_vmnames[n]);
        return null;
    }

    protected final JavaClass getSystemClass(String vmName) {
        JavaClass type = this.provider.getClassByVMName(vmName);
        if (type != null) {
            return type;
        }
        this.error(null, (short)75, vmName);
        return null;
    }

    public final void cancel() {
        this.cancel = true;
        this.cancelTrace = new Throwable("Cancel origin");
    }

    public final void clearCancel() {
        this.cancel = false;
        this.cancelTrace = null;
    }

    public final boolean isCanceled() {
        return this.cancel;
    }

    public final Throwable getCancelTrace() {
        return this.cancelTrace;
    }

    public final JavaElement error(Sym s, short errorCode) {
        return this.errorImpl(s, errorCode, EMPTY_OBJECT_ARRAY);
    }

    public final JavaElement error(Sym s, short errorCode, Object data) {
        if (data != null) {
            return this.errorImpl(s, errorCode, new Object[]{data});
        }
        return this.error(s, errorCode);
    }

    public final JavaElement error(Sym s, short errorCode, Object data0, Object data1) {
        if (data1 != null) {
            return this.errorImpl(s, errorCode, new Object[]{data0, data1});
        }
        return this.error(s, errorCode, data0);
    }

    public final JavaElement error(Sym s, short errorCode, Object data0, Object data1, Object data2) {
        if (data2 != null) {
            return this.errorImpl(s, errorCode, new Object[]{data0, data1, data2});
        }
        return this.error(s, errorCode, data0, data1);
    }

    public final JavaElement error(Sym s, short errorCode, Object data0, Object data1, Object data2, Object data3) {
        if (data3 != null) {
            return this.errorImpl(s, errorCode, new Object[]{data0, data1, data2, data3});
        }
        return this.error(s, errorCode, data0, data1, data2);
    }

    public final JavaElement errorImpl(Sym s, short errorCode, Object[] data) {
        FileSym symFile;
        CompilerContext context = this.getCompilerContext();
        if (context != null && context.suppressErrors && InternalUtilities.errorToSeverity(errorCode) >= 4) {
            return null;
        }
        Sym cookie = s;
        if (cookie == null) {
            if (context == null) {
                return null;
            }
            cookie = context.symCookie;
            if (cookie == null) {
                return null;
            }
        }
        if ((symFile = cookie.symFile) == null) {
            return null;
        }
        this.generateErrorImpl(symFile, cookie, errorCode, data);
        return null;
    }

    private static class JavaProvider2Proxy
    implements JavaProvider2 {
        private JavaProvider javaProvider;
        private boolean isJavaProvider2;

        private JavaProvider2Proxy(JavaProvider javaProvider) {
            this.javaProvider = javaProvider;
            this.isJavaProvider2 = javaProvider instanceof JavaProvider2;
        }

        @Override
        public JavaClass getClassInterruptibly(String fqName) {
            if (this.isJavaProvider2) {
                try {
                    return ((JavaProvider2)this.javaProvider).getClassInterruptibly(fqName);
                }
                catch (InterruptedException ex) {
                    Thread.interrupted();
                    throw new CancellationException(ex.getMessage());
                }
            }
            return this.javaProvider.getClass(fqName);
        }

        @Override
        public JavaClass getClassInterruptibly(String fqPrefix, String name) {
            if (this.isJavaProvider2) {
                try {
                    return ((JavaProvider2)this.javaProvider).getClassInterruptibly(fqPrefix, name);
                }
                catch (InterruptedException ex) {
                    Thread.interrupted();
                    throw new CancellationException(ex.getMessage());
                }
            }
            return this.javaProvider.getClass(fqPrefix, name);
        }

        @Override
        public JavaClass getClassByVMNameInterruptibly(String fqVmName) {
            if (this.isJavaProvider2) {
                try {
                    return ((JavaProvider2)this.javaProvider).getClassByVMNameInterruptibly(fqVmName);
                }
                catch (InterruptedException ex) {
                    Thread.interrupted();
                    throw new CancellationException(ex.getMessage());
                }
            }
            return this.javaProvider.getClassByVMName(fqVmName);
        }

        @Override
        public SourceClass getSourceClassInterruptibly(String fqName) {
            if (this.isJavaProvider2) {
                try {
                    return ((JavaProvider2)this.javaProvider).getSourceClassInterruptibly(fqName);
                }
                catch (InterruptedException ex) {
                    Thread.interrupted();
                    throw new CancellationException(ex.getMessage());
                }
            }
            return this.javaProvider.getSourceClass(fqName);
        }

        @Override
        public JavaClass getClass(String fqName) {
            return this.getClassInterruptibly(fqName);
        }

        @Override
        public JavaClass getClass(String fqPrefix, String name) {
            return this.getClassInterruptibly(fqPrefix, name);
        }

        @Override
        public JavaClass getClassByVMName(String fqVmName) {
            return this.getClassByVMNameInterruptibly(fqVmName);
        }

        @Override
        public JavaType getArrayType(JavaType componentType, int dimensions) {
            return this.javaProvider.getArrayType(componentType, dimensions);
        }

        @Override
        public SourceClass getSourceClass(String fqName) {
            return this.getSourceClassInterruptibly(fqName);
        }

        @Override
        public JavaPackage getPackage(String fqPrefix) {
            return this.javaProvider.getPackage(fqPrefix);
        }

        @Override
        public TextBuffer getTextBuffer(URL url) {
            return this.javaProvider.getTextBuffer(url);
        }
    }
}

