/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.InternalAnnotationComponent;
import oracle.javatools.parser.java.v2.internal.InternalConstants;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.model.ClassKind;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.resource.BundleHelper;

public abstract class InternalUtilities
extends CommonUtilities
implements InternalConstants {
    protected static final BundleHelper resources = InternalUtilities.initResources();
    protected static final String[] ERROR_loaded = new String[ERROR_words.length];

    public static boolean isCommentToken(int tk) {
        switch (tk) {
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    public static boolean symKindIsMemberDeclaration(int symKind) {
        switch (symKind) {
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    public static boolean symKindIsBlockElement(int symKind) {
        switch (symKind) {
            case 3: 
            case 18: 
            case 23: {
                return true;
            }
        }
        return InternalUtilities.symKindIsStatement(symKind);
    }

    public static boolean symKindIsStatement(int k) {
        return 47 <= k && k < 66;
    }

    public static boolean symKindIsExpression(int k) {
        return 66 <= k && k < 87;
    }

    public static boolean symKindIsLexical(int k) {
        return 95 <= k && k < 98;
    }

    public static boolean symKindIsDocElement(int k) {
        return 88 <= k && k < 95;
    }

    public static String operatorToText(short op) {
        return OP_words[op - 32];
    }

    public static String keywordToText(short kw) {
        return KW_words[kw - 96];
    }

    public static char typeKindToAccess(ClassKind classKind) {
        return switch (classKind) {
            default -> throw new IncompatibleClassChangeError();
            case ClassKind.CLASS -> '\u0000';
            case ClassKind.INTERFACE -> '\u0200';
            case ClassKind.ENUM -> '\u4000';
            case ClassKind.RECORD -> '\u0000';
            case ClassKind.ANNOTATION -> '\u2200';
        };
    }

    public static ClassKind accessToTypeKind(char access) {
        if ((access & 0x2000) != 0) {
            return ClassKind.ANNOTATION;
        }
        if ((access & 0x4000) != 0) {
            return ClassKind.ENUM;
        }
        if ((access & 0x8000) != 0) {
            throw new UnsupportedOperationException("modules are not a type");
        }
        if ((access & 0x200) != 0) {
            return ClassKind.INTERFACE;
        }
        return ClassKind.CLASS;
    }

    public static short accessModifierToKeyword(char access) {
        switch (access) {
            case '\u0800': {
                return 132;
            }
            case '\u0400': {
                return 96;
            }
            case '\u0100': {
                return 123;
            }
            case '\u0080': {
                return 139;
            }
            case '@': {
                return 142;
            }
            case ' ': {
                return 135;
            }
            case '\u0010': {
                return 111;
            }
            case '\b': {
                return 131;
            }
            case '\u0004': {
                return 127;
            }
            case '\u0002': {
                return 126;
            }
            case '\u0001': {
                return 128;
            }
            case '\u0200': {
                return 106;
            }
        }
        return -1;
    }

    public static String tagToName(short tag) {
        return 202 <= tag && tag < 228 ? TAG_words[tag - 202] : "@unknown";
    }

    public static int errorToSeverity(int error) {
        if (error == 2) {
            return 5;
        }
        if (error == 121) {
            return 1;
        }
        for (short errorWarning : ERROR_warnings) {
            if (error != errorWarning) continue;
            return 3;
        }
        return 4;
    }

    public static int errorToCategory(int error) {
        if (4 <= error && error < 12) {
            return 1;
        }
        if (12 <= error && error < 39) {
            return 2;
        }
        if (39 <= error && error < 139) {
            return 4;
        }
        return 0;
    }

    private static BundleHelper initResources() {
        try {
            return new BundleHelper("oracle.javatools.parser.resource.ParserBundle", BundleHelper.class.getClassLoader());
        }
        catch (MissingResourceException mre) {
            return null;
        }
    }

    private static String loadErrorMessage(int index) {
        if (resources != null) {
            String key = ERROR_keys[index];
            String value = resources.getString(key);
            return value != null ? value : "Missing resource '" + key + "'";
        }
        return ERROR_words[index];
    }

    public static String errorToMessage(int error) {
        if (1 <= error && error < 139) {
            String loaded;
            int index = error - 1;
            String alreadyLoaded = ERROR_loaded[index];
            if (alreadyLoaded != null) {
                return alreadyLoaded;
            }
            InternalUtilities.ERROR_loaded[index] = loaded = InternalUtilities.loadErrorMessage(index);
            return loaded;
        }
        return "Error";
    }

    public static JavaType getOuterClassOfNonstaticInner(ClassSym classSym) {
        Sym parentSym = classSym.getParentSym();
        if (parentSym == null) {
            return null;
        }
        switch (parentSym.symKind) {
            case 98: {
                return null;
            }
            case 4: {
                return classSym.isStatic() ? null : classSym.getOwningClassSym();
            }
        }
        Sym sym = parentSym;
        while (sym != null) {
            if (sym.symKind == 4) {
                return sym.getOwningClassSym();
            }
            if (sym.isStatic()) {
                return null;
            }
            sym = sym.symParent;
        }
        return null;
    }

    protected static JavaType getOuterClassOfNonstaticInner(JavaType subject) {
        if (subject == null) {
            return null;
        }
        if (subject instanceof ClassSym) {
            return InternalUtilities.getOuterClassOfNonstaticInner((ClassSym)subject);
        }
        if (subject.isExported()) {
            if (subject.isStatic()) {
                return null;
            }
        } else {
            boolean nonstatic;
            JavaField thisDollarZero = subject.getDeclaredField("this$0");
            boolean bl = nonstatic = thisDollarZero != null && thisDollarZero.isSynthetic();
            if (!nonstatic) {
                return null;
            }
        }
        return subject.getOwningClass();
    }

    public static Map<String, Object> getAnnotationArguments(JavaAnnotation javaAnnotation) {
        return InternalUtilities.getAnnotationArguments(javaAnnotation, true);
    }

    public static Map<String, Object> getUnresolvedAnnotationArguments(JavaAnnotation javaAnnotation) {
        return InternalUtilities.getAnnotationArguments(javaAnnotation, false);
    }

    private static Map<String, Object> getAnnotationArguments(JavaAnnotation javaAnnotation, boolean resolved) {
        Map<String, Object> componentMap = javaAnnotation.getComponents();
        if (componentMap == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> argumentMap = new HashMap<String, Object>(componentMap.size());
        for (Map.Entry<String, Object> stringObjectEntry : componentMap.entrySet()) {
            Object value;
            InternalAnnotationComponent entry = (InternalAnnotationComponent)stringObjectEntry;
            if (!entry.isAnnotationArgument() || (value = resolved ? entry.getValue() : entry.unresolvedValue) == null) continue;
            argumentMap.put(entry.getKey(), value);
        }
        return argumentMap;
    }
}

