/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.WrapperField;
import oracle.javatools.parser.java.v2.common.WrapperLocalVariable;
import oracle.javatools.parser.java.v2.common.WrapperMethod;
import oracle.javatools.parser.java.v2.internal.model.WrappedJavaType;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.parser.java.v2.model.SourceClass;

final class TypeErasedClass
extends WrappedJavaType
implements JavaClass {
    private JavaType erasedSuperClass;
    private Collection<JavaType> erasedInterfaces;
    private Collection<JavaMethod> erasedConstructors;
    private Collection<JavaMethod> erasedMethods;
    private Collection<JavaField> erasedFields;
    private JavaProvider provider;

    TypeErasedClass(JavaProvider provider, JavaType baseType) {
        super(baseType);
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JavaType getSuperclass() {
        if (this.erasedSuperClass == null) {
            TypeErasedClass typeErasedClass = this;
            synchronized (typeErasedClass) {
                if (this.erasedSuperClass == null) {
                    JavaType superType = super.getSuperclass();
                    this.erasedSuperClass = this.eraseSuper(superType) ? new TypeErasedClass(this.provider, superType) : superType;
                }
            }
        }
        return this.erasedSuperClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<JavaType> getInterfaces() {
        if (this.erasedInterfaces == null) {
            TypeErasedClass typeErasedClass = this;
            synchronized (typeErasedClass) {
                if (this.erasedInterfaces == null) {
                    Collection<JavaType> interfaces = super.getInterfaces();
                    if (interfaces.isEmpty()) {
                        this.erasedInterfaces = Collections.emptyList();
                    } else {
                        ArrayList<JavaType> interfacesFound = new ArrayList<JavaType>();
                        for (JavaType type : interfaces) {
                            interfacesFound.add(this.eraseSuper(type) ? new TypeErasedClass(this.provider, type) : type);
                        }
                        this.erasedInterfaces = interfacesFound;
                    }
                }
            }
        }
        return this.erasedInterfaces;
    }

    @Override
    public JavaClass getTypeErasure() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<JavaMethod> getDeclaredConstructors() {
        if (this.erasedConstructors != null) {
            return this.erasedConstructors;
        }
        TypeErasedClass typeErasedClass = this;
        synchronized (typeErasedClass) {
            if (this.erasedConstructors == null) {
                Collection<JavaMethod> thingConstructors = super.getDeclaredConstructors();
                ArrayList<JavaMethod> constructorsFound = new ArrayList<JavaMethod>();
                for (JavaMethod thingConstructor : thingConstructors) {
                    constructorsFound.add(new TypeErasedMethod(thingConstructor.getMethodErasure()));
                }
                this.erasedConstructors = constructorsFound;
            }
        }
        return this.erasedConstructors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<JavaMethod> getDeclaredMethods() {
        if (this.erasedMethods != null) {
            return this.erasedMethods;
        }
        TypeErasedClass typeErasedClass = this;
        synchronized (typeErasedClass) {
            if (this.erasedMethods == null) {
                Collection<JavaMethod> declared = super.getDeclaredMethods();
                ArrayList<JavaMethod> methodsFound = new ArrayList<JavaMethod>();
                for (JavaMethod method : declared) {
                    methodsFound.add(this.eraseMember(method) ? new TypeErasedMethod(method.getMethodErasure()) : new TypeErasedMethod(method));
                }
                this.erasedMethods = methodsFound;
            }
        }
        return this.erasedMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<JavaField> getDeclaredFields() {
        if (this.erasedFields != null) {
            return this.erasedFields;
        }
        TypeErasedClass typeErasedClass = this;
        synchronized (typeErasedClass) {
            if (this.erasedFields == null) {
                Collection<JavaField> fields = super.getDeclaredFields();
                ArrayList<JavaField> fieldsFound = new ArrayList<JavaField>();
                for (JavaField field : fields) {
                    JavaType fieldType = field.getResolvedType();
                    if (this.eraseMember(field) && fieldType != null && (fieldType.hasTypeParameters() || fieldType.getElementKind() == 10)) {
                        fieldsFound.add(new TypeErasedField(field.getFieldErasure()));
                        continue;
                    }
                    fieldsFound.add(field);
                }
                this.erasedFields = fieldsFound;
            }
        }
        return this.erasedFields;
    }

    @Override
    public boolean hasActualTypeArguments() {
        return false;
    }

    @Override
    public Collection<JavaType> getActualTypeArguments() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasTypeParameters() {
        return this.wrappedType.hasTypeParameters();
    }

    @Override
    public Collection<JavaTypeVariable> getTypeParameters() {
        return this.wrappedType.getTypeParameters();
    }

    @Override
    public JavaTypeVariable getTypeParameter(String name) {
        return this.wrappedType.getTypeParameter(name);
    }

    @Override
    public boolean isErasedType() {
        return true;
    }

    @Override
    public String getUnqualifiedName() {
        return this.getName();
    }

    @Override
    public String getQualifiedName() {
        return this.getRawName();
    }

    @Override
    public void clearCompiledInfo() {
        if (this.wrappedType instanceof JavaClass) {
            ((JavaClass)this.wrappedType).clearCompiledInfo();
        }
    }

    @Override
    public SourceClass getSourceElement() {
        return this.wrappedType instanceof JavaClass ? ((JavaClass)this.wrappedType).getSourceElement() : null;
    }

    private boolean eraseMember(JavaMember javaMember) {
        if (!javaMember.isStatic()) {
            return true;
        }
        JavaClass owningClass = javaMember.getOwningClass();
        return owningClass != null && owningClass.isStatic();
    }

    private boolean eraseSuper(JavaType superType) {
        if (superType == null || !superType.hasTypeParameters()) {
            return false;
        }
        if (!superType.hasActualTypeArguments()) {
            return true;
        }
        Collection<JavaTypeVariable> typeParams = this.getTypeParameters();
        return this.typeArgMatchesAnyTypeParameter(superType, typeParams);
    }

    private boolean typeArgMatchesAnyTypeParameter(JavaType typeArg, Collection typeParams) {
        block7: {
            block6: {
                if (typeArg == null) {
                    return false;
                }
                if (typeParams.contains(typeArg)) {
                    return true;
                }
                if (typeArg.getElementKind() != 11) break block6;
                JavaWildcardType wildcard = (JavaWildcardType)typeArg;
                Collection<JavaType> bounds = wildcard.getLowerBounds();
                if (bounds.isEmpty()) {
                    bounds = wildcard.getUpperBounds();
                } else {
                    bounds.addAll(wildcard.getUpperBounds());
                }
                for (JavaType bound : bounds) {
                    if (!this.typeArgMatchesAnyTypeParameter(bound, typeParams)) continue;
                    return true;
                }
                break block7;
            }
            if (!typeArg.hasActualTypeArguments()) break block7;
            Collection<JavaType> actualTypeArgs = typeArg.getActualTypeArguments();
            for (JavaType actualTypeArg : actualTypeArgs) {
                if (!this.typeArgMatchesAnyTypeParameter(actualTypeArg, typeParams)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public JavaType getQualifyingType() {
        return this.wrappedType.getQualifyingType();
    }

    @Override
    public void setQualifyingType(JavaType qualifyingType) {
        this.wrappedType.setQualifyingType(qualifyingType);
    }

    @Override
    public String getUniqueIdentifier() {
        return CommonUtilities.getUniqueIdentifier(this);
    }

    @Override
    public String getDescriptor() {
        return CommonUtilities.getDescriptor(this);
    }

    @Override
    public String getTypeSignature() {
        return CommonUtilities.getTypeSignature(this);
    }

    @Override
    public String getSignature() {
        return CommonUtilities.getSignature(this);
    }

    @Override
    public JavaType getNonParameterizedType() {
        return this.wrappedType.getNonParameterizedType();
    }

    private class TypeErasedMethod
    extends WrapperMethod {
        private volatile Collection<JavaVariable> erasedParameters;

        private TypeErasedMethod(JavaMethod baseMethod) {
            super(baseMethod);
            this.erasedParameters = null;
        }

        @Override
        public JavaType getResolvedType() {
            return this.eraseResolvedType(this.method.getResolvedType());
        }

        private JavaType eraseResolvedType(JavaType resolvedType) {
            if (!TypeErasedClass.this.eraseMember(this.method)) {
                return resolvedType;
            }
            if (resolvedType != null) {
                if (resolvedType.isArray()) {
                    JavaType resolvedComponentType = this.eraseResolvedType(resolvedType.getComponentType());
                    return CommonUtilities.createArrayType(TypeErasedClass.this.provider, resolvedComponentType, 1);
                }
                if (resolvedType.getElementKind() == 10) {
                    return resolvedType.getTypeErasure();
                }
                if (resolvedType.hasTypeParameters()) {
                    return new TypeErasedClass(TypeErasedClass.this.provider, resolvedType);
                }
            }
            return resolvedType;
        }

        @Override
        public JavaType getReturnType() {
            return this.eraseResolvedType(this.method.getReturnType());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<JavaVariable> getParameters() {
            if (this.erasedParameters != null) {
                return this.erasedParameters;
            }
            TypeErasedMethod typeErasedMethod = this;
            synchronized (typeErasedMethod) {
                if (this.erasedParameters == null) {
                    Collection<JavaVariable> parameters = super.getParameters();
                    ArrayList<JavaVariable> parametersFound = new ArrayList<JavaVariable>();
                    for (JavaVariable parameter : parameters) {
                        JavaType type = parameter.getResolvedType();
                        if (TypeErasedClass.this.eraseMember(this) && type != null && (type.hasTypeParameters() || type.getElementKind() == 10)) {
                            parametersFound.add(new TypeErasedParameter(((JavaLocalVariable)parameter).getLocalVariableErasure()));
                            continue;
                        }
                        parametersFound.add(parameter);
                    }
                    this.erasedParameters = parametersFound;
                }
            }
            return this.erasedParameters;
        }

        @Override
        public JavaMethod getMethodErasure() {
            return this.method.getMethodErasure();
        }

        @Override
        public Collection<JavaTypeVariable> getTypeParameters() {
            if (!TypeErasedClass.this.eraseMember(this)) {
                return super.getTypeParameters();
            }
            return Collections.emptyList();
        }

        @Override
        public JavaTypeVariable getTypeParameter(String name) {
            return !TypeErasedClass.this.eraseMember(this) ? super.getTypeParameter(name) : null;
        }

        @Override
        public boolean hasTypeParameters() {
            return !TypeErasedClass.this.eraseMember(this) && super.hasTypeParameters();
        }

        private class TypeErasedParameter
        extends WrapperLocalVariable {
            private TypeErasedParameter(JavaLocalVariable baseVariable) {
                super(baseVariable);
            }

            private JavaType eraseResolvedType(JavaType resolvedType) {
                if (!TypeErasedClass.this.eraseMember(TypeErasedMethod.this)) {
                    return resolvedType;
                }
                if (resolvedType == null) {
                    return resolvedType;
                }
                if (resolvedType.isArray()) {
                    JavaType resolvedComponentType = this.eraseResolvedType(resolvedType.getComponentType());
                    return CommonUtilities.createArrayType(TypeErasedClass.this.provider, resolvedComponentType, 1);
                }
                if (resolvedType.getElementKind() == 10) {
                    return resolvedType.getTypeErasure();
                }
                if (resolvedType.hasTypeParameters()) {
                    return new TypeErasedClass(TypeErasedClass.this.provider, resolvedType);
                }
                return resolvedType;
            }

            @Override
            public JavaType getResolvedType() {
                return this.eraseResolvedType(super.getResolvedType());
            }

            @Override
            public JavaElement getOwner() {
                return TypeErasedMethod.this;
            }

            @Override
            public JavaLocalVariable getLocalVariableErasure() {
                return this;
            }
        }
    }

    private class TypeErasedField
    extends WrapperField {
        private TypeErasedField(JavaField baseField) {
            super(baseField);
        }

        private JavaType eraseResolvedType(JavaType resolvedType) {
            if (resolvedType == null) {
                return resolvedType;
            }
            if (resolvedType.isArray()) {
                JavaType resolvedComponentType = this.eraseResolvedType(resolvedType.getComponentType());
                return CommonUtilities.createArrayType(TypeErasedClass.this.provider, resolvedComponentType, 1);
            }
            if (resolvedType.getElementKind() == 10) {
                return resolvedType.getTypeErasure();
            }
            if (resolvedType.hasTypeParameters()) {
                return new TypeErasedClass(TypeErasedClass.this.provider, resolvedType);
            }
            return resolvedType;
        }

        @Override
        public JavaType getResolvedType() {
            return this.eraseResolvedType(super.getResolvedType());
        }

        @Override
        public JavaClass getOwningClass() {
            return TypeErasedClass.this;
        }

        @Override
        public JavaField getFieldErasure() {
            return this.thing;
        }
    }
}

