/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import oracle.javatools.parser.java.v2.common.AbstractField;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceEnumConstant;

public class QuickField
extends AbstractField {
    private JavaClass owningClass;
    private char modifiers;
    private JavaType type;
    private String name;
    private Object constantValue;

    public static QuickField createField(JavaClass owningClass, char modifiers, JavaVariable variable) {
        return new QuickField(owningClass, modifiers, variable.getResolvedType(), variable.getName(), null);
    }

    public static QuickField createField(JavaClass owningClass, char modifiers, JavaVariable variable, Object constantValue) {
        return new QuickField(owningClass, modifiers, variable.getResolvedType(), variable.getName(), constantValue);
    }

    public static QuickField createField(JavaClass owningClass, char modifiers, JavaType type, String name) {
        return new QuickField(owningClass, modifiers, type, name, null);
    }

    public static QuickField createField(JavaClass owningClass, char modifiers, JavaType type, String name, Object constantValue) {
        return new QuickField(owningClass, modifiers, type, name, constantValue);
    }

    private QuickField(JavaClass owningClass, char modifiers, JavaType type, String name, Object constantValue) {
        this.owningClass = owningClass;
        this.modifiers = modifiers;
        this.type = type;
        this.name = name;
        this.constantValue = constantValue;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public JavaClass getOwningClass() {
        return this.owningClass;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JavaType getResolvedType() {
        return this.type;
    }

    @Override
    public boolean isEnumConstant() {
        return this.constantValue instanceof SourceEnumConstant;
    }

    @Override
    public Object getConstantValue() {
        return this.constantValue;
    }
}

