/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.ParameterizedClass;
import oracle.javatools.parser.java.v2.common.WildcardType;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaIsGeneric;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;

final class Parameterization
implements JavaConstants {
    final JavaProvider provider;
    final JavaIsGeneric baseObject;
    final JavaType[] boundArguments;
    final Map<JavaType, JavaType> typeParamToTypeArgMap;

    Parameterization(JavaProvider provider, JavaIsGeneric baseObject, JavaType[] boundArguments) {
        JavaClass owningClass;
        this.provider = provider;
        this.baseObject = baseObject;
        this.boundArguments = boundArguments;
        LinkedHashMap<JavaType, JavaType> map = null;
        if (boundArguments.length > 0) {
            map = new LinkedHashMap<JavaType, JavaType>();
            int i = 0;
            for (JavaTypeVariable typeVariable : baseObject.getTypeParameters()) {
                map.put(typeVariable, boundArguments[i++]);
            }
        }
        if ((owningClass = baseObject.getOwningClass()) instanceof ParameterizedClass) {
            ParameterizedClass owningBoundType = (ParameterizedClass)owningClass;
            if (!owningBoundType.params.typeParamToTypeArgMap.isEmpty()) {
                if (map == null) {
                    map = new LinkedHashMap();
                }
                map.putAll(owningBoundType.params.typeParamToTypeArgMap);
            }
        }
        this.typeParamToTypeArgMap = map == null ? Collections.emptyMap() : map;
    }

    Parameterization(JavaIsGeneric baseObject, Parameterization otherParams) {
        this.provider = otherParams.provider;
        this.baseObject = baseObject;
        this.boundArguments = JavaType.EMPTY_ARRAY;
        this.typeParamToTypeArgMap = otherParams.typeParamToTypeArgMap;
    }

    final JavaType bind(JavaType thing) {
        JavaType[] boundArgs;
        Collection<JavaType> arguments;
        JavaClass owningClass;
        JavaType owningBound;
        if (thing == null) {
            return null;
        }
        if (thing.isPrimitive()) {
            return thing;
        }
        if (thing.isArray()) {
            JavaType bound = this.bind(thing.getComponentType());
            return bound == thing ? thing : CommonUtilities.createArrayType(this.provider, bound, 1);
        }
        switch (thing.getElementKind()) {
            case 11: {
                Collection<JavaType> lowers;
                JavaWildcardType wildcard = (JavaWildcardType)thing;
                JavaType upper = null;
                JavaType lower = null;
                Collection<JavaType> uppers = wildcard.getUpperBounds();
                if (!uppers.isEmpty()) {
                    upper = uppers.iterator().next();
                }
                if (!(lowers = wildcard.getLowerBounds()).isEmpty()) {
                    lower = lowers.iterator().next();
                }
                JavaType boundUpper = this.bind(upper);
                JavaType boundLower = this.bind(lower);
                return upper == boundUpper && lower == boundLower ? thing : new WildcardType(boundUpper, boundLower, this.provider);
            }
            case 10: {
                JavaType mapped = this.typeParamToTypeArgMap.get(thing);
                if (mapped == null) {
                    return thing;
                }
                if (mapped instanceof WildcardType) {
                    JavaTypeVariable typeParamSym;
                    Collection<JavaType> bounds;
                    WildcardType wildcardType = (WildcardType)mapped;
                    if (wildcardType.getUpperBound() == null && wildcardType.getLowerBound() == null) {
                        JavaType bound;
                        JavaTypeVariable typeParamSym2 = (JavaTypeVariable)thing;
                        Collection<JavaType> bounds2 = typeParamSym2.getBounds();
                        if (bounds2 != null && bounds2.size() > 0 && (bound = bounds2.iterator().next()) != null) {
                            return CommonUtilities.createWildcardType((byte)1, bound, this.provider);
                        }
                    } else if (wildcardType.getLowerBound() != null && wildcardType.getUpperBound() == null && (bounds = (typeParamSym = (JavaTypeVariable)thing).getBounds()) != null && bounds.size() > 0) {
                        JavaType upperBound = bounds.iterator().next();
                        JavaType lowerBound = wildcardType.getLowerBound();
                        if (upperBound != null && lowerBound != null && upperBound.equals(lowerBound)) {
                            return upperBound;
                        }
                    }
                }
                return mapped;
            }
        }
        if (thing.isMemberClass() && (owningBound = this.bind(owningClass = thing.getOwningClass())) != owningClass) {
            Collection<JavaType> actualTypeArguments = thing.getActualTypeArguments();
            if ((thing = owningBound.getDeclaredClass(thing.getName())) == null) {
                return null;
            }
            if (!actualTypeArguments.isEmpty()) {
                JavaType[] argArray = actualTypeArguments.toArray(new JavaType[actualTypeArguments.size()]);
                thing = new ParameterizedClass(this.provider, (JavaClass)thing, argArray);
            }
        }
        if ((arguments = thing.getActualTypeArguments()).isEmpty()) {
            return thing;
        }
        int argumentCount = arguments.size();
        JavaType[] argumentArray = arguments.toArray(new JavaType[argumentCount]);
        if (argumentArray == (boundArgs = this.bindImpl(argumentArray))) {
            return thing;
        }
        try {
            ParameterizedClass paramThing = (ParameterizedClass)thing;
            return new ParameterizedClass(this.provider, paramThing.delegate, boundArgs);
        }
        catch (ClassCastException e) {
            return thing;
        }
    }

    final Collection<JavaType> bind(Collection<JavaType> things) {
        JavaType[] out;
        if (things.isEmpty()) {
            return Collections.emptyList();
        }
        int count = things.size();
        JavaType[] in = things.toArray(new JavaType[count]);
        if (in == (out = this.bindImpl(in))) {
            return things;
        }
        ArrayList<JavaType> javaTypes = new ArrayList<JavaType>();
        for (JavaType javaType : out) {
            if (javaType == null) continue;
            javaTypes.add(javaType);
        }
        return javaTypes;
    }

    JavaType bindNoWildcard(JavaType javaType) {
        if (javaType == null) {
            return null;
        }
        if (javaType.isArray()) {
            JavaType bound = this.bindNoWildcard(javaType.getComponentType());
            return CommonUtilities.createArrayType(this.provider, bound, 1);
        }
        JavaType result = this.bind(javaType);
        if (result != null && result.getElementKind() == 11) {
            JavaWildcardType wildcard = (JavaWildcardType)result;
            if (!wildcard.getUpperBounds().isEmpty()) {
                return wildcard.getUpperBounds().iterator().next();
            }
            return wildcard.getTypeErasure();
        }
        return result;
    }

    private JavaType[] bindImpl(JavaType[] things) {
        int count = things.length;
        if (count == 0) {
            return things;
        }
        JavaType[] out = new JavaType[count];
        boolean bound = false;
        for (int i = 0; i < count; ++i) {
            JavaType boundThing;
            JavaType thing = things[i];
            out[i] = boundThing = this.bind(thing);
            if (thing == boundThing) continue;
            bound = true;
        }
        if (!bound) {
            return things;
        }
        return out;
    }
}

