/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CancellationException;
import oracle.javatools.buffer.GuardedTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.parser.java.v2.common.ArrayType;
import oracle.javatools.parser.java.v2.common.IntersectionType;
import oracle.javatools.parser.java.v2.common.ParameterizedClass;
import oracle.javatools.parser.java.v2.common.ParameterizedMethod;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.common.QuickSignatureParser;
import oracle.javatools.parser.java.v2.common.SignatureHasType;
import oracle.javatools.parser.java.v2.common.TypeErasedClass;
import oracle.javatools.parser.java.v2.common.WildcardType;
import oracle.javatools.parser.java.v2.internal.model.AnnotatedJavaClass;
import oracle.javatools.parser.java.v2.internal.model.AnnotatedJavaType;
import oracle.javatools.parser.java.v2.internal.model.AnnotatedJavaTypeVariable;
import oracle.javatools.parser.java.v2.internal.model.AnnotatedJavaWildcardType;
import oracle.javatools.parser.java.v2.internal.model.AnnotatedPrimitiveType;
import oracle.javatools.parser.java.v2.internal.model.WrappedJavaType;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaHasAnnotations;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaIsGeneric;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaRecordComponent;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceCatchParameter;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceEnumConstant;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceHasModifiers;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceRecordComponent;
import oracle.javatools.parser.java.v2.model.SourceToken;
import oracle.javatools.parser.java.v2.model.SourceTypeArgument;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceArrayAccessExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInfixExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLambdaExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewArrayExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceQuestionExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceTypecastExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceAssertStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceCatchClause;
import oracle.javatools.parser.java.v2.model.statement.SourceFinallyClause;
import oracle.javatools.parser.java.v2.model.statement.SourceForStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceTryStatement;
import oracle.javatools.parser.java.v2.util.BindingContext;
import oracle.javatools.parser.java.v2.util.Conversions;
import oracle.javatools.parser.java.v2.util.SourceVisitor;
import oracle.javatools.util.JavaHasNameSet;

public class CommonUtilities
extends Conversions
implements JavaConstants {
    private static final byte OPTYPE_ASSIGNMENT = 0;
    private static final byte OPTYPE_RELATIONAL = 1;
    private static final byte OPTYPE_SHIFT = 2;
    private static final byte OPTYPE_INFIX = 3;
    private static final byte OPTYPE_PREFIX = 4;
    private static final byte OPTYPE_POSTFIX = 5;
    private static final byte OPTYPE_max = 6;
    private static final byte[][] op2optTable = CommonUtilities.initOp2OptTable();
    private static final Map<String, Short> keywordToToken = CommonUtilities.initKeywordToToken();
    private static final Set<String> reservedLiterals = CommonUtilities.initReservedLiterals();

    public static JdkVersion provider2JdkVersion(JavaProvider provider) {
        if (provider == null) {
            return JdkVersion.JDK_17;
        }
        return JdkVersion.getLoaderJdkVersion((version, typeName) -> provider.getClass(typeName) != null);
    }

    public static boolean isInGuardedSection(SourceElement sourceElement) {
        TextBuffer buffer;
        SourceFile sourceFile;
        if (sourceElement == null) {
            throw new IllegalArgumentException("Null argument");
        }
        int startOffset = sourceElement.getStartOffset();
        int endOffset = sourceElement.getEndOffset();
        if (startOffset >= 0 && endOffset > startOffset && (sourceFile = sourceElement.getOwningSourceFile()) != null && (buffer = sourceFile.getTextBuffer()) instanceof GuardedTextBuffer) {
            int count = endOffset - startOffset;
            return ((GuardedTextBuffer)buffer).isOffsetRangeGuarded(startOffset, count);
        }
        return false;
    }

    public static PrimitiveType getPrimitiveType(String name) {
        return PrimitiveType.lookupPrimitive(name);
    }

    public static JavaType createArrayType(JavaProvider provider, JavaType component, int dimensions) {
        return CommonUtilities.createArrayType(provider, component, dimensions, null);
    }

    public static JavaType createArrayType(JavaProvider provider, JavaType component, int dimensions, List<List<JavaAnnotation>> typeAnnotations) {
        if (component == null) {
            return null;
        }
        if (dimensions == 0) {
            return component;
        }
        if (dimensions < 0) {
            throw new IllegalArgumentException("Negative dimensions");
        }
        if (typeAnnotations != null && !typeAnnotations.isEmpty() && typeAnnotations.size() != dimensions) {
            throw new IllegalArgumentException("Dimensions and typeAnnotations.size() don't match");
        }
        JavaType type = component;
        for (int i = 0; i < dimensions; ++i) {
            type = new ArrayType(provider, type);
            if (typeAnnotations == null || typeAnnotations.isEmpty()) continue;
            ((ArrayType)type).setTypeAnnotations(typeAnnotations.get(dimensions - 1 - i));
        }
        return type;
    }

    public static JavaType createTypeErasedClass(JavaProvider provider, JavaType type) {
        return new TypeErasedClass(provider, type);
    }

    public static JavaType createParameterizedType(JavaProvider provider, JavaType generic, JavaType[] typeArguments) {
        int argumentCount;
        if (!CommonUtilities.allowsParameterization(generic)) {
            return generic;
        }
        Collection<JavaTypeVariable> parameters = generic.getTypeParameters();
        int parameterCount = parameters.size();
        if (parameterCount != (argumentCount = typeArguments.length)) {
            String message = "Arguments mismatch: " + generic.getQualifiedName();
            throw new IllegalArgumentException(message);
        }
        try {
            return new ParameterizedClass(provider, (JavaClass)generic, typeArguments);
        }
        catch (ClassCastException e) {
            return generic;
        }
    }

    private static boolean allowsParameterization(JavaType type) {
        if (type == null || type.getElementKind() != 3) {
            return false;
        }
        return type.getTypeParameters().size() > 0;
    }

    public static JavaType createDiamondParameterizedType(JavaProvider provider, JavaType type) {
        try {
            JavaClass genericClass = (JavaClass)type;
            return new ParameterizedClass(provider, genericClass, JavaType.EMPTY_ARRAY);
        }
        catch (ClassCastException e) {
            return type;
        }
    }

    public static JavaType createAnnotatedJavaType(JavaType javaType, List<JavaAnnotation> annotations) {
        switch (javaType.getElementKind()) {
            case 3: {
                if (javaType.isPrimitive()) {
                    javaType = new AnnotatedPrimitiveType(((PrimitiveType)javaType).primCode, annotations);
                    break;
                }
                if (javaType instanceof AnnotatedJavaType) {
                    ((AnnotatedJavaType)((Object)javaType)).setTypeAnnotations(annotations);
                    break;
                }
                javaType = new AnnotatedJavaClass((JavaClass)javaType, annotations);
                break;
            }
            case 10: {
                javaType = new AnnotatedJavaTypeVariable((JavaTypeVariable)javaType, annotations);
                break;
            }
            case 11: {
                javaType = new AnnotatedJavaWildcardType((JavaWildcardType)javaType, annotations);
                break;
            }
            default: {
                javaType = new WrappedJavaType(javaType, annotations);
            }
        }
        return javaType;
    }

    public static JavaMethod createParameterizedMethod(JavaProvider provider, JavaMethod generic, JavaType[] typeArguments) {
        Collection<JavaTypeVariable> parameters = generic.getTypeParameters();
        int parameterCount = parameters.size();
        if (parameterCount == 0) {
            throw new IllegalArgumentException("Not a generic type");
        }
        int argumentCount = typeArguments.length;
        if (parameterCount != argumentCount) {
            throw new IllegalArgumentException("Arguments mismatch");
        }
        return new ParameterizedMethod(provider, generic, typeArguments);
    }

    public static JavaType createWildcardType(byte bound, JavaType t, JavaProvider provider) {
        switch (bound) {
            case 0: {
                return t;
            }
            case 2: {
                if (t != null) {
                    return new WildcardType(null, t, provider);
                }
                throw new IllegalArgumentException();
            }
            case 1: {
                return new WildcardType(t, null, provider);
            }
            case 3: {
                if (t != null) break;
                return new WildcardType(null, null, provider);
            }
        }
        throw new IllegalArgumentException();
    }

    public static boolean isFunctionalInterface(JavaType javaType) {
        return CommonUtilities.getFunctionalInterfaceMethod(javaType) != null;
    }

    public static boolean isMarkerInterface(JavaType javaType) {
        if (javaType == null || !javaType.isInterface()) {
            return false;
        }
        List<JavaType> hierarchy = CommonUtilities.getClassHierarchy(javaType);
        hierarchy.add(javaType);
        for (JavaType type : hierarchy) {
            if (type == null || !type.isInterface()) continue;
            for (JavaMethod method : type.getDeclaredMethods()) {
                if (method.isSynthetic()) continue;
                return false;
            }
            if (type.getDeclaredFields().size() > 0) {
                return false;
            }
            if (type.getDeclaredClasses().size() <= 0) continue;
            return false;
        }
        return true;
    }

    private static JavaMethod getFunctionalInterfaceMethod(IntersectionType intersectionType) {
        JavaType sam = null;
        for (JavaType type : intersectionType.getTypes()) {
            if (CommonUtilities.isFunctionalInterface(type)) {
                if (sam != null) {
                    return null;
                }
                sam = type;
                continue;
            }
            if (CommonUtilities.isMarkerInterface(type)) continue;
            return null;
        }
        return CommonUtilities.getFunctionalInterfaceMethod(sam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaMethod getFunctionalInterfaceMethod(JavaType javaType) {
        if (javaType == null) {
            return null;
        }
        if (javaType.getElementKind() == 12) {
            return CommonUtilities.getFunctionalInterfaceMethod((IntersectionType)javaType);
        }
        if (!javaType.isInterface()) {
            return null;
        }
        ArrayList foundMethods = CommonUtilities.allocArrayList();
        ArrayList methodsToSkip = CommonUtilities.allocArrayList();
        try {
            String foundName = null;
            Collection<JavaMethod> methods = javaType.getMethods();
            String[] objectMethodDescriptors = new String[]{"getClass()Ljava/lang/Class;", "hashCode()I", "equals(Ljava/lang/Object;)Z", "toString()Ljava/lang/String;", "notify()V", "notifyAll()V", "wait(J)V", "wait(JI)V", "wait()V"};
            block6: for (JavaMethod method : methods) {
                if (methodsToSkip.contains(method)) continue;
                if (!method.isAbstract()) {
                    methodsToSkip.addAll(method.getOverriddenMethods());
                    continue;
                }
                String nameDescriptor = method.getName() + method.getDescriptor();
                for (String objectMethodDescriptor : objectMethodDescriptors) {
                    if (nameDescriptor.equals(objectMethodDescriptor)) continue block6;
                }
                String methodName = method.getName();
                if (foundName == null) {
                    foundName = methodName;
                } else if (!foundName.equals(methodName)) {
                    JavaMethod javaMethod = null;
                    return javaMethod;
                }
                foundMethods.add(method);
            }
            if (foundMethods.isEmpty()) {
                Iterator<JavaMethod> iterator = null;
                return iterator;
            }
            JavaMethod foundMethod = (JavaMethod)foundMethods.get(0);
            for (int i = 1; i < foundMethods.size(); ++i) {
                JavaMethod otherMethod = (JavaMethod)foundMethods.get(i);
                if (CommonUtilities.isFunctionallyEquivalent(foundMethod, otherMethod)) continue;
                if (CommonUtilities.isFunctionallyEquivalent(otherMethod, foundMethod)) {
                    foundMethod = otherMethod;
                    continue;
                }
                String[] stringArray = null;
                return stringArray;
            }
            JavaMethod javaMethod = foundMethod;
            return javaMethod;
        }
        finally {
            CommonUtilities.freeArrayList(foundMethods);
            CommonUtilities.freeArrayList(methodsToSkip);
        }
    }

    private static boolean isFunctionallyEquivalent(JavaMethod subject, JavaMethod target) {
        return Conversions.hasSubsignatureOf(subject, target) && Conversions.isReturnTypeSubstitutable(subject, target);
    }

    public static Collection<JavaType> getTargetType(SourceExpression expression, Collection<JavaType> exceptions) {
        SourceElement parent = expression.getParent();
        switch (parent.getSymbolKind()) {
            case 7: 
            case 10: 
            case 17: {
                return CommonUtilities.singletonOrEmptyList(((SourceVariable)parent).getResolvedType());
            }
            case 47: {
                SourceAssertStatement asser = (SourceAssertStatement)parent;
                if (expression == asser.getExpression()) {
                    return CommonUtilities.singletonOrEmptyList(CommonUtilities.getPrimitiveType("boolean"));
                }
                return Collections.emptyList();
            }
            case 52: 
            case 58: 
            case 64: {
                return CommonUtilities.singletonOrEmptyList(CommonUtilities.getPrimitiveType("boolean"));
            }
            case 57: {
                SourceForStatement loop = (SourceForStatement)parent;
                if (expression == loop.getForConditional()) {
                    return CommonUtilities.singletonOrEmptyList(CommonUtilities.getPrimitiveType("boolean"));
                }
                return Collections.emptyList();
            }
            case 59: {
                SourceMethod method = CommonUtilities.getEnclosingMethod(parent);
                if (method != null) {
                    JavaType type = method.getReturnType();
                    if (type == null || "void".equals(type.getName())) {
                        return Collections.emptyList();
                    }
                    return CommonUtilities.singletonOrEmptyList(type);
                }
                return Collections.emptyList();
            }
            case 62: {
                return exceptions != null ? exceptions : CommonUtilities.getHandledExceptions(parent);
            }
            case 68: {
                SourceAssignmentExpression assignment = (SourceAssignmentExpression)parent;
                SourceExpression lhs = assignment.getFirstOperand();
                if (expression == lhs) {
                    Collection<JavaType> expectedTypes = CommonUtilities.getTargetType(assignment, exceptions);
                    if (expectedTypes.isEmpty()) {
                        expectedTypes = CommonUtilities.singletonOrEmptyList(assignment.getSecondOperand().getResolvedType());
                    }
                    return expectedTypes;
                }
                JavaType type = lhs.getResolvedType();
                if (type != null) {
                    SourceAssignmentExpression assignExprRhs;
                    SourceExpression secondOperand;
                    SourceExpression rhs = expression;
                    if (rhs.getSymbolKind() == 68 && (secondOperand = (assignExprRhs = (SourceAssignmentExpression)rhs).getSecondOperand()) != null) {
                        rhs = secondOperand;
                    }
                    if (rhs.getSymbolKind() != 71 && rhs.getSymbolKind() != 74 && type.isArray()) {
                        SourceElement greatGrandParent;
                        SourceElement grandParent = parent.getParent();
                        SourceElement sourceElement = greatGrandParent = grandParent == null ? null : grandParent.getParent();
                        if (greatGrandParent != null && greatGrandParent.getSymbolKind() == 1 && grandParent.getSymbolKind() == 71) {
                            type = type.getComponentType();
                        }
                    }
                }
                return CommonUtilities.singletonOrEmptyList(type);
            }
            case 69: {
                SourceDotExpression dotExpression = (SourceDotExpression)parent;
                SourceExpression lhs = dotExpression.getLhsOperand();
                if (expression == lhs) {
                    return CommonUtilities.singletonOrEmptyList(lhs.getResolvedType());
                }
                return CommonUtilities.getTargetType((SourceExpression)parent, exceptions);
            }
            case 70: {
                SourceInfixExpression infix = (SourceInfixExpression)parent;
                if (infix.getOperatorCode() == 20) {
                    SourceExpression other;
                    SourceExpression sourceExpression = other = expression == infix.getFirstOperand() ? infix.getSecondOperand() : infix.getFirstOperand();
                    if (other.getText().equals("null")) {
                        return Collections.emptyList();
                    }
                    return CommonUtilities.singletonOrEmptyList(other.getResolvedType());
                }
                return Collections.emptyList();
            }
            case 71: {
                SourceListExpression list = (SourceListExpression)parent;
                int index = list.getOperands().indexOf(expression);
                if (index < 0) {
                    return Collections.emptyList();
                }
                SourceElement grandParent = parent.getParent();
                switch (grandParent.getSymbolKind()) {
                    case 7: {
                        return CommonUtilities.getExpectedTypesFromConstructors(((SourceEnumConstant)grandParent).getResolvedType(), index);
                    }
                    case 73: {
                        SourceMethodCallExpression invocation = (SourceMethodCallExpression)grandParent;
                        if (CommonUtilities.isMethodReferenceOrLambda(expression)) {
                            return CommonUtilities.getFunctionalInterfaceTargetTypes(invocation, index);
                        }
                        JavaMethod method = invocation.getResolvedMethod();
                        if (method != null) {
                            JavaType[] parameterTypes = method.getParameterTypes();
                            JavaType type = null;
                            if (index < parameterTypes.length) {
                                type = parameterTypes[index];
                            } else if (method.isVarargs() && (type = parameterTypes[parameterTypes.length - 1]) != null) {
                                type = type.getComponentType();
                            }
                            if (type != null) {
                                type = new BindingContext(expression.getOwningSourceFile().getProvider(), method, CommonUtilities.getInvocationSearchType(invocation)).bind(type);
                                return CommonUtilities.singletonOrEmptyList(type);
                            }
                            return Collections.emptyList();
                        }
                        return Collections.emptyList();
                    }
                    case 75: {
                        SourceNewClassExpression invocation = (SourceNewClassExpression)grandParent;
                        if (CommonUtilities.isMethodReferenceOrLambda(expression)) {
                            return CommonUtilities.getFunctionalInterfaceTargetTypes(invocation, index);
                        }
                        JavaMethod method = invocation.getResolvedMethod();
                        if (method != null) {
                            JavaType[] parameterTypes = method.getParameterTypes();
                            JavaType type = null;
                            if (index < parameterTypes.length) {
                                type = parameterTypes[index];
                            } else if (method.isVarargs() && (type = parameterTypes[parameterTypes.length - 1]) != null) {
                                type = type.getComponentType();
                            }
                            if (type != null) {
                                type = new BindingContext(expression.getOwningSourceFile().getProvider(), method, CommonUtilities.getInvocationSearchType(invocation)).bind(type);
                                return CommonUtilities.singletonOrEmptyList(type);
                            }
                            return Collections.emptyList();
                        }
                        return CommonUtilities.getExpectedTypesFromConstructors(invocation.getResolvedType(), index);
                    }
                    case 1: {
                        JavaMethod method;
                        SourceAnnotation annotation = (SourceAnnotation)grandParent;
                        JavaType annotationType = annotation.getAnnotationType();
                        if (annotationType == null) {
                            return Collections.emptyList();
                        }
                        Collection<JavaMethod> methods = annotationType.getDeclaredMethods();
                        JavaType targetType = null;
                        if (annotation.getArgumentCount() == 1 && methods.size() == 1 && "value".equals((method = methods.iterator().next()).getName()) && (targetType = method.getReturnType()) != null) {
                            SourceAssignmentExpression assignExprRhs;
                            SourceExpression secondOperand;
                            SourceExpression rhs = expression;
                            if (rhs.getSymbolKind() == 68 && (secondOperand = (assignExprRhs = (SourceAssignmentExpression)rhs).getSecondOperand()) != null) {
                                rhs = secondOperand;
                            }
                            if (rhs.getSymbolKind() != 71 && rhs.getSymbolKind() != 74 && targetType.isArray()) {
                                targetType = targetType.getComponentType();
                            }
                        }
                        return CommonUtilities.singletonOrEmptyList(targetType);
                    }
                    case 57: {
                        return Collections.emptyList();
                    }
                    case 74: {
                        JavaType javaType = ((SourceNewArrayExpression)grandParent).getResolvedType();
                        if (javaType != null && javaType.isArray()) {
                            return CommonUtilities.singletonOrEmptyList(javaType.getComponentType());
                        }
                        return CommonUtilities.singletonOrEmptyList(javaType);
                    }
                }
                if (list.getStartOffset() >= 0 && '{' == list.getOwningSourceFile().getTextBuffer().getChar(list.getStartOffset())) {
                    Collection<JavaType> arrayTypes = CommonUtilities.getTargetType(list, exceptions);
                    if (arrayTypes.isEmpty()) {
                        return arrayTypes;
                    }
                    ArrayList<JavaType> types = new ArrayList<JavaType>(arrayTypes.size());
                    for (JavaType arrayType : arrayTypes) {
                        if (!arrayType.isArray()) continue;
                        types.add(arrayType.getComponentType());
                    }
                    return types;
                }
                return Collections.emptyList();
            }
            case 73: 
            case 75: {
                SourceInvokeExpression invocation = (SourceInvokeExpression)parent;
                JavaMethod method = invocation.getResolvedMethod();
                SourceExpression lhs = invocation.getLhsOperand();
                if (expression == lhs) {
                    if (method != null) {
                        return Collections.singletonList(method.getOwningClass());
                    }
                    return Collections.emptyList();
                }
                return Collections.emptyList();
            }
            case 76: {
                SourceQuestionExpression question = (SourceQuestionExpression)parent;
                if (expression == question.getFirstOperand()) {
                    return Collections.singletonList(CommonUtilities.getPrimitiveType("boolean"));
                }
                return CommonUtilities.getTargetType(question, exceptions);
            }
            case 79: {
                SourceExpression lhs = ((SourceTypecastExpression)parent).getOperandAt(0);
                return CommonUtilities.singletonOrEmptyList(lhs != null ? lhs.getResolvedType() : null);
            }
            case 80: {
                return CommonUtilities.getTargetType((SourceExpression)parent, exceptions);
            }
            case 81: {
                return CommonUtilities.getTargetType((SourceExpression)parent, exceptions);
            }
            case 83: {
                JavaMethod targetMethod = ((SourceLambdaExpression)parent).getTargetMethod();
                if (targetMethod != null) {
                    return CommonUtilities.singletonOrEmptyList(targetMethod.getResolvedType());
                }
                return Collections.emptyList();
            }
            case 74: {
                if (expression.getExpressionCode() == 5) {
                    return CommonUtilities.singletonOrEmptyList(((SourceNewArrayExpression)parent).getResolvedType());
                }
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    private static boolean isMethodReferenceOrLambda(SourceExpression expression) {
        while (expression != null && expression.getSymbolKind() == 81) {
            expression = expression.getFirstOperand();
        }
        return expression != null && (expression.getSymbolKind() == 82 || expression.getSymbolKind() == 83);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static List<JavaType> getFunctionalInterfaceTargetTypes(SourceInvokeExpression invocation, int index) {
        ArrayList<JavaType> targets = new ArrayList<JavaType>();
        ArrayList classes = CommonUtilities.allocArrayList();
        try {
            JavaType[] typeArgumentTypes;
            String name;
            block34: {
                block33: {
                    name = null;
                    if (invocation.getSymbolKind() != 75) break block33;
                    SourceNewClassExpression creator = (SourceNewClassExpression)invocation;
                    JavaType creatorResolvedType = creator.getResolvedType();
                    if (creatorResolvedType == null) break block34;
                    if (creatorResolvedType.isAnonymousClass()) {
                        creatorResolvedType = creatorResolvedType.getSuperclass();
                    }
                    if (creatorResolvedType == null) break block34;
                    classes.add(creatorResolvedType);
                    break block34;
                }
                name = ((SourceMethodCallExpression)invocation).getName();
                if (name == null) {
                    ArrayList<JavaType> creator = targets;
                    return creator;
                }
                SourceExpression expression = invocation.getLhsOperand();
                if (expression != null) {
                    JavaType lhsType = expression.getResolvedType();
                    if (lhsType != null) {
                        classes.add(lhsType);
                    }
                } else {
                    JavaProvider javaProvider;
                    SourceClass cls = CommonUtilities.getEnclosingType(invocation);
                    while (cls != null) {
                        classes.add(cls);
                        cls = CommonUtilities.getEnclosingType(cls);
                    }
                    SourceFile file = invocation.getOwningSourceFile();
                    if (file != null && (javaProvider = file.getProvider()) != null) {
                        List<SourceImport> imports = file.getSourceImports();
                        for (SourceImport oneImport : imports) {
                            int postfixLength;
                            String importName = oneImport.getName();
                            if (!oneImport.isStatic() || !importName.endsWith("." + name) && !importName.endsWith(".*")) continue;
                            int n = postfixLength = importName.endsWith(".*") ? 2 : 1 + name.length();
                            String className = importName.substring(0, importName.length() - postfixLength);
                            JavaClass importedClass = javaProvider.getClass(className);
                            if (importedClass == null) continue;
                            classes.add(importedClass);
                        }
                    }
                }
            }
            if (invocation.isGeneric()) {
                List<SourceTypeArgument> typeArguments = invocation.getTypeArguments();
                typeArgumentTypes = new JavaType[typeArguments.size()];
                for (int i = 0; i < typeArguments.size(); ++i) {
                    typeArgumentTypes[i] = typeArguments.get(i).getResolvedType();
                    if (typeArgumentTypes[i] != null) continue;
                    typeArgumentTypes = JavaType.EMPTY_ARRAY;
                    break;
                }
            } else {
                typeArgumentTypes = JavaType.EMPTY_ARRAY;
            }
            for (Object type : classes) {
                Collection<Object> methods = Collections.emptyList();
                if (invocation.getSymbolKind() == 75) {
                    methods = ((JavaType)type).getDeclaredConstructors();
                } else if ("this".equals(name)) {
                    methods = ((JavaType)type).getDeclaredConstructors();
                } else if ("super".equals(name)) {
                    JavaType classType = (JavaType)type;
                    if ((classType = classType.getSuperclass()) != null) {
                        methods = classType.getDeclaredConstructors();
                    }
                } else {
                    methods = ((JavaType)type).getMethods(name);
                }
                block8: for (JavaMethod javaMethod : methods) {
                    void var10_17;
                    if (typeArgumentTypes.length > 0) {
                        if (javaMethod.getTypeParameters().size() != typeArgumentTypes.length) continue;
                        if (invocation.getOwningSourceFile() != null) {
                            JavaMethod javaMethod2 = CommonUtilities.createParameterizedMethod(invocation.getOwningSourceFile().getProvider(), javaMethod, typeArgumentTypes);
                        }
                    }
                    Collection<JavaVariable> parameters = var10_17.getParameters();
                    boolean varargs = var10_17.isVarargs();
                    int count = 0;
                    int adjustIndex = 0;
                    StickyIterator<JavaVariable> iterator = new StickyIterator<JavaVariable>(parameters, varargs);
                    while (iterator.hasNext()) {
                        JavaVariable param = (JavaVariable)iterator.next();
                        if (count == 0 && param != null && "this$0".equals(param.getName())) {
                            adjustIndex = 1;
                        } else if (param != null && count == index + adjustIndex) {
                            JavaType paramType = param.getResolvedType();
                            if (varargs && count >= parameters.size() - 1 && paramType != null && paramType.isArray()) {
                                paramType = paramType.getComponentType();
                            }
                            if (CommonUtilities.getFunctionalInterfaceMethod(paramType) == null || targets.contains(paramType)) continue block8;
                            targets.add(paramType);
                            continue block8;
                        }
                        ++count;
                    }
                }
            }
        }
        finally {
            CommonUtilities.freeArrayList(classes);
        }
        return targets;
    }

    private static Collection<JavaType> getExpectedTypesFromConstructors(JavaType type, int index) {
        if (type == null) {
            return Collections.emptyList();
        }
        HashSet<JavaType> types = new HashSet<JavaType>();
        for (JavaMethod constructor : type.getDeclaredConstructors()) {
            JavaType[] parameters = constructor.getParameterTypes();
            if (parameters.length <= index || parameters[index] == null) continue;
            types.add(parameters[index]);
        }
        return types;
    }

    public static JavaType getInvocationSearchType(SourceInvokeExpression invokeExpression) {
        SourceExpression lhs;
        JavaType searchType = invokeExpression instanceof SourceNewClassExpression ? invokeExpression.getResolvedType() : ((lhs = invokeExpression.getLhsOperand()) != null ? lhs.getResolvedType() : CommonUtilities.getEnclosingType(invokeExpression));
        return searchType;
    }

    public static SourceClass getEnclosingType(SourceElement sourceElement) {
        for (SourceElement parent = sourceElement.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getSymbolKind() != 3) continue;
            return (SourceClass)parent;
        }
        return null;
    }

    public static SourceMethod getEnclosingMethod(SourceElement sourceElement) {
        for (SourceElement parent = sourceElement.getParent(); parent != null; parent = parent.getParent()) {
            switch (parent.getSymbolKind()) {
                case 6: 
                case 19: {
                    return (SourceMethod)parent;
                }
            }
        }
        return null;
    }

    public static SourceMember getEnclosingMember(SourceElement sourceElement) {
        for (SourceElement parent = sourceElement.getParent(); parent != null; parent = parent.getParent()) {
            switch (parent.getSymbolKind()) {
                case 3: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 19: {
                    return (SourceMember)parent;
                }
            }
        }
        return null;
    }

    private static Collection<JavaType> singletonOrEmptyList(JavaType type) {
        return type == null ? Collections.emptyList() : Collections.singletonList(type);
    }

    public static boolean isTypeUseAnnotation(JavaAnnotation javaAnnotation, boolean strict) {
        boolean result = false;
        JavaType annotationType = javaAnnotation.getAnnotationType();
        if (annotationType != null) {
            result = !strict;
            Collection<JavaAnnotation> annotationAnnotations = annotationType.getAnnotations();
            for (JavaAnnotation annotationAnnotation : annotationAnnotations) {
                JavaType annotationAnnotationType = annotationAnnotation.getResolvedType();
                if (annotationAnnotationType == null || !"java.lang.annotation.Target".equals(annotationAnnotationType.getRawName())) continue;
                result = false;
                Map<String, Object> arguments = annotationAnnotation.getArguments();
                Collection<Object> values = arguments.values();
                if (values.isEmpty()) continue;
                Object value = values.iterator().next();
                if (value instanceof JavaField) {
                    if (!CommonUtilities.isTypeAnnotationTarget((JavaField)value)) continue;
                    return true;
                }
                if (!(value instanceof Object[])) continue;
                for (Object oneValue : (Object[])value) {
                    if (!(oneValue instanceof JavaField) || !CommonUtilities.isTypeAnnotationTarget((JavaField)oneValue)) continue;
                    return true;
                }
            }
        }
        return result;
    }

    private static boolean isTypeAnnotationTarget(JavaField field) {
        return "TYPE_USE".equals(field.getName());
    }

    public static JavaType getInitialTypeContaining(SourceMethodCallExpression expr) {
        if (expr == null) {
            return null;
        }
        SourceExpression lhs = expr.getLhsOperand();
        if (lhs != null) {
            return lhs.getResolvedType();
        }
        JavaMethod javaMethod = expr.getResolvedMethod();
        if (javaMethod == null) {
            return null;
        }
        boolean wantStatic = false;
        for (SourceElement scope = expr.getParent(); scope != null; scope = scope.getParent()) {
            if (scope.getSymbolKind() != 3) continue;
            SourceClass cls = (SourceClass)scope;
            JavaMethod method = cls.getMethod(javaMethod.getName(), javaMethod.getParameterTypes());
            if (method != null && (!wantStatic || method.isStatic())) {
                return cls;
            }
            if (!cls.isStatic()) continue;
            wantStatic = true;
        }
        SourceImport oneImport = CommonUtilities.getStaticSourceImport(expr.getOwningSourceFile(), javaMethod.getName());
        if (oneImport != null) {
            return oneImport.getQualifyingType();
        }
        return null;
    }

    public static JavaType getInitialTypeContaining(SourceSimpleNameExpression expr) {
        if (expr == null) {
            return null;
        }
        JavaHasType hasType = expr.getResolvedObject();
        if (!(hasType instanceof JavaField)) {
            return null;
        }
        boolean wantStatic = false;
        for (SourceElement scope = expr.getParent(); scope != null; scope = scope.getParent()) {
            if (scope.getSymbolKind() != 3) continue;
            SourceClass cls = (SourceClass)scope;
            JavaField field = cls.getField(expr.getName());
            if (field != null && (!wantStatic || field.isStatic())) {
                return cls;
            }
            if (!cls.isStatic()) continue;
            wantStatic = true;
        }
        SourceImport oneImport = CommonUtilities.getStaticSourceImport(expr.getOwningSourceFile(), ((JavaField)hasType).getName());
        if (oneImport != null) {
            return oneImport.getQualifyingType();
        }
        return null;
    }

    public static JavaType getInitialTypeContaining(SourceArrayAccessExpression expr) {
        if (expr == null) {
            return null;
        }
        SourceExpression lhs = expr.getLhsOperand();
        if (lhs != null) {
            switch (lhs.getSymbolKind()) {
                case 77: {
                    return CommonUtilities.getInitialTypeContaining((SourceSimpleNameExpression)lhs);
                }
                case 73: {
                    return CommonUtilities.getInitialTypeContaining((SourceMethodCallExpression)lhs);
                }
                case 69: {
                    return CommonUtilities.getInitialTypeContaining((SourceDotExpression)lhs);
                }
            }
        }
        return null;
    }

    public static JavaType getInitialTypeContaining(SourceDotExpression expr) {
        if (expr == null) {
            return null;
        }
        SourceExpression lhs = expr.getLhsOperand();
        if (lhs != null) {
            return lhs.getResolvedType();
        }
        return null;
    }

    public static JavaType getInitialTypeContaining(SourceNewClassExpression expr) {
        return expr != null ? expr.getResolvedType() : null;
    }

    public static SourceImport getStaticSourceImport(SourceFile file, String name) {
        if (file == null || name == null) {
            return null;
        }
        List<SourceImport> imports = file.getSourceImports();
        String dotName = "." + name;
        for (SourceImport oneImport : imports) {
            if (!oneImport.isStatic() || !oneImport.getName().endsWith(dotName)) continue;
            return oneImport;
        }
        return null;
    }

    public static boolean matchMethod(JavaMethod method, JavaType ... targetParameterTypes) {
        Collection<JavaVariable> parameterCollection = method.getParameters();
        int parameterSize = parameterCollection.size();
        Iterator<JavaVariable> iterator = parameterCollection.iterator();
        if (iterator.hasNext() && method.isSourceElement() && ((SourceMethod)method).getJdkVersion().isGreaterThanOrEqualTo8()) {
            JavaVariable firstParameter = iterator.next();
            if ("this".equals(firstParameter.getName())) {
                --parameterSize;
            } else {
                iterator = parameterCollection.iterator();
            }
        }
        if (targetParameterTypes == null) {
            return parameterSize == 0;
        }
        if (targetParameterTypes.length != parameterSize) {
            return false;
        }
        int p = 0;
        while (iterator.hasNext()) {
            JavaType targetParameterType = targetParameterTypes[p++];
            JavaVariable parameter = iterator.next();
            if (targetParameterType == null) continue;
            JavaType parameterType = parameter.getResolvedType();
            if (parameterType == null) {
                return false;
            }
            if (targetParameterType.getTypeErasure().equals(parameterType.getTypeErasure())) continue;
            return false;
        }
        return true;
    }

    public static boolean isInheritedAnnotation(JavaAnnotation annotation) {
        if (annotation == null) {
            return false;
        }
        JavaType annotationType = annotation.getResolvedType();
        return CommonUtilities.isInheritedAnnotation(annotationType);
    }

    public static boolean isInheritedAnnotation(JavaType annotationType) {
        if (annotationType == null || !annotationType.isAnnotation()) {
            return false;
        }
        for (JavaAnnotation annotation : annotationType.getDeclaredAnnotations()) {
            JavaType type = annotation.getAnnotationType();
            if (type == null || !"java/lang/annotation/Inherited".equals(type.getVMName())) continue;
            return true;
        }
        return false;
    }

    protected static boolean classProcessed(Set<Object> processed, JavaType javaClass) {
        if (processed == null) {
            return false;
        }
        String targetClassName = javaClass.getTypeSignature();
        return !processed.add(targetClassName);
    }

    private static void setOp2Opt(byte[][] table, byte optype, short tk, byte opt) {
        table[optype][tk - 32] = opt;
    }

    private static byte[][] initOp2OptTable() {
        byte[][] table = new byte[6][51];
        CommonUtilities.setOp2Opt(table, (byte)0, (short)33, (byte)6);
        CommonUtilities.setOp2Opt(table, (byte)0, (short)68, (byte)2);
        CommonUtilities.setOp2Opt(table, (byte)0, (short)60, (byte)32);
        CommonUtilities.setOp2Opt(table, (byte)0, (short)64, (byte)36);
        CommonUtilities.setOp2Opt(table, (byte)0, (short)42, (byte)18);
        CommonUtilities.setOp2Opt(table, (byte)0, (short)62, (byte)34);
        CommonUtilities.setOp2Opt(table, (byte)0, (short)32, (byte)8);
        CommonUtilities.setOp2Opt(table, (byte)0, (short)66, (byte)11);
        CommonUtilities.setOp2Opt(table, (byte)0, (short)78, (byte)13);
        CommonUtilities.setOp2Opt(table, (byte)0, (short)57, (byte)29);
        CommonUtilities.setOp2Opt(table, (byte)0, (short)74, (byte)52);
        CommonUtilities.setOp2Opt(table, (byte)0, (short)77, (byte)57);
        CommonUtilities.setOp2Opt(table, (byte)1, (short)58, (byte)30);
        CommonUtilities.setOp2Opt(table, (byte)1, (short)51, (byte)25);
        CommonUtilities.setOp2Opt(table, (byte)1, (short)46, (byte)22);
        CommonUtilities.setOp2Opt(table, (byte)1, (short)45, (byte)21);
        CommonUtilities.setOp2Opt(table, (byte)1, (short)44, (byte)20);
        CommonUtilities.setOp2Opt(table, (byte)1, (short)65, (byte)42);
        CommonUtilities.setOp2Opt(table, (byte)2, (short)56, (byte)28);
        CommonUtilities.setOp2Opt(table, (byte)2, (short)73, (byte)51);
        CommonUtilities.setOp2Opt(table, (byte)2, (short)76, (byte)56);
        CommonUtilities.setOp2Opt(table, (byte)3, (short)67, (byte)1);
        CommonUtilities.setOp2Opt(table, (byte)3, (short)59, (byte)31);
        CommonUtilities.setOp2Opt(table, (byte)3, (short)63, (byte)35);
        CommonUtilities.setOp2Opt(table, (byte)3, (short)41, (byte)17);
        CommonUtilities.setOp2Opt(table, (byte)3, (short)61, (byte)33);
        CommonUtilities.setOp2Opt(table, (byte)3, (short)52, (byte)3);
        CommonUtilities.setOp2Opt(table, (byte)3, (short)54, (byte)43);
        CommonUtilities.setOp2Opt(table, (byte)3, (short)34, (byte)7);
        CommonUtilities.setOp2Opt(table, (byte)3, (short)36, (byte)10);
        CommonUtilities.setOp2Opt(table, (byte)3, (short)37, (byte)12);
        for (short tk = 32; tk < 83; tk = (short)(tk + 1)) {
            byte opt = 0;
            if (opt == 0) {
                opt = CommonUtilities.assignmentOp(table, tk);
            }
            if (opt == 0) {
                opt = CommonUtilities.relationalOp(table, tk);
            }
            if (opt == 0) {
                opt = CommonUtilities.shiftOp(table, tk);
            }
            if (opt == 0) continue;
            CommonUtilities.setOp2Opt(table, (byte)3, tk, opt);
        }
        CommonUtilities.setOp2Opt(table, (byte)4, (short)48, (byte)48);
        CommonUtilities.setOp2Opt(table, (byte)4, (short)40, (byte)47);
        CommonUtilities.setOp2Opt(table, (byte)4, (short)53, (byte)41);
        CommonUtilities.setOp2Opt(table, (byte)4, (short)35, (byte)9);
        CommonUtilities.setOp2Opt(table, (byte)4, (short)67, (byte)44);
        CommonUtilities.setOp2Opt(table, (byte)4, (short)59, (byte)37);
        CommonUtilities.setOp2Opt(table, (byte)5, (short)48, (byte)46);
        CommonUtilities.setOp2Opt(table, (byte)5, (short)40, (byte)45);
        return table;
    }

    protected static byte assignmentOp(int token) {
        return CommonUtilities.assignmentOp(op2optTable, token);
    }

    private static byte assignmentOp(byte[][] table, int token) {
        if (32 <= token && token < 83) {
            return table[0][token - 32];
        }
        return 0;
    }

    protected static byte relationalOp(int token) {
        return CommonUtilities.relationalOp(op2optTable, token);
    }

    private static byte relationalOp(byte[][] table, int token) {
        if (32 <= token && token < 83) {
            return table[1][token - 32];
        }
        return 0;
    }

    protected static byte shiftOp(int token) {
        return CommonUtilities.shiftOp(op2optTable, token);
    }

    private static byte shiftOp(byte[][] table, int token) {
        if (32 <= token && token < 83) {
            return table[2][token - 32];
        }
        return 0;
    }

    protected static byte infixOp(int token) {
        return CommonUtilities.infixOp(op2optTable, token);
    }

    private static byte infixOp(byte[][] table, int token) {
        if (32 <= token && token < 83) {
            return table[3][token - 32];
        }
        return 0;
    }

    protected static byte prefixOp(int token) {
        return CommonUtilities.prefixOp(op2optTable, token);
    }

    private static byte prefixOp(byte[][] table, int token) {
        if (32 <= token && token < 83) {
            return table[4][token - 32];
        }
        return 0;
    }

    protected static byte postfixOp(int token) {
        return CommonUtilities.postfixOp(op2optTable, token);
    }

    private static byte postfixOp(byte[][] table, int token) {
        if (32 <= token && token < 83) {
            return table[5][token - 32];
        }
        return 0;
    }

    public static String getDescriptor(JavaMethod input) {
        if (input == null) {
            return "";
        }
        JavaMethod erasedMethod = input.getMethodErasure();
        Collection<JavaVariable> parameters = erasedMethod.getParameters();
        boolean jdk8 = input.isSourceElement() && ((SourceMethod)input).getJdkVersion().isGreaterThanOrEqualTo8();
        boolean hasThis = jdk8 && !parameters.isEmpty() && "this".equals(parameters.iterator().next().getName());
        StringBuilder builder = new StringBuilder("(");
        for (JavaVariable parameter : parameters) {
            if (hasThis) {
                hasThis = false;
                continue;
            }
            JavaType type = parameter.getResolvedType();
            if (type != null) {
                type = type.getTypeErasure();
            }
            builder.append(type != null ? type.getDescriptor() : "Ljava/lang/Object;");
        }
        builder.append(')');
        JavaType returnType = erasedMethod.getReturnType();
        if (returnType != null) {
            returnType = returnType.getTypeErasure();
        }
        builder.append(returnType != null ? returnType.getDescriptor() : "V");
        return builder.toString();
    }

    public static String getTypeSignature(JavaMethod input) {
        if (input == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        if (input.hasActualTypeArguments()) {
            builder.append('<');
            for (JavaType type : input.getActualTypeArguments()) {
                builder.append(type != null ? type.getTypeSignature() : "*");
            }
            builder.append('>');
        }
        boolean jdk8 = input.isSourceElement() && ((SourceMethod)input).getJdkVersion().isGreaterThanOrEqualTo8();
        Collection<JavaVariable> parameters = input.getParameters();
        boolean hasThis = jdk8 && !parameters.isEmpty() && "this".equals(parameters.iterator().next().getName());
        builder.append('(');
        for (JavaVariable parameter : parameters) {
            if (hasThis) {
                hasThis = false;
                continue;
            }
            JavaType parameterType = parameter.getResolvedType();
            builder.append(parameterType != null ? parameterType.getTypeSignature() : "V");
        }
        builder.append(')');
        JavaType returnType = input.getReturnType();
        builder.append(returnType != null ? returnType.getTypeSignature() : "V");
        return builder.toString();
    }

    public static String getSignature(JavaMethod input) {
        if (input == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        if (input.hasTypeParameters()) {
            builder.append('<');
            for (JavaTypeVariable variable : input.getTypeParameters()) {
                builder.append(variable.getSignature());
            }
            builder.append('>');
        }
        boolean jdk8 = input.isSourceElement() && ((SourceMethod)input).getJdkVersion().isGreaterThanOrEqualTo8();
        Collection<JavaVariable> parameters = input.getParameters();
        boolean hasThis = jdk8 && !parameters.isEmpty() && "this".equals(parameters.iterator().next().getName());
        builder.append('(');
        for (JavaVariable parameter : parameters) {
            if (hasThis) {
                hasThis = false;
                continue;
            }
            JavaType parameterType = parameter.getResolvedType();
            builder.append(parameterType != null ? parameterType.getTypeSignature() : "V");
        }
        builder.append(')');
        JavaType returnType = input.getReturnType();
        builder.append(returnType != null ? returnType.getTypeSignature() : "V");
        for (JavaType exception : input.getExceptions()) {
            builder.append('^');
            builder.append(exception.getTypeSignature());
        }
        return builder.toString();
    }

    public static String getDescriptor(JavaField input) {
        if (input == null) {
            return "";
        }
        JavaField erasedField = input.getFieldErasure();
        JavaType type = erasedField.getResolvedType();
        if (type != null) {
            type = type.getTypeErasure();
        }
        if (type == null) {
            return "Ljava/lang/Object;";
        }
        return type.getDescriptor();
    }

    public static String getSignature(JavaField input) {
        if (input == null) {
            return "";
        }
        JavaType type = input.getResolvedType();
        if (type == null) {
            return "Ljava/lang/Object;";
        }
        return type.getTypeSignature();
    }

    public static String getDescriptor(JavaType input) {
        if (input == null) {
            return "";
        }
        if (input.isPrimitive()) {
            String name = input.getName();
            if ("boolean".equals(name)) {
                return "Z";
            }
            if ("byte".equals(name)) {
                return "B";
            }
            if ("char".equals(name)) {
                return "C";
            }
            if ("short".equals(name)) {
                return "S";
            }
            if ("int".equals(name)) {
                return "I";
            }
            if ("long".equals(name)) {
                return "J";
            }
            if ("float".equals(name)) {
                return "F";
            }
            if ("double".equals(name)) {
                return "D";
            }
            if ("null".equals(name)) {
                return "*";
            }
            if ("void".equals(name)) {
                return "V";
            }
            assert (false) : "Primitive type name is unknown";
            return "";
        }
        if (input.getElementKind() == 11 || input.getElementKind() == 10) {
            JavaClass erasure = input.getTypeErasure();
            return erasure != null ? erasure.getDescriptor() : "Ljava/lang/Object;";
        }
        return "L" + input.getVMName() + ";";
    }

    public static String getTypeSignature(JavaClass input) {
        if (input == null) {
            return "";
        }
        if (input.isPrimitive()) {
            return CommonUtilities.getDescriptor(input);
        }
        StringBuilder builder = new StringBuilder();
        if (input.isMemberClass() && !input.isStatic()) {
            String owningTypeSignature;
            JavaClass owningClass = input.getOwningClass();
            String owningDescriptor = owningClass.getDescriptor();
            if (!owningDescriptor.equals(owningTypeSignature = owningClass.getTypeSignature())) {
                builder.append(owningTypeSignature);
                builder.setLength(builder.length() - 1);
                builder.append('.');
                builder.append(input.getName());
            } else {
                builder.append('L');
                builder.append(input.getVMName());
            }
        } else {
            builder.append('L');
            builder.append(input.getVMName());
        }
        if (input.hasActualTypeArguments()) {
            builder.append('<');
            for (JavaType type : input.getActualTypeArguments()) {
                builder.append(type != null ? type.getTypeSignature() : "*");
            }
            builder.append('>');
        }
        builder.append(';');
        return builder.toString();
    }

    public static String getSignature(JavaType input) {
        JavaType superclass;
        if (input == null) {
            return "";
        }
        if (input.isPrimitive()) {
            return CommonUtilities.getDescriptor(input);
        }
        StringBuilder buffer = new StringBuilder();
        if (input.hasTypeParameters()) {
            buffer.append('<');
            for (JavaTypeVariable variable : input.getTypeParameters()) {
                buffer.append(variable.getSignature());
            }
            buffer.append('>');
        }
        buffer.append((superclass = input.getSuperclass()) != null ? superclass.getTypeSignature() : "Ljava/lang/Object;");
        for (JavaType type : input.getInterfaces()) {
            buffer.append(type.getTypeSignature());
        }
        return buffer.toString();
    }

    public static String getDescriptor(JavaTypeVariable input) {
        if (input == null) {
            return "";
        }
        JavaClass erasure = input.getTypeErasure();
        return erasure != null ? erasure.getDescriptor() : "Ljava/lang/Object;";
    }

    public static String getTypeSignature(JavaTypeVariable input) {
        if (input == null) {
            return null;
        }
        return "T" + input.getName() + ";";
    }

    public static String getSignature(JavaTypeVariable input) {
        if (input == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(input.getName());
        Collection<JavaType> bounds = input.getBounds();
        if (bounds.size() > 0) {
            for (JavaType bound : input.getBounds()) {
                buffer.append(':');
                buffer.append(bound.getTypeSignature());
            }
        } else {
            buffer.append(':').append("Ljava/lang/Object;");
        }
        return buffer.toString();
    }

    public static String getUniqueIdentifier(JavaPackage thing) {
        return "p" + thing.getQualifiedName().replace('.', '/');
    }

    public static String getUniqueIdentifier(JavaClass type) {
        return type.getTypeSignature();
    }

    public static String getUniqueIdentifier(JavaTypeVariable typeVariable) {
        JavaIsGeneric owner = (JavaIsGeneric)typeVariable.getOwningMember();
        String prefix = owner != null ? owner.getUniqueIdentifier() : "<unknown>";
        return prefix + ":" + typeVariable.getTypeSignature();
    }

    public static String getUniqueIdentifier(JavaWildcardType wildcardType) {
        return wildcardType.getTypeSignature();
    }

    public static String getUniqueIdentifier(JavaField field) {
        JavaClass owner = field.getOwningClass();
        String ownerUnique = owner != null ? owner.getUniqueIdentifier() : "class-unknown";
        return "f" + ownerUnique + "." + field.getName() + " " + CommonUtilities.getSignature(field);
    }

    public static String getUniqueIdentifier(JavaMethod method) {
        if (method == null) {
            return "";
        }
        JavaClass owner = method.getOwningClass();
        String ownerUnique = owner != null ? owner.getUniqueIdentifier() : "class-unknown";
        String signature = method.getSignature();
        int firstExp = signature.indexOf(94);
        String signatureToUse = firstExp >= 0 ? signature.substring(0, firstExp) : signature;
        return "m" + ownerUnique + "." + method.getName() + " " + signatureToUse;
    }

    public static boolean equals(JavaPackage left, JavaPackage right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return left.getQualifiedName().equals(right.getQualifiedName());
    }

    public static boolean equals(JavaMember left, JavaMember right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        String leftName = left.getName();
        String rightName = right.getName();
        return leftName != null && leftName.equals(rightName) && left.getUniqueIdentifier().equals(right.getUniqueIdentifier());
    }

    public static boolean isSameDeclaration(JavaType left, JavaType right) {
        if (!CommonUtilities.isSameNameAndOwningClass(left, right)) {
            return false;
        }
        String leftDescriptor = left.getDescriptor();
        return leftDescriptor != null && leftDescriptor.equals(right.getDescriptor());
    }

    public static boolean isSameDeclaration(JavaMethod left, JavaMethod right) {
        if (!CommonUtilities.isSameNameAndOwningClass(left, right)) {
            return false;
        }
        String leftDescriptor = left.getDescriptor();
        return leftDescriptor != null && leftDescriptor.equals(right.getDescriptor());
    }

    public static boolean isSameDeclaration(JavaField left, JavaField right) {
        if (!CommonUtilities.isSameNameAndOwningClass(left, right)) {
            return false;
        }
        String leftDescriptor = left.getDescriptor();
        return leftDescriptor != null && leftDescriptor.equals(right.getDescriptor());
    }

    private static boolean isSameNameAndOwningClass(JavaMember left, JavaMember right) {
        if (left == null || right == null) {
            return false;
        }
        String leftName = left.getName();
        if (leftName == null || !leftName.equals(right.getName())) {
            return false;
        }
        JavaClass leftOwner = left.getOwningClass();
        JavaClass rightOwner = right.getOwningClass();
        if (leftOwner == null || rightOwner == null) {
            return leftOwner == rightOwner;
        }
        String leftOwnerDescriptor = leftOwner.getDescriptor();
        return leftOwnerDescriptor != null && leftOwnerDescriptor.equals(rightOwner.getDescriptor());
    }

    public static int hashCode(JavaPackage thing) {
        if (thing == null) {
            return 0;
        }
        return thing.getQualifiedName().hashCode();
    }

    public static int hashCode(JavaMember thing) {
        if (thing == null) {
            return 0;
        }
        return thing.getUniqueIdentifier().hashCode();
    }

    public static JavaRecordComponent getDeclaredRecordComponent(JavaType target, String name) {
        for (JavaRecordComponent component : target.getDeclaredRecordComponents()) {
            if (!name.equals(component.getName())) continue;
            return component;
        }
        return null;
    }

    public static JavaField getDeclaredField(JavaType target, String name) {
        for (JavaField field : target.getDeclaredFields()) {
            if (!name.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public static Collection<JavaMethod> getDeclaredMethods(JavaType target, String name) {
        ArrayList<JavaMethod> list = new ArrayList<JavaMethod>();
        for (JavaMethod method : target.getDeclaredMethods()) {
            if (!name.equals(method.getName())) continue;
            list.add(method);
        }
        return list;
    }

    public static JavaMethod getDeclaredMethod(JavaType target, String name, JavaType[] targetTypes) {
        if (target == null) {
            return null;
        }
        if (targetTypes == null) {
            targetTypes = JavaType.EMPTY_ARRAY;
        }
        for (JavaMethod method : target.getDeclaredMethods(name)) {
            if (!CommonUtilities.matchMethod(method, targetTypes)) continue;
            return method;
        }
        return null;
    }

    public static JavaMethod getDeclaredConstructor(JavaType target, JavaType[] targetTypes) {
        if (target == null) {
            return null;
        }
        if (targetTypes == null) {
            targetTypes = JavaType.EMPTY_ARRAY;
        }
        for (JavaMethod constructor : target.getDeclaredConstructors()) {
            if (!CommonUtilities.matchMethod(constructor, targetTypes)) continue;
            return constructor;
        }
        return null;
    }

    public static JavaClass getDeclaredClass(JavaType target, String name) {
        for (JavaClass type : target.getDeclaredClasses()) {
            if (!name.equals(type.getName())) continue;
            return type;
        }
        return null;
    }

    public static JavaTypeVariable getTypeParameter(JavaIsGeneric target, String name) {
        if (!target.hasTypeParameters()) {
            return null;
        }
        for (JavaTypeVariable typeVariable : target.getTypeParameters()) {
            if (!name.equals(typeVariable.getName())) continue;
            return typeVariable;
        }
        return null;
    }

    public static JavaAnnotation getDeclaredAnnotation(JavaHasAnnotations target, JavaType annotationType) {
        if (annotationType == null) {
            return null;
        }
        for (JavaAnnotation annotation : target.getDeclaredAnnotations()) {
            JavaType type = annotation.getResolvedType();
            if (type == null || !type.equals(annotationType)) continue;
            return annotation;
        }
        return null;
    }

    public static Collection<JavaField> getFields(JavaType target) {
        ArrayList<JavaField> list = new ArrayList<JavaField>(target.getDeclaredFields());
        Set<JavaType> hierarchy = target.getHierarchy();
        for (JavaType superType : hierarchy) {
            list.addAll(superType.getDeclaredFields());
        }
        return list;
    }

    public static JavaField getField(JavaType target, String name) {
        JavaField field = target.getDeclaredField(name);
        if (field != null) {
            return field;
        }
        Set<JavaType> hierarchy = target.getHierarchy();
        for (JavaType superType : hierarchy) {
            field = superType.getDeclaredField(name);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    public static Collection<JavaMethod> getMethods(JavaType target) {
        return CommonUtilities.getMethodsImpl(target, null);
    }

    private static Collection<JavaMethod> getMethodsImpl(JavaType target, String name) {
        if (target == null) {
            return Collections.emptyList();
        }
        ArrayList<JavaMethod> result = new ArrayList<JavaMethod>(name == null ? target.getDeclaredMethods() : target.getDeclaredMethods(name));
        Set<JavaType> hierarchy = target.getHierarchy();
        for (JavaType superType : hierarchy) {
            result.addAll(name == null ? superType.getDeclaredMethods() : superType.getDeclaredMethods(name));
        }
        return result;
    }

    public static Collection<JavaMethod> getMethods(JavaType target, String name) {
        return CommonUtilities.getMethodsImpl(target, name);
    }

    public static JavaMethod getMethod(JavaType target, String name, JavaType ... parameterTypes) {
        Collection<JavaMethod> methods = CommonUtilities.getMethods(target, name);
        for (JavaMethod javaMethod : methods) {
            if (!CommonUtilities.matchMethod(javaMethod, parameterTypes)) continue;
            return javaMethod;
        }
        return null;
    }

    public static boolean methodThrowsMoreCheckedExceptions(JavaMethod subject, JavaMethod target) {
        Collection<JavaType> targetExceptions = target.getExceptions();
        Collection<JavaType> subjectExceptions = subject.getExceptions();
        Iterator<JavaType> iterator = subjectExceptions.iterator();
        block0: while (iterator.hasNext()) {
            JavaType subjectException;
            for (JavaType superClass = subjectException = iterator.next(); superClass != null; superClass = superClass.getSuperclass()) {
                String name = superClass.getRawName();
                String re = "java.lang.RuntimeException";
                String ee = "java.lang.Error";
                if (re.equals(name) || ee.equals(name)) continue block0;
            }
            for (JavaType targetException : targetExceptions) {
                if (!subjectException.isSubtypeOf(targetException)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    public static boolean hasOverrideCompatibleVisibility(JavaMethod method, JavaMethod otherMethod) {
        JavaClass owner;
        JavaClass otherOwner;
        if (method.isStatic() || otherMethod.isStatic()) {
            return false;
        }
        if (otherMethod.isFinal() || otherMethod.isPrivate() || method.isPrivate()) {
            return false;
        }
        boolean otherMethodIsPublic = otherMethod.isPublic();
        if (otherMethod.isPackagePrivate() && (otherOwner = otherMethod.getOwningClass()) != null && otherOwner.isInterface()) {
            otherMethodIsPublic = true;
        }
        boolean methodIsPublic = method.isPublic();
        if (method.isPackagePrivate() && (owner = method.getOwningClass()) != null && owner.isInterface()) {
            methodIsPublic = true;
        }
        if (otherMethodIsPublic && !methodIsPublic) {
            return false;
        }
        if (otherMethod.isProtected() && method.isPackagePrivate()) {
            return false;
        }
        JavaPackage otherPackage = otherMethod.getOwningClass().getPackage();
        JavaPackage packag = method.getOwningClass().getPackage();
        return !otherMethod.isPackagePrivate() || otherPackage.equals(packag);
    }

    public static Collection<JavaClass> getClasses(JavaType target) {
        ArrayList<JavaClass> list = new ArrayList<JavaClass>(target.getDeclaredClasses());
        Set<JavaType> hierarchy = target.getHierarchy();
        for (JavaType superType : hierarchy) {
            list.addAll(superType.getDeclaredClasses());
        }
        return list;
    }

    public static List<JavaType> getClassHierarchy(JavaType javaType) {
        ArrayList<JavaType> finalResults = new ArrayList<JavaType>();
        if (javaType == null) {
            return finalResults;
        }
        HashSet<String> processed = new HashSet<String>();
        boolean eraseTypes = javaType.isErasedType();
        CommonUtilities.getClassHierarchyImpl(javaType, true, eraseTypes, 0, processed, finalResults);
        ArrayList<JavaType> classes = new ArrayList<JavaType>(finalResults);
        classes.add(0, javaType);
        processed.clear();
        for (JavaType clazz : classes) {
            CommonUtilities.getClassHierarchyImpl(clazz, false, eraseTypes, 0, processed, finalResults);
        }
        return finalResults;
    }

    private static void getClassHierarchyImpl(JavaType type, boolean collectSupers, boolean eraseTypes, int depth, Set<String> processedTypes, List<JavaType> finalResults) {
        if (type == null) {
            return;
        }
        if (!processedTypes.add(type.getVMName())) {
            return;
        }
        if (depth > 0) {
            boolean hasTypeParameters = type.hasTypeParameters();
            if (hasTypeParameters && !type.hasActualTypeArguments()) {
                eraseTypes = true;
            } else if (!hasTypeParameters) {
                eraseTypes = false;
            }
            if (collectSupers != type.isInterface()) {
                finalResults.add(eraseTypes ? type.getTypeErasure() : type);
            }
        }
        if (collectSupers) {
            JavaType superType = type.getSuperclass();
            CommonUtilities.getClassHierarchyImpl(superType, collectSupers, eraseTypes, depth + 1, processedTypes, finalResults);
        } else {
            for (JavaType interfac : type.getInterfaces()) {
                CommonUtilities.getClassHierarchyImpl(interfac, collectSupers, eraseTypes, depth + 1, processedTypes, finalResults);
            }
        }
    }

    public static JavaClass getClass(JavaType target, String name) {
        JavaClass type = target.getDeclaredClass(name);
        if (type != null) {
            return type;
        }
        Set<JavaType> hierarchy = target.getHierarchy();
        for (JavaType superType : hierarchy) {
            type = superType.getDeclaredClass(name);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    public static JavaClass getClass(JavaFile target, String name) {
        if (target == null || name == null) {
            return null;
        }
        for (JavaClass type : target.getClasses()) {
            if (!name.equals(type.getName())) continue;
            return type;
        }
        return null;
    }

    public static Collection<JavaAnnotation> getAnnotations(JavaType target) {
        ArrayList<JavaAnnotation> list = new ArrayList<JavaAnnotation>(target.getDeclaredAnnotations());
        Set<JavaType> hierarchy = target.getHierarchy();
        for (JavaType superType : hierarchy) {
            for (JavaAnnotation a : superType.getDeclaredAnnotations()) {
                if (!a.isInherited()) continue;
                list.add(a);
            }
        }
        return list;
    }

    public static JavaAnnotation getAnnotation(JavaType target, JavaType annotationType) {
        if (annotationType == null) {
            return null;
        }
        for (JavaAnnotation annotation : target.getAnnotations()) {
            JavaType type = annotation.getResolvedType();
            if (type == null || !type.equals(annotationType)) continue;
            return annotation;
        }
        return null;
    }

    public static JavaType[] getParameterTypes(JavaMethod target) {
        if (target == null) {
            return JavaType.EMPTY_ARRAY;
        }
        Collection<JavaVariable> parameters = target.getParameters();
        boolean jdk8 = target.isSourceElement() && ((SourceMethod)target).getJdkVersion().isGreaterThanOrEqualTo8();
        boolean hasThis = jdk8 && !parameters.isEmpty() && "this".equals(parameters.iterator().next().getName());
        JavaType[] result = new JavaType[hasThis ? parameters.size() - 1 : parameters.size()];
        int count = 0;
        for (JavaVariable parameter : parameters) {
            if (!hasThis) {
                result[count++] = parameter.getResolvedType();
            }
            hasThis = false;
        }
        return result;
    }

    public static JavaElement locateByUniqueIdentifier(String uniqueIdentifier, JavaProvider provider) {
        int totalLength = uniqueIdentifier.length();
        if (totalLength == 0) {
            return null;
        }
        char first = uniqueIdentifier.charAt(0);
        switch (first) {
            case 'p': {
                if (totalLength == 1) {
                    return provider.getPackage("");
                }
                String packageName = uniqueIdentifier.substring(1).replace('/', '.');
                return provider.getPackage(packageName);
            }
            case 'f': {
                int dot = uniqueIdentifier.indexOf(46, 1);
                if (dot <= 1) {
                    return null;
                }
                String classIdentifier = uniqueIdentifier.substring(1, dot);
                JavaType classThing = CommonUtilities.getTypeByUniqueIdentifier0(classIdentifier, provider);
                if (classThing == null) {
                    return null;
                }
                int space = uniqueIdentifier.indexOf(32, dot + 1);
                if (space < 0 || space == dot + 1) {
                    return null;
                }
                String name = uniqueIdentifier.substring(dot + 1, space);
                return classThing.getDeclaredField(name);
            }
            case 'm': {
                int dot = uniqueIdentifier.indexOf(46, 1);
                if (dot <= 1) {
                    return null;
                }
                String classIdentifier = uniqueIdentifier.substring(1, dot);
                JavaType classThing = CommonUtilities.getTypeByUniqueIdentifier0(classIdentifier, provider);
                if (classThing == null) {
                    return null;
                }
                int space = uniqueIdentifier.indexOf(32, dot + 1);
                if (space < 0 || space == dot + 1) {
                    return null;
                }
                String name = uniqueIdentifier.substring(dot + 1, space);
                int lparen = uniqueIdentifier.indexOf(40, space + 1);
                if (lparen < 0) {
                    return null;
                }
                int rparen = uniqueIdentifier.indexOf(41, lparen + 1);
                if (rparen < 0) {
                    return null;
                }
                JavaType[] formals = JavaType.EMPTY_ARRAY;
                if (rparen != lparen + 1) {
                    String formalsString = uniqueIdentifier.substring(lparen + 1, rparen);
                    formals = CommonUtilities.getTypesByUniqueIdentifier0(formalsString, provider);
                }
                return classThing.getDeclaredMethod(name, formals);
            }
        }
        return CommonUtilities.getTypeByUniqueIdentifier0(uniqueIdentifier, provider);
    }

    private static JavaType getTypeByUniqueIdentifier0(String identifier, JavaProvider provider) {
        char first;
        int length = identifier.length();
        if (length == 1 && 'A' <= (first = identifier.charAt(0)) && first <= 'Z') {
            return PrimitiveType.PRIMITIVE_alpha[first - 65];
        }
        try {
            QuickSignatureParser parser = new QuickSignatureParser(identifier, null, provider);
            SignatureHasType hasType = (SignatureHasType)parser.parseTypeSignature0();
            if (hasType != null) {
                return hasType.getResolvedType();
            }
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    private static JavaType[] getTypesByUniqueIdentifier0(String identifier, JavaProvider provider) {
        try {
            SignatureHasType hasType;
            QuickSignatureParser parser = new QuickSignatureParser(identifier, null, provider);
            ArrayList<JavaType> list = new ArrayList<JavaType>();
            while (parser.curToken != 0 && (hasType = (SignatureHasType)parser.parseTypeSignature0()) != null) {
                list.add(hasType.getResolvedType());
            }
            int count = list.size();
            if (count == 0) {
                return JavaType.EMPTY_ARRAY;
            }
            return list.toArray(new JavaType[count]);
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (IllegalStateException illegalStateException) {
            return JavaType.EMPTY_ARRAY;
        }
    }

    public static SourceElement getSourceElement(JavaElement target, SourceFile searchSpace) {
        if (searchSpace == null) {
            return null;
        }
        if (target == null) {
            throw new IllegalArgumentException();
        }
        switch (target.getElementKind()) {
            case 3: {
                JavaClass thing = (JavaClass)target;
                SourceClass found = CommonUtilities.getSourceElement(thing, searchSpace);
                if (found != null) {
                    return found;
                }
                JavaClass owning = thing.getOwningClass();
                if (owning == null) {
                    return null;
                }
                SourceClass searchClass = CommonUtilities.getSourceElement(owning, searchSpace);
                return CommonUtilities.getSourceElement(thing, searchClass);
            }
            case 5: {
                JavaField thing = (JavaField)target;
                JavaClass owning = thing.getOwningClass();
                SourceClass searchClass = CommonUtilities.getSourceElement(owning, searchSpace);
                return CommonUtilities.getSourceElement(thing, searchClass);
            }
            case 4: 
            case 8: {
                JavaMethod thing = (JavaMethod)target;
                JavaClass owning = thing.getOwningClass();
                SourceClass searchClass = CommonUtilities.getSourceElement(owning, searchSpace);
                return CommonUtilities.getSourceElement(thing, searchClass);
            }
        }
        return null;
    }

    public static SourceClass getSourceElement(JavaClass target, SourceFile searchSpace) {
        if (searchSpace == null) {
            return null;
        }
        if (target == null) {
            throw new IllegalArgumentException();
        }
        String targetName = target.getDescriptor();
        for (SourceClass thing : searchSpace.getSourceClasses()) {
            if (!targetName.equals(thing.getDescriptor())) continue;
            return thing;
        }
        return null;
    }

    public static SourceClass getSourceElement(JavaClass target, SourceClass searchSpace) {
        if (searchSpace == null) {
            return null;
        }
        if (target == null) {
            throw new IllegalArgumentException();
        }
        String targetName = target.getName();
        for (SourceClass thing : searchSpace.getSourceClasses()) {
            if (!targetName.equals(thing.getName())) continue;
            return thing;
        }
        return null;
    }

    public static SourceMemberVariable getSourceElement(JavaField target, SourceClass searchSpace) {
        if (searchSpace == null) {
            return null;
        }
        if (target == null) {
            throw new IllegalArgumentException();
        }
        String targetName = target.getName();
        for (SourceMemberVariable thing : searchSpace.getSourceMemberVariables()) {
            if (!targetName.equals(thing.getName())) continue;
            return thing;
        }
        return null;
    }

    public static SourceRecordComponent getSourceElement(JavaRecordComponent target, SourceClass searchSpace) {
        if (searchSpace == null) {
            return null;
        }
        if (target == null) {
            throw new IllegalArgumentException();
        }
        String targetName = target.getName();
        for (SourceRecordComponent component : searchSpace.getSourceRecordComponents()) {
            if (!targetName.equals(component.getName())) continue;
            return component;
        }
        return null;
    }

    public static SourceMethod getSourceElement(JavaMethod target, SourceClass searchSpace) {
        if (searchSpace == null) {
            return null;
        }
        if (target == null) {
            throw new IllegalArgumentException();
        }
        boolean isConstructor = target.isConstructor();
        String targetName = target.getName();
        boolean isVarargs = target.isVarargs();
        String descriptor = target.getDescriptor();
        List<SourceMethod> methods = isConstructor ? searchSpace.getSourceConstructors() : searchSpace.getSourceMethods();
        for (SourceMethod method : methods) {
            if (!isConstructor && (!targetName.equals(method.getName()) || isVarargs != method.isVarargs()) || !descriptor.equals(method.getDescriptor())) continue;
            return method;
        }
        return null;
    }

    public static SourceAnnotation getSourceElement(JavaAnnotation target, SourceHasModifiers searchSpace) {
        if (searchSpace == null) {
            return null;
        }
        if (target == null) {
            throw new IllegalArgumentException();
        }
        JavaType targetType = target.getResolvedType();
        if (targetType == null) {
            return null;
        }
        for (SourceAnnotation sourceAnnotation : searchSpace.getSourceAnnotations()) {
            JavaType type;
            JavaAnnotation annotation = sourceAnnotation.getCompiledObject();
            if (annotation == null || !targetType.equals(type = annotation.getResolvedType())) continue;
            return sourceAnnotation;
        }
        return null;
    }

    public static JavaMethod getDeclaredMethodFromUniqueId(JavaFile javaFile, String uniqueIdentifier) {
        if (javaFile == null) {
            return null;
        }
        for (JavaClass type : javaFile.getClasses()) {
            JavaMethod method = CommonUtilities.getDeclaredMethodFromUniqueId(type, uniqueIdentifier);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    public static JavaMethod getDeclaredMethodFromUniqueId(JavaClass javaClass, String uniqueIdentifier) {
        if (javaClass == null) {
            return null;
        }
        JavaMethod method = CommonUtilities.getDeclaredMethodFromUniqueId(javaClass.getDeclaredMethods(), uniqueIdentifier);
        if (method != null) {
            return method;
        }
        method = CommonUtilities.getDeclaredMethodFromUniqueId(javaClass.getDeclaredConstructors(), uniqueIdentifier);
        if (method != null) {
            return method;
        }
        for (JavaClass aClass : javaClass.getDeclaredClasses()) {
            method = CommonUtilities.getDeclaredMethodFromUniqueId(aClass, uniqueIdentifier);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    private static JavaMethod getDeclaredMethodFromUniqueId(Collection<JavaMethod> methods, String uniqueIdentifier) {
        for (JavaMethod method : methods) {
            if (!method.getUniqueIdentifier().equals(uniqueIdentifier)) continue;
            return method;
        }
        return null;
    }

    public static JavaField getDeclaredFieldFromUniqueId(JavaFile javaFile, String uniqueIdentifier) {
        if (javaFile == null) {
            return null;
        }
        Collection<JavaClass> classes = javaFile.getClasses();
        for (JavaClass type : classes) {
            JavaField field = CommonUtilities.getDeclaredFieldFromUniqueId(type, uniqueIdentifier);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    public static JavaField getDeclaredFieldFromUniqueId(JavaClass javaClass, String uniqueIdentifier) {
        if (javaClass == null) {
            return null;
        }
        for (JavaField field : javaClass.getDeclaredFields()) {
            if (!field.getUniqueIdentifier().equals(uniqueIdentifier)) continue;
            return field;
        }
        for (JavaClass type : javaClass.getDeclaredClasses()) {
            JavaField field = CommonUtilities.getDeclaredFieldFromUniqueId(type, uniqueIdentifier);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    public static List<SourceClass> getSourceAnonymousClasses(final SourceElement sourceElement) {
        if (sourceElement == null) {
            return Collections.emptyList();
        }
        final ArrayList<SourceClass> foundClasses = new ArrayList<SourceClass>();
        SourceVisitor<Object> visitor = new SourceVisitor<Object>(){

            @Override
            public void whenEnterClass(SourceClass sourceClass) {
                if (sourceClass == sourceElement) {
                    return;
                }
                if (sourceClass.isAnonymousClass()) {
                    foundClasses.add(sourceClass);
                }
                this.cancelSubtree();
            }
        };
        visitor.visit(sourceElement);
        return foundClasses;
    }

    public static List<SourceClass> getSourceLocalClasses(final SourceElement sourceElement) {
        if (sourceElement == null) {
            return Collections.emptyList();
        }
        final ArrayList<SourceClass> foundClasses = new ArrayList<SourceClass>();
        SourceVisitor<Object> visitor = new SourceVisitor<Object>(){

            @Override
            public void whenEnterClass(SourceClass sourceClass) {
                if (sourceClass == sourceElement) {
                    return;
                }
                if (sourceClass.isLocalClass()) {
                    foundClasses.add(sourceClass);
                }
                this.cancelSubtree();
            }
        };
        visitor.visit(sourceElement);
        return foundClasses;
    }

    private static Map<String, Short> initKeywordToToken() {
        HashMap<String, Short> map = new HashMap<String, Short>();
        for (short kw = 96; kw < 146; kw = (short)(kw + 1)) {
            map.put(KW_words[kw - 96], kw);
        }
        return map;
    }

    private static Set<String> initReservedLiterals() {
        return new HashSet<String>(Arrays.asList("null", "true", "false"));
    }

    public static boolean isKeyword(String word, JdkVersion jdkVersion) {
        if (word == null || jdkVersion == null || jdkVersion == JdkVersion.JDK_UNKNOWN) {
            return false;
        }
        Short kw = keywordToToken.get(word);
        if (kw == null) {
            return false;
        }
        switch (jdkVersion) {
            case JDK_1: 
            case JDK_2: 
            case JDK_3: {
                return kw < 144;
            }
            case JDK_4: {
                return kw < 145;
            }
            case JDK_5: {
                return kw < 146;
            }
            case JDK_6: {
                return kw < 146;
            }
            case JDK_7: {
                return kw < 146;
            }
            case JDK_8: {
                return kw < 146;
            }
        }
        return kw < 146;
    }

    public static boolean isValidImportName(String name) {
        return CommonUtilities.isValidName(name, true, false);
    }

    public static boolean isValidQualifiedName(String name) {
        return CommonUtilities.isValidName(name, false, true);
    }

    public static boolean isValidSimpleName(String name) {
        return CommonUtilities.isValidIdentifier(name) || "this".equals(name) || "super".equals(name);
    }

    private static boolean isValidName(String name, boolean checkImport, boolean checkQualified) {
        if (name == null || name.length() == 0) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(name, ".", true);
        boolean sawDot = true;
        int count = 0;
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            if (".".equals(nextToken)) {
                if (sawDot) {
                    return false;
                }
                sawDot = true;
            } else {
                if (checkQualified) {
                    if (!CommonUtilities.isValidSimpleName(nextToken) && !"class".equals(nextToken) && PrimitiveType.lookupPrimitive(name) == null) {
                        return false;
                    }
                } else if (checkImport) {
                    if (!CommonUtilities.isValidIdentifier(nextToken)) {
                        return count > 0 && "*".equals(nextToken) && !tokenizer.hasMoreTokens();
                    }
                } else if (!CommonUtilities.isValidIdentifier(nextToken)) {
                    return false;
                }
                sawDot = false;
            }
            ++count;
        }
        return !sawDot;
    }

    public static boolean isReservedLiteral(String word) {
        return reservedLiterals.contains(word);
    }

    public static boolean isReservedWord(String word) {
        return CommonUtilities.isKeyword(word, JdkVersion.getMaxVersion()) || CommonUtilities.isReservedLiteral(word);
    }

    public static boolean isReservedWord(String word, JdkVersion jdkVersion) {
        return CommonUtilities.isKeyword(word, jdkVersion) || CommonUtilities.isReservedLiteral(word);
    }

    public static boolean isValidIdentifier(String name) {
        if (name == null) {
            return false;
        }
        int count = name.length();
        if (count == 0) {
            return false;
        }
        if (CommonUtilities.isReservedWord(name)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < count; ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidPackageName(String name) {
        return CommonUtilities.isValidName(name, false, false);
    }

    public static boolean isValidTypeName(String name) {
        return CommonUtilities.isValidPackageName(name) || PrimitiveType.lookupPrimitive(name) != null;
    }

    public static boolean containsClassThisSuper(String qualifiedName) {
        int length = qualifiedName.length();
        int afterLastDot = 0;
        while (afterLastDot < length) {
            int segmentLength;
            int nextDot = qualifiedName.indexOf(46, afterLastDot);
            if (nextDot < 0) {
                nextDot = length;
            }
            if (4 <= (segmentLength = nextDot - afterLastDot) && segmentLength <= 5) {
                String segment = qualifiedName.substring(afterLastDot, nextDot);
                if (segment.equals("class")) {
                    return true;
                }
                if (segment.equals("this")) {
                    return true;
                }
                if (segment.equals("super")) {
                    return true;
                }
            }
            afterLastDot = nextDot + 1;
        }
        return false;
    }

    public static JavaClass getTypeErasure(JavaTypeVariable typeVariable) {
        JavaType firstBound;
        Collection<JavaType> bounds;
        if (!(CommonUtilities.hasBoundsCircularity(typeVariable) || (bounds = typeVariable.getBounds()).isEmpty() || (firstBound = bounds.iterator().next()).equals(typeVariable))) {
            return firstBound.getTypeErasure();
        }
        JavaType superclass = typeVariable.getSuperclass();
        if (superclass != null) {
            return superclass.getTypeErasure();
        }
        Collection<JavaType> interfaces = typeVariable.getInterfaces();
        if (interfaces.isEmpty()) {
            return null;
        }
        JavaType firstInterface = interfaces.iterator().next();
        return firstInterface.getTypeErasure();
    }

    public static boolean hasBoundsCircularity(JavaTypeVariable javaTypeVariable) {
        if (javaTypeVariable == null) {
            return false;
        }
        return CommonUtilities.hasBoundsCircularity(javaTypeVariable, javaTypeVariable);
    }

    private static boolean hasBoundsCircularity(JavaTypeVariable originalThing, JavaTypeVariable currentThing) {
        Collection<JavaType> bounds = currentThing.getBounds();
        if (bounds.isEmpty()) {
            return false;
        }
        for (JavaType bound : bounds) {
            boolean hasCircularity;
            if (bound == null) continue;
            if (bound.equals(originalThing)) {
                return true;
            }
            if (bound.getElementKind() != 10 || !(hasCircularity = CommonUtilities.hasBoundsCircularity(originalThing, (JavaTypeVariable)bound))) continue;
            return true;
        }
        return false;
    }

    public static String getInstantiatedTypeToString(JavaType type) {
        StringBuilder builder = new StringBuilder();
        if (type.isArray()) {
            builder.append(CommonUtilities.getInstantiatedTypeToString(type.getComponentType()));
            builder.append("[]");
        } else {
            builder.append(type.getName());
            if (type.getElementKind() == 11) {
                JavaWildcardType wildCardType = (JavaWildcardType)type;
                String snippet = null;
                Collection<JavaType> upperBounds = wildCardType.getUpperBounds();
                if (upperBounds != null && upperBounds.iterator().hasNext()) {
                    snippet = " extends ";
                } else {
                    upperBounds = wildCardType.getLowerBounds();
                    if (upperBounds != null && upperBounds.iterator().hasNext()) {
                        snippet = " super ";
                    }
                }
                if (snippet != null) {
                    builder.append(snippet);
                    JavaType boundType = upperBounds.iterator().next();
                    builder.append(CommonUtilities.getInstantiatedTypeToString(boundType));
                }
            } else if (type.hasActualTypeArguments()) {
                int punctuation = 60;
                for (JavaType argument : type.getActualTypeArguments()) {
                    builder.append((char)punctuation);
                    builder.append(CommonUtilities.getInstantiatedTypeToString(argument));
                    punctuation = 44;
                }
                builder.append('>');
            }
        }
        return builder.toString();
    }

    public static boolean hasTypeParameter(JavaType javaType, JavaType[] typeParameters) {
        if (javaType == null) {
            return false;
        }
        switch (javaType.getElementKind()) {
            case 10: {
                if (typeParameters == null || typeParameters.length == 0) {
                    return true;
                }
                for (JavaType typeParameter : typeParameters) {
                    if (!javaType.equals(typeParameter)) continue;
                    return true;
                }
                break;
            }
            case 11: {
                if (typeParameters == null || typeParameters.length == 0) {
                    return true;
                }
                JavaWildcardType fw = (JavaWildcardType)javaType;
                for (JavaType bound : fw.getUpperBounds()) {
                    if (!CommonUtilities.hasTypeParameter(bound, typeParameters)) continue;
                    return true;
                }
                for (JavaType bound : fw.getLowerBounds()) {
                    if (!CommonUtilities.hasTypeParameter(bound, typeParameters)) continue;
                    return true;
                }
                break;
            }
            case 3: {
                if (javaType.isPrimitive()) {
                    return false;
                }
                if (javaType.isArray()) {
                    return CommonUtilities.hasTypeParameter(javaType.getComponentType(), typeParameters);
                }
                if (!javaType.hasActualTypeArguments()) break;
                for (JavaType y : javaType.getActualTypeArguments()) {
                    if (!CommonUtilities.hasTypeParameter(y, typeParameters)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    public static <T> List<T> immutableCopy(Collection<T> src) {
        return Collections.unmodifiableList(CommonUtilities.mutableCopy(src));
    }

    public static <T> ArrayList<T> mutableCopy(Collection<T> src) {
        return new ArrayList<T>(src);
    }

    public static List<Integer> getParameterCommaLocations(SourceMethod sourceMethod) {
        if (sourceMethod == null) {
            return Collections.emptyList();
        }
        ArrayList<Integer> commaLocations = new ArrayList<Integer>();
        SourceFormalParameterList formalParameterList = sourceMethod.getFormalParameterList();
        if (formalParameterList != null) {
            List<SourceVariable> parameters = formalParameterList.getSourceParameters();
            CommonUtilities.fillInCommaLocations(parameters, formalParameterList.getTokens(), commaLocations);
        }
        return commaLocations;
    }

    public static List<Integer> getArgumentCommaLocations(SourceInvokeExpression invokeExpression) {
        if (invokeExpression == null) {
            return Collections.emptyList();
        }
        SourceListExpression argumentList = invokeExpression.getArgumentList();
        ArrayList<Integer> commaLocations = new ArrayList<Integer>();
        if (argumentList != null) {
            List<SourceExpression> arguments = argumentList.getOperands();
            CommonUtilities.fillInCommaLocations(arguments, argumentList.getTokens(), commaLocations);
        }
        return commaLocations;
    }

    private static void fillInCommaLocations(List<? extends SourceElement> pieces, List<SourceToken> tokens, List<Integer> commaLocations) {
        if (pieces.isEmpty()) {
            return;
        }
        int piecesIndex = 0;
        int currentPieceStart = pieces.get(piecesIndex).getStartOffset();
        int currentPieceEnd = pieces.get(piecesIndex).getEndOffset();
        for (SourceToken token : tokens) {
            if (token.getTokenStart() >= currentPieceStart && token.getTokenEnd() <= currentPieceEnd) continue;
            if (token.getTokenStart() >= currentPieceEnd) {
                if (++piecesIndex < pieces.size()) {
                    currentPieceStart = pieces.get(piecesIndex).getStartOffset();
                    currentPieceEnd = pieces.get(piecesIndex).getEndOffset();
                } else {
                    SourceToken lastToken = tokens.get(tokens.size() - 1);
                    currentPieceStart = lastToken.getTokenEnd();
                    currentPieceEnd = lastToken.getTokenEnd();
                }
            }
            if (token.getTokenValue() != 39) continue;
            commaLocations.add(token.getTokenStart());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static JavaHasNameSet<JavaType> getHandledExceptions(SourceElement sourceElement) {
        JavaHasNameSet<JavaType> set = new JavaHasNameSet<JavaType>();
        SourceElement parent = sourceElement.getParent();
        while (parent != null) {
            switch (parent.getSymbolKind()) {
                case 63: {
                    for (SourceCatchClause clause : ((SourceTryStatement)parent).getCatchClauses()) {
                        SourceCatchParameter variable = (SourceCatchParameter)clause.getCatchVariable();
                        if (variable == null) continue;
                        List<SourceTypeReference> types = variable.getSourceTypes();
                        for (SourceTypeReference type : types) {
                            JavaType javaType = type.getResolvedType();
                            if (javaType == null) continue;
                            set.add(javaType);
                        }
                    }
                    break;
                }
                case 50: {
                    SourceCatchClause catchClause = (SourceCatchClause)parent;
                    SourceTryStatement catchTry = catchClause.getOwningTry();
                    if (catchTry == null) break;
                    parent = catchTry;
                    break;
                }
                case 56: {
                    SourceFinallyClause finallyClause = (SourceFinallyClause)parent;
                    SourceTryStatement finallyTry = finallyClause.getOwningTry();
                    if (finallyTry == null) break;
                    parent = finallyTry;
                    break;
                }
                case 19: {
                    set.addAll(((SourceMethod)parent).getExceptions());
                    return set;
                }
            }
            parent = parent.getParent();
        }
        return set;
    }

    public static String format(String input, String arg0) {
        int index;
        if (arg0 != null && (index = ((String)input).indexOf("{0}")) >= 0) {
            String prefix = ((String)input).substring(0, index);
            String suffix = ((String)input).substring(index + 3);
            input = prefix + arg0 + suffix;
        }
        return input;
    }

    public static String format(String input, String arg0, String arg1) {
        String suffix;
        String prefix;
        int index;
        if (arg0 != null && (index = ((String)input).indexOf("{0}")) >= 0) {
            prefix = ((String)input).substring(0, index);
            suffix = ((String)input).substring(index + 3);
            input = prefix + arg0 + suffix;
        }
        if (arg1 != null && (index = ((String)input).indexOf("{1}")) >= 0) {
            prefix = ((String)input).substring(0, index);
            suffix = ((String)input).substring(index + 3);
            input = prefix + arg1 + suffix;
        }
        return input;
    }

    public static void panic(String message) {
        throw new IllegalStateException(message);
    }

    public static void panic() {
        throw new IllegalStateException();
    }

    public static void unsupported(String message) {
        throw new UnsupportedOperationException(message);
    }

    public static void unsupported() {
        throw new UnsupportedOperationException();
    }

    public static void notImplementedYet() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private static class StickyIterator<JavaVariable>
    implements Iterator<JavaVariable> {
        private final Iterator<JavaVariable> iterator;
        private final boolean varargs;
        private JavaVariable lastParameter;

        StickyIterator(Collection<JavaVariable> parameters, boolean varargs) {
            this.iterator = parameters.iterator();
            this.varargs = varargs;
        }

        @Override
        public boolean hasNext() {
            return this.varargs || this.iterator.hasNext();
        }

        @Override
        public JavaVariable next() {
            if (this.iterator.hasNext()) {
                this.lastParameter = this.iterator.next();
                return this.lastParameter;
            }
            if (this.varargs) {
                return this.lastParameter;
            }
            throw new NoSuchElementException();
        }
    }
}

