/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.classfile;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.net.URLFileSystem;
import oracle.ide.nulls.NullPrintStream;
import oracle.ide.util.Assert;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.classfile.ClassConstants;
import oracle.javatools.parser.java.v2.classfile.Name;
import oracle.javatools.parser.java.v2.classfile.NamePool;

public final class ClassFile
implements ClassConstants {
    private static final ClassField[] EMPTY_FIELD_ARRAY = new ClassField[0];
    private static final ClassMethod[] EMPTY_METHOD_ARRAY = new ClassMethod[0];
    private static final ClassAnnotation[] EMPTY_ANNOTATION_ARRAY = new ClassAnnotation[0];
    private static final ComponentValue[] EMPTY_VALUE_ARRAY = new ComponentValue[0];
    private static final ClassAnnotation[][] EMPTY_ANNOTATION_ARRAY_ARRAY = new ClassAnnotation[0][];
    private static final MethodParameter[] EMPTY_METHOD_PARAMETER_ARRAY = new MethodParameter[0];
    private static final int DEPRECATED = 65536;
    private static final int HIDDEN_ATTR = 0x20000000;
    private static final Map<Name, Byte> ATTRIBUTE_indices = ClassFile.initAttributeIndices();
    private static final String kInitS = "<init>";
    private static final String kClinitS = "<clinit>";
    private final byte[] buffer;
    private final int bufferLength;
    private int bp;
    private int[] poolIdx;
    private Object[] poolObj;
    private int implBp;
    private int fieldBp;
    private int methodBp;
    private int attrBp;
    private final URL url;
    private int modifiers;
    private Name thisClassName;
    private Name sourceFilename;
    private Name classSignature;
    private Name baseClass;
    private Name[] baseInterfaces;
    private ClassField[] fields;
    private ClassMethod clinit;
    private ClassMethod[] methods;
    private ClassMethod[] constructors;
    private Name outerClass;
    private Name[] innerClasses;
    private ClassAnnotation[] classAnnotations;
    private List<TypeAnnotation> typeAnnotations;
    private boolean isAnonymous;
    private int enclosingClassIndex;
    private int enclosingMethodIndex;
    private Module module;
    private ModuleHashes moduleHashes;
    private ModuleMainClass moduleMainClass;
    private ModulePackages modulePackages;
    private ModuleResolution moduleResolution;
    private ModuleTarget moduleTarget;
    private NestHost nestHost;
    private NestMembers nestMembers;
    private ClassRecord record;
    private PermittedSubclasses permittedSubclasses;
    private int majorVersion;
    private int minorVersion;
    private boolean printCode;
    private static final int kMember_AttrPos = 6;

    private static Map<Name, Byte> initAttributeIndices() {
        int count = 31;
        HashMap<Name, Byte> map = new HashMap<Name, Byte>(count);
        for (int i = 0; i < count; ++i) {
            Name name = NamePool.fromString(ATTRIBUTE_words[i]);
            map.put(name, (byte)(i + 1));
        }
        return map;
    }

    private static byte name2attribute(Name name) {
        Byte result = ATTRIBUTE_indices.get(name);
        return result != null ? result : Byte.valueOf((byte)0);
    }

    public ClassFile(byte[] buffer, int length, URL url) {
        this.buffer = buffer;
        this.bufferLength = length;
        this.url = url;
        try {
            this.readHeader();
            this.indexFields();
            this.indexMethods();
            this.readClassAttributes();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw this.updateException(e);
        }
    }

    public ClassFile(byte[] buffer, URL url) {
        this(buffer, buffer.length, url);
    }

    public ClassFile(byte[] buffer) {
        this(buffer, buffer.length, null);
    }

    public ByteArrayInputStream getBytes() {
        return new ByteArrayInputStream(this.buffer, 0, this.bufferLength);
    }

    public boolean isInterface() {
        return (this.modifiers & 0x200) != 0;
    }

    public boolean isModule() {
        return (this.modifiers & 0x8000) != 0;
    }

    public int getModifiers() {
        return this.modifiers & 0xFFFF;
    }

    public String getSignature() {
        return this.classSignature != null ? this.classSignature.toString() : null;
    }

    public boolean isDeprecated() {
        return (this.modifiers & 0x10000) != 0;
    }

    public boolean isHidden() {
        return (this.modifiers & 0x20000000) != 0;
    }

    public String getFullClassName() {
        return this.thisClassName.toString();
    }

    public Name getBaseClass() {
        return this.baseClass;
    }

    public Name[] getBaseInterfaces() {
        if (this.baseInterfaces != null) {
            return this.baseInterfaces;
        }
        try {
            this.readBaseInterfaces();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw this.updateException(e);
        }
        return this.baseInterfaces;
    }

    public Name getOuterClass() {
        return this.outerClass;
    }

    public ClassField[] getDeclaredFields() {
        if (this.fields != null) {
            return this.fields;
        }
        try {
            this.readFields();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw this.updateException(e);
        }
        return this.fields;
    }

    public ClassMethod[] getDeclaredMethods() {
        if (this.methods == null) {
            try {
                this.readMethods();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw this.updateException(e);
            }
        }
        return this.methods;
    }

    public ClassMethod[] getDeclaredConstructors() {
        if (this.constructors == null) {
            try {
                this.readMethods();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw this.updateException(e);
            }
        }
        return this.constructors;
    }

    public ClassMethod getClinitMethod() {
        if (this.methods == null) {
            try {
                this.readMethods();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw this.updateException(e);
            }
        }
        return this.clinit;
    }

    public Name[] getDeclaredInnerClasses() {
        return this.innerClasses;
    }

    public ClassAnnotation[] getDeclaredAnnotations() {
        return this.classAnnotations;
    }

    public Collection<TypeAnnotation> getTypeAnnotations() {
        return this.typeAnnotations;
    }

    public String getSourceFilename() {
        return this.sourceFilename == null ? null : this.sourceFilename.toString();
    }

    public URL getURL() {
        return this.url;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public boolean isLocal() {
        return !this.isAnonymous() && this.enclosingMethodIndex > 0;
    }

    public String getEnclosingClassName() {
        try {
            Name name;
            if (this.isValidPoolIndex(this.enclosingClassIndex) && (name = this.readPoolName(this.enclosingClassIndex)) != null) {
                return name.toString();
            }
            return null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw this.updateException(e);
        }
    }

    public String getEnclosingMethodName() {
        try {
            return this.getEnclosingMethodDetail(0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw this.updateException(e);
        }
    }

    public String getEnclosingMethodDescriptor() {
        try {
            return this.getEnclosingMethodDetail(1);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw this.updateException(e);
        }
    }

    private String getEnclosingMethodDetail(int index) {
        if (this.isValidPoolIndex(this.enclosingMethodIndex)) {
            int byteIndex = this.poolIdx[this.enclosingMethodIndex];
            if (this.buffer[byteIndex] != 12) {
                throw this.fileError("Expected CONSTANT_NameandType index");
            }
            Name[] names = (Name[])this.readPoolObject(this.enclosingMethodIndex);
            if (names != null && names.length > index && names[index] != null) {
                return names[index].toString();
            }
        }
        return null;
    }

    public Module getModule() {
        this.readClassAttributes();
        return this.module;
    }

    public ModuleHashes getModuleHashes() {
        this.readClassAttributes();
        return this.moduleHashes;
    }

    public ModuleMainClass getModuleMainClass() {
        this.readClassAttributes();
        return this.moduleMainClass;
    }

    public ModulePackages getModulePackages() {
        this.readClassAttributes();
        return this.modulePackages;
    }

    public ModuleResolution getModuleResolution() {
        this.readClassAttributes();
        return this.moduleResolution;
    }

    public ModuleTarget getModuleTarget() {
        this.readClassAttributes();
        return this.moduleTarget;
    }

    public String getModuleName() {
        Module module = this.getModule();
        return module != null ? module.getName() : null;
    }

    public NestHost getNestHost() {
        this.readClassAttributes();
        return this.nestHost;
    }

    public NestMembers getNestMembers() {
        this.readClassAttributes();
        return this.nestMembers;
    }

    public ClassRecord getRecord() {
        this.readClassAttributes();
        return this.record;
    }

    public PermittedSubclasses getPermittedSubclasses() {
        this.readClassAttributes();
        return this.permittedSubclasses;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    private void readHeader() {
        int magic = this.nextInt();
        if (magic != -889275714) {
            throw this.fileError("Bad magic number");
        }
        this.minorVersion = this.nextChar();
        this.majorVersion = this.nextChar();
        if (this.majorVersion * 100 + this.minorVersion < 4503) {
            throw this.fileError("Wrong version");
        }
        this.indexConstantPool();
        this.modifiers = this.nextChar();
        this.thisClassName = (Name)this.readPoolObject(this.nextChar());
        this.baseClass = this.readPoolClass(this.nextChar());
        this.implBp = this.bp;
        char interfaceCount = this.nextChar();
        this.bp += 2 * interfaceCount;
        this.fieldBp = this.bp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexFields() {
        ClassFile classFile = this;
        synchronized (classFile) {
            int fieldCount = this.nextChar();
            for (int i = 0; i < fieldCount; ++i) {
                this.skipFieldOrMethod();
            }
            this.methodBp = this.bp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexMethods() {
        ClassFile classFile = this;
        synchronized (classFile) {
            if (this.methodBp == 0) {
                this.indexFields();
            }
            this.bp = this.methodBp;
            int methodCount = this.nextChar();
            for (int i = 0; i < methodCount; ++i) {
                this.skipFieldOrMethod();
            }
            this.attrBp = this.bp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBaseInterfaces() {
        ClassFile classFile = this;
        synchronized (classFile) {
            if (this.baseInterfaces != null) {
                return;
            }
            int savedBp = this.bp;
            this.bp = this.implBp;
            int interfaceCount = this.nextChar();
            Name[] newBaseInterfaces = new Name[interfaceCount];
            for (int i = 0; i < interfaceCount; ++i) {
                Name name = this.readPoolClass(this.nextChar());
                if (name == null) {
                    String message = "Invalid reference";
                    throw this.fileError(message);
                }
                newBaseInterfaces[i] = name;
            }
            this.bp = savedBp;
            this.baseInterfaces = newBaseInterfaces;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFields() {
        ClassFile classFile = this;
        synchronized (classFile) {
            if (this.fields != null) {
                return;
            }
            int savedBp = this.bp;
            this.bp = this.fieldBp;
            int fieldCount = this.nextChar();
            ClassField[] newFields = ClassFile.createFieldArray(fieldCount);
            for (int i = 0; i < fieldCount; ++i) {
                newFields[i] = new ClassField();
            }
            if (this.methodBp == 0) {
                this.methodBp = this.bp;
            } else {
                this.bp = savedBp;
            }
            this.fields = newFields;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMethods() {
        ClassFile classFile = this;
        synchronized (classFile) {
            if (this.methods != null) {
                return;
            }
            int savedBp = this.bp;
            if (this.methodBp == 0) {
                this.indexFields();
            }
            this.bp = this.methodBp;
            int methodCount = this.nextChar();
            if (methodCount == 0) {
                this.methods = EMPTY_METHOD_ARRAY;
                this.constructors = EMPTY_METHOD_ARRAY;
                this.clinit = null;
            } else {
                ClassMethod[] allMethods = new ClassMethod[methodCount];
                int nConstructors = 0;
                int nClInit = 0;
                for (int i = 0; i < methodCount; ++i) {
                    ClassMethod m;
                    allMethods[i] = m = new ClassMethod();
                    if (m.isConstructor()) {
                        ++nConstructors;
                        continue;
                    }
                    if (!m.isClinit()) continue;
                    ++nClInit;
                }
                ClassMethod[] newMethods = ClassFile.createMethodArray(methodCount - nConstructors - nClInit);
                ClassMethod[] newConstructors = ClassFile.createMethodArray(nConstructors);
                ClassMethod newClinit = null;
                int m = 0;
                int c = 0;
                for (int i = 0; i < methodCount; ++i) {
                    ClassMethod method = allMethods[i];
                    if (method.isConstructor()) {
                        newConstructors[c++] = method;
                        continue;
                    }
                    if (method.isClinit()) {
                        newClinit = method;
                        continue;
                    }
                    newMethods[m++] = method;
                }
                this.constructors = newConstructors;
                this.clinit = newClinit;
                this.methods = newMethods;
            }
            if (this.attrBp == 0) {
                this.attrBp = this.bp;
            } else {
                this.bp = savedBp;
            }
        }
    }

    private void readInnerClasses() {
        this.innerClasses = Name.EMPTY_ARRAY;
        int count = this.nextChar();
        if (count == 0) {
            return;
        }
        Name[] childClasses = new Name[count];
        int childCount = 0;
        while (count-- > 0) {
            Name vmName = this.readPoolClass(this.nextChar());
            Name outerName = this.readPoolClass(this.nextChar());
            char innerNameIndex = this.nextChar();
            Name simpleName = innerNameIndex > '\u0000' ? this.readPoolName(innerNameIndex) : null;
            char flags = this.nextChar();
            if (vmName == null) continue;
            if (vmName.equals(this.thisClassName)) {
                this.outerClass = outerName;
                this.modifiers = this.modifiers & 0xFFFFFFFE | flags & 0xF;
                this.isAnonymous = innerNameIndex == '\u0000';
                continue;
            }
            if (simpleName != null && outerName != null) {
                if (!outerName.equals(this.thisClassName)) {
                    continue;
                }
            } else {
                String thisName = this.thisClassName.toString();
                int thisLength = thisName.length();
                String qualifiedName = vmName.toString();
                if (qualifiedName.length() <= thisLength || !qualifiedName.startsWith(thisName) || qualifiedName.charAt(thisLength) != '$' || qualifiedName.indexOf(36, thisLength + 1) >= 0) continue;
            }
            childClasses[childCount++] = vmName;
        }
        if (childCount != 0) {
            this.innerClasses = new Name[childCount];
            System.arraycopy(childClasses, 0, this.innerClasses, 0, childCount);
        }
    }

    private void readEnclosingMethodAttribute() {
        this.enclosingClassIndex = this.nextChar();
        this.enclosingMethodIndex = this.nextChar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readClassAttributes() {
        int savedBp = this.bp;
        if (this.attrBp == 0) {
            this.indexMethods();
        }
        try {
            this.bp = this.attrBp;
            int attrCount = this.nextChar();
            for (int i = 0; i < attrCount; ++i) {
                char attrIndex = this.nextChar();
                int attrLen = this.nextInt();
                int attrSavedBp = this.bp;
                Name attrName = this.readPoolName(attrIndex);
                switch (ClassFile.name2attribute(attrName)) {
                    case 4: {
                        this.modifiers |= 0x10000;
                        break;
                    }
                    case 31: {
                        this.modifiers |= 0x20000000;
                        break;
                    }
                    case 18: {
                        this.classSignature = this.readPoolExternal(this.nextChar());
                        break;
                    }
                    case 20: {
                        this.modifiers |= 0x1000;
                        break;
                    }
                    case 12: 
                    case 15: {
                        this.classAnnotations = this.readAnnotations(this.classAnnotations);
                        break;
                    }
                    case 14: 
                    case 17: {
                        this.typeAnnotations = this.readTypeAnnotations(this.typeAnnotations, attrSavedBp + attrLen);
                        break;
                    }
                    case 19: {
                        this.sourceFilename = this.readPoolName(this.nextChar());
                        break;
                    }
                    case 7: {
                        this.readInnerClasses();
                        break;
                    }
                    case 5: {
                        this.readEnclosingMethodAttribute();
                        break;
                    }
                    case 21: {
                        this.module = new Module(this.nextChar());
                        break;
                    }
                    case 25: {
                        this.moduleHashes = new ModuleHashes();
                        break;
                    }
                    case 23: {
                        this.moduleMainClass = new ModuleMainClass();
                        break;
                    }
                    case 22: {
                        this.modulePackages = new ModulePackages();
                        break;
                    }
                    case 26: {
                        this.moduleResolution = new ModuleResolution();
                        break;
                    }
                    case 24: {
                        this.moduleTarget = new ModuleTarget(attrLen);
                        break;
                    }
                    case 27: {
                        this.nestHost = new NestHost();
                        break;
                    }
                    case 28: {
                        this.nestMembers = new NestMembers();
                        break;
                    }
                    case 29: {
                        this.record = new ClassRecord();
                        break;
                    }
                    case 30: {
                        this.permittedSubclasses = new PermittedSubclasses();
                        break;
                    }
                    default: {
                        this.bp += attrLen;
                    }
                }
                int endBp = attrSavedBp + attrLen;
                if (this.bp == endBp) continue;
                throw this.fileError("Invalid attribute length for " + attrName.toString());
            }
            if (this.innerClasses == null) {
                this.innerClasses = Name.EMPTY_ARRAY;
            }
            if (this.classAnnotations == null) {
                this.classAnnotations = EMPTY_ANNOTATION_ARRAY;
            }
            if (this.typeAnnotations == null) {
                this.typeAnnotations = Collections.emptyList();
            }
        }
        finally {
            this.bp = savedBp;
        }
    }

    private ArrayIndexOutOfBoundsException updateException(ArrayIndexOutOfBoundsException original) {
        try {
            if (original.getMessage().indexOf("File/Class name") > 0) {
                return original;
            }
            String name = null;
            if (this.url != null) {
                name = this.url.getPath();
            } else if (this.sourceFilename != null) {
                name = this.sourceFilename.toString();
            } else if (this.thisClassName != null) {
                name = this.thisClassName.toString();
            }
            return new ArrayIndexOutOfBoundsException(original.getMessage() + ". File/Class name = " + name + ". Buffer length = " + this.bufferLength);
        }
        catch (Exception e) {
            e.printStackTrace();
            return original;
        }
    }

    private void indexConstantPool() {
        int entryCount = this.nextChar();
        this.poolIdx = new int[entryCount];
        this.poolObj = new Object[entryCount];
        int i = 1;
        block7: while (i < entryCount) {
            this.poolIdx[i++] = this.bp;
            byte tag = this.buffer[this.bp++];
            switch (tag) {
                case 1: 
                case 2: {
                    char len = this.nextChar();
                    this.bp += len;
                    continue block7;
                }
                case 7: 
                case 8: 
                case 16: 
                case 19: 
                case 20: {
                    this.bp += 2;
                    continue block7;
                }
                case 15: {
                    this.bp += 3;
                    continue block7;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 17: 
                case 18: {
                    this.bp += 4;
                    continue block7;
                }
                case 5: 
                case 6: {
                    this.bp += 8;
                    ++i;
                    continue block7;
                }
            }
            throw this.fileError("Bad constant pool tag: " + tag);
        }
    }

    private boolean isValidPoolIndex(int poolIndex) {
        return poolIndex > 0 && poolIndex < this.poolObj.length;
    }

    private Object readPoolObject(int poolIndex) {
        Object o;
        if (!this.isValidPoolIndex(poolIndex)) {
            throw this.fileError("Invalid pool index");
        }
        if (this.poolObj[poolIndex] != null) {
            return this.poolObj[poolIndex];
        }
        int byteIndex = this.poolIdx[poolIndex];
        if (byteIndex == 0) {
            return null;
        }
        this.poolObj[poolIndex] = o = this.readPoolObjectImpl(byteIndex);
        return o;
    }

    private Object readPoolObjectImpl(int byteIndex) {
        byte tag = this.buffer[byteIndex];
        switch (tag) {
            case 1: {
                return NamePool.fromUTF(this.buffer, byteIndex + 3, this.getChar(byteIndex + 1));
            }
            case 7: 
            case 19: 
            case 20: {
                return this.readPoolExternal(this.getChar(byteIndex + 1));
            }
            case 2: {
                throw this.fileError("Can't read unicode");
            }
            case 8: {
                return this.readPoolObject(this.getChar(byteIndex + 1)).toString();
            }
            case 3: {
                return this.getInt(byteIndex + 1);
            }
            case 4: {
                return Float.valueOf(Float.intBitsToFloat(this.getInt(byteIndex + 1)));
            }
            case 5: {
                return this.getLong(byteIndex + 1);
            }
            case 6: {
                return Double.longBitsToDouble(this.getLong(byteIndex + 1));
            }
            case 12: {
                Name n1 = (Name)this.readPoolObject(this.getChar(byteIndex + 1));
                Name n2 = (Name)this.readPoolObject(this.getChar(byteIndex + 3));
                return new Name[]{n1, n2};
            }
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                throw this.fileError("Shouldn't be handling these attributes: " + tag);
            }
        }
        throw this.fileError("Bad constant pool tag: " + tag);
    }

    private Object readPoolConstant(int poolIndex, char descriptor) {
        switch (descriptor) {
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 's': {
                return this.readPoolObject(poolIndex);
            }
            case 'c': {
                return this.readPoolName(poolIndex);
            }
            case '@': 
            case '[': 
            case 'e': {
                return null;
            }
        }
        Integer i = (Integer)this.readPoolObject(poolIndex);
        if (i == null) {
            return null;
        }
        switch (descriptor) {
            case 'S': {
                return (short)i.intValue();
            }
            case 'C': {
                return Character.valueOf((char)i.intValue());
            }
            case 'B': {
                return (byte)i.intValue();
            }
            case 'Z': {
                return i != 0;
            }
        }
        throw this.fileError("Invalid type for a ConstantValue attribute");
    }

    private Name readPoolName(int poolIndex) {
        return (Name)this.readPoolObject(poolIndex);
    }

    private Name readPoolExternal(int poolIndex) {
        if (this.poolObj[poolIndex] == null) {
            int byteIndex = this.poolIdx[poolIndex];
            if (this.buffer[byteIndex] == 1) {
                this.poolObj[poolIndex] = NamePool.fromUTF(this.buffer, byteIndex + 3, this.getChar(byteIndex + 1));
            } else {
                throw this.fileError("Expected CONSTANT_Utf8 index");
            }
        }
        return (Name)this.poolObj[poolIndex];
    }

    private Name readPoolClass(int poolIndex) {
        if (poolIndex == 0) {
            return null;
        }
        int byteIndex = this.poolIdx[poolIndex];
        if (this.buffer[byteIndex] != 7) {
            throw this.fileError("Expected CONSTANT_Class index");
        }
        return (Name)this.readPoolObject(poolIndex);
    }

    private Name readPoolModuleInfo(int poolIndex) {
        if (poolIndex == 0) {
            return null;
        }
        int byteIndex = this.poolIdx[poolIndex];
        if (this.buffer[byteIndex] != 19) {
            throw this.fileError("Expected CONSTANT_ModuleInfo index");
        }
        return (Name)this.readPoolObject(poolIndex);
    }

    private Name readPoolPackageInfo(int poolIndex) {
        if (poolIndex == 0) {
            return null;
        }
        int byteIndex = this.poolIdx[poolIndex];
        if (this.buffer[byteIndex] != 20) {
            throw this.fileError("Expected CONSTANT_PackageInfo index");
        }
        return (Name)this.readPoolObject(poolIndex);
    }

    private byte nextByte() {
        return this.buffer[this.bp++];
    }

    private char nextChar() {
        int b = this.bp;
        char c = (char)((this.buffer[b] & 0xFF) << 8 | this.buffer[b + 1] & 0xFF);
        this.bp += 2;
        return c;
    }

    private int nextInt() {
        int b = this.bp;
        int i = (this.buffer[b] & 0xFF) << 24 | (this.buffer[b + 1] & 0xFF) << 16 | (this.buffer[b + 2] & 0xFF) << 8 | this.buffer[b + 3] & 0xFF;
        this.bp += 4;
        return i;
    }

    private byte getByte(int b) {
        return this.buffer[b];
    }

    private char getChar(int b) {
        return (char)((this.buffer[b] & 0xFF) << 8 | this.buffer[b + 1] & 0xFF);
    }

    private int getInt(int b) {
        return (this.buffer[b] & 0xFF) << 24 | (this.buffer[b + 1] & 0xFF) << 16 | (this.buffer[b + 2] & 0xFF) << 8 | this.buffer[b + 3] & 0xFF;
    }

    private long getLong(int b) {
        long hi = this.getInt(b);
        long lo = this.getInt(b + 4);
        return hi << 32 | lo & 0xFFFFFFFFL;
    }

    public static void main(String[] arguments) throws IOException {
        if (arguments.length == 0) {
            System.out.println("[directory, jar, zip, or jmod] class [class...]");
            return;
        }
        Path cwd = Paths.get(System.getProperty("user.dir"), new String[0]);
        Path container = null;
        int begin = 0;
        String argument = arguments[0];
        if (!argument.endsWith(".class")) {
            Path path = Paths.get(arguments[0], new String[0]);
            if (!path.isAbsolute()) {
                path = cwd.resolve(path);
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                container = path;
            } else if (argument.endsWith(".jmod")) {
                container = FileSystems.newFileSystem(path, (ClassLoader)null).getPath("classes", new String[0]);
            } else if (argument.endsWith("jar") || argument.endsWith(".zip")) {
                container = FileSystems.newFileSystem(path, (ClassLoader)null).getPath("", new String[0]);
            } else {
                System.out.println("[directory, jar, zip, or jmod] class [class...]");
                return;
            }
            begin = 1;
        }
        ArrayList<Path> classes = new ArrayList<Path>(arguments.length);
        for (int i = begin; i < arguments.length; ++i) {
            Path path;
            Object name = arguments[i];
            if (((String)name).endsWith(".class")) {
                if (((String)name).endsWith(".class")) {
                    name = ((String)name).substring(0, ((String)name).length() - ".class".length());
                }
                name = ((String)name).replace('.', '/') + ".class";
                if (container == null) {
                    path = Paths.get((String)name, new String[0]);
                    if (!path.isAbsolute()) {
                        path = cwd.resolve(path);
                    }
                } else {
                    path = container.resolve((String)name);
                }
            } else {
                System.out.println("ERROR: expected .class file: " + (String)name);
                return;
            }
            classes.add(path);
        }
        int separator = 0;
        for (Path path : classes) {
            if (separator++ > 0) {
                System.out.println("\n" + "-".repeat(80) + "\n");
            }
            SeekableByteChannel channel = Files.newByteChannel(path, new OpenOption[0]);
            try {
                long longSize = channel.size();
                int size = (int)longSize;
                byte[] byteBuffer = new byte[size];
                ByteBuffer buffer = ByteBuffer.wrap(byteBuffer, 0, size);
                int count = channel.read(buffer);
                if (count != size) {
                    throw new IOException("Expected " + size + " but got " + count + " bytes from " + path);
                }
                ClassFile file = new ClassFile(byteBuffer, size, path.toUri().toURL());
                file.dump(System.out, path);
            }
            finally {
                if (channel == null) continue;
                channel.close();
            }
        }
    }

    private String pathToString(Path path) {
        Object string = path.getFileSystem() == FileSystems.getDefault() ? path.toString() : path.getFileSystem().toString() + path;
        String scratch = "/scratch/" + System.getProperty("user.name") + "/view_storage/";
        String ade = "/ade/";
        return ((String)string).replace(scratch, ade);
    }

    public synchronized void dump(PrintStream stream, Path path) {
        try {
            ClassMethod[] methods;
            ClassMethod[] constructors;
            ClassField[] fields;
            Name[] interfaces;
            System.out.println(path);
            ClassFile.dumpModifiers(stream, this.modifiers, true, false);
            ClassRecord record = this.getRecord();
            if ((this.modifiers & 0x2000) != 0) {
                stream.print("@interface ");
            } else if ((this.modifiers & 0x200) != 0) {
                stream.print("interface ");
            } else if ((this.modifiers & 0x4000) != 0) {
                stream.print("enum ");
            } else {
                if ((this.modifiers & 0x8000) != 0) {
                    this.dumpModule(stream);
                    return;
                }
                if (record != null) {
                    stream.print("record ");
                } else {
                    stream.print("class ");
                }
            }
            stream.println(this.getFullClassName());
            if (record != null) {
                stream.println("  extends java/lang/Record");
            } else if ((this.modifiers & 0x4000) != 0) {
                stream.println("  extends java/lang/Enum<E>");
            } else if (this.getBaseClass() != null) {
                stream.println("  extends " + this.getBaseClass());
            }
            for (Name i : interfaces = this.getBaseInterfaces()) {
                stream.println("  implements " + i.toString());
            }
            String signature = this.getSignature();
            if (signature != null) {
                stream.println("  signature: " + signature);
            }
            stream.println("  major version: " + this.majorVersion);
            stream.println("  minor version: " + this.minorVersion);
            stream.println("  path: " + this.pathToString(path));
            ClassFile.dumpAnnotations(stream, this.getDeclaredAnnotations());
            if (record != null) {
                stream.println("Record Components:");
                for (ClassRecord.ClassRecordComponent component : record.getComponents()) {
                    component.dump(stream);
                }
            }
            if ((fields = this.getDeclaredFields()).length > 0) {
                stream.println("Fields:");
                for (ClassField field : fields) {
                    field.dump(stream);
                }
            }
            if ((constructors = this.getDeclaredConstructors()).length > 0) {
                stream.println("Constructors:");
                for (ClassMethod constructor : constructors) {
                    constructor.dump(stream);
                }
            }
            if ((methods = this.getDeclaredMethods()).length > 0) {
                stream.println("Methods:");
                for (ClassMethod method : methods) {
                    method.dump(stream);
                }
            }
            this.dumpPermittedSubclasses(stream);
            this.dumpNestMembers(stream);
            this.dumpNestHost(stream);
            this.dumpAttributes(stream, this.attrBp, true, "");
            this.dumpConstantPool(stream);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw this.updateException(e);
        }
    }

    private void dumpModule(PrintStream stream) {
        ModuleTarget moduleTarget;
        ModuleResolution resolution;
        ModulePackages packages;
        ModuleMainClass mainClass;
        String[] uses;
        ModuleRequires[] requires;
        ModuleProvides[] provides;
        ModuleOpens[] opens;
        ModuleExports[] exports;
        String filename;
        Module module = this.getModule();
        if (module.isOpen()) {
            stream.print("open ");
        }
        stream.print("module ");
        stream.println(module.getName());
        if (!module.getVersion().isEmpty()) {
            stream.print("Version: ");
            stream.println(module.getVersion());
        }
        if ((filename = this.getSourceFilename()) != null) {
            stream.println("SourceFile: " + filename);
        }
        ClassFile.dumpAnnotations(stream, this.getDeclaredAnnotations());
        stream.println();
        this.dumpConstantPool(stream);
        this.dumpAttributes(stream, this.attrBp, false, "");
        stream.println("Exports:");
        for (ModuleExports moduleExports : exports = module.getExports()) {
            stream.print(moduleExports.getPackageName());
            String[] moduleNames = moduleExports.getModuleNames();
            if (moduleNames.length > 0) {
                stream.print(" exported to ");
                for (int i = 0; i < moduleNames.length; ++i) {
                    if (i > 0) {
                        stream.print(", ");
                    }
                    stream.print(moduleNames[i]);
                }
            }
            stream.println();
        }
        stream.println("Opens:");
        for (ModuleOpens moduleOpens : opens = module.getOpens()) {
            stream.print(moduleOpens.getPackageName());
            String[] moduleNames = moduleOpens.getModuleNames();
            if (moduleNames.length > 0) {
                stream.print(" opened to ");
                for (int i = 0; i < moduleNames.length; ++i) {
                    if (i > 0) {
                        stream.print(", ");
                    }
                    stream.print(moduleNames[i]);
                }
            }
            stream.println();
        }
        stream.println("Provides:");
        for (ModuleProvides moduleProvides : provides = module.getProvides()) {
            stream.print(moduleProvides.getServiceInterface());
            stream.print(" provided with ");
            List<String> implementations = moduleProvides.getServiceImplementations();
            for (int i = 0; i < implementations.size(); ++i) {
                if (i > 0) {
                    stream.print(", ");
                }
                stream.print(implementations.get(i));
            }
            stream.println();
        }
        stream.println("Requires:");
        for (ModuleRequires moduleRequires : requires = module.getRequires()) {
            if (moduleRequires.isStaticPhase()) {
                stream.print("static ");
            }
            if (moduleRequires.isTransitive()) {
                stream.print("transitive ");
            }
            stream.println(moduleRequires.getModuleName());
        }
        stream.println("Uses:");
        for (String used : uses = module.getUses()) {
            stream.println(used);
        }
        ModuleHashes moduleHashes = this.getModuleHashes();
        if (moduleHashes != null) {
            List<ModuleHashes.ModuleHash> hashes;
            stream.println("ModuleHashes:");
            String algorithm = moduleHashes.getAlgorithm();
            if (algorithm != null) {
                stream.println("  Algorithm: " + algorithm);
            }
            if ((hashes = moduleHashes.getHashes()).size() > 0) {
                stream.println("  Hashes:");
                for (ModuleHashes.ModuleHash moduleHash : hashes) {
                    byte[] bytes;
                    String moduleName = moduleHash.getModuleName();
                    if (moduleName != null) {
                        stream.println("    ModuleName: " + moduleName);
                    }
                    if ((bytes = moduleHash.getHash()).length > 0) {
                        stream.print("    Bytes: ");
                        for (byte b : bytes) {
                            stream.printf("%02x ", b);
                        }
                    }
                    stream.println();
                }
            }
        }
        if ((mainClass = this.getModuleMainClass()) != null) {
            stream.println("ModuleMainClass:");
            String name = mainClass.getMainClass();
            if (name != null) {
                stream.println("  MainClass: " + name);
            }
        }
        if ((packages = this.getModulePackages()) != null) {
            stream.println("ModulePackages:");
            List<String> packageNames = packages.getPackages();
            if (packageNames.size() > 0) {
                stream.println("  Packages:");
                for (String packageName : packageNames) {
                    stream.println("    " + packageName);
                }
            }
        }
        if ((resolution = this.getModuleResolution()) != null) {
            stream.println("ModuleResolution:");
            stream.println("  Flags: " + String.format("0x%04x", resolution.getFlags()));
        }
        if ((moduleTarget = this.getModuleTarget()) != null) {
            stream.println("ModuleTarget:");
            String arch = moduleTarget.getOsArch();
            String name = moduleTarget.getOsName();
            if (arch != null) {
                stream.println("  OsArch: " + arch);
            }
            if (name != null) {
                stream.println("  OsName: " + name);
            }
        }
    }

    private void dumpConstantPool(PrintStream stream) {
        stream.println("Constant Pool:");
        for (int i = 1; i < this.poolIdx.length; ++i) {
            stream.print("  " + i + "\t");
            this.dumpPoolObject(stream, i);
            stream.println();
            int byteIndex = this.poolIdx[i];
            byte tag = this.buffer[byteIndex];
            if (tag != 5 && tag != 6) continue;
            ++i;
        }
    }

    private void dumpPoolObject(PrintStream stream, int poolIndex) {
        int byteIndex = this.poolIdx[poolIndex];
        byte tag = this.buffer[byteIndex];
        switch (tag) {
            case 1: {
                stream.print("(Utf8) ");
                break;
            }
            case 7: {
                stream.print("(Class) #" + this.getChar(byteIndex + 1) + ": ");
                break;
            }
            case 2: {
                stream.print("(Unicode) ??");
                return;
            }
            case 8: {
                stream.print("(String) #" + this.getChar(byteIndex + 1) + ": ");
                break;
            }
            case 3: {
                stream.print("(Integer) ");
                break;
            }
            case 4: {
                stream.print("(Float) ");
                break;
            }
            case 5: {
                stream.print("(Long) ");
                break;
            }
            case 6: {
                stream.print("(Double) ");
                break;
            }
            case 12: {
                char nameref = this.getChar(byteIndex + 1);
                char typeref = this.getChar(byteIndex + 3);
                stream.print("(NameandTypeRef) ");
                stream.print("#" + nameref + " #" + typeref + ": ");
                break;
            }
            case 9: {
                stream.print("(Fieldref) ");
                char classref = this.getChar(byteIndex + 1);
                char nametyperef = this.getChar(byteIndex + 3);
                stream.print("#" + classref + " #" + nametyperef + ": ");
                break;
            }
            case 10: {
                stream.print("(Methodref) ");
                char classref = this.getChar(byteIndex + 1);
                char nametyperef = this.getChar(byteIndex + 3);
                stream.print("#" + classref + " #" + nametyperef + ": ");
                break;
            }
            case 11: {
                stream.print("(InterfaceMethodref) ");
                char classref = this.getChar(byteIndex + 1);
                char nametyperef = this.getChar(byteIndex + 3);
                stream.print("#" + classref + " #" + nametyperef + ": ");
                break;
            }
            case 15: {
                stream.print("(MethodHandle) ");
                byte refKind = this.getByte(byteIndex + 1);
                char refIndex = this.getChar(byteIndex + 2);
                stream.print("#" + refKind + " #" + refIndex + ": ");
                break;
            }
            case 16: {
                stream.print("(MethodType) ");
                char signatureIndex = this.getChar(byteIndex + 1);
                stream.print("#" + signatureIndex + ": ");
                break;
            }
            case 17: {
                stream.print("(Dynamic) ");
                char methodIndex = this.getChar(byteIndex + 1);
                char nameTypeIndex = this.getChar(byteIndex + 3);
                stream.print("#" + methodIndex + " #" + nameTypeIndex + ": ");
                break;
            }
            case 18: {
                stream.print("(InvokeDynamic) ");
                char methodIndex = this.getChar(byteIndex + 1);
                char nameTypeIndex = this.getChar(byteIndex + 3);
                stream.print("#" + methodIndex + " #" + nameTypeIndex + ": ");
                break;
            }
            case 19: {
                stream.print("(ModuleInfo) #" + this.getChar(byteIndex + 1) + ": ");
                break;
            }
            case 20: {
                stream.print("(PackageInfo) #" + this.getChar(byteIndex + 1) + ": ");
                break;
            }
            default: {
                throw this.fileError("Bad constant pool tag: " + tag);
            }
        }
        this.dumpPoolObjectImpl(stream, poolIndex);
    }

    private void dumpPoolObjectImpl(PrintStream stream, int poolIndex) {
        int byteIndex = this.poolIdx[poolIndex];
        byte tag = this.buffer[byteIndex];
        switch (tag) {
            case 7: 
            case 8: 
            case 16: 
            case 19: 
            case 20: {
                this.dumpPoolObjectImpl(stream, this.getChar(byteIndex + 1));
                return;
            }
            case 12: {
                char nameref = this.getChar(byteIndex + 1);
                char typeref = this.getChar(byteIndex + 3);
                this.dumpPoolObjectImpl(stream, nameref);
                stream.print(", ");
                this.dumpPoolObjectImpl(stream, typeref);
                return;
            }
            case 9: 
            case 10: 
            case 11: {
                char classref = this.getChar(byteIndex + 1);
                char nametyperef = this.getChar(byteIndex + 3);
                this.dumpPoolObjectImpl(stream, classref);
                stream.print(".");
                this.dumpPoolObjectImpl(stream, nametyperef);
                return;
            }
            case 17: 
            case 18: {
                char bootStrapMethodRef = this.getChar(byteIndex + 1);
                char nametyperef = this.getChar(byteIndex + 3);
                stream.print("#");
                stream.print((int)bootStrapMethodRef);
                stream.print(": ");
                this.dumpPoolObjectImpl(stream, nametyperef);
                return;
            }
            case 15: {
                byte kind = this.getByte(byteIndex + 1);
                char methodRef = this.getChar(byteIndex + 2);
                stream.print(kind);
                stream.print(", ");
                this.dumpPoolObjectImpl(stream, methodRef);
                return;
            }
        }
        Object object = this.readPoolObject(poolIndex);
        if (object != null) {
            stream.print(object);
        }
    }

    private static void dumpModifiers(PrintStream stream, int modifiers, boolean isClass, boolean isField) {
        if ((modifiers & 1) != 0) {
            stream.print("public ");
        }
        if ((modifiers & 2) != 0) {
            stream.print("private ");
        }
        if ((modifiers & 4) != 0) {
            stream.print("protected ");
        }
        if ((modifiers & 8) != 0) {
            stream.print("static ");
        }
        if ((modifiers & 0x10) != 0) {
            stream.print("final ");
        }
        if (!isClass && (modifiers & 0x20) != 0) {
            stream.print("synchronized ");
        }
        if (isField) {
            if ((modifiers & 0x40) != 0) {
                stream.print("volatile ");
            }
            if ((modifiers & 0x80) != 0) {
                stream.print("transient ");
            }
        }
        if ((modifiers & 0x100) != 0) {
            stream.print("native ");
        }
        if ((modifiers & 0x400) != 0) {
            stream.print("abstract ");
        }
        if ((modifiers & 0x800) != 0) {
            stream.print("strictfp ");
        }
        if ((modifiers & 0x1000) != 0) {
            stream.print("(synthetic) ");
        }
        if ((modifiers & 0x2000) != 0) {
            stream.print("(annotation) ");
        }
        if ((modifiers & 0x4000) != 0) {
            stream.print("(enum) ");
        }
        if ((modifiers & 0x10000) != 0) {
            stream.print("@deprecated ");
        }
        if ((modifiers & 0x20000000) != 0) {
            stream.print("@hidden ");
        }
    }

    private static void dumpAnnotations(PrintStream stream, ClassAnnotation[] annotations) {
        for (ClassAnnotation classAnnotation : annotations) {
            classAnnotation.dump(stream);
        }
    }

    private static ClassField[] createFieldArray(int size) {
        return size != 0 ? new ClassField[size] : EMPTY_FIELD_ARRAY;
    }

    private static ClassMethod[] createMethodArray(int size) {
        return size != 0 ? new ClassMethod[size] : EMPTY_METHOD_ARRAY;
    }

    private TargetInfo parseTargetInfo() {
        byte targetType = this.nextByte();
        switch (targetType) {
            case 0: {
                return new ParamTargetInfo(TargetInfoType.CLASS_TYPE_PARAMETER);
            }
            case 1: {
                return new ParamTargetInfo(TargetInfoType.METHOD_TYPE_PARAMETER);
            }
            case 16: {
                return new SuperTargetInfo(TargetInfoType.CLASS_EXTENDS);
            }
            case 17: {
                return new TypeParamBoundTargetInfo(TargetInfoType.CLASS_TYPE_PARAMETER_BOUND);
            }
            case 18: {
                return new TypeParamBoundTargetInfo(TargetInfoType.METHOD_TYPE_PARAMETER_BOUND);
            }
            case 19: {
                return new TargetInfo(TargetInfoType.FIELD, true);
            }
            case 20: {
                return new TargetInfo(TargetInfoType.METHOD_RETURN, true);
            }
            case 21: {
                return new TargetInfo(TargetInfoType.METHOD_RECEIVER, true);
            }
            case 22: {
                return new ParamTargetInfo(TargetInfoType.METHOD_PARAMETER);
            }
            case 23: {
                return new ThrowsTargetInfo(TargetInfoType.THROWS);
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                return null;
            }
        }
        String msg = "Unknown target info kind";
        Assert.printStackTrace(msg);
        throw new IllegalStateException(msg);
    }

    private void skipFieldOrMethod() {
        this.bp += 6;
        int attrCount = this.nextChar();
        for (int i = 0; i < attrCount; ++i) {
            this.bp += 2;
            int attrLen = this.nextInt();
            this.bp += attrLen;
        }
    }

    private void skipAnnotation() {
        this.bp += 2;
        int count = this.nextChar();
        for (int i = 0; i < count; ++i) {
            this.skipComponent();
        }
    }

    private void skipComponent() {
        this.bp += 2;
        this.skipComponentValue();
    }

    private void skipComponentValue() {
        byte tag = this.nextByte();
        this.skipValue(tag);
    }

    private void skipValue(byte componentTag) {
        switch (componentTag) {
            case 64: {
                this.skipAnnotation();
                break;
            }
            case 91: {
                int count = this.nextChar();
                for (int i = 0; i < count; ++i) {
                    this.skipComponentValue();
                }
                break;
            }
            case 101: {
                this.bp += 4;
                break;
            }
            default: {
                this.bp += 2;
            }
        }
    }

    private ClassAnnotation[] readAnnotations(ClassAnnotation[] oldArray) {
        int oldCount;
        int count;
        if (oldArray == null) {
            oldArray = EMPTY_ANNOTATION_ARRAY;
        }
        if ((count = (oldCount = oldArray.length) + this.nextChar()) == 0) {
            return EMPTY_ANNOTATION_ARRAY;
        }
        ClassAnnotation[] newArray = new ClassAnnotation[count];
        if (oldCount > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, oldCount);
        }
        for (int i = oldCount; i < count; ++i) {
            newArray[i] = new ClassAnnotation();
        }
        return newArray;
    }

    private List<TypeAnnotation> readTypeAnnotations(List<TypeAnnotation> typeAnnotations, int endBp) {
        if (typeAnnotations == null) {
            typeAnnotations = new ArrayList<TypeAnnotation>();
        }
        int count = this.nextChar();
        try {
            for (int i = 0; i < count; ++i) {
                typeAnnotations.add(new TypeAnnotation());
            }
        }
        catch (IllegalStateException e) {
            this.bp = endBp;
        }
        return typeAnnotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpAttributes(PrintStream stream, int targetBp, boolean filter, String indent) {
        PrintStream realStream = stream;
        NullPrintStream nullStream = new NullPrintStream();
        int savedBp = this.bp;
        try {
            this.bp = targetBp;
            int attrCount = this.nextChar();
            for (int i = 0; i < attrCount; ++i) {
                int modulo;
                char attrIndex = this.nextChar();
                int attrLen = this.nextInt();
                int attrSavedBp = this.bp;
                Name attrName = this.readPoolName(attrIndex);
                if (filter) {
                    switch (attrName.toString()) {
                        case "NestHost": 
                        case "NestMembers": 
                        case "Record": 
                        case "PermittedSubclasses": 
                        case "Signature": 
                        case "SourceFile": 
                        case "Code": {
                            stream = nullStream;
                            break;
                        }
                        default: {
                            stream = realStream;
                        }
                    }
                }
                switch (attrName.toString()) {
                    case "Code": {
                        stream.print(indent + attrName + " (" + attrLen + ") ");
                        modulo = 20;
                        break;
                    }
                    default: {
                        stream.println(indent + attrName + " (" + attrLen + ")");
                        modulo = 24;
                        stream.print(indent + "  ");
                    }
                }
                if (attrLen > 0) {
                    for (int j = 0; j < attrLen; ++j) {
                        if (j > 0 && j % modulo == 0) {
                            stream.println();
                            stream.print(indent + "    ");
                        }
                        int ii = this.nextByte();
                        stream.print(ClassFile.toHex(ii &= 0xFF, 2) + " ");
                        modulo = 24;
                    }
                    stream.println();
                    this.dumpAttribute(stream, attrName, attrSavedBp);
                }
                this.bp = attrSavedBp + attrLen;
            }
        }
        finally {
            this.bp = savedBp;
        }
    }

    private void dumpAttribute(PrintStream stream, Name attrName, int targetBp) {
        this.bp = targetBp;
        byte attribute = ClassFile.name2attribute(attrName);
        switch (attribute) {
            case 18: 
            case 19: {
                this.dumpAttributeName(stream);
                break;
            }
            case 7: {
                this.dumpInnerClasses(stream);
                break;
            }
            case 5: {
                this.dumpEnclosingMethod(stream);
                break;
            }
            case 11: {
                this.dumpMethodParameters(stream);
                break;
            }
            case 27: {
                this.dumpNestHost(stream);
                break;
            }
            case 28: {
                this.dumpNestMembers(stream);
            }
        }
    }

    private void dumpMethodParameters(PrintStream stream) {
        int count = 0xFF & this.nextByte();
        for (int x = 0; x < count; ++x) {
            Name name = this.readPoolName(this.nextChar());
            char flags = this.nextChar();
            stream.println("      Method parameter name: " + name.toString() + " flags: 0X" + Integer.toHexString(flags));
        }
    }

    private void dumpInnerClasses(PrintStream stream) {
        int count = this.nextChar();
        while (count-- > 0) {
            Name inner = this.readPoolClass(this.nextChar());
            Name outer = this.readPoolClass(this.nextChar());
            stream.println("  Inner Name: " + inner);
            stream.println("  Outer Name: " + outer);
            char innerNameIndex = this.nextChar();
            Name plainName = innerNameIndex > '\u0000' ? this.readPoolName(innerNameIndex) : null;
            stream.println("  Plain Name: " + plainName);
            char flags = this.nextChar();
            stream.println("  Modifiers:  " + ClassFile.toHex(flags, 4) + ": " + Modifier.toString(flags));
        }
    }

    private void dumpEnclosingMethod(PrintStream stream) {
        Name[] names;
        this.enclosingClassIndex = this.nextChar();
        stream.println("      Class:      " + this.readPoolName(this.enclosingClassIndex));
        this.enclosingMethodIndex = this.nextChar();
        if (this.enclosingMethodIndex > 0 && (names = (Name[])this.readPoolObject(this.enclosingMethodIndex)) != null) {
            if (names.length > 0) {
                stream.println("      Name:       " + names[0]);
            }
            if (names.length > 1) {
                stream.println("      Descriptor: " + names[1]);
            }
        }
    }

    private void dumpPermittedSubclasses(PrintStream stream) {
        PermittedSubclasses permittedSubclasses = this.getPermittedSubclasses();
        if (permittedSubclasses == null) {
            return;
        }
        stream.println("Permitted Subclasses:");
        for (String type : permittedSubclasses.getPermittedSubclasses()) {
            stream.println("  " + type);
        }
    }

    private void dumpNestHost(PrintStream stream) {
        NestHost nestHost = this.getNestHost();
        if (nestHost == null) {
            return;
        }
        stream.println("Nest Host:");
        stream.println("  " + nestHost.getHostClass());
    }

    private void dumpNestMembers(PrintStream stream) {
        NestMembers nestMembers = this.getNestMembers();
        if (nestMembers == null) {
            return;
        }
        stream.println("Nest Members:");
        for (String type : nestMembers.getMemberClasses()) {
            stream.println("  " + type);
        }
    }

    private void dumpAttributeName(PrintStream stream) {
        Name name = this.readPoolName(this.nextChar());
        stream.println("      \"" + name + "\"");
    }

    private static String toHex(int i, int width) {
        String value = Integer.toHexString(i);
        return "0".repeat(Math.max(width - value.length(), 0)) + value;
    }

    private RuntimeException fileError(String message) {
        if (this.url != null) {
            message = (String)message + " in file " + URLFileSystem.getPlatformPathName(this.url);
        }
        return new RuntimeException((String)message);
    }

    public final class ClassField
    implements ClassMember {
        private final int thisBp;
        private int modifiers;
        private final char name;
        private final char fieldDescriptor;
        private String fieldSignature;
        private int constantValueIndex = -1;
        private ClassAnnotation[] fieldAnnotations = null;
        private List<TypeAnnotation> typeAnnotations = null;

        private ClassField() {
            this.thisBp = ClassFile.this.bp;
            this.modifiers = ClassFile.this.nextChar();
            this.name = ClassFile.this.nextChar();
            this.fieldDescriptor = ClassFile.this.nextChar();
            ClassFile.this.bp = this.thisBp;
            ClassFile.this.skipFieldOrMethod();
        }

        @Override
        public int getModifiers() {
            if (this.fieldAnnotations == null) {
                try {
                    this.readFieldAttributes();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw ClassFile.this.updateException(e);
                }
            }
            return this.modifiers & 0xFFFF;
        }

        public String getFieldName() {
            return ClassFile.this.readPoolName(this.name).toString();
        }

        @Override
        public String getDescriptor() {
            return ClassFile.this.readPoolExternal(this.fieldDescriptor).toString();
        }

        @Override
        public String getSignature() {
            if (this.fieldAnnotations == null) {
                try {
                    this.readFieldAttributes();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw ClassFile.this.updateException(e);
                }
            }
            return this.fieldSignature;
        }

        @Override
        public boolean isDeprecated() {
            if (this.fieldAnnotations == null) {
                try {
                    this.readFieldAttributes();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw ClassFile.this.updateException(e);
                }
            }
            return (this.modifiers & 0x10000) != 0;
        }

        public boolean isHidden() {
            if (this.fieldAnnotations == null) {
                try {
                    this.readFieldAttributes();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw ClassFile.this.updateException(e);
                }
            }
            return (this.modifiers & 0x20000000) != 0;
        }

        public Object getConstantValue() {
            try {
                if (this.fieldAnnotations == null) {
                    this.readFieldAttributes();
                }
                if (this.constantValueIndex < 0) {
                    return null;
                }
                String fieldDesc = this.getDescriptor();
                char descriptor = fieldDesc.charAt(0);
                if (descriptor == 'L' && fieldDesc.equals("Ljava/lang/String;")) {
                    descriptor = 's';
                }
                return ClassFile.this.readPoolConstant(this.constantValueIndex, descriptor);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw ClassFile.this.updateException(e);
            }
        }

        @Override
        public ClassAnnotation[] getDeclaredAnnotations() {
            if (this.fieldAnnotations == null) {
                try {
                    this.readFieldAttributes();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw ClassFile.this.updateException(e);
                }
            }
            return this.fieldAnnotations;
        }

        public Collection<TypeAnnotation> getTypeAnnotations() {
            if (this.typeAnnotations == null) {
                try {
                    this.readFieldAttributes();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw ClassFile.this.updateException(e);
                }
            }
            return this.typeAnnotations;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readFieldAttributes() {
            ClassFile classFile = ClassFile.this;
            synchronized (classFile) {
                if (this.fieldAnnotations != null) {
                    return;
                }
                int savedBp = ClassFile.this.bp;
                ClassFile.this.bp = this.thisBp + 6;
                int attrCount = ClassFile.this.nextChar();
                block12: for (int i = 0; i < attrCount; ++i) {
                    Name attrName = ClassFile.this.readPoolName(ClassFile.this.nextChar());
                    int attrLen = ClassFile.this.nextInt();
                    int attrSavedBp = ClassFile.this.bp;
                    byte attribute = ClassFile.name2attribute(attrName);
                    switch (attribute) {
                        case 4: {
                            this.modifiers |= 0x10000;
                            continue block12;
                        }
                        case 31: {
                            this.modifiers |= 0x20000000;
                            continue block12;
                        }
                        case 18: {
                            this.fieldSignature = ClassFile.this.readPoolExternal(ClassFile.this.nextChar()).toString();
                            continue block12;
                        }
                        case 20: {
                            this.modifiers |= 0x1000;
                            continue block12;
                        }
                        case 12: 
                        case 15: {
                            this.fieldAnnotations = ClassFile.this.readAnnotations(this.fieldAnnotations);
                            int endBp = attrSavedBp + attrLen;
                            if (ClassFile.this.bp == endBp) continue block12;
                            throw ClassFile.this.fileError("Invalid annotations length");
                        }
                        case 14: 
                        case 17: {
                            int endBp = attrSavedBp + attrLen;
                            this.typeAnnotations = ClassFile.this.readTypeAnnotations(this.typeAnnotations, endBp);
                            if (ClassFile.this.bp == endBp) continue block12;
                            throw ClassFile.this.fileError("Invalid type annotations length");
                        }
                        case 3: {
                            this.constantValueIndex = ClassFile.this.nextChar();
                            continue block12;
                        }
                        default: {
                            ClassFile.this.bp += attrLen;
                        }
                    }
                }
                if (this.fieldAnnotations == null) {
                    this.fieldAnnotations = EMPTY_ANNOTATION_ARRAY;
                }
                if (this.typeAnnotations == null) {
                    this.typeAnnotations = Collections.emptyList();
                }
                if (ClassFile.this.isDeprecated()) {
                    this.modifiers |= 0x10000;
                }
                if (ClassFile.this.isHidden()) {
                    this.modifiers |= 0x20000000;
                }
                ClassFile.this.bp = savedBp;
            }
        }

        private void dump(PrintStream stream) {
            this.readFieldAttributes();
            ClassFile.dumpAnnotations(stream, this.getDeclaredAnnotations());
            stream.print("  ");
            ClassFile.dumpModifiers(stream, this.modifiers, false, true);
            stream.println(this.getFieldName() + " " + this.getDescriptor());
            String signature = this.getSignature();
            if (signature != null) {
                stream.println("    signature: " + signature);
            }
            if (this.constantValueIndex > 0) {
                stream.print("    constant value: " + this.constantValueIndex + ", ");
                ClassFile.this.dumpPoolObject(stream, this.constantValueIndex);
                stream.println();
            }
            ClassFile.this.dumpAttributes(stream, this.thisBp + 6, false, "");
        }
    }

    public final class ClassMethod
    implements ClassMember {
        private final int thisBp;
        private int modifiers;
        private final char name;
        private final char methodDescriptor;
        private String methodSignature;
        private Name[] exceptions;
        private ClassAnnotation[] methodAnnotations;
        private List<TypeAnnotation> typeAnnotations;
        private MethodParameter[] methodParameters;
        private ClassAnnotation[][] parameterAnnotations;
        private ComponentValue defaultValue;

        private ClassMethod() {
            this.thisBp = ClassFile.this.bp;
            this.modifiers = ClassFile.this.nextChar();
            this.name = ClassFile.this.nextChar();
            this.methodDescriptor = ClassFile.this.nextChar();
            ClassFile.this.bp = this.thisBp;
            ClassFile.this.skipFieldOrMethod();
        }

        @Override
        public int getModifiers() {
            if (this.methodAnnotations == null) {
                try {
                    this.readMethodAttributes();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw ClassFile.this.updateException(e);
                }
            }
            return this.modifiers & 0xFFFF;
        }

        @Override
        public String getDescriptor() {
            return ClassFile.this.readPoolExternal(this.methodDescriptor).toString();
        }

        @Override
        public String getSignature() {
            if (this.methodAnnotations == null) {
                try {
                    this.readMethodAttributes();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw ClassFile.this.updateException(e);
                }
            }
            return this.methodSignature;
        }

        public boolean isClinit() {
            return this.getMethodName().equals(ClassFile.kClinitS);
        }

        public boolean isConstructor() {
            return this.getMethodName().equals(ClassFile.kInitS);
        }

        public String getMethodName() {
            return ClassFile.this.readPoolName(this.name).toString();
        }

        @Override
        public boolean isDeprecated() {
            if (this.methodAnnotations == null) {
                try {
                    this.readMethodAttributes();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw ClassFile.this.updateException(e);
                }
            }
            return (this.modifiers & 0x10000) != 0;
        }

        public boolean isHidden() {
            if (this.methodAnnotations == null) {
                try {
                    this.readMethodAttributes();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw ClassFile.this.updateException(e);
                }
            }
            return (this.modifiers & 0x20000000) != 0;
        }

        public Name[] getThrownExceptionTypes() {
            if (this.exceptions == null) {
                try {
                    this.readMethodAttributes();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw ClassFile.this.updateException(e);
                }
            }
            return this.exceptions;
        }

        @Override
        public ClassAnnotation[] getDeclaredAnnotations() {
            if (this.methodAnnotations == null) {
                try {
                    this.readMethodAttributes();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw ClassFile.this.updateException(e);
                }
            }
            return this.methodAnnotations;
        }

        public Collection<TypeAnnotation> getTypeAnnotations() {
            if (this.typeAnnotations == null) {
                try {
                    this.readMethodAttributes();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw ClassFile.this.updateException(e);
                }
            }
            return this.typeAnnotations;
        }

        public ClassAnnotation[][] getParameterAnnotations() {
            if (this.methodAnnotations == null) {
                try {
                    this.readMethodAttributes();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw ClassFile.this.updateException(e);
                }
            }
            return this.parameterAnnotations;
        }

        public ComponentValue getDefaultValue() {
            if (this.methodAnnotations == null) {
                try {
                    this.readMethodAttributes();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw ClassFile.this.updateException(e);
                }
            }
            return this.defaultValue;
        }

        public MethodParameter[] getMethodParameters() {
            if (this.methodParameters == null) {
                try {
                    this.readMethodAttributes();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw ClassFile.this.updateException(e);
                }
            }
            return this.methodParameters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readMethodAttributes() {
            ClassFile classFile = ClassFile.this;
            synchronized (classFile) {
                if (this.methodAnnotations != null) {
                    return;
                }
                int savedBp = ClassFile.this.bp;
                try {
                    ClassFile.this.bp = this.thisBp + 6;
                    int attrCount = ClassFile.this.nextChar();
                    block18: for (int i = 0; i < attrCount; ++i) {
                        Name attrName = ClassFile.this.readPoolName(ClassFile.this.nextChar());
                        int attrLen = ClassFile.this.nextInt();
                        int attrSavedBp = ClassFile.this.bp;
                        byte attribute = ClassFile.name2attribute(attrName);
                        switch (attribute) {
                            case 4: {
                                this.modifiers |= 0x10000;
                                continue block18;
                            }
                            case 31: {
                                this.modifiers |= 0x20000000;
                                continue block18;
                            }
                            case 18: {
                                this.methodSignature = ClassFile.this.readPoolExternal(ClassFile.this.nextChar()).toString();
                                continue block18;
                            }
                            case 20: {
                                this.modifiers |= 0x1000;
                                continue block18;
                            }
                            case 1: {
                                this.defaultValue = new ComponentValue();
                                continue block18;
                            }
                            case 6: {
                                int exceptionCount = ClassFile.this.nextChar();
                                this.exceptions = new Name[exceptionCount];
                                for (int j = 0; j < exceptionCount; ++j) {
                                    this.exceptions[j] = ClassFile.this.readPoolClass(ClassFile.this.nextChar());
                                }
                                continue block18;
                            }
                            case 12: 
                            case 15: {
                                this.methodAnnotations = ClassFile.this.readAnnotations(this.methodAnnotations);
                                int endBp = attrSavedBp + attrLen;
                                if (ClassFile.this.bp == endBp) continue block18;
                                throw ClassFile.this.fileError("Invalid annotations length");
                            }
                            case 13: 
                            case 16: {
                                int paramCount = ClassFile.this.nextByte();
                                ClassAnnotation[][] annotations = paramCount > 0 ? new ClassAnnotation[paramCount][] : EMPTY_ANNOTATION_ARRAY_ARRAY;
                                for (int p = 0; p < paramCount; ++p) {
                                    annotations[p] = this.parameterAnnotations != null ? ClassFile.this.readAnnotations(this.parameterAnnotations[p]) : ClassFile.this.readAnnotations(null);
                                }
                                this.parameterAnnotations = annotations;
                                int endBp = attrSavedBp + attrLen;
                                if (ClassFile.this.bp == endBp) continue block18;
                                throw ClassFile.this.fileError("Invalid annotations length");
                            }
                            case 14: 
                            case 17: {
                                int endBp = attrSavedBp + attrLen;
                                this.typeAnnotations = ClassFile.this.readTypeAnnotations(this.typeAnnotations, endBp);
                                if (ClassFile.this.bp == endBp) continue block18;
                                throw ClassFile.this.fileError("Invalid type annotations length");
                            }
                            case 11: {
                                int endBp = attrSavedBp + attrLen;
                                int count = 0xFF & ClassFile.this.nextByte();
                                this.methodParameters = new MethodParameter[count];
                                for (int mp = 0; mp < count; ++mp) {
                                    this.methodParameters[mp] = new MethodParameter();
                                }
                                if (ClassFile.this.bp == endBp) continue block18;
                                throw ClassFile.this.fileError("Invalid method parameters length");
                            }
                            default: {
                                ClassFile.this.bp += attrLen;
                            }
                        }
                    }
                    if (this.exceptions == null) {
                        this.exceptions = Name.EMPTY_ARRAY;
                    }
                    if (this.methodAnnotations == null) {
                        this.methodAnnotations = EMPTY_ANNOTATION_ARRAY;
                    }
                    if (this.typeAnnotations == null) {
                        this.typeAnnotations = Collections.emptyList();
                    }
                    if (ClassFile.this.isDeprecated()) {
                        this.modifiers |= 0x10000;
                    }
                    if (ClassFile.this.isHidden()) {
                        this.modifiers |= 0x20000000;
                    }
                    if (this.methodParameters == null) {
                        this.methodParameters = EMPTY_METHOD_PARAMETER_ARRAY;
                    }
                }
                finally {
                    ClassFile.this.bp = savedBp;
                }
            }
        }

        private void dump(PrintStream stream) {
            Name[] exceptions;
            this.readMethodAttributes();
            ClassFile.dumpAnnotations(stream, this.getDeclaredAnnotations());
            stream.print("  ");
            ClassFile.dumpModifiers(stream, this.modifiers, false, true);
            stream.println(this.getMethodName() + " " + this.getDescriptor());
            String signature = this.getSignature();
            if (signature != null) {
                stream.println("    signature: " + signature);
            }
            for (Name exception : exceptions = this.getThrownExceptionTypes()) {
                stream.println("    throws " + exception.toString());
            }
            ClassFile.this.dumpAttributes(stream, this.thisBp + 6, true, "    ");
        }
    }

    public class ClassAnnotation {
        private final char annotationType;
        private final int compBp;
        private String[] componentNames;
        private ComponentValue[] componentValues;

        private ClassAnnotation() {
            this.annotationType = ClassFile.this.nextChar();
            this.compBp = ClassFile.this.bp;
            int count = ClassFile.this.nextChar();
            for (int i = 0; i < count; ++i) {
                ClassFile.this.skipComponent();
            }
        }

        public final Name getAnnotationType() {
            return (Name)ClassFile.this.readPoolConstant(this.annotationType, 'c');
        }

        public final String[] getComponentNames() {
            if (this.componentNames == null) {
                try {
                    this.readComponents();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw ClassFile.this.updateException(e);
                }
            }
            return this.componentNames;
        }

        public final ComponentValue[] getComponentValues() {
            if (this.componentValues == null) {
                try {
                    this.readComponents();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw ClassFile.this.updateException(e);
                }
            }
            return this.componentValues;
        }

        private void dump(PrintStream stream) {
            String type = this.getAnnotationType().toString();
            stream.print("  @");
            stream.print(type.substring(1, type.length() - 1));
            stream.print('(');
            this.readComponents();
            int count = this.componentNames.length;
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    stream.print(", ");
                }
                stream.print(this.componentNames[i]);
                stream.print(" = ");
                this.componentValues[i].dump(stream);
            }
            stream.println(')');
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readComponents() {
            ClassFile classFile = ClassFile.this;
            synchronized (classFile) {
                if (this.componentNames != null) {
                    return;
                }
                int savedBp = ClassFile.this.bp;
                try {
                    ClassFile.this.bp = this.compBp;
                    int count = ClassFile.this.nextChar();
                    if (count != 0) {
                        String[] newComponentNames = new String[count];
                        ComponentValue[] newComponentValues = new ComponentValue[count];
                        for (int i = 0; i < count; ++i) {
                            newComponentNames[i] = ClassFile.this.readPoolName(ClassFile.this.nextChar()).toString();
                            newComponentValues[i] = new ComponentValue();
                        }
                        this.componentValues = newComponentValues;
                        this.componentNames = newComponentNames;
                    } else {
                        this.componentValues = EMPTY_VALUE_ARRAY;
                        this.componentNames = JavaConstants.EMPTY_STRING_ARRAY;
                    }
                }
                finally {
                    ClassFile.this.bp = savedBp;
                }
            }
        }
    }

    public final class Module {
        private final char nameIndex;
        private final char flags;
        private final char versionIndex;
        private final ModuleRequires[] requires;
        private final ModuleExports[] exports;
        private final ModuleOpens[] opens;
        private final char[] uses;
        private final ModuleProvides[] provides;

        private Module(char moduleInfoIndex) {
            int i;
            this.nameIndex = moduleInfoIndex;
            this.flags = ClassFile.this.nextChar();
            this.versionIndex = ClassFile.this.nextChar();
            int count = ClassFile.this.nextChar();
            this.requires = new ModuleRequires[count];
            for (i = 0; i < count; ++i) {
                this.requires[i] = new ModuleRequires();
            }
            count = ClassFile.this.nextChar();
            this.exports = new ModuleExports[count];
            for (i = 0; i < count; ++i) {
                this.exports[i] = new ModuleExports();
            }
            count = ClassFile.this.nextChar();
            this.opens = new ModuleOpens[count];
            for (i = 0; i < count; ++i) {
                this.opens[i] = new ModuleOpens();
            }
            count = ClassFile.this.nextChar();
            this.uses = new char[count];
            for (i = 0; i < count; ++i) {
                this.uses[i] = ClassFile.this.nextChar();
            }
            count = ClassFile.this.nextChar();
            this.provides = new ModuleProvides[count];
            for (i = 0; i < count; ++i) {
                this.provides[i] = new ModuleProvides();
            }
        }

        public String getName() {
            Name name = ClassFile.this.readPoolModuleInfo(this.nameIndex);
            return name != null ? name.toString() : "";
        }

        public String getVersion() {
            Name version = this.versionIndex > '\u0000' ? (Name)ClassFile.this.readPoolConstant(this.versionIndex, 'c') : null;
            return version != null ? version.toString() : "";
        }

        public boolean isOpen() {
            return (this.flags & 0x20) != 0;
        }

        public boolean isSynthetic() {
            return (this.flags & 0x1000) != 0;
        }

        public boolean isMandated() {
            return (this.flags & 0x8000) != 0;
        }

        public ModuleRequires[] getRequires() {
            return this.requires;
        }

        public ModuleExports[] getExports() {
            return this.exports;
        }

        public ModuleOpens[] getOpens() {
            return this.opens;
        }

        public String[] getUses() {
            String[] usesNames = new String[this.uses.length];
            for (int i = 0; i < this.uses.length; ++i) {
                usesNames[i] = ClassFile.this.readPoolClass(this.uses[i]).toString();
            }
            return usesNames;
        }

        public ModuleProvides[] getProvides() {
            return this.provides;
        }
    }

    public final class ModuleHashes {
        private final char algorithm;
        private final List<ModuleHash> hashes;

        private ModuleHashes() {
            this.algorithm = ClassFile.this.nextChar();
            char hashCount = ClassFile.this.nextChar();
            this.hashes = new ArrayList<ModuleHash>(hashCount);
            for (char c = '\u0000'; c < hashCount; c = (char)(c + '\u0001')) {
                this.hashes.add(new ModuleHash());
            }
        }

        public String getAlgorithm() {
            return this.algorithm > '\u0000' ? ClassFile.this.readPoolName(this.algorithm).toString() : null;
        }

        public List<ModuleHash> getHashes() {
            return this.hashes;
        }

        public final class ModuleHash {
            private final char moduleName;
            private final byte[] hash;

            private ModuleHash() {
                this.moduleName = ClassFile.this.nextChar();
                char hashCount = ClassFile.this.nextChar();
                this.hash = new byte[hashCount];
                for (char c = '\u0000'; c < hashCount; c = (char)(c + '\u0001')) {
                    this.hash[c] = ClassFile.this.nextByte();
                }
            }

            public String getModuleName() {
                Name name = ClassFile.this.readPoolModuleInfo(this.moduleName);
                return name != null ? name.toString() : "";
            }

            public byte[] getHash() {
                return this.hash;
            }
        }
    }

    public final class ModuleMainClass {
        private final char mainClass;

        private ModuleMainClass() {
            this.mainClass = ClassFile.this.nextChar();
        }

        public String getMainClass() {
            return this.mainClass > '\u0000' ? ClassFile.this.readPoolClass(this.mainClass).toString() : null;
        }
    }

    public final class ModulePackages {
        private final char[] packages;

        private ModulePackages() {
            char packageCount = ClassFile.this.nextChar();
            this.packages = new char[packageCount];
            for (char c = '\u0000'; c < packageCount; c = (char)(c + '\u0001')) {
                this.packages[c] = ClassFile.this.nextChar();
            }
        }

        public List<String> getPackages() {
            ArrayList<String> packageList = new ArrayList<String>(this.packages.length);
            for (char aPackage : this.packages) {
                packageList.add(ClassFile.this.readPoolPackageInfo(aPackage).toString());
            }
            return packageList;
        }
    }

    public final class ModuleResolution {
        private final char flags;

        private ModuleResolution() {
            this.flags = ClassFile.this.nextChar();
        }

        public char getFlags() {
            return this.flags;
        }
    }

    public final class ModuleTarget {
        private final char osName;
        private char osArch;

        private ModuleTarget(int length) {
            this.osName = ClassFile.this.nextChar();
            if (length > 2) {
                this.osArch = ClassFile.this.nextChar();
            }
        }

        public String getOsName() {
            return this.osName > '\u0000' ? ClassFile.this.readPoolName(this.osName).toString() : null;
        }

        public String getOsArch() {
            return this.osArch > '\u0000' ? ClassFile.this.readPoolName(this.osArch).toString() : null;
        }
    }

    public final class NestHost {
        private final char hostClass;

        private NestHost() {
            this.hostClass = ClassFile.this.nextChar();
        }

        public String getHostClass() {
            return this.hostClass > '\u0000' ? ClassFile.this.readPoolClass(this.hostClass).toString() : null;
        }
    }

    public final class NestMembers {
        private final char[] memberClasses;

        private NestMembers() {
            char count = ClassFile.this.nextChar();
            this.memberClasses = new char[count];
            for (char c = '\u0000'; c < count; c = (char)(c + '\u0001')) {
                this.memberClasses[c] = ClassFile.this.nextChar();
            }
        }

        public List<String> getMemberClasses() {
            ArrayList<String> names = new ArrayList<String>(this.memberClasses.length);
            for (char memberClass : this.memberClasses) {
                names.add(ClassFile.this.readPoolClass(memberClass).toString());
            }
            return names;
        }
    }

    public final class ClassRecord {
        private final int thisBp;
        private Collection<ClassRecordComponent> components;

        private ClassRecord() {
            this.thisBp = ClassFile.this.bp;
            char count = ClassFile.this.nextChar();
            this.components = new ArrayList<ClassRecordComponent>();
            for (char c = '\u0000'; c < count; c = (char)(c + '\u0001')) {
                this.components.add(new ClassRecordComponent());
            }
        }

        public Collection<ClassRecordComponent> getComponents() {
            return this.components;
        }

        public class ClassRecordComponent {
            private final char name;
            private final char descriptor;
            private String signature;
            private boolean deprecated = false;
            private boolean hidden = false;
            private ClassAnnotation[] componentAnnotations = null;
            private List<TypeAnnotation> typeAnnotations = null;

            private ClassRecordComponent() {
                this.name = ClassFile.this.nextChar();
                this.descriptor = ClassFile.this.nextChar();
                this.readRecordComponentAttributes();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void readRecordComponentAttributes() {
                ClassFile classFile = ClassFile.this;
                synchronized (classFile) {
                    if (this.componentAnnotations != null) {
                        return;
                    }
                    int attrCount = ClassFile.this.nextChar();
                    block11: for (int i = 0; i < attrCount; ++i) {
                        Name attrName = ClassFile.this.readPoolName(ClassFile.this.nextChar());
                        int attrLen = ClassFile.this.nextInt();
                        int attrSavedBp = ClassFile.this.bp;
                        byte attribute = ClassFile.name2attribute(attrName);
                        switch (attribute) {
                            case 4: {
                                this.deprecated = true;
                                continue block11;
                            }
                            case 31: {
                                this.hidden = true;
                                continue block11;
                            }
                            case 18: {
                                this.signature = ClassFile.this.readPoolExternal(ClassFile.this.nextChar()).toString();
                                continue block11;
                            }
                            case 20: {
                                ClassFile.this.modifiers |= 0x1000;
                                continue block11;
                            }
                            case 12: 
                            case 15: {
                                this.componentAnnotations = ClassFile.this.readAnnotations(this.componentAnnotations);
                                int endBp = attrSavedBp + attrLen;
                                if (ClassFile.this.bp == endBp) continue block11;
                                throw ClassFile.this.fileError("Invalid annotations length");
                            }
                            case 14: 
                            case 17: {
                                int endBp = attrSavedBp + attrLen;
                                this.typeAnnotations = ClassFile.this.readTypeAnnotations(this.typeAnnotations, endBp);
                                if (ClassFile.this.bp == endBp) continue block11;
                                throw ClassFile.this.fileError("Invalid type annotations length");
                            }
                            default: {
                                ClassFile.this.bp += attrLen;
                            }
                        }
                    }
                    if (this.componentAnnotations == null) {
                        this.componentAnnotations = EMPTY_ANNOTATION_ARRAY;
                    }
                    if (this.typeAnnotations == null) {
                        this.typeAnnotations = Collections.emptyList();
                    }
                }
            }

            private void dump(PrintStream stream) {
                this.readRecordComponentAttributes();
                ClassFile.dumpAnnotations(stream, this.getDeclaredAnnotations());
                stream.println("  " + this.getName() + " " + this.getDescriptor());
                String signature = this.getSignature();
                if (signature != null) {
                    stream.println("  signature: " + signature);
                }
                ClassFile.this.dumpAttributes(stream, ClassRecord.this.thisBp + 6, false, "");
            }

            public String getName() {
                return ClassFile.this.readPoolName(this.name).toString();
            }

            public String getDescriptor() {
                return ClassFile.this.readPoolExternal(this.descriptor).toString();
            }

            public String getSignature() {
                if (this.componentAnnotations == null) {
                    try {
                        this.readRecordComponentAttributes();
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw ClassFile.this.updateException(e);
                    }
                }
                return this.signature;
            }

            public boolean isDeprecated() {
                if (this.componentAnnotations == null) {
                    try {
                        this.readRecordComponentAttributes();
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw ClassFile.this.updateException(e);
                    }
                }
                return this.deprecated;
            }

            public boolean isHidden() {
                if (this.componentAnnotations == null) {
                    try {
                        this.readRecordComponentAttributes();
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw ClassFile.this.updateException(e);
                    }
                }
                return this.hidden;
            }

            public ClassAnnotation[] getDeclaredAnnotations() {
                if (this.componentAnnotations == null) {
                    try {
                        this.readRecordComponentAttributes();
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw ClassFile.this.updateException(e);
                    }
                }
                return this.componentAnnotations;
            }

            public Collection<TypeAnnotation> getTypeAnnotations() {
                if (this.typeAnnotations == null) {
                    try {
                        this.readRecordComponentAttributes();
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw ClassFile.this.updateException(e);
                    }
                }
                return this.typeAnnotations;
            }
        }
    }

    public final class PermittedSubclasses {
        private final char[] permittedSubclasses;

        private PermittedSubclasses() {
            char count = ClassFile.this.nextChar();
            this.permittedSubclasses = new char[count];
            for (char c = '\u0000'; c < count; c = (char)(c + '\u0001')) {
                this.permittedSubclasses[c] = ClassFile.this.nextChar();
            }
        }

        public List<String> getPermittedSubclasses() {
            ArrayList<String> names = new ArrayList<String>(this.permittedSubclasses.length);
            for (char subclass : this.permittedSubclasses) {
                names.add(ClassFile.this.readPoolClass(subclass).toString());
            }
            return names;
        }
    }

    public final class ModuleExports {
        private final char packageName;
        private final char flags;
        private final char[] exportsTo;

        private ModuleExports() {
            this.packageName = ClassFile.this.nextChar();
            this.flags = ClassFile.this.nextChar();
            int count = ClassFile.this.nextChar();
            this.exportsTo = new char[count];
            for (int i = 0; i < count; ++i) {
                this.exportsTo[i] = ClassFile.this.nextChar();
            }
        }

        public String getPackageName() {
            Name name = ClassFile.this.readPoolPackageInfo(this.packageName);
            return name != null ? name.toString() : "";
        }

        public boolean isSynthetic() {
            return (this.flags & 0x1000) != 0;
        }

        public boolean isMandated() {
            return (this.flags & 0x8000) != 0;
        }

        public String[] getModuleNames() {
            String[] names = new String[this.exportsTo.length];
            for (int i = 0; i < this.exportsTo.length; ++i) {
                Name name = ClassFile.this.readPoolModuleInfo(this.exportsTo[i]);
                names[i] = name != null ? name.toString() : "";
            }
            return names;
        }
    }

    public final class ModuleOpens {
        private final char packageName;
        private final char flags;
        private final char[] opensTo;

        private ModuleOpens() {
            this.packageName = ClassFile.this.nextChar();
            this.flags = ClassFile.this.nextChar();
            int count = ClassFile.this.nextChar();
            this.opensTo = new char[count];
            for (int i = 0; i < count; ++i) {
                this.opensTo[i] = ClassFile.this.nextChar();
            }
        }

        public String getPackageName() {
            Name name = ClassFile.this.readPoolPackageInfo(this.packageName);
            return name != null ? name.toString() : "";
        }

        public boolean isSynthetic() {
            return (this.flags & 0x1000) != 0;
        }

        public boolean isMandated() {
            return (this.flags & 0x8000) != 0;
        }

        public String[] getModuleNames() {
            String[] names = new String[this.opensTo.length];
            for (int i = 0; i < this.opensTo.length; ++i) {
                Name name = ClassFile.this.readPoolModuleInfo(this.opensTo[i]);
                names[i] = name != null ? name.toString() : "";
            }
            return names;
        }
    }

    public final class ModuleProvides {
        private final char serviceInterface;
        private final char[] serviceImplementations;

        private ModuleProvides() {
            this.serviceInterface = ClassFile.this.nextChar();
            char count = ClassFile.this.nextChar();
            this.serviceImplementations = new char[count];
            for (char c = '\u0000'; c < count; c = (char)(c + '\u0001')) {
                this.serviceImplementations[c] = ClassFile.this.nextChar();
            }
        }

        public String getServiceInterface() {
            return ClassFile.this.readPoolClass(this.serviceInterface).toString();
        }

        public List<String> getServiceImplementations() {
            ArrayList<String> names = new ArrayList<String>(this.serviceImplementations.length);
            for (char serviceImplementation : this.serviceImplementations) {
                names.add(ClassFile.this.readPoolClass(serviceImplementation).toString());
            }
            return names;
        }
    }

    public final class ModuleRequires {
        private final char requiresName;
        private final char requiresFlags;
        private final char requiresVersion;

        private ModuleRequires() {
            this.requiresName = ClassFile.this.nextChar();
            this.requiresFlags = ClassFile.this.nextChar();
            this.requiresVersion = ClassFile.this.nextChar();
        }

        public String getModuleName() {
            Name name = ClassFile.this.readPoolModuleInfo(this.requiresName);
            return name != null ? name.toString() : "";
        }

        public boolean isTransitive() {
            return (this.requiresFlags & 0x20) != 0;
        }

        public boolean isStaticPhase() {
            return (this.requiresFlags & 0x40) != 0;
        }

        public boolean isSynthetic() {
            return (this.requiresFlags & 0x1000) != 0;
        }

        public boolean isMandated() {
            return (this.requiresFlags & 0x8000) != 0;
        }

        public String getVersion() {
            Name name = ClassFile.this.readPoolName(this.requiresVersion);
            return name != null ? name.toString() : "";
        }
    }

    public class ParamTargetInfo
    extends TargetInfo {
        private final byte paramIndex;

        private ParamTargetInfo(TargetInfoType targetInfoType) {
            super(targetInfoType, false);
            this.paramIndex = ClassFile.this.nextByte();
            this.readTargetInfoPaths();
        }

        public byte getParamIndex() {
            return this.paramIndex;
        }
    }

    public static enum TargetInfoType {
        CLASS_EXTENDS,
        CLASS_TYPE_PARAMETER,
        CLASS_TYPE_PARAMETER_BOUND,
        FIELD,
        METHOD_PARAMETER,
        METHOD_RECEIVER,
        METHOD_RETURN,
        METHOD_TYPE_PARAMETER,
        METHOD_TYPE_PARAMETER_BOUND,
        THROWS,
        TYPECAST,
        RECORD_COMPONENT;

    }

    public class SuperTargetInfo
    extends TargetInfo {
        private final char superIndex;

        private SuperTargetInfo(TargetInfoType targetInfoType) {
            super(targetInfoType, false);
            this.superIndex = ClassFile.this.nextChar();
            this.readTargetInfoPaths();
        }

        public char getSuperIndex() {
            return this.superIndex;
        }
    }

    public class TypeParamBoundTargetInfo
    extends TargetInfo {
        private final byte paramIndex;
        private final byte boundIndex;

        private TypeParamBoundTargetInfo(TargetInfoType targetInfoType) {
            super(targetInfoType, false);
            this.paramIndex = ClassFile.this.nextByte();
            this.boundIndex = ClassFile.this.nextByte();
            this.readTargetInfoPaths();
        }

        public byte getParamIndex() {
            return this.paramIndex;
        }

        public byte getBoundIndex() {
            return this.boundIndex;
        }
    }

    public class TargetInfo {
        private TargetInfoPaths targetInfoPaths;
        private final TargetInfoType targetInfoType;

        private TargetInfo(TargetInfoType targetInfoType, boolean readTargetInfoPaths) {
            this.targetInfoType = targetInfoType;
            if (readTargetInfoPaths) {
                this.readTargetInfoPaths();
            }
        }

        protected void readTargetInfoPaths() {
            this.targetInfoPaths = new TargetInfoPaths();
        }

        public TargetInfoPaths getTargetInfoPaths() {
            return this.targetInfoPaths;
        }

        public TargetInfoType getTargetInfoType() {
            return this.targetInfoType;
        }
    }

    public class ThrowsTargetInfo
    extends TargetInfo {
        private final char typeIndex;

        private ThrowsTargetInfo(TargetInfoType targetInfoType) {
            super(targetInfoType, false);
            this.typeIndex = ClassFile.this.nextChar();
            this.readTargetInfoPaths();
        }

        public char getTypeIndex() {
            return this.typeIndex;
        }
    }

    public final class TypeAnnotation {
        private final ClassAnnotation classAnnotation;
        private final TargetInfo targetInfo;

        private TypeAnnotation() {
            this.targetInfo = ClassFile.this.parseTargetInfo();
            this.classAnnotation = new ClassAnnotation();
        }

        public TargetInfo getTargetInfo() {
            return this.targetInfo;
        }

        public ClassAnnotation getClassAnnotation() {
            return this.classAnnotation;
        }
    }

    public final class ComponentValue {
        private final byte tag;
        private final int valueBp;
        private Object value;

        private ComponentValue() {
            this.tag = ClassFile.this.nextByte();
            this.valueBp = ClassFile.this.bp;
            ClassFile.this.skipValue(this.tag);
        }

        public char getComponentTag() {
            return (char)(this.tag & 0xFF);
        }

        public Object getComponentValue() {
            if (this.value == null) {
                try {
                    this.value = this.readValue();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw ClassFile.this.updateException(e);
                }
            }
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Object readValue() {
            ClassFile classFile = ClassFile.this;
            synchronized (classFile) {
                if (this.value != null) {
                    return this.value;
                }
                switch (this.tag) {
                    case 101: {
                        char classindex = ClassFile.this.getChar(this.valueBp);
                        char enumindex = ClassFile.this.getChar(this.valueBp + 2);
                        return new EnumReference(classindex, enumindex);
                    }
                    case 91: {
                        int count = ClassFile.this.getChar(this.valueBp);
                        if (count == 0) {
                            return EMPTY_VALUE_ARRAY;
                        }
                        ComponentValue[] values = new ComponentValue[count];
                        int savedBp = ClassFile.this.bp;
                        try {
                            ClassFile.this.bp = this.valueBp + 2;
                            for (int i = 0; i < count; ++i) {
                                values[i] = new ComponentValue();
                            }
                            ComponentValue[] componentValueArray = values;
                            return componentValueArray;
                        }
                        finally {
                            ClassFile.this.bp = savedBp;
                        }
                    }
                    case 64: {
                        int savedBp = ClassFile.this.bp;
                        try {
                            ClassFile.this.bp = this.valueBp;
                            ClassAnnotation values = new ClassAnnotation();
                            return values;
                        }
                        finally {
                            ClassFile.this.bp = savedBp;
                        }
                    }
                }
                char index = ClassFile.this.getChar(this.valueBp);
                return ClassFile.this.readPoolConstant(index, this.getComponentTag());
            }
        }

        private void dump(PrintStream stream) {
            this.dump(stream, this.getComponentValue(), this.tag);
        }

        private void dump(PrintStream stream, Object object, byte tag) {
            switch (tag) {
                case 66: 
                case 67: 
                case 68: 
                case 73: 
                case 74: 
                case 83: 
                case 90: {
                    stream.print(object);
                    break;
                }
                case 115: {
                    stream.print("\"" + object.toString() + "\"");
                    break;
                }
                case 64: {
                    ((ClassAnnotation)object).dump(stream);
                    break;
                }
                case 99: {
                    stream.print("(Class) " + object.toString());
                    break;
                }
                case 101: {
                    ((EnumReference)object).dump(stream);
                    break;
                }
                case 91: {
                    stream.print('{');
                    for (ComponentValue componentValue : (ComponentValue[])object) {
                        this.dump(stream, componentValue.readValue(), componentValue.tag);
                    }
                    stream.print('}');
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown component tag: " + tag);
                }
            }
        }
    }

    public final class MethodParameter {
        private final char name;
        private final char flags;

        private MethodParameter() {
            this.name = ClassFile.this.nextChar();
            this.flags = ClassFile.this.nextChar();
        }

        public String getName() {
            return ClassFile.this.readPoolName(this.name).toString();
        }

        public char getFlags() {
            return this.flags;
        }
    }

    public static class TargetInfoPath {
        private final byte pathKind;
        private final byte argumentIndex;

        public TargetInfoPath(byte pathKind, byte argumentIndex) {
            this.pathKind = pathKind;
            this.argumentIndex = argumentIndex;
        }

        public byte getPathKind() {
            return this.pathKind;
        }

        public byte getArgumentIndex() {
            return this.argumentIndex;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof TargetInfoPath)) return false;
            TargetInfoPath tip = (TargetInfoPath)object;
            if (this.pathKind != tip.pathKind) return false;
            if (this.argumentIndex != tip.argumentIndex) return false;
            return true;
        }

        public int hashCode() {
            return this.pathKind * 37 + this.argumentIndex;
        }
    }

    public class TargetInfoPaths {
        private final List<TargetInfoPath> paths;

        private TargetInfoPaths() {
            byte count = ClassFile.this.nextByte();
            this.paths = new ArrayList<TargetInfoPath>(count);
            for (byte b = 0; b < count; b = (byte)(b + 1)) {
                byte pathKind = ClassFile.this.nextByte();
                byte argumentIndex = ClassFile.this.nextByte();
                this.paths.add(new TargetInfoPath(pathKind, argumentIndex));
            }
        }

        public List<TargetInfoPath> getPaths() {
            return this.paths;
        }
    }

    public final class EnumReference {
        private final int enumClassname;
        private final int enumName;

        private EnumReference(int classIndex, int enumIndex) {
            this.enumClassname = classIndex;
            this.enumName = enumIndex;
        }

        public Name getName() {
            return ClassFile.this.readPoolName(this.enumName);
        }

        public Name getClassName() {
            return (Name)ClassFile.this.readPoolConstant(this.enumClassname, 'c');
        }

        private void dump(PrintStream stream) {
            stream.print("(Enum) " + this.getClassName().toString() + "." + this.getName());
        }
    }

    public static interface ClassMember {
        public int getModifiers();

        public String getDescriptor();

        public String getSignature();

        public boolean isDeprecated();

        public ClassAnnotation[] getDeclaredAnnotations();
    }
}

