/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2;

import java.net.URL;
import java.util.concurrent.CancellationException;
import java.util.logging.Logger;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.parser.java.v2.internal.parser.ParserDriver;
import oracle.javatools.parser.java.v2.internal.symbol.JavaFileSym;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.SourceFile;

public class JavaParser {
    public static final String JOT_JDKVERSION_OVERRIDE = "Jot_JdkVersion_Override";
    private static final Logger LOG = Logger.getLogger(JavaParser.class.getName());
    private static volatile JdkVersion jdkVersion;

    public static synchronized JdkVersion getJdkVersion() {
        if (jdkVersion != null) {
            return jdkVersion;
        }
        JdkVersion jdkVersion = JdkVersion.getJdkVersion(System.getProperty(JOT_JDKVERSION_OVERRIDE));
        if (jdkVersion != JdkVersion.JDK_UNKNOWN) {
            return jdkVersion;
        }
        jdkVersion = JdkVersion.getJdkVersion(System.getProperty("java.version"));
        if (jdkVersion != JdkVersion.JDK_UNKNOWN) {
            return jdkVersion;
        }
        return JdkVersion.getExecutingJdkVersion();
    }

    static synchronized void setJdkVersion(JdkVersion newJdkVersion) {
        if (newJdkVersion != null && newJdkVersion == jdkVersion) {
            return;
        }
        if (jdkVersion != null) {
            throw new IllegalStateException("jdkVersion already set");
        }
        if (newJdkVersion == null) {
            throw new NullPointerException("newJdkVersion == nulll");
        }
        if (newJdkVersion == JdkVersion.JDK_UNKNOWN) {
            throw new IllegalArgumentException("newJdkVersion == JdkVersion.JDK_UNKNOWN");
        }
        JdkVersion version = JdkVersion.getJdkVersion(System.getProperty(JOT_JDKVERSION_OVERRIDE));
        jdkVersion = version != JdkVersion.JDK_UNKNOWN ? version : newJdkVersion;
    }

    public static SourceFile parse(ReadTextBuffer textBuffer) {
        return JavaParser.parseImpl(textBuffer, JavaParser.getJdkVersion(), false);
    }

    public static SourceFile parse(ReadTextBuffer textBuffer, JdkVersion jdkVersion) {
        return JavaParser.parseImpl(textBuffer, jdkVersion, false);
    }

    public static JavaFile lightParse(ReadTextBuffer textBuffer, URL url, JavaProvider javaProvider, JdkVersion jdkVersion) {
        SourceFile sourceFile = JavaParser.parseImpl(textBuffer, jdkVersion, true);
        if (sourceFile == null) {
            return null;
        }
        sourceFile.setURL(url);
        sourceFile.setProvider(javaProvider);
        return new JavaFileSym(sourceFile);
    }

    private static SourceFile parseImpl(ReadTextBuffer textBuffer, JdkVersion jdkVersion, boolean lightParse) {
        ParserDriver driver = new ParserDriver();
        driver.setTextBuffer(textBuffer);
        try {
            return driver.parse(jdkVersion, lightParse);
        }
        catch (OutOfMemoryError | CancellationException | ExpiredTextBufferException e) {
            throw e;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean cancelParse(Thread thread) {
        return ParserDriver.cancelParse(thread);
    }

    public static Logger getLogger() {
        return LOG;
    }
}

