/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.javatools.mt.annotation.CodeSharingSafe;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.InternalConstants;

public class BindingRegistry
extends CommonUtilities
implements InternalConstants {
    public static final int BINDING_invalid = 0;
    @CodeSharingSafe(value="StaticField")
    private static AtomicInteger keyCount = new AtomicInteger(26);
    @CodeSharingSafe(value="StaticField")
    private static ConcurrentHashMap<Integer, String> keyMap = BindingRegistry.initKeyMap();

    public static int register(String name) {
        int key = keyCount.getAndIncrement();
        if (key == 0x7FFFFFF5) {
            CommonUtilities.panic();
        }
        Integer keyInteger = key;
        keyMap.put(keyInteger, name);
        return key;
    }

    public static void unregister(int key) {
        keyMap.remove(key);
    }

    public static String lookup(int key) {
        return keyMap.get(key);
    }

    private static ConcurrentHashMap<Integer, String> initKeyMap() {
        ConcurrentHashMap<Integer, String> map = new ConcurrentHashMap<Integer, String>();
        for (int i = 1; i < 26; ++i) {
            map.put(i, BINDING_words[i - 1]);
        }
        return map;
    }
}

