/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.filesystem;

import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.Set;
import oracle.javatools.filesystem.FileSystemImpl;
import oracle.javatools.filesystem.PathImpl;
import oracle.javatools.util.PlatformUtils;

public abstract class FileSystemProviderImpl
extends FileSystemProvider {
    protected String scheme;
    protected FileSystemImpl<?> fileSystem;

    public FileSystemProviderImpl(String scheme) {
        if (scheme == null || scheme.trim().isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.scheme = scheme.toLowerCase();
    }

    public abstract FileSystemImpl<?> getFileSystem();

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public Path getPath(URI uri) {
        this.checkURI(uri);
        String path = uri.getPath();
        if (PlatformUtils.isWindows() && path.length() > 1 && path.charAt(2) == ':') {
            path = path.substring(1);
        }
        return this.getFileSystem(uri).getPath(path, new String[0]);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        if (!(path instanceof PathImpl) || ((PathImpl)path).isDirectory()) {
            throw new IllegalArgumentException();
        }
        return this.newByteChannelImpl((PathImpl)path, options, attrs);
    }

    protected abstract SeekableByteChannel newByteChannelImpl(PathImpl var1, Set<? extends OpenOption> var2, FileAttribute<?> ... var3) throws IOException;

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        if (!(dir instanceof PathImpl)) {
            throw new NotDirectoryException(dir == null ? "<NULL>" : dir.toString());
        }
        return this.getFileSystem().newDirectoryStream((PathImpl)dir, filter);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        if (!(dir instanceof PathImpl) || !((PathImpl)dir).isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.getFileSystem().createDirectory((PathImpl)dir, attrs);
    }

    @Override
    public void delete(Path path) throws IOException {
        if (!(path instanceof PathImpl)) {
            throw new IllegalArgumentException();
        }
        this.getFileSystem().delete((PathImpl)path);
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        if (!(source instanceof PathImpl) || !(target instanceof PathImpl)) {
            throw new IllegalArgumentException();
        }
        this.getFileSystem().copy((PathImpl)source, (PathImpl)target, options);
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        if (!(source instanceof PathImpl) || !(target instanceof PathImpl)) {
            throw new IllegalArgumentException();
        }
        this.getFileSystem().move((PathImpl)source, (PathImpl)target, options);
    }

    @Override
    public boolean isSameFile(Path path1, Path path2) throws IOException {
        if (path1 == null || path2 == null) {
            return path1 == path2;
        }
        if (!(path1 instanceof PathImpl) || !(path2 instanceof PathImpl)) {
            throw new IllegalArgumentException();
        }
        return path1.equals(path2);
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return false;
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        return null;
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        if (!(path instanceof PathImpl)) {
            throw new IllegalArgumentException();
        }
        this.getFileSystem().checkAccess((PathImpl)path, modes);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        return null;
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        if (!(path instanceof PathImpl) || type != BasicFileAttributes.class) {
            throw new IllegalArgumentException();
        }
        return this.getFileSystem().readAttributes((PathImpl)path, type, options);
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void checkURI(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        String scheme = uri.getScheme();
        if (!this.scheme.equalsIgnoreCase(scheme)) {
            throw new IllegalArgumentException();
        }
    }
}

