/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.data;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.Dirtyable;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.Structure;
import oracle.javatools.data.StructureChangeListener;

public abstract class HashStructure
extends Structure {
    public static final int NONEXISTENT = 0;
    public static final int PERSISTENT = 1;
    public static final int PLACEHOLDER = 2;

    private HashStructure() {
    }

    public static final HashStructure newInstance() {
        return new Impl();
    }

    public static final HashStructure newChainForStatusQuo(HashStructure[] hashes) {
        return new ChainForStatusQuo(hashes, null);
    }

    public static final HashStructure newChainForOverriding(HashStructure[] hashes) {
        return new ChainForOverriding(hashes, null);
    }

    public static final HashStructure newHashStructureFilteredImpl(HashStructure hs, Filter filter) {
        return new HashStructureFilteredImpl(hs, filter);
    }

    public final String getString(String name) {
        Object obj = this.getObject(name);
        return obj != null ? obj.toString() : null;
    }

    public final String getString(String name, String defaultValue) {
        if (this.containsKey(name)) {
            Object obj = this.getObject(name);
            return obj != null ? obj.toString() : null;
        }
        this.putPlaceholder(name, defaultValue);
        return defaultValue;
    }

    public final void putString(String name, String value) {
        this.putObject(HashStructure.intern(name), HashStructure.intern(value));
    }

    public final void putString(String name, String value, boolean removeIfNullValue) {
        this.putObject(HashStructure.intern(name), HashStructure.intern(value), removeIfNullValue);
    }

    public final boolean getBoolean(String name) {
        Object obj = this.getObject(name);
        return obj != null ? Boolean.valueOf(obj.toString()) : false;
    }

    public final boolean getBoolean(String name, boolean defaultValue) {
        Object obj = this.getObject(name);
        if (obj != null) {
            return Boolean.valueOf(obj.toString());
        }
        this.putPlaceholder(name, Boolean.toString(defaultValue));
        return defaultValue;
    }

    public final void putBoolean(String name, boolean value) {
        Boolean b = value ? Boolean.TRUE : Boolean.FALSE;
        this.putString(name, b.toString());
    }

    public final int getInt(String name) {
        Object obj = this.getObject(name);
        return obj != null ? Integer.parseInt(obj.toString()) : 0;
    }

    public final int getInt(String name, int defaultValue) {
        Object obj = this.getObject(name);
        if (obj != null) {
            return Integer.parseInt(obj.toString());
        }
        this.putPlaceholder(name, Integer.toString(defaultValue));
        return defaultValue;
    }

    public final void putInt(String name, int value) {
        this.putString(name, Integer.toString(value));
    }

    public final long getLong(String name) {
        Object obj = this.getObject(name);
        return obj != null ? Long.parseLong(obj.toString()) : 0L;
    }

    public final long getLong(String name, long defaultValue) {
        Object obj = this.getObject(name);
        if (obj != null) {
            return Long.parseLong(obj.toString());
        }
        this.putPlaceholder(name, Long.toString(defaultValue));
        return defaultValue;
    }

    public final void putLong(String name, long value) {
        this.putString(name, Long.toString(value));
    }

    public final float getFloat(String name) {
        Object obj = this.getObject(name);
        return obj != null ? Float.parseFloat(obj.toString()) : 0.0f;
    }

    public final float getFloat(String name, float defaultValue) {
        Object obj = this.getObject(name);
        if (obj != null) {
            return Float.parseFloat(obj.toString());
        }
        this.putPlaceholder(name, Float.toString(defaultValue));
        return defaultValue;
    }

    public final void putFloat(String name, float value) {
        this.putString(name, Float.toString(value));
    }

    public final double getDouble(String name) {
        Object obj = this.getObject(name);
        return obj != null ? Double.parseDouble(obj.toString()) : 0.0;
    }

    public final double getDouble(String name, double defaultValue) {
        Object obj = this.getObject(name);
        if (obj != null) {
            return Double.parseDouble(obj.toString());
        }
        this.putPlaceholder(name, Double.toString(defaultValue));
        return defaultValue;
    }

    public final void putDouble(String name, double value) {
        this.putString(name, Double.toString(value));
    }

    public final URL getURL(String name) {
        return (URL)this.getObject(name);
    }

    public final URL getURL(String name, URL defaultValue) {
        if (this.containsKey(name)) {
            return (URL)this.getObject(name);
        }
        this.putPlaceholder(HashStructure.intern(name), HashStructure.intern(defaultValue));
        return defaultValue;
    }

    public final void putPlaceholderURL(String name, URL placeholderValue) {
        this.putPlaceholder(HashStructure.intern(name), HashStructure.intern(placeholderValue));
    }

    public final void putURL(String name, URL value) {
        this.putObject(HashStructure.intern(name), HashStructure.intern(value));
    }

    public final void _putObject(String name, Object obj) {
        this.putObject(HashStructure.intern(name), HashStructure.intern(obj));
    }

    public final void _putPlaceholder(String name, Object obj) {
        this.putPlaceholder(HashStructure.intern(name), HashStructure.intern(obj));
    }

    public final void putURL(String name, URL value, boolean removeIfNullValue) {
        this.putObject(HashStructure.intern(name), HashStructure.intern(value), removeIfNullValue);
    }

    public abstract Object getObject(String var1);

    public abstract Set<String> keySet();

    public final void applyChange(ChangeInfo change) {
        if (change != null) {
            String name = change.getPropertyName();
            Structure keyStruct = this;
            StringTokenizer st = new StringTokenizer(name, "/", true);
            boolean tokenSeen = false;
            String curToken = null;
            while (st.hasMoreTokens() && keyStruct != null) {
                curToken = st.nextToken();
                if (!st.hasMoreTokens()) continue;
                if ("/".equals(curToken)) {
                    if (tokenSeen) {
                        tokenSeen = false;
                        continue;
                    }
                    keyStruct = this.descendStruct(keyStruct, "");
                    continue;
                }
                keyStruct = this.descendStruct(keyStruct, curToken);
                tokenSeen = true;
            }
            if (keyStruct instanceof HashStructure) {
                HashStructure hash = keyStruct;
                switch (change.getChangeType()) {
                    case 0: 
                    case 1: {
                        hash.putObject(HashStructure.intern(curToken), change.getNewValue());
                        break;
                    }
                    case 2: {
                        Object newValue = change.getNewValue();
                        if (newValue instanceof Structure) {
                            hash.putStructure(HashStructure.intern(curToken), (Structure)newValue, "structure", true);
                            break;
                        }
                        hash.putPlaceholder(HashStructure.intern(curToken), newValue);
                        break;
                    }
                    case 3: {
                        hash.remove(curToken);
                    }
                }
            } else if (keyStruct instanceof ListStructure) {
                ListStructure list = (ListStructure)keyStruct;
                try {
                    int index = Integer.parseInt(curToken);
                    switch (change.getChangeType()) {
                        case 0: {
                            list.set(index, change.getNewValue());
                            break;
                        }
                        case 1: {
                            list.add(index, change.getNewValue());
                            break;
                        }
                        case 2: {
                            list.addPlaceholder(change.getNewValue());
                            break;
                        }
                        case 3: {
                            list.remove(index);
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public final void applyChanges(ChangeInfo[] changes) {
        if (changes != null) {
            int n = changes.length;
            Pattern pattern = Pattern.compile("/\\d+(/|$)");
            HashSet<String> seen = new HashSet<String>();
            for (int i = n - 1; i >= 0; --i) {
                ChangeInfo change = changes[i];
                String name = change.getPropertyName();
                Matcher matcher = pattern.matcher(name);
                if (matcher.find()) continue;
                if (seen.contains(name)) {
                    changes[i] = null;
                    continue;
                }
                seen.add(name);
            }
            for (int i = 0; i < changes.length; ++i) {
                this.applyChange(changes[i]);
            }
        }
    }

    private Structure descendStruct(Structure struct, String name) {
        if (struct instanceof HashStructure) {
            HashStructure hash = (HashStructure)struct;
            Object nextObj = hash.getObject(name);
            if (nextObj != null) {
                return nextObj instanceof Structure ? (Structure)nextObj : null;
            }
        } else if (struct instanceof ListStructure) {
            ListStructure list = (ListStructure)struct;
            try {
                int index = Integer.parseInt(name);
                Object nextObj = list.get(index);
                if (nextObj != null) {
                    return nextObj instanceof Structure ? (Structure)nextObj : null;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public abstract Set<String> persistentKeySet();

    public abstract int keyStatus(String var1);

    public abstract void setKeyStatus(String var1, int var2);

    abstract HashStructure unchain();

    public final HashStructure getHashStructure(String name) {
        return (HashStructure)this.getObject(name);
    }

    public final HashStructure getOrCreateHashStructure(String name) {
        HashStructure hash = this.getHashStructure(name);
        if (hash == null) {
            hash = HashStructure.newInstance();
            this.putStructure(HashStructure.intern(name), hash, "hash", true);
        }
        return hash;
    }

    public final void putHashStructure(String name, HashStructure hash) {
        this.putStructure(HashStructure.intern(name), hash, "hash", false);
    }

    public final void putPlaceholderHashStructure(String name, HashStructure hash) {
        this.putStructure(HashStructure.intern(name), hash, "hash", true);
    }

    public final List getAsList(String name) {
        if (this.containsKey(name)) {
            Object obj = this.getObject(name);
            if (obj instanceof ListStructure) {
                return Collections.unmodifiableList(new ArrayList((ListStructure)obj));
            }
            return Collections.singletonList(obj);
        }
        return null;
    }

    public final ListStructure getListStructure(String name) {
        return (ListStructure)this.getObject(name);
    }

    public final ListStructure getOrCreateListStructure(String name) {
        ListStructure list = this.getListStructure(name);
        if (list == null) {
            list = ListStructure.newInstance();
            this.putStructure(HashStructure.intern(name), list, "list", true);
        }
        return list;
    }

    public final void putListStructure(String name, ListStructure list) {
        this.putStructure(HashStructure.intern(name), list, "list", false);
    }

    public final void putPlaceholderListStructure(String name, ListStructure list) {
        this.putStructure(HashStructure.intern(name), list, "list", true);
    }

    @Override
    public void clear() {
    }

    public abstract boolean containsKey(String var1);

    public abstract void remove(String var1);

    public abstract int size();

    public abstract void setParentDirtyable(Dirtyable var1);

    public boolean isAnyValueOverridden(String[] names) {
        return false;
    }

    public abstract void hideValues(String[] var1);

    public abstract void recoverValues(String[] var1);

    public boolean isReadOnly() {
        return false;
    }

    public HashStructure asReadOnly() {
        return new ReadOnly(this);
    }

    public HashStructure copyTo(HashStructure target, String[] names) {
        HashStructure copy = HashStructure.notNullOrCreate(target);
        for (String name : names) {
            if (this.containsKey(name)) {
                HashStructure.copyItem(this, copy, name, true);
                continue;
            }
            copy.remove(name);
        }
        return copy;
    }

    public HashStructure copyTo(HashStructure target) {
        return this.copyImpl(target, true);
    }

    HashStructure copyImpl(HashStructure target, boolean deleteDestKeysMissingFromSrcHash) {
        HashStructure orig = this;
        HashStructure copy = HashStructure.notNullOrCreate(target);
        HashStructure.deepCopy(orig, copy, deleteDestKeysMissingFromSrcHash);
        return copy;
    }

    private static void deepCopy(final HashStructure srcHash, final HashStructure destHash, final boolean deleteDestKeysMissingFromSrcHash) {
        destHash.applyBatchChanges(new Runnable(){

            @Override
            public void run() {
                String key;
                if (deleteDestKeysMissingFromSrcHash) {
                    ArrayList<String> keysToRemove = new ArrayList<String>();
                    Iterator<String> destKeyIter = destHash.keySet().iterator();
                    while (destKeyIter.hasNext()) {
                        key = destKeyIter.next().toString();
                        if (srcHash.containsKey(key)) continue;
                        keysToRemove.add(key);
                    }
                    Iterator keysToRemoveIter = keysToRemove.iterator();
                    while (keysToRemoveIter.hasNext()) {
                        destHash.remove(keysToRemoveIter.next().toString());
                    }
                }
                for (String keyObj : srcHash.keySet()) {
                    key = keyObj.toString();
                    HashStructure.copyItem(srcHash, destHash, key, deleteDestKeysMissingFromSrcHash);
                }
            }
        });
    }

    private static void copyItem(HashStructure srcHash, HashStructure destHash, String key, boolean deleteDestKeysMissingFromSrcHash) {
        Object srcValue = srcHash.getObject(key);
        if (srcValue instanceof HashStructure) {
            Object destValue = destHash.getObject(key);
            HashStructure origHash = (HashStructure)srcValue;
            if (destValue instanceof HashStructure) {
                HashStructure targetHash = (HashStructure)destValue;
                origHash.copyImpl(targetHash, deleteDestKeysMissingFromSrcHash);
            } else {
                HashStructure targetHash = HashStructure.newInstance();
                origHash.copyImpl(targetHash, deleteDestKeysMissingFromSrcHash);
                destHash.putHashStructure(key, targetHash);
            }
        } else if (srcValue instanceof ListStructure) {
            Object destValue = destHash.getObject(key);
            ListStructure origList = (ListStructure)srcValue;
            if (destValue instanceof ListStructure) {
                ListStructure targetList = (ListStructure)destValue;
                origList.copyTo(targetList);
            } else {
                ListStructure targetList = ListStructure.newInstance();
                origList.copyTo(targetList);
                targetList.markDirty(false);
                destHash.putListStructure(key, targetList);
            }
        } else {
            destHash.putObject(key, srcValue);
        }
    }

    abstract void putObject(String var1, Object var2);

    private void putObject(String name, Object value, boolean removeIfNullValue) {
        if (removeIfNullValue && value == null) {
            this.remove(name);
        } else {
            this.putObject(name, value);
        }
    }

    private static HashStructure notNullOrCreate(HashStructure hash) {
        return hash != null ? hash : HashStructure.newInstance();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((HashStructure)obj);
    }

    abstract boolean equalsImpl(HashStructure var1);

    abstract void putPlaceholder(String var1, Object var2);

    abstract void putStructure(String var1, Structure var2, String var3, boolean var4);

    static final class Impl
    extends HashStructure {
        private Set<String> _placeholderKeys;
        private final Map<String, Object> _data = new HashMap<String, Object>(3);
        private Dirtyable _parentDirtyable;
        private static final int NO_CREATE = 0;
        private static final int CREATE_PLACEHOLDER = 1;
        private static final int CREATE_PERSISTENT = 2;

        private Impl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public HashStructure copyTo(HashStructure target, String[] names) {
            HashStructure copy = HashStructure.notNullOrCreate(target);
            if (names != null && copy.getClass() == Impl.class) {
                Map<String, Object> map;
                String leafName;
                String name;
                int i;
                Impl targetImpl = (Impl)copy;
                int n = names.length;
                ArrayList<String> additions = new ArrayList<String>();
                ArrayList<String> removals = new ArrayList<String>();
                for (i = 0; i < n; ++i) {
                    name = names[i];
                    Impl keyStruct = this.getKeyStruct(name, 0);
                    if (keyStruct == null) continue;
                    leafName = this.getLeafName(name);
                    map = keyStruct._data;
                    synchronized (map) {
                        if (keyStruct._placeholderKeys != null && keyStruct._placeholderKeys.contains(leafName)) {
                            additions.add(leafName);
                        } else {
                            removals.add(leafName);
                        }
                        continue;
                    }
                }
                for (i = 0; i < n; ++i) {
                    name = names[i];
                    Impl targetKeyStruct = targetImpl.getKeyStruct(name, 0);
                    if (targetKeyStruct == null) continue;
                    leafName = this.getLeafName(name);
                    map = targetKeyStruct._data;
                    synchronized (map) {
                        if (additions.contains(leafName)) {
                            if (targetKeyStruct._placeholderKeys == null) {
                                targetKeyStruct._placeholderKeys = new HashSet<String>(3);
                            }
                            targetKeyStruct._placeholderKeys.add(leafName);
                        } else if (removals.contains(leafName) && targetKeyStruct._placeholderKeys != null) {
                            targetKeyStruct._placeholderKeys.remove(leafName);
                        }
                        continue;
                    }
                }
            }
            return super.copyTo(copy, names);
        }

        @Override
        HashStructure copyImpl(HashStructure target, boolean deleteDestKeysMissingFromSrcHash) {
            HashStructure copy = this.transferPlaceholders(target);
            return super.copyImpl(copy, deleteDestKeysMissingFromSrcHash);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HashStructure transferPlaceholders(HashStructure target) {
            HashStructure copy = HashStructure.notNullOrCreate(target);
            if (copy.getClass() == Impl.class) {
                Impl impl = (Impl)copy;
                Set<String> placeholderKeys = this.placeholderKeys();
                Map<String, Object> map = impl._data;
                synchronized (map) {
                    if (impl._placeholderKeys == null) {
                        impl._placeholderKeys = new HashSet<String>(3);
                    }
                    impl._placeholderKeys.clear();
                    impl._placeholderKeys.addAll(placeholderKeys);
                }
            }
            return copy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object read(String key) {
            Map<String, Object> map = this._data;
            synchronized (map) {
                return this._data.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean has(String key) {
            Map<String, Object> map = this._data;
            synchronized (map) {
                return this._data.containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Set<String> placeholderKeys() {
            Map<String, Object> map = this._data;
            synchronized (map) {
                if (this._placeholderKeys == null) {
                    return Collections.emptySet();
                }
                HashSet<String> placeholderKeys = new HashSet<String>();
                placeholderKeys.addAll(this._placeholderKeys);
                return placeholderKeys;
            }
        }

        @Override
        public Object getObject(String name) {
            Impl keyStruct = this.getKeyStruct(name, 0);
            return keyStruct != null ? keyStruct.read(this.getLeafName(name)) : null;
        }

        @Override
        public Set<String> keySet() {
            return Collections.unmodifiableSet(this.keySetImpl());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HashSet<String> keySetImpl() {
            HashSet<String> copy = new HashSet<String>();
            Map<String, Object> map = this._data;
            synchronized (map) {
                for (String key : this._data.keySet()) {
                    copy.add(key);
                }
            }
            return copy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<String> persistentKeySet() {
            HashSet<String> keys = this.keySetImpl();
            Map<String, Object> map = this._data;
            synchronized (map) {
                if (this._placeholderKeys != null) {
                    keys.removeAll(this._placeholderKeys);
                }
            }
            return Collections.unmodifiableSet(keys);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int keyStatus(String key) {
            Impl keyStruct = this.getKeyStruct(key, 0);
            if (keyStruct != null) {
                String leafName = this.getLeafName(key);
                Map<String, Object> map = this._data;
                synchronized (map) {
                    if (keyStruct._data.keySet().contains(leafName)) {
                        if (keyStruct._placeholderKeys != null && keyStruct._placeholderKeys.contains(leafName)) {
                            return 2;
                        }
                        return 1;
                    }
                    return 0;
                }
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setKeyStatus(String key, int status) {
            Impl keyStruct = this.getKeyStruct(key, 0);
            if (keyStruct != null) {
                String leafName = this.getLeafName(key);
                Map<String, Object> map = keyStruct._data;
                synchronized (map) {
                    if (keyStruct._data.keySet().contains(leafName)) {
                        if (status == 2) {
                            if (keyStruct._placeholderKeys == null) {
                                keyStruct._placeholderKeys = new HashSet<String>(3);
                            }
                            keyStruct._placeholderKeys.add(leafName);
                        } else if (status == 1 && keyStruct._placeholderKeys != null) {
                            keyStruct._placeholderKeys.remove(leafName);
                        }
                    }
                }
            }
        }

        @Override
        HashStructure unchain() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            final ArrayList<String> keys = new ArrayList<String>();
            Map<String, Object> map = this._data;
            synchronized (map) {
                keys.addAll(this._data.keySet());
            }
            int n = keys.size();
            final Impl self = this;
            if (n > 0) {
                this.applyBatchChanges(new Runnable(){

                    @Override
                    public void run() {
                        Iterator iter = keys.iterator();
                        while (iter.hasNext()) {
                            Impl.removeValueFromKeyStruct(self, (String)iter.next());
                        }
                    }
                });
            }
        }

        @Override
        public boolean containsKey(String name) {
            Impl keyStruct = this.getKeyStruct(name, 0);
            return keyStruct != null ? keyStruct.has(this.getLeafName(name)) : false;
        }

        @Override
        public void remove(String name) {
            Impl keyStruct = this.getKeyStruct(name, 0);
            Impl.removeValueFromKeyStruct(keyStruct, this.getLeafName(name));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void removeValueFromKeyStruct(final Impl keyStruct, final String leafName) {
            if (keyStruct == null) {
                return;
            }
            Runnable eventRunner = null;
            boolean dirty = false;
            Map<String, Object> map = keyStruct._data;
            synchronized (map) {
                if (keyStruct._data.containsKey(leafName)) {
                    final Object oldValue = keyStruct._data.remove(leafName);
                    if (oldValue instanceof Structure) {
                        ((Structure)oldValue).setParent(null);
                    }
                    if (keyStruct._placeholderKeys != null && keyStruct._placeholderKeys.contains(leafName)) {
                        keyStruct._placeholderKeys.remove(leafName);
                    } else {
                        dirty = true;
                    }
                    eventRunner = new Runnable(){

                        @Override
                        public void run() {
                            keyStruct.fireValueRemoved(leafName, keyStruct, oldValue);
                        }
                    };
                }
            }
            if (dirty) {
                keyStruct.markDirty(true);
            }
            if (eventRunner != null) {
                eventRunner.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Map<String, Object> map = this._data;
            synchronized (map) {
                return this._data.size();
            }
        }

        @Override
        Dirtyable getParentDirtyable() {
            return this._parentDirtyable != null ? this._parentDirtyable : super.getParentDirtyable();
        }

        @Override
        public void setParentDirtyable(Dirtyable parentDirtyable) {
            this._parentDirtyable = parentDirtyable;
        }

        @Override
        public void hideValues(String[] names) {
            if (names != null) {
                for (String name : names) {
                    Impl keyStruct = this.getKeyStruct(name, 0);
                    if (keyStruct == null) continue;
                    String leafName = this.getLeafName(name);
                    String hiddenLeafName = "hidden:" + leafName;
                    if (!keyStruct.containsKey(leafName)) continue;
                    Object value = keyStruct.getObject(leafName);
                    keyStruct.remove(leafName);
                    keyStruct.putObject(hiddenLeafName, value);
                }
            }
        }

        @Override
        public void recoverValues(String[] names) {
            if (names != null) {
                for (String name : names) {
                    String leafName;
                    String hiddenLeafName;
                    Impl keyStruct = this.getKeyStruct(name, 0);
                    if (keyStruct == null || !keyStruct.containsKey(hiddenLeafName = "hidden:" + (leafName = this.getLeafName(name)))) continue;
                    Object value = keyStruct.getObject(hiddenLeafName);
                    keyStruct.remove(hiddenLeafName);
                    keyStruct.putObject(leafName, value);
                }
            }
        }

        @Override
        void removeChild(Structure child) {
            for (String key : this.keySetImpl()) {
                Object value = this.read(key);
                if (value != child) continue;
                Impl.removeValueFromKeyStruct(this, key);
                break;
            }
        }

        @Override
        protected boolean equalsImpl(HashStructure o) {
            Set<String> otherPersistentKeys;
            if (!(o instanceof Impl)) {
                return false;
            }
            Impl other = (Impl)o;
            Set<String> persistentKeys = this.persistentKeySet();
            if (!persistentKeys.equals(otherPersistentKeys = other.persistentKeySet())) {
                return false;
            }
            for (String key : persistentKeys) {
                Object otherValue;
                Object value = this.read(key);
                if (!Impl.areDifferent(value, otherValue = other.read(key))) continue;
                return false;
            }
            HashSet<String> placeholderKeys = new HashSet<String>();
            placeholderKeys.addAll(this.placeholderKeys());
            placeholderKeys.addAll(other.placeholderKeys());
            for (String key : placeholderKeys) {
                Object otherValue;
                Object value;
                if (!this.has(key) || !other.has(key) || !Impl.areDifferent(value = this.read(key), otherValue = other.read(key))) continue;
                return false;
            }
            return true;
        }

        @Override
        void putObject(String name, Object value) {
            Impl.checkNotNull(name, "name");
            this.putObject0(name, value, false);
        }

        @Override
        void putPlaceholder(String name, Object value) {
            Impl.checkNotNull(name, "name");
            this.putObject0(name, value, true);
        }

        @Override
        void putStructure(String name, Structure struct, String valueParamName, boolean isPlaceholder) {
            Impl.checkNotNull(name, "name");
            Impl.checkNotNull(struct, valueParamName);
            this.putObject0(name, struct, isPlaceholder);
        }

        private final Impl getKeyStruct(String name, boolean isPlaceholder) {
            return this.getKeyStruct(name, isPlaceholder ? 1 : 2);
        }

        private final Impl getKeyStruct(String name, int createMode) {
            Impl.checkNotNull(name, "name");
            HashStructure keyStruct = this;
            StringTokenizer st = new StringTokenizer(name, "/", true);
            boolean tokenSeen = false;
            String curToken = null;
            while (st.hasMoreTokens() && keyStruct != null) {
                curToken = st.nextToken();
                if (!st.hasMoreTokens()) continue;
                if ("/".equals(curToken)) {
                    if (tokenSeen) {
                        tokenSeen = false;
                        continue;
                    }
                    keyStruct = Impl.descend(keyStruct, "", createMode);
                    continue;
                }
                keyStruct = Impl.descend(keyStruct, curToken, createMode);
                tokenSeen = true;
            }
            return keyStruct;
        }

        private static HashStructure descend(HashStructure hash, String name, int createMode) {
            return switch (createMode) {
                case 0 -> hash.getHashStructure(name);
                case 1 -> hash.getOrCreateHashStructure(name);
                case 2 -> {
                    HashStructure persistentHash = hash.getHashStructure(name);
                    if (persistentHash == null) {
                        persistentHash = HashStructure.newInstance();
                        hash.putHashStructure(name, persistentHash);
                    }
                    yield persistentHash;
                }
                default -> throw new IllegalArgumentException("Unexpected mode in descend(..).");
            };
        }

        private String getLeafName(String name) {
            return name.substring(name.lastIndexOf(47) + 1);
        }

        private void putObject0(String name, Object value, boolean isPlaceholder) {
            Structure structVal;
            Impl keyStruct = this.getKeyStruct(name, isPlaceholder);
            String leafName = Impl.intern(this.getLeafName(name));
            if (value instanceof Structure && (structVal = (Structure)value).mayHaveParent()) {
                keyStruct.checkAndSetParent(structVal, leafName);
            }
            Impl.putValueInKeyStruct(keyStruct, leafName, value, isPlaceholder);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void putValueInKeyStruct(final Impl keyStruct, final String leafName, final Object value, boolean isPlaceholder) {
            final Object oldValue = keyStruct.read(leafName);
            boolean alreadyContainsKey = keyStruct.has(leafName);
            if (Impl.areEqual(oldValue, value) && (value != null || alreadyContainsKey)) {
                return;
            }
            Runnable eventRunner = null;
            boolean dirty = false;
            Map<String, Object> map = keyStruct._data;
            synchronized (map) {
                keyStruct._data.put(leafName, value);
                if (isPlaceholder) {
                    if (keyStruct._placeholderKeys == null) {
                        keyStruct._placeholderKeys = new HashSet<String>(3);
                    }
                    keyStruct._placeholderKeys.add(leafName);
                    eventRunner = new Runnable(){

                        @Override
                        public void run() {
                            keyStruct.firePlaceholderValueAdded(leafName, keyStruct, value);
                        }
                    };
                } else if (alreadyContainsKey) {
                    keyStruct.clearPlaceholderFlag(leafName);
                    dirty = true;
                    eventRunner = new Runnable(){

                        @Override
                        public void run() {
                            keyStruct.fireValueModified(leafName, keyStruct, oldValue, value);
                        }
                    };
                } else if (keyStruct._placeholderKeys != null && keyStruct._placeholderKeys.contains(leafName)) {
                    eventRunner = new Runnable(){

                        @Override
                        public void run() {
                            keyStruct.firePlaceholderValueAdded(leafName, keyStruct, value);
                        }
                    };
                } else {
                    keyStruct.clearPlaceholderFlag(leafName);
                    dirty = true;
                    eventRunner = new Runnable(){

                        @Override
                        public void run() {
                            keyStruct.fireValueAdded(leafName, keyStruct, value);
                        }
                    };
                }
            }
            if (dirty) {
                keyStruct.markDirty(true);
            }
            if (eventRunner != null) {
                eventRunner.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final void clearPlaceholderFlag(String structName) {
            Map<String, Object> map = this._data;
            synchronized (map) {
                if (this._placeholderKeys != null) {
                    this._placeholderKeys.remove(structName);
                }
            }
        }

        private static void checkNotNull(Object obj, String paramName) {
            if (obj == null) {
                throw new IllegalArgumentException("The '" + paramName + "' parameter must not be null.");
            }
        }
    }

    private static final class ChainForStatusQuo
    extends BaseChain {
        private ChainForStatusQuo(HashStructure[] hashes, String prefix) {
            super(hashes, prefix);
        }

        @Override
        boolean mayHaveParent() {
            return false;
        }

        @Override
        final HashStructure getChainedHashStructure(String fullName) {
            return new ChainForStatusQuo(this._hashes, fullName);
        }

        @Override
        final ListStructure getChainedListStructure(ListStructure found, String fullName) {
            return found;
        }

        @Override
        public void clear() {
            final int n = this._hashes.length;
            if (n > 0) {
                final ChainForStatusQuo self = this;
                this.applyBatchChanges(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < n; ++i) {
                            HashStructure hash = self._hashes[i];
                            HashStructure subHash = self.getSubHashStructureAtPrefix(hash);
                            if (subHash == null) continue;
                            subHash.clear();
                            break;
                        }
                    }
                });
            }
        }

        @Override
        public void remove(String name) {
            String fullName = this.getFullName(name);
            for (HashStructure hash : this._hashes) {
                if (!hash.containsKey(fullName)) continue;
                hash.remove(fullName);
                break;
            }
        }

        @Override
        void putObject(String name, Object value) {
            String fullName = this.getFullName(name);
            HashStructure hash = this.findHashStructureWithKey(fullName);
            if (hash != null) {
                hash.putObject(fullName, value);
            }
        }

        @Override
        void putPlaceholder(String name, Object value) {
            String fullName = this.getFullName(name);
            HashStructure hash = this.findHashStructureWithKey(fullName);
            if (hash != null) {
                hash.putPlaceholder(fullName, value);
            }
        }

        @Override
        void putStructure(String name, Structure struct, String valueParamName, boolean isPlaceholder) {
            HashStructure hash;
            String fullName = this.getFullName(name);
            if (fullName != name) {
                fullName = ChainForStatusQuo.intern(fullName);
            }
            if ((hash = this.findHashStructureWithKey(fullName)) != null) {
                hash.putStructure(fullName, struct, valueParamName, isPlaceholder);
            }
        }

        private HashStructure findHashStructureWithKey(String fullName) {
            HashStructure hash2 = null;
            for (HashStructure hash2 : this._hashes) {
                if (!hash2.containsKey(fullName)) continue;
                return hash2;
            }
            return hash2;
        }

        @Override
        protected boolean equalsImpl(HashStructure o) {
            if (!(o instanceof ChainForStatusQuo)) {
                return false;
            }
            ChainForStatusQuo other = (ChainForStatusQuo)o;
            if (!this.samePrefixAndLength(other)) {
                return false;
            }
            for (int i = this._hashes.length; i > 0; --i) {
                if (this._hashes[i - 1].equals(other._hashes[i - 1])) continue;
                return false;
            }
            return true;
        }
    }

    private static final class ChainForOverriding
    extends BaseChain {
        private final HashStructure _firstHash;

        private ChainForOverriding(HashStructure[] hashes, String prefix) {
            super(hashes, prefix);
            this._firstHash = this._hashes[0];
        }

        @Override
        final HashStructure getChainedHashStructure(String fullName) {
            return new ChainForOverriding(this._hashes, fullName);
        }

        @Override
        final ListStructure getChainedListStructure(ListStructure found, String fullName) {
            HashStructure subHash = this.getSubHashStructureAtPrefix(this._firstHash);
            return ListStructure.newChainForOverriding(found, this._firstHash, fullName);
        }

        @Override
        public void clear() {
            HashStructure subHash = this.getSubHashStructureAtPrefix(this._firstHash);
            if (subHash != null) {
                subHash.clear();
            }
        }

        @Override
        public void remove(String name) {
            String fullName = this.getFullName(name);
            this._firstHash.remove(fullName);
        }

        @Override
        void putObject(String name, Object value) {
            String fullName = this.getFullName(name);
            this._firstHash.putObject(fullName, value);
        }

        @Override
        void putPlaceholder(String name, Object value) {
            String fullName = this.getFullName(name);
            this._firstHash.putPlaceholder(fullName, value);
        }

        @Override
        void putStructure(String name, Structure struct, String valueParamName, boolean isPlaceholder) {
            String fullName = this.getFullName(name);
            this._firstHash.putStructure(fullName, struct, valueParamName, isPlaceholder);
        }
    }

    public static class HashStructureFilteredImpl
    extends HashStructure {
        private final HashStructure _hash;
        private final Filter _filter;

        HashStructureFilteredImpl(HashStructure hash, Filter filter) {
            assert (hash != null);
            assert (filter != null);
            this._filter = filter;
            this._hash = hash;
        }

        @Override
        public Object getObject(String name) {
            if (this._filter.isDelegated(name) && this._filter.containsKey(name)) {
                Object obj = this._filter.getObject(name);
                if (obj == null) {
                    return this._hash.getObject(name);
                }
                return obj;
            }
            if (this._filter.isDelegated(name)) {
                Object object = this._filter.getObject(name);
                if (object != null) {
                    return object;
                }
                return this._hash.getObject(name);
            }
            return this._hash.getObject(name);
        }

        @Override
        public Set<String> keySet() {
            return this._hash.keySet();
        }

        @Override
        public Set<String> persistentKeySet() {
            return this._hash.persistentKeySet();
        }

        @Override
        public int keyStatus(String key) {
            return this._hash.keyStatus(key);
        }

        @Override
        public void setKeyStatus(String key, int status) {
            this._hash.setKeyStatus(key, status);
        }

        @Override
        public boolean containsKey(String name) {
            return this._filter.containsKey(name) || this._hash.containsKey(name);
        }

        @Override
        public void remove(String name) {
            if (this._filter.isDelegated(name)) {
                this._filter.putObject(name, null);
            } else {
                this._hash.remove(name);
            }
        }

        @Override
        public int size() {
            return this._hash.size();
        }

        @Override
        public void setParentDirtyable(Dirtyable parentDirtyable) {
            this._hash.setParentDirtyable(parentDirtyable);
        }

        @Override
        public void hideValues(String[] names) {
            this._hash.hideValues(names);
        }

        @Override
        public void recoverValues(String[] names) {
            this._hash.recoverValues(names);
        }

        @Override
        void putObject(String name, Object value) {
            if (this._filter.isDelegated(name)) {
                this._filter.putObject(name, value);
            } else {
                this._hash.putObject(name, value);
            }
        }

        @Override
        boolean equalsImpl(HashStructure other) {
            return this._hash.equalsImpl(other);
        }

        @Override
        void putPlaceholder(String name, Object value) {
            this._hash.putPlaceholder(name, value);
        }

        @Override
        void putStructure(String name, Structure struct, String valueParamName, boolean isPlaceholder) {
            this._hash.putStructure(name, struct, valueParamName, isPlaceholder);
        }

        @Override
        void removeChild(Structure child) {
            this._hash.removeChild(child);
        }

        @Override
        HashStructure unchain() {
            return this._hash.unchain();
        }
    }

    public static interface Filter {
        public boolean isDelegated(String var1);

        public boolean containsKey(String var1);

        public Object getObject(String var1);

        public void putObject(String var1, Object var2);
    }

    private static final class ReadOnly
    extends HashStructure {
        private final HashStructure _hash;

        private ReadOnly(HashStructure hash) {
            this._hash = hash;
        }

        @Override
        void removeChild(Structure child) {
            this.throwReadOnly();
        }

        @Override
        public void addStructureChangeListener(StructureChangeListener listener) {
            this.throwReadOnly();
        }

        @Override
        public void removeStructureChangeListener(StructureChangeListener listener) {
            this.throwReadOnly();
        }

        @Override
        public Object getObject(String name) {
            return this._hash.getObject(name);
        }

        @Override
        public Set<String> keySet() {
            return this._hash.keySet();
        }

        public Set persistentKeySet() {
            return this._hash.persistentKeySet();
        }

        @Override
        public int keyStatus(String key) {
            return this._hash.keyStatus(key);
        }

        @Override
        public void setKeyStatus(String key, int status) {
            this.throwReadOnly();
        }

        @Override
        HashStructure unchain() {
            return this._hash.unchain();
        }

        @Override
        public void clear() {
            this.throwReadOnly();
        }

        @Override
        public boolean containsKey(String name) {
            return this._hash.containsKey(name);
        }

        @Override
        public void remove(String name) {
            this.throwReadOnly();
        }

        @Override
        public int size() {
            return this._hash.size();
        }

        @Override
        public void setParentDirtyable(Dirtyable parentDirtyable) {
            this.throwReadOnly();
        }

        @Override
        public boolean isAnyValueOverridden(String[] names) {
            return this._hash.isAnyValueOverridden(names);
        }

        @Override
        public void hideValues(String[] names) {
            this.throwReadOnly();
        }

        @Override
        public void recoverValues(String[] names) {
            this.throwReadOnly();
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public HashStructure asReadOnly() {
            return this;
        }

        @Override
        void putObject(String name, Object value) {
            this.throwReadOnly();
        }

        @Override
        void putPlaceholder(String name, Object value) {
            this.throwReadOnly();
        }

        @Override
        void putStructure(String name, Structure struct, String valueParamName, boolean isPlaceholder) {
            this.throwReadOnly();
        }

        private void throwReadOnly() {
            throw new UnsupportedOperationException("This HashStructure is read-only");
        }

        @Override
        protected boolean equalsImpl(HashStructure other) {
            if (!(other instanceof ReadOnly)) {
                return false;
            }
            return this._hash.equals(((ReadOnly)other)._hash);
        }
    }

    private static abstract class BaseChain
    extends HashStructure {
        final HashStructure[] _hashes;
        private final String _prefix;

        private BaseChain(HashStructure[] hashes, String prefix) {
            if (hashes == null) {
                throw new IllegalArgumentException("hashes cannot be null");
            }
            int n = hashes.length;
            ArrayList<HashStructure> hashList = new ArrayList<HashStructure>();
            for (int i = 0; i < n; ++i) {
                HashStructure hash = hashes[i];
                if (hash == null) continue;
                hashList.add(hash);
            }
            int trimmedSize = hashList.size();
            if (trimmedSize < 1) {
                throw new IllegalArgumentException("hashes must contain at least one non-null element");
            }
            this._hashes = hashList.toArray(new HashStructure[trimmedSize]);
            this._prefix = prefix == null ? BaseChain.intern("") : (prefix.endsWith("/") ? BaseChain.intern(prefix) : BaseChain.intern(prefix + "/"));
        }

        @Override
        public String getStructName() {
            if ("".equals(this._prefix)) {
                return null;
            }
            int n = this._prefix.length() - 1;
            int start = this._prefix.lastIndexOf("/", n - 1);
            return this._prefix.substring(start + 1, n);
        }

        @Override
        public String getFullName() {
            if ("".equals(this._prefix)) {
                return null;
            }
            int n = this._prefix.length() - 1;
            return this._prefix.substring(0, n);
        }

        @Override
        public void applyBatchChanges(Runnable runnable) {
            this.applyBatchChangesImpl(0, runnable);
        }

        private void applyBatchChangesImpl(int index, final Runnable runnable) {
            while (index < this._hashes.length) {
                HashStructure hash;
                if ((hash = this._hashes[index++]) == null) continue;
                final int nextIndex = index;
                hash.applyBatchChanges(new Runnable(){

                    @Override
                    public void run() {
                        this.applyBatchChangesImpl(nextIndex, runnable);
                    }
                });
                return;
            }
            super.applyBatchChanges(runnable);
        }

        @Override
        void removeChild(Structure child) {
            int n = this._hashes.length;
            for (int i = 0; i < n; ++i) {
                this._hashes[i].removeChild(child);
            }
        }

        abstract HashStructure getChainedHashStructure(String var1);

        abstract ListStructure getChainedListStructure(ListStructure var1, String var2);

        @Override
        public final Object getObject(String name) {
            String fullName = this.getFullName(name);
            for (HashStructure hash : this._hashes) {
                if (!hash.containsKey(fullName)) continue;
                Object value = hash.getObject(fullName);
                if (value instanceof HashStructure) {
                    return this.getChainedHashStructure(fullName);
                }
                if (value instanceof ListStructure) {
                    return this.getChainedListStructure((ListStructure)value, fullName);
                }
                return value;
            }
            return null;
        }

        @Override
        public Set<String> keySet() {
            HashSet<String> keySet = new HashSet<String>();
            int n = this._hashes.length;
            for (int i = 0; i < n; ++i) {
                HashStructure hash = this.getSubHashStructureAtPrefix(this._hashes[i]);
                if (hash == null) continue;
                keySet.addAll(hash.keySet());
            }
            return Collections.unmodifiableSet(keySet);
        }

        public Set persistentKeySet() {
            HashSet<String> keySet = new HashSet<String>();
            int n = this._hashes.length;
            for (int i = 0; i < n; ++i) {
                HashStructure hash = this.getSubHashStructureAtPrefix(this._hashes[i]);
                if (hash == null) continue;
                keySet.addAll(hash.persistentKeySet());
            }
            return keySet;
        }

        @Override
        public int keyStatus(String key) {
            int n = this._hashes.length;
            for (int i = 0; i < n; ++i) {
                int keyStatus;
                HashStructure hash = this.getSubHashStructureAtPrefix(this._hashes[i]);
                if (hash == null || (keyStatus = hash.keyStatus(key)) == 0) continue;
                return keyStatus;
            }
            return 0;
        }

        @Override
        public void setKeyStatus(String key, int status) {
            int n = this._hashes.length;
            for (int i = 0; i < n; ++i) {
                HashStructure hash = this.getSubHashStructureAtPrefix(this._hashes[i]);
                if (hash == null || !hash.containsKey(key)) continue;
                hash.setKeyStatus(key, status);
                return;
            }
        }

        @Override
        HashStructure unchain() {
            String fullName = this.getFullName();
            if (fullName != null) {
                for (HashStructure hash : this._hashes) {
                    if (!hash.containsKey(fullName)) continue;
                    HashStructure result = hash.getHashStructure(fullName);
                    if (result != null) {
                        result = result.unchain();
                    }
                    return result;
                }
            } else {
                return this._hashes[0].unchain();
            }
            throw new IllegalStateException("Unable to unchain HashStructure.");
        }

        HashStructure getSubHashStructureAtPrefix(HashStructure hash) {
            if ("".equals(this._prefix)) {
                return hash;
            }
            String prefix = this._prefix.endsWith("/") ? this._prefix.substring(0, this._prefix.length() - 1) : this._prefix;
            try {
                return hash.getHashStructure(prefix);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public boolean containsKey(String name) {
            String fullName = this.getFullName(name);
            for (HashStructure hash : this._hashes) {
                if (!hash.containsKey(fullName)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return this.keySet().size();
        }

        @Override
        public void setParentDirtyable(Dirtyable parentDirtyable) {
            throw new IllegalStateException("A chained HashStructure cannot be put into another HashStructure");
        }

        @Override
        public final boolean isAnyValueOverridden(String[] names) {
            int numNames = names.length;
            for (int i = 0; i < numNames; ++i) {
                String fullName = this.getFullName(names[i]);
                int n = this._hashes.length - 1;
                for (int j = 0; j < n; ++j) {
                    HashStructure hash = this._hashes[j];
                    if (!hash.containsKey(fullName)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void hideValues(String[] names) {
            if (names != null) {
                HashStructure firstHash = this._hashes[0];
                String[] fullNames = this.toFullNames(names);
                firstHash.hideValues(fullNames);
            }
        }

        @Override
        public void recoverValues(String[] names) {
            if (names != null) {
                HashStructure firstHash = this._hashes[0];
                String[] fullNames = this.toFullNames(names);
                firstHash.recoverValues(fullNames);
            }
        }

        private String[] toFullNames(String[] names) {
            ArrayList<String> fullNames = new ArrayList<String>();
            for (String name : names) {
                if (name == null) continue;
                fullNames.add(this.getFullName(name));
            }
            return fullNames.toArray(new String[fullNames.size()]);
        }

        @Override
        void setParent(Structure parent) {
            throw new IllegalStateException("A chained HashStructure cannot have a parent.");
        }

        String getFullName(String name) {
            return this._prefix.length() == 0 ? name : this._prefix + name;
        }

        protected boolean samePrefixAndLength(BaseChain other) {
            return other._hashes.length == this._hashes.length && BaseChain.areEqual(other._prefix, this._prefix);
        }

        @Override
        boolean equalsImpl(HashStructure o) {
            if (!(o instanceof BaseChain)) {
                return false;
            }
            BaseChain other = (BaseChain)o;
            if (!this.samePrefixAndLength(other)) {
                return false;
            }
            for (int i = 0; i < this._hashes.length; ++i) {
                if (this._hashes[i].equals(other._hashes[i])) continue;
                return false;
            }
            return true;
        }
    }
}

