/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.data;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class Cache<T>
extends AbstractCollection<T> {
    private final List<Reference<T>> items = new CopyOnWriteArrayList<Reference<T>>();
    private final ReferenceQueue<T> staleRefs = new ReferenceQueue();
    private final ReferenceFactory refFactory;

    @Override
    public Iterator<T> iterator() {
        this.expungeStaleItems();
        return new CacheIterator(this.items.iterator());
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public boolean add(T e) {
        return this.items.add(this.refFactory.newReference(e, this.staleRefs));
    }

    @Override
    public void clear() {
        this.items.clear();
        while (this.staleRefs.poll() != null) {
        }
    }

    private void expungeStaleItems() {
        Reference<T> ref = this.staleRefs.poll();
        while (null != ref) {
            this.items.remove(ref);
            ref = this.staleRefs.poll();
        }
    }

    private Cache(ReferenceFactory refFactory) {
        this.refFactory = refFactory;
    }

    private class CacheIterator
    implements Iterator<T> {
        private final Iterator<Reference<T>> base;
        private Reference<T> current = null;

        public CacheIterator(Iterator<Reference<T>> base) {
            this.base = base;
        }

        @Override
        public boolean hasNext() {
            return this.base.hasNext();
        }

        @Override
        public T next() {
            this.current = this.base.next();
            return null != this.current ? (Object)this.current.get() : null;
        }

        @Override
        public void remove() {
            Cache.this.items.remove(this.current);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum ReferenceFactory {
        SOFT{

            @Override
            public <T> Reference<T> newReference(T obj, ReferenceQueue<T> refQ) {
                return new SoftReference<T>(obj, refQ);
            }
        }
        ,
        WEAK{

            @Override
            public <T> Reference<T> newReference(T obj, ReferenceQueue<T> refQ) {
                return new WeakReference<T>(obj, refQ);
            }
        };


        public abstract <T> Reference<T> newReference(T var1, ReferenceQueue<T> var2);
    }

    public static class Factory {
        public static <T> Cache<T> newWeakCache() {
            return new Cache(ReferenceFactory.WEAK);
        }

        public static <T> Cache<T> newSoftCache() {
            return new Cache(ReferenceFactory.SOFT);
        }
    }
}

