/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.swing.text.Segment;
import javax.swing.undo.UndoableEdit;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.ReadOnlyException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.buffer.WriteLockRequestListener;
import oracle.javatools.util.NullArgumentException;

final class ExpirableTextBufferSnapshot
implements TextBuffer {
    private final TextBuffer textBuffer;
    private final int snapshotId;
    private volatile boolean expired = false;
    private long expirationTime;
    private String expirationThread;
    private Throwable expirationCause;
    private TextBufferListener listener = null;

    ExpirableTextBufferSnapshot(TextBuffer textBuffer) {
        this.textBuffer = textBuffer;
        textBuffer.readLock();
        try {
            this.snapshotId = textBuffer.getChangeId();
            textBuffer.addTextBufferListener(new TextBufferListener(){

                @Override
                public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
                    ExpirableTextBufferSnapshot.this.expireSnapshot();
                }

                @Override
                public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
                    ExpirableTextBufferSnapshot.this.expireSnapshot();
                }

                @Override
                public void attributeUpdate(TextBuffer buffer, int attribute) {
                }
            });
        }
        finally {
            textBuffer.readUnlock();
        }
    }

    private void bailIfExpired() {
        if (this.expired) {
            throw new ExpiredTextBufferException(this.getClass(), this.textBuffer, false, this.expirationTime, this.expirationThread, this.expirationCause);
        }
    }

    private void expireSnapshot() {
        if (this.expired) {
            return;
        }
        this.expired = true;
        this.expirationTime = System.currentTimeMillis();
        this.expirationThread = Thread.currentThread().getName();
        this.expirationCause = new Throwable("expiration cause");
        if (this.listener != null) {
            this.textBuffer.removeTextBufferListener(this.listener);
            this.listener = null;
        }
    }

    @Override
    public int getLength() {
        this.bailIfExpired();
        return this.textBuffer.getLength();
    }

    @Override
    public char getChar(int offset) throws IndexOutOfBoundsException {
        this.bailIfExpired();
        return this.textBuffer.getChar(offset);
    }

    @Override
    public char[] getChars(int offset, int length) throws IndexOutOfBoundsException {
        this.bailIfExpired();
        char[] chars = this.textBuffer.getChars(offset, length);
        this.bailIfExpired();
        return chars;
    }

    @Override
    public String getString(int offset, int length) throws IndexOutOfBoundsException {
        this.bailIfExpired();
        String s = this.textBuffer.getString(offset, length);
        this.bailIfExpired();
        return s;
    }

    @Override
    public void getText(int offset, int length, Segment segment) throws IndexOutOfBoundsException {
        this.bailIfExpired();
        this.textBuffer.getText(offset, length, segment);
        this.bailIfExpired();
    }

    @Override
    public void readLock() {
        this.bailIfExpired();
        this.textBuffer.readLock();
        if (this.expired) {
            this.textBuffer.readUnlock();
            this.bailIfExpired();
        }
    }

    @Override
    public void readLockInterruptibly() throws InterruptedException {
        this.bailIfExpired();
        this.textBuffer.readLockInterruptibly();
        if (this.expired) {
            this.textBuffer.readUnlock();
            this.bailIfExpired();
        }
    }

    @Override
    public boolean tryReadLock() {
        this.bailIfExpired();
        boolean success = this.textBuffer.tryReadLock();
        if (this.expired) {
            if (success) {
                this.textBuffer.readUnlock();
            }
            this.bailIfExpired();
        }
        return success;
    }

    @Override
    public void readUnlock() {
        this.textBuffer.readUnlock();
    }

    @Override
    public int getLockStatus() {
        return this.textBuffer.getLockStatus();
    }

    @Override
    public void beginEdit() throws ReadOnlyException {
        throw new UnsupportedOperationException();
    }

    @Override
    public UndoableEdit endEdit() {
        throw new UnsupportedOperationException();
    }

    @Override
    public UndoableEdit insert(int offset, char[] data) throws ReadOnlyException {
        throw new UnsupportedOperationException();
    }

    @Override
    public UndoableEdit append(char[] data) throws ReadOnlyException {
        throw new UnsupportedOperationException();
    }

    @Override
    public UndoableEdit remove(int offset, int count) throws ReadOnlyException {
        throw new UnsupportedOperationException();
    }

    @Override
    public UndoableEdit removeToEnd(int offset) throws ReadOnlyException {
        throw new UnsupportedOperationException();
    }

    @Override
    public LineMap getLineMap() {
        this.bailIfExpired();
        return new ExpirableLineMap(this.textBuffer.getLineMap());
    }

    @Override
    public void addTextBufferListener(TextBufferListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeTextBufferListener(TextBufferListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void writeLock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeLockInterruptibly() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeLock(boolean checkIfReadOnly) throws ReadOnlyException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean tryWriteLock() throws ReadOnlyException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeUnlock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addWriteLockRequestListener(WriteLockRequestListener listener) {
        if (listener == null) {
            throw new NullArgumentException("null listener");
        }
        this.bailIfExpired();
        return this.textBuffer.addWriteLockRequestListener(listener);
    }

    @Override
    public void removeWriteLockRequestListener(WriteLockRequestListener listener) {
        if (listener == null) {
            throw new NullArgumentException("null listener");
        }
        this.textBuffer.removeWriteLockRequestListener(listener);
    }

    @Override
    public OffsetMark addOffsetMark(int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OffsetMark addOffsetMark(int offset, boolean bias) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeOffsetMark(OffsetMark offsetMark) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isModified() {
        this.bailIfExpired();
        return this.textBuffer.isModified();
    }

    @Override
    public void clearModified() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getChangeId() {
        return this.snapshotId;
    }

    @Override
    public void read(Reader reader) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public UndoableEdit insert(int offset, Reader reader) throws ReadOnlyException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(Writer writer) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(Writer writer, boolean clearModified) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPlatformEOLType() {
        this.bailIfExpired();
        return this.textBuffer.getPlatformEOLType();
    }

    @Override
    public String getEOLType() {
        this.bailIfExpired();
        return this.textBuffer.getEOLType();
    }

    @Override
    public void setEOLType(String eolType) throws ReadOnlyException {
        throw new UnsupportedOperationException();
    }

    private class ExpirableLineMap
    implements LineMap {
        private final LineMap _delegateLineMap;

        ExpirableLineMap(LineMap delegateLineMap) {
            this._delegateLineMap = delegateLineMap;
        }

        @Override
        public TextBuffer getTextBuffer() {
            ExpirableTextBufferSnapshot.this.bailIfExpired();
            return this._delegateLineMap.getTextBuffer();
        }

        @Override
        public int getLineCount() {
            ExpirableTextBufferSnapshot.this.bailIfExpired();
            return this._delegateLineMap.getLineCount();
        }

        @Override
        public int getLineFromOffset(int offset) {
            ExpirableTextBufferSnapshot.this.bailIfExpired();
            return this._delegateLineMap.getLineFromOffset(offset);
        }

        @Override
        public int getLineStartOffset(int line) {
            ExpirableTextBufferSnapshot.this.bailIfExpired();
            return this._delegateLineMap.getLineStartOffset(line);
        }

        @Override
        public int getLineEndOffset(int line) {
            ExpirableTextBufferSnapshot.this.bailIfExpired();
            return this._delegateLineMap.getLineEndOffset(line);
        }
    }
}

