/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import javax.swing.text.Segment;
import oracle.javatools.buffer.ReadTextBuffer;

public final class CharArrayReadTextBuffer
implements ReadTextBuffer {
    private char[] dataSource;

    public CharArrayReadTextBuffer(char[] dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public int getLength() {
        return this.dataSource.length;
    }

    @Override
    public char getChar(int offset) throws IndexOutOfBoundsException {
        return this.dataSource[offset];
    }

    @Override
    public char[] getChars(int offset, int length) throws IndexOutOfBoundsException {
        char[] buffer = new char[length];
        System.arraycopy(this.dataSource, offset, buffer, 0, length);
        return buffer;
    }

    @Override
    public String getString(int offset, int length) throws IndexOutOfBoundsException {
        if (length == 0) {
            if (offset < 0) {
                throw new StringIndexOutOfBoundsException(offset);
            }
            if (offset > this.getLength()) {
                throw new StringIndexOutOfBoundsException(offset);
            }
            return "";
        }
        return new String(this.dataSource, offset, length);
    }

    @Override
    public void getText(int offset, int length, Segment segment) throws IndexOutOfBoundsException {
        segment.array = this.getChars(offset, length);
        segment.offset = 0;
        segment.count = length;
    }

    @Override
    public void readLock() {
    }

    @Override
    public void readLockInterruptibly() {
    }

    @Override
    public boolean tryReadLock() {
        return true;
    }

    @Override
    public void readUnlock() {
    }

    @Override
    public int getLockStatus() {
        return -1;
    }
}

