/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.ide.net.JarUtil;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.ProtocolConstants;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.net.EncoderUtils;
import oracle.javatools.util.Maps;

public final class URLFactory {
    private static final Map<URLPoolKey, URL> pool = new Maps.WeakHashMap<URLPoolKey, URL>();

    private URLFactory() {
    }

    public static URL copyURL(URL url) {
        return URLFactory.newURL(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
    }

    public static URL newURL(URL baseURL, String relativePath) {
        if (JarUtil.isJarURL(baseURL)) {
            URL jarFileURL = JarUtil.getJarFileURL(baseURL);
            String entry = JarUtil.getJarEntry(baseURL);
            String basePath = URLFileSystem.getPath(jarFileURL) + "!/" + entry;
            String newPath = URLFactory.resolveRelative(basePath, relativePath);
            int separator = newPath.indexOf("!/");
            if (separator < 0) {
                return URLFactory.replacePathPart(jarFileURL, newPath);
            }
            String newEntry = newPath.substring(separator + "!/".length());
            return URLFactory.newJarURL(jarFileURL, newEntry);
        }
        String newPath = URLFactory.resolveRelative(baseURL.getPath(), relativePath);
        return URLFactory.replacePathPart(baseURL, newPath);
    }

    public static URL newDirURL(URL baseURL, String relativePath) {
        if (relativePath == null) {
            return null;
        }
        return URLFactory.newURL(baseURL, (String)(relativePath.endsWith("/") ? relativePath : relativePath + "/"));
    }

    public static URL newURL(String protocol, String path) {
        int index;
        String query = null;
        if (path != null && (index = path.indexOf("?")) != -1) {
            query = path.substring(index + 1);
            path = path.substring(0, index);
        }
        return URLFactory.newURL(protocol, null, null, -1, path, query, null);
    }

    public static URL newDirURL(String protocol, String dirPath) {
        return URLFactory.newURL(protocol, (String)(dirPath.endsWith("/") ? dirPath : dirPath + "/"));
    }

    public static URL newUniqueURL(URL baseURL, NameGenerator generator) {
        URL url;
        do {
            if ((url = URLFactory.newURL(baseURL, generator.nextName())) != null) continue;
            return null;
        } while (URLFileSystem.isBound(url));
        return url;
    }

    public static URL replaceProtocolPart(URL url, String newProtocol) {
        return URLFactory.newURL(newProtocol, url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
    }

    public static URL replacePortPart(URL url, int newPort) {
        return URLFactory.newURL(url.getProtocol(), url.getUserInfo(), url.getHost(), newPort, url.getPath(), url.getQuery(), url.getRef());
    }

    public static URL replaceHostPart(URL url, String newHost) {
        return URLFactory.newURL(url.getProtocol(), url.getUserInfo(), newHost, url.getPort(), url.getPath(), url.getQuery(), url.getRef());
    }

    public static URL replacePathPart(URL url, String newPath) {
        String protocol = url.getProtocol();
        String host = url.getHost();
        if ("file".equals(protocol) && host != null && !host.isEmpty() && newPath.startsWith("//")) {
            host = null;
        }
        return URLFactory.newURL(protocol, url.getUserInfo(), host, url.getPort(), newPath, url.getQuery(), url.getRef());
    }

    public static URL replaceQueryPart(URL url, String newQuery) {
        return URLFactory.newURL(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), newQuery, url.getRef());
    }

    public static URL replaceRefPart(URL url, String newRef) {
        return URLFactory.newURL(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), newRef);
    }

    public static URL encodeURL(URL url) {
        return URLFactory.encodeURL(url, null);
    }

    public static URL encodeURL(URL url, String encoding) {
        return URLFactory.newURL(url.getProtocol(), URLFactory.encodeString(url.getUserInfo(), encoding), url.getHost(), url.getPort(), URLFactory.encodeString(url.getPath(), encoding), URLFactory.encodeQuery(url.getQuery(), encoding), URLFactory.encodeString(url.getRef(), encoding));
    }

    private static String encodeString(String string, String encoding) {
        if (URLFactory.nullOrEmpty(string)) {
            return string;
        }
        try {
            return EncoderUtils.encodeString(string, encoding);
        }
        catch (UnsupportedEncodingException e) {
            return string;
        }
    }

    private static String encodeQuery(String query, String encoding) {
        if (URLFactory.nullOrEmpty(query)) {
            return query;
        }
        StringWriter sw = new StringWriter(query.length());
        try {
            EncoderUtils.writeQueryParameters(sw, query, encoding, 0);
        }
        catch (UnsupportedEncodingException uee) {
            return query;
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL intern(URL url) {
        URLFileSystem.hashCode(url);
        URLPoolKey key = new URLPoolKey(url);
        Map<URLPoolKey, URL> map = pool;
        synchronized (map) {
            URL pooled = pool.get(key);
            if (pooled == null) {
                pool.put(key, url);
                pooled = url;
            }
            return pooled;
        }
    }

    public static URL newURL(String urlString) {
        return URLFactory.newURL(urlString, false, false);
    }

    public static URL newURL(String urlString, boolean forceDir, boolean assumeFile) {
        char firstChar;
        int size;
        if (urlString == null) {
            return null;
        }
        if (forceDir && !((String)urlString).endsWith("/")) {
            urlString = (String)urlString + "/";
        }
        if ((size = ((String)urlString).length()) > 0 && ((firstChar = ((String)urlString).charAt(0)) == File.separatorChar || firstChar == '/' || size > 1 && ((String)urlString).charAt(1) == ':' || ((String)urlString).indexOf(58) < 0 && assumeFile)) {
            return URLFactory.newFileURL((String)urlString);
        }
        if (((String)urlString).toLowerCase().startsWith("file:")) {
            return URLFactory.newFileURL(((String)urlString).substring(5));
        }
        try {
            return new URL((String)urlString);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static URL newFileURL(String filePath) {
        if (filePath == null) {
            return null;
        }
        String path = URLFactory.sanitizePath(filePath);
        return URLFactory.newURL("file", path);
    }

    public static URL newFileURL(File file) {
        if (file == null) {
            return null;
        }
        String filePath = file.getAbsolutePath();
        return file.isDirectory() ? URLFactory.newDirURL(filePath) : URLFactory.newFileURL(filePath);
    }

    public static URL newDirURL(String dirPath) {
        if (dirPath == null) {
            return null;
        }
        Object path = URLFactory.sanitizePath(dirPath);
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        return URLFactory.newURL("file", (String)path);
    }

    public static URL newDirURL(File dir) {
        return dir != null ? URLFactory.newDirURL(dir.getAbsolutePath()) : null;
    }

    public static URL newIdeURL(String protocol, URL url) {
        if (protocol == null || url == null) {
            return null;
        }
        if (!ProtocolConstants.isIdeProtocol(protocol)) {
            return null;
        }
        String newProtocol = protocol + "." + url.getProtocol();
        return URLFactory.replaceProtocolPart(url, newProtocol);
    }

    public static URL newJarURL(File archiveFile, String entryName) {
        return URLFactory.newJarURL(URLFactory.newFileURL(archiveFile), entryName);
    }

    public static URL newJarURL(URL archiveFile, String entryName) {
        if (JarUtil.isJarURL(archiveFile)) {
            String path = archiveFile.getPath();
            int bangSlash = path.indexOf("!/");
            if (bangSlash < 0) {
                throw new IllegalArgumentException("Bad jar url: " + archiveFile);
            }
            StringBuilder newPath = new StringBuilder(path);
            if (!path.endsWith("/")) {
                newPath.append('/');
            }
            if (entryName != null) {
                newPath.append(entryName);
            }
            return URLFactory.replacePathPart(archiveFile, newPath.toString());
        }
        StringBuilder path = new StringBuilder(archiveFile.toString());
        path.append("!/");
        if (entryName != null) {
            path.append(entryName);
        }
        return URLFactory.newURL("jar", path.toString());
    }

    public static URL newURL(String protocol, String userInfo, String host, int port, String path, String query, String ref) {
        try {
            if (URLFactory.nullOrEmpty(userInfo)) {
                if ("file".equals(protocol)) {
                    protocol = "file";
                } else if ("jar".equals(protocol)) {
                    protocol = "jar";
                }
                if (host == null) {
                    host = "";
                }
                StringBuilder file = new StringBuilder();
                if (path != null) {
                    file.append(path);
                }
                if (query != null) {
                    file.append('?').append(query);
                }
                if (ref != null) {
                    file.append('#').append(ref);
                }
                return new URL(protocol, host, port, file.toString());
            }
            StringBuilder builder = new StringBuilder();
            if (URLFactory.notNullOrEmpty(protocol)) {
                builder.append(protocol).append(':');
            }
            if (URLFactory.notNullOrEmpty(userInfo) || URLFactory.notNullOrEmpty(host) || port != -1) {
                builder.append("//");
                if (URLFactory.notNullOrEmpty(userInfo)) {
                    builder.append(userInfo).append('@');
                }
                if (URLFactory.notNullOrEmpty(host)) {
                    builder.append(host);
                }
                if (port != -1) {
                    builder.append(':').append(port);
                }
            }
            if (URLFactory.notNullOrEmpty(path)) {
                builder.append(path);
            }
            if (query != null) {
                builder.append('?').append(query);
            }
            if (URLFactory.notNullOrEmpty(ref)) {
                builder.append('#').append(ref);
            }
            return new URL(builder.toString());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static boolean nullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    private static boolean notNullOrEmpty(String string) {
        return string != null && !string.isEmpty();
    }

    private static String sanitizePath(String path) {
        int backslash = ((String)path).indexOf(92);
        if (backslash < 0) {
            if (((String)path).length() > 0 && ((String)path).charAt(0) != '/') {
                path = "/" + (String)path;
            }
        } else if (backslash == 0) {
            path = ((String)path).replace('\\', '/');
        } else {
            StringBuilder builder = new StringBuilder();
            int start = ((String)path).charAt(0) != '/' ? 0 : 1;
            builder.append('/');
            do {
                builder.append((CharSequence)path, start, backslash);
                builder.append('/');
            } while ((backslash = ((String)path).indexOf(92, start = backslash + 1)) > 0);
            builder.append((CharSequence)path, start, ((String)path).length());
            path = builder.toString();
        }
        return path;
    }

    static String resolveRelative(List<String> parts, String relativePath, StringBuffer newPath) {
        int length;
        boolean trailingRelativeDirectory = false;
        int index = 0;
        while (true) {
            int newIndex;
            String part;
            if (!(part = relativePath.substring(index, (newIndex = relativePath.indexOf(47, index)) < 0 ? relativePath.length() : newIndex)).isEmpty()) {
                if (part.equals("..")) {
                    int n = parts.size();
                    if (n > 0) {
                        parts.remove(n - 1);
                    }
                    trailingRelativeDirectory = true;
                } else if (part.equals(".")) {
                    trailingRelativeDirectory = true;
                } else {
                    parts.add(part);
                    trailingRelativeDirectory = false;
                }
            }
            if (newIndex < 0) break;
            index = newIndex + 1;
        }
        for (String part : parts) {
            newPath.append(part).append('/');
        }
        if (!trailingRelativeDirectory && !relativePath.endsWith("/") && relativePath.length() != 0 && (length = newPath.length()) > 0) {
            newPath.setLength(length - 1);
        }
        return newPath.toString();
    }

    private static String resolveRelative(String basePath, String relativePath) {
        ArrayList<String> parts = new ArrayList<String>();
        int index = 0;
        while (true) {
            int newIndex;
            String part;
            if ((part = basePath.substring(index, (newIndex = basePath.indexOf(47, index)) >= 0 ? newIndex : basePath.length())).length() > 0 || newIndex == index + 1) {
                parts.add(part);
            }
            if (newIndex < 0) break;
            index = newIndex + 1;
        }
        StringBuffer newPath = new StringBuffer();
        if (basePath.startsWith("//")) {
            newPath.append("//");
        } else if (basePath.startsWith("/")) {
            newPath.append('/');
        }
        return URLFactory.resolveRelative(parts, relativePath, newPath);
    }

    private static final class URLPoolKey
    extends WeakReference<URL> {
        URLPoolKey(URL url) {
            super(url);
        }

        public int hashCode() {
            URL url = (URL)this.get();
            return url == null ? 0 : URLFileSystem.hashCode(url);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof URLPoolKey)) {
                return false;
            }
            return URLFileSystem.equals((URL)this.get(), (URL)((URLPoolKey)object).get());
        }
    }
}

