/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLPath;

public class URLClassLoaderFactory {
    public static URLClassLoader newClassLoader(URL ... urls) {
        URL[] array = new URL[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            array[i] = URLClassLoaderFactory.unwrap(urls[i]);
        }
        return new PalliativeURLClassLoader(array);
    }

    public static URLClassLoader newClassLoader(ClassLoader parent, URL ... urls) {
        URL[] array = new URL[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            array[i] = URLClassLoaderFactory.unwrap(urls[i]);
        }
        return new PalliativeURLClassLoader(array, parent);
    }

    public static URLClassLoader newClassLoader(ClassLoader parent, URLStreamHandlerFactory factory, URL[] urls) {
        URL[] array = new URL[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            array[i] = URLClassLoaderFactory.unwrap(urls[i]);
        }
        return new PalliativeURLClassLoader(array, parent, factory);
    }

    public static URLClassLoader newClassLoader(Collection<URL> urls) {
        URL[] array = new URL[urls.size()];
        Iterator<URL> iterator = urls.iterator();
        for (int i = 0; i < array.length; ++i) {
            array[i] = URLClassLoaderFactory.unwrap(iterator.next());
        }
        return new PalliativeURLClassLoader(array);
    }

    public static URLClassLoader newClassLoader(ClassLoader parent, Collection<URL> urls) {
        URL[] array = new URL[urls.size()];
        Iterator<URL> iterator = urls.iterator();
        for (int i = 0; i < array.length; ++i) {
            array[i] = URLClassLoaderFactory.unwrap(iterator.next());
        }
        return new PalliativeURLClassLoader(array, parent);
    }

    public static URLClassLoader newClassLoader(ClassLoader parent, URLStreamHandlerFactory factory, Collection<URL> urls) {
        URL[] array = new URL[urls.size()];
        Iterator<URL> iterator = urls.iterator();
        for (int i = 0; i < array.length; ++i) {
            array[i] = URLClassLoaderFactory.unwrap(iterator.next());
        }
        return new PalliativeURLClassLoader(array, parent, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URLClassLoader newClassLoader(URLPath urls) {
        URL[] array;
        Object object = urls.iteratorLock();
        synchronized (object) {
            array = new URL[urls.size()];
            Iterator<URL> iterator = urls.iterator();
            for (int i = 0; i < array.length; ++i) {
                array[i] = URLClassLoaderFactory.unwrap(iterator.next());
            }
        }
        return new PalliativeURLClassLoader(array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URLClassLoader newClassLoader(URLPath urls, ClassLoader parent) {
        URL[] array;
        Object object = urls.iteratorLock();
        synchronized (object) {
            array = new URL[urls.size()];
            Iterator<URL> iterator = urls.iterator();
            for (int i = 0; i < array.length; ++i) {
                array[i] = URLClassLoaderFactory.unwrap(iterator.next());
            }
        }
        return new PalliativeURLClassLoader(array, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URLClassLoader newClassLoader(URLPath urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        URL[] array;
        Object object = urls.iteratorLock();
        synchronized (object) {
            array = new URL[urls.size()];
            Iterator<URL> iterator = urls.iterator();
            for (int i = 0; i < array.length; ++i) {
                array[i] = URLClassLoaderFactory.unwrap(iterator.next());
            }
        }
        return new PalliativeURLClassLoader(array, parent, factory);
    }

    public static URL unwrap(URL url) {
        return JarUtil.isJarURL(url) && JarUtil.getJarEntry(url).isEmpty() ? JarUtil.getJarFileURL(url) : url;
    }

    public static URLClassLoader newClassLoader(Path ... paths) {
        URL[] array = new URL[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            array[i] = URLClassLoaderFactory.convert(paths[i]);
        }
        return new PalliativeURLClassLoader(array);
    }

    public static URLClassLoader newClassLoader(ClassLoader parent, Path ... paths) {
        URL[] array = new URL[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            array[i] = URLClassLoaderFactory.convert(paths[i]);
        }
        return new PalliativeURLClassLoader(array, parent);
    }

    public static URLClassLoader newClassLoader(ClassLoader parent, URLStreamHandlerFactory factory, Path ... paths) {
        URL[] array = new URL[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            array[i] = URLClassLoaderFactory.convert(paths[i]);
        }
        return new PalliativeURLClassLoader(array, parent, factory);
    }

    public static URLClassLoader newClassLoaderFromPaths(Collection<Path> paths) {
        URL[] array = new URL[paths.size()];
        Iterator<Path> iterator = paths.iterator();
        for (int i = 0; i < array.length; ++i) {
            array[i] = URLClassLoaderFactory.convert(iterator.next());
        }
        return new PalliativeURLClassLoader(array);
    }

    public static URLClassLoader newClassLoaderFromPaths(ClassLoader parent, Collection<Path> paths) {
        URL[] array = new URL[paths.size()];
        Iterator<Path> iterator = paths.iterator();
        for (int i = 0; i < array.length; ++i) {
            array[i] = URLClassLoaderFactory.convert(iterator.next());
        }
        return new PalliativeURLClassLoader(array, parent);
    }

    public static URLClassLoader newClassLoaderFromPaths(ClassLoader parent, URLStreamHandlerFactory factory, Collection<Path> paths) {
        URL[] array = new URL[paths.size()];
        Iterator<Path> iterator = paths.iterator();
        for (int i = 0; i < array.length; ++i) {
            array[i] = URLClassLoaderFactory.convert(iterator.next());
        }
        return new PalliativeURLClassLoader(array, parent, factory);
    }

    private static URL convert(Path path) {
        FileSystem fileSystem = path.getFileSystem();
        File file = "jar".equals(fileSystem.provider().getScheme()) ? new File(fileSystem.toString()) : path.toFile();
        return URLFactory.newFileURL(file);
    }

    private static class PalliativeURLClassLoader
    extends URLClassLoader {
        public PalliativeURLClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        public PalliativeURLClassLoader(URL[] urls) {
            super(urls);
        }

        public PalliativeURLClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
            super(urls, parent, factory);
        }
    }
}

