/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.awt.EventQueue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ideimpl.net.AuthenticatorHelper;
import oracle.javatools.mt.annotation.CodeSharingSafe;
import oracle.javatools.util.Executors;

public class MultiThreadURLFileSystemHelper
extends URLFileSystemHelper {
    @CodeSharingSafe(value="StaticField")
    private static final Executor IO_EXECUTORS = java.util.concurrent.Executors.newCachedThreadPool(Executors.namedThreadFactory("MultiThreadURLFileSystemHelper"));
    private static final Logger LOG = Logger.getLogger(MultiThreadURLFileSystemHelper.class.getName());

    protected URLConnection openConnection(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        return connection;
    }

    protected void closeConnection(URLConnection connection) throws IOException {
    }

    public <R, C extends URLConnection> R invokeInterruptibly(URL url, InterruptibleClosure<R, C> callable) throws IOException {
        return this.invokeInterruptiblyImpl(url, callable, true);
    }

    private <R, C extends URLConnection> R invokeInterruptiblyImpl(final URL url, final InterruptibleClosure<R, C> callable, final boolean close) throws IOException {
        return this.invokeInterruptiblyImpl(new Callable<R>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public R call() throws IOException {
                URLConnection connection = MultiThreadURLFileSystemHelper.this.openConnection(url);
                Object r = callable.call(connection);
                return r;
                finally {
                    if (close) {
                        try {
                            MultiThreadURLFileSystemHelper.this.closeConnection(connection);
                        }
                        catch (IOException iOException) {}
                        try {
                            connection.getInputStream().close();
                        }
                        catch (IOException iOException) {}
                        try {
                            connection.getOutputStream().close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R invokeInterruptiblyImpl(Callable<R> callable) throws IOException {
        if (EventQueue.isDispatchThread()) {
            LOG.log(Level.WARNING, "invokeInterrruptibly invoked from EDT possible deadlock, is a http URL being accessed from the event queue", new Throwable());
        }
        class OffThread
        implements AuthenticatorHelper.AuthenticatorCallback {
            public final BlockingQueue<Authenticator> toProcess = new ArrayBlockingQueue<Authenticator>(1);
            public final BlockingQueue<PasswordAuthentication> result = new ArrayBlockingQueue<PasswordAuthentication>(1);
            public final PasswordAuthentication NULL = new PasswordAuthentication("", new char[0]);

            OffThread() {
            }

            @Override
            public PasswordAuthentication getPasswordAuthentication(Authenticator auth) {
                try {
                    this.toProcess.put(auth);
                    PasswordAuthentication pa = this.result.take();
                    return pa != this.NULL ? pa : null;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
        }
        final OffThread cb = new OffThread();
        FutureTask future = new FutureTask<R>(callable){
            {
                super(arg0);
            }

            @Override
            public void run() {
                try {
                    AuthenticatorHelper.setAuthenticatorCallback(cb);
                    super.run();
                }
                finally {
                    AuthenticatorHelper.clearAuthenticatorCallback();
                }
            }
        };
        IO_EXECUTORS.execute(future);
        while (true) {
            try {
                Object result;
                Object v = result = future.get(1L, TimeUnit.SECONDS);
                return (R)v;
            }
            catch (TimeoutException e) {
                try {
                    Authenticator a;
                    do {
                        if ((a = cb.toProcess.poll(0L, TimeUnit.SECONDS)) == null) continue;
                        PasswordAuthentication pa = cb.NULL;
                        try {
                            try {
                                Method $getPasswordAuthentication = Authenticator.class.getDeclaredMethod("getPasswordAuthentication", new Class[0]);
                                $getPasswordAuthentication.setAccessible(true);
                                PasswordAuthentication paResult = (PasswordAuthentication)$getPasswordAuthentication.invoke((Object)a, new Object[0]);
                                if (paResult != null) {
                                    pa = paResult;
                                }
                            }
                            catch (NoSuchMethodException f) {
                                LOG.log(Level.SEVERE, "The JDK appears to have changed", f);
                            }
                            catch (IllegalAccessException f) {
                                LOG.log(Level.SEVERE, "The security manager appears to have changed", f);
                            }
                            catch (InvocationTargetException f) {
                                Throwable cause = f.getCause();
                                throw new RuntimeException(cause == null ? f : cause);
                            }
                        }
                        finally {
                            cb.result.put(pa);
                        }
                    } while (a != null);
                    continue;
                }
                catch (InterruptedException e2) {
                    future.cancel(true);
                    Thread.currentThread().interrupt();
                    InterruptedIOException iioe = new InterruptedIOException("Request interrupted");
                    iioe.initCause(e2);
                    throw iioe;
                }
                catch (ExecutionException e3) {
                    Throwable cause = e3.getCause();
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw new RuntimeException(cause == null ? e3 : cause);
                }
            }
            break;
        }
        finally {
            if (!future.isDone() && !future.isCancelled()) {
                future.cancel(true);
            }
        }
    }

    private <R> R reThrow(Exception e) {
        Throwable cause = e.getCause();
        throw new RuntimeException(cause == null ? e : cause);
    }

    protected <T> T invokeInterruptiblyNoThrowIO(URL url, InterruptibleClosure<T, ?> callable, T defaultValue) {
        try {
            return this.invokeInterruptibly(url, callable);
        }
        catch (IOException ex) {
            return defaultValue;
        }
    }

    protected InputStream openInterruptibleInputStream(URL url) throws IOException {
        InterruptibleClosure<InputStream, URLConnection> getInputStream = new InterruptibleClosure<InputStream, URLConnection>(){

            @Override
            public InputStream call(URLConnection connection) throws IOException {
                return connection.getInputStream();
            }
        };
        if (Boolean.getBoolean("oracle.ide.net.URLFileSystemHelper.useSimplerUninteruptableInputStream")) {
            return this.invokeInterruptiblyImpl(url, getInputStream, false);
        }
        final InputStream is = this.invokeInterruptiblyImpl(url, getInputStream, false);
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return MultiThreadURLFileSystemHelper.this.invokeInterruptiblyImpl(new Callable<Integer>(){

                    @Override
                    public Integer call() throws IOException {
                        return is.read();
                    }
                });
            }

            @Override
            public int available() throws IOException {
                return MultiThreadURLFileSystemHelper.this.invokeInterruptiblyImpl(new Callable<Integer>(){

                    @Override
                    public Integer call() throws IOException {
                        return is.available();
                    }
                });
            }

            @Override
            public void close() throws IOException {
                MultiThreadURLFileSystemHelper.this.invokeInterruptiblyImpl(new Callable<Void>(){

                    @Override
                    public Void call() throws IOException {
                        is.close();
                        return null;
                    }
                });
            }

            @Override
            public synchronized void mark(final int readlimit) {
                if (!is.markSupported()) {
                    throw new UnsupportedOperationException("Mark not supported on the delegated stream");
                }
                try {
                    MultiThreadURLFileSystemHelper.this.invokeInterruptiblyImpl(new Callable<Void>(){

                        @Override
                        public Void call() throws IOException {
                            is.mark(readlimit);
                            return null;
                        }
                    });
                }
                catch (IOException ioe) {
                    Throwable cause = ioe.getCause();
                    throw new RuntimeException(cause == null ? ioe : cause);
                }
            }

            @Override
            public boolean markSupported() {
                return is.markSupported();
            }

            @Override
            public int read(final byte[] b) throws IOException {
                return MultiThreadURLFileSystemHelper.this.invokeInterruptiblyImpl(new Callable<Integer>(){

                    @Override
                    public Integer call() throws IOException {
                        return is.read(b);
                    }
                });
            }

            @Override
            public int read(final byte[] b, final int off, final int len) throws IOException {
                return MultiThreadURLFileSystemHelper.this.invokeInterruptiblyImpl(new Callable<Integer>(){

                    @Override
                    public Integer call() throws IOException {
                        return is.read(b, off, len);
                    }
                });
            }

            @Override
            public synchronized void reset() throws IOException {
                MultiThreadURLFileSystemHelper.this.invokeInterruptiblyImpl(new Callable<Void>(){

                    @Override
                    public Void call() throws IOException {
                        is.reset();
                        return null;
                    }
                });
            }

            @Override
            public long skip(final long n) throws IOException {
                return MultiThreadURLFileSystemHelper.this.invokeInterruptiblyImpl(new Callable<Long>(){

                    @Override
                    public Long call() throws IOException {
                        return is.skip(n);
                    }
                });
            }
        };
    }

    public static interface InterruptibleClosure<R, C extends URLConnection> {
        public R call(C var1) throws IOException;
    }
}

